/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server;

import com.tridium.bacnet.BacnetQuery;
import com.tridium.bacnet.datatypes.BNextInstArgs;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.server.BIBacnetExportFolder;
import com.tridium.util.ComponentTreeCursor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.export.BBacnetPointDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BOutOfServiceExt;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.control.BControlPoint;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetExportTable
extends BComponent
implements BIBacnetExportFolder {
    public static final Action getObjectOrdById = BBacnetExportTable.newAction((int)4, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    public static final Action getNextInst = BBacnetExportTable.newAction((int)4, (BValue)new BNextInstArgs(), null);
    public static final Type TYPE;
    private static final Log log;
    ServerObjectComparator comparator;
    private Hashtable exportsByObjectId;
    private Hashtable exportsByObjectName;
    private Vector objectList;
    private Hashtable objectIdsByOrd;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$server$BBacnetExportTable;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BOutOfServiceExt;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BIBacnetExportObject;

    public BOrd getObjectOrdById(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        return (BOrd)this.invoke(getObjectOrdById, (BValue)bBacnetObjectIdentifier, null);
    }

    public BInteger getNextInst(BNextInstArgs bNextInstArgs) {
        return (BInteger)this.invoke(getNextInst, (BValue)bNextInstArgs, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BOrd doGetObjectOrdById(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        BIBacnetExportObject bIBacnetExportObject = this.byObjectId(bBacnetObjectIdentifier);
        if (bIBacnetExportObject == null) {
            return BOrd.DEFAULT;
        }
        return ((BComponent)bIBacnetExportObject).getOrdInSpace();
    }

    public String toString(Context context) {
        return "ExportTable:" + this.getSize();
    }

    public BBacnetExportTable getExports() {
        return this;
    }

    public String export(BIBacnetExportObject bIBacnetExportObject) {
        BIBacnetExportObject bIBacnetExportObject2;
        BBacnetObjectIdentifier bBacnetObjectIdentifier = bIBacnetExportObject.getObjectId();
        String string = bIBacnetExportObject.getObjectName();
        if (log.isTraceOn()) {
            log.trace("export:" + bIBacnetExportObject + " id=" + (Object)((Object)bBacnetObjectIdentifier) + " name=" + string + " ord=" + bIBacnetExportObject.getObjectOrd());
        }
        if ((bIBacnetExportObject2 = (BIBacnetExportObject)this.exportsByObjectId.get((Object)bBacnetObjectIdentifier)) != null && bIBacnetExportObject2 != bIBacnetExportObject) {
            return "Duplicate Object ID";
        }
        bIBacnetExportObject2 = (BIBacnetExportObject)this.exportsByObjectName.get(string);
        if (bIBacnetExportObject2 != null && bIBacnetExportObject2 != bIBacnetExportObject) {
            return "Duplicate Object Name";
        }
        if (bIBacnetExportObject2 == null) {
            this.exportsByObjectId.put(bBacnetObjectIdentifier, bIBacnetExportObject);
            this.exportsByObjectName.put(string, bIBacnetExportObject);
            this.objectList.addElement(bBacnetObjectIdentifier);
            this.objectIdsByOrd.values().remove((Object)bBacnetObjectIdentifier);
            this.objectIdsByOrd.put(bIBacnetExportObject.getObjectOrd(), bIBacnetExportObject.getObjectId());
        }
        return null;
    }

    public void unexport(BBacnetObjectIdentifier bBacnetObjectIdentifier, String string, BIBacnetExportObject bIBacnetExportObject) {
        BIBacnetExportObject bIBacnetExportObject2 = (BIBacnetExportObject)this.exportsByObjectId.get((Object)bBacnetObjectIdentifier);
        BIBacnetExportObject bIBacnetExportObject3 = (BIBacnetExportObject)this.exportsByObjectName.get(string);
        if (log.isTraceOn()) {
            log.trace("unexport:" + bIBacnetExportObject + " id=" + (Object)((Object)bBacnetObjectIdentifier) + " name=" + string + " ord=" + bIBacnetExportObject.getObjectOrd() + "\n  idDup=" + bIBacnetExportObject2 + "  nameDup=" + bIBacnetExportObject3);
        }
        if (bIBacnetExportObject2 == bIBacnetExportObject) {
            this.exportsByObjectId.remove((Object)bBacnetObjectIdentifier);
            this.objectList.removeElement((Object)bBacnetObjectIdentifier);
        }
        if (bIBacnetExportObject3 == bIBacnetExportObject) {
            this.exportsByObjectName.remove(string);
        }
        this.objectIdsByOrd.values().remove((Object)bBacnetObjectIdentifier);
        ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getServer().getEventHandler().removeEventSummary(bBacnetObjectIdentifier);
        this.removeOutOfServiceExt(bIBacnetExportObject);
    }

    private final void removeOutOfServiceExt(BIBacnetExportObject bIBacnetExportObject) {
        BBacnetPointDescriptor bBacnetPointDescriptor;
        BControlPoint bControlPoint;
        if (bIBacnetExportObject instanceof BBacnetPointDescriptor && (bControlPoint = (bBacnetPointDescriptor = (BBacnetPointDescriptor)bIBacnetExportObject).getPoint()) != null) {
            Object[] objectArray;
            Class clazz = class$javax$baja$bacnet$export$BOutOfServiceExt;
            if (clazz == null) {
                clazz = class$javax$baja$bacnet$export$BOutOfServiceExt = BBacnetExportTable.class("[Ljavax.baja.bacnet.export.BOutOfServiceExt;", false);
            }
            if ((objectArray = bControlPoint.getChildren(clazz)) != null && objectArray.length > 0 && objectArray[0] instanceof BOutOfServiceExt) {
                bControlPoint.remove((BComplex)((BOutOfServiceExt)((Object)objectArray[0])));
            }
        }
    }

    public BIBacnetExportObject byObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        BIBacnetExportObject bIBacnetExportObject = (BIBacnetExportObject)this.exportsByObjectId.get((Object)bBacnetObjectIdentifier);
        if (bIBacnetExportObject == null) {
            return null;
        }
        return bIBacnetExportObject.isFatalFault() ? null : bIBacnetExportObject;
    }

    public BIBacnetExportObject byObjectName(String string) {
        BIBacnetExportObject bIBacnetExportObject = (BIBacnetExportObject)this.exportsByObjectName.get(string);
        if (bIBacnetExportObject == null) {
            return null;
        }
        return bIBacnetExportObject.isFatalFault() ? null : bIBacnetExportObject;
    }

    public BBacnetObjectIdentifier byObjectOrd(BOrd bOrd) {
        BOrd bOrd2;
        if (bOrd == null || bOrd.equals((Object)BOrd.NULL)) {
            return null;
        }
        BOrd bOrd3 = bOrd.relativizeToSession();
        OrdQuery[] ordQueryArray = bOrd3.parse();
        String string = ordQueryArray[0].getScheme();
        if (string.equals("station")) {
            bOrd3 = BOrd.make((OrdQuery[])ordQueryArray, (int)1, (int)ordQueryArray.length);
        } else if (string.equals("bac")) {
            try {
                BBacnetObjectIdentifier bBacnetObjectIdentifier = (BBacnetObjectIdentifier)BBacnetObjectIdentifier.DEFAULT.decodeFromString(((BacnetQuery)ordQueryArray[0]).getObject());
                return bBacnetObjectIdentifier;
            }
            catch (Exception exception) {
                if (log.isTraceOn()) {
                    exception.printStackTrace();
                }
                log.message("Error decoding BACnet Ord:" + bOrd3 + ": oq=" + ordQueryArray[0]);
                return null;
            }
        }
        BBacnetObjectIdentifier bBacnetObjectIdentifier = (BBacnetObjectIdentifier)((Object)this.objectIdsByOrd.get(bOrd3));
        if (bBacnetObjectIdentifier == null && string.equals("slot")) {
            bOrd2 = bOrd.resolve((BObject)Sys.getStation()).get().asComponent().getHandleOrd();
            bBacnetObjectIdentifier = (BBacnetObjectIdentifier)((Object)this.objectIdsByOrd.get(bOrd2));
        }
        if (bBacnetObjectIdentifier == null && string.equals("h")) {
            bOrd2 = bOrd.resolve((BObject)Sys.getStation()).get().asComponent().getSlotPathOrd();
            bBacnetObjectIdentifier = (BBacnetObjectIdentifier)((Object)this.objectIdsByOrd.get(bOrd2));
        }
        return bBacnetObjectIdentifier;
    }

    public void writeObjectIds(AsnOutput asnOutput) {
        Enumeration enumeration = this.objectList.elements();
        while (enumeration.hasMoreElements()) {
            asnOutput.writeObjectIdentifier((BBacnetObjectIdentifier)((Object)enumeration.nextElement()));
        }
    }

    public BBacnetObjectIdentifier[] getObjectIds() {
        BBacnetObjectIdentifier[] bBacnetObjectIdentifierArray = new BBacnetObjectIdentifier[this.objectList.size()];
        this.objectList.copyInto((Object[])bBacnetObjectIdentifierArray);
        return bBacnetObjectIdentifierArray;
    }

    public BBacnetObjectIdentifier getEntry(int n) {
        return (BBacnetObjectIdentifier)((Object)this.objectList.elementAt(n));
    }

    public int getSize() {
        return this.objectList.size();
    }

    public BIBacnetExportObject[] getExportedObjects(Type type) {
        if (!type.is(BIBacnetExportObject.TYPE)) {
            return null;
        }
        Class clazz = type.getTypeClass();
        Class clazz2 = class$javax$baja$bacnet$export$BIBacnetExportObject;
        if (clazz2 == null) {
            clazz2 = class$javax$baja$bacnet$export$BIBacnetExportObject = BBacnetExportTable.class("[Ljavax.baja.bacnet.export.BIBacnetExportObject;", false);
        }
        Array array = new Array(clazz2);
        Enumeration enumeration = this.exportsByObjectId.elements();
        while (enumeration.hasMoreElements()) {
            BIBacnetExportObject bIBacnetExportObject = (BIBacnetExportObject)enumeration.nextElement();
            if (!clazz.isInstance(bIBacnetExportObject) || bIBacnetExportObject.isFatalFault()) continue;
            array.add((Object)bIBacnetExportObject);
        }
        return (BIBacnetExportObject[])array.trim();
    }

    public BInteger doGetNextInst(BNextInstArgs bNextInstArgs) {
        return BInteger.make((int)this.getNextInstance(bNextInstArgs.getObjectType(), bNextInstArgs.getSiblings().getOrdinals()));
    }

    public int getNextInstance(int n) {
        return this.getNextInstance(n, new int[0]);
    }

    /*
     * Unable to fully structure code
     */
    public int getNextInstance(int var1_1, int[] var2_2) {
        var3_3 = new ComponentTreeCursor((BComponent)this, null);
        var4_4 = 0;
        if (true) ** GOTO lbl7
        do {
            if (((BIBacnetExportObject)var3_3.get()).getObjectId().getObjectType() == var1_1) {
                ++var4_4;
            }
lbl7:
            // 4 sources

            if ((v0 = BBacnetExportTable.class$javax$baja$bacnet$export$BIBacnetExportObject) != null) continue;
            v0 = BBacnetExportTable.class("[Ljavax.baja.bacnet.export.BIBacnetExportObject;", false);
        } while (var3_3.next(v0));
        var5_5 = new int[var2_2.length + var4_4];
        System.arraycopy(var2_2, 0, var5_5, 0, var2_2.length);
        var3_3.reset();
        var4_4 = var2_2.length;
        if (true) ** GOTO lbl18
        do {
            if ((var6_6 = (BIBacnetExportObject)var3_3.get()).getObjectId().getObjectType() == var1_1) {
                var5_5[var4_4++] = var6_6.getObjectId().getInstanceNumber();
            }
lbl18:
            // 4 sources

            if ((v1 = BBacnetExportTable.class$javax$baja$bacnet$export$BIBacnetExportObject) != null) continue;
            v1 = BBacnetExportTable.class("[Ljavax.baja.bacnet.export.BIBacnetExportObject;", false);
        } while (var3_3.next(v1));
        Arrays.sort(var5_5);
        var6_7 = 0;
        var7_8 = 0;
        while (var7_8 < var5_5.length) {
            if (var5_5[var7_8] > var6_7) {
                return var6_7;
            }
            if (var5_5[var7_8] == var6_7) {
                ++var6_7;
            }
            ++var7_8;
        }
        return var6_7;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetExportTable", 2);
        spyWriter.prop((Object)"Exports By Object Id", (Object)"");
        Enumeration enumeration = this.exportsByObjectId.keys();
        while (enumeration.hasMoreElements()) {
            BBacnetObjectIdentifier bBacnetObjectIdentifier = (BBacnetObjectIdentifier)((Object)enumeration.nextElement());
            spyWriter.prop((Object)("  " + (Object)((Object)bBacnetObjectIdentifier)), (Object)((BIBacnetExportObject)this.exportsByObjectId.get((Object)bBacnetObjectIdentifier)));
        }
        spyWriter.prop((Object)"Exports By Object Name", (Object)"");
        enumeration = this.exportsByObjectName.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            spyWriter.prop((Object)("  " + string), (Object)((BIBacnetExportObject)this.exportsByObjectName.get(string)));
        }
        spyWriter.prop((Object)"ObjectList", (Object)"[] is external index");
        int n = this.objectList.size();
        int n2 = 0;
        while (n2 < n) {
            spyWriter.prop((Object)("  " + n2 + " [" + (n2 + 2) + ']'), this.objectList.get(n2));
            ++n2;
        }
        spyWriter.prop((Object)"ObjectIDs By Object Ord", (Object)"");
        enumeration = this.objectIdsByOrd.keys();
        while (enumeration.hasMoreElements()) {
            BOrd bOrd = (BOrd)enumeration.nextElement();
            spyWriter.prop((Object)("  " + bOrd), (Object)((BBacnetObjectIdentifier)((Object)this.objectIdsByOrd.get(bOrd))));
        }
        spyWriter.endProps();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.comparator = new ServerObjectComparator();
        this.exportsByObjectId = new Hashtable();
        this.exportsByObjectName = new Hashtable();
        this.objectList = new Vector();
        this.objectIdsByOrd = new Hashtable();
    }

    public BBacnetExportTable() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$stack$server$BBacnetExportTable;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$server$BBacnetExportTable = BBacnetExportTable.class("[Lcom.tridium.bacnet.stack.server.BBacnetExportTable;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"bacnet.server");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ServerObjectComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            BIBacnetExportObject bIBacnetExportObject = (BIBacnetExportObject)object;
            BIBacnetExportObject bIBacnetExportObject2 = (BIBacnetExportObject)object2;
            long l = bIBacnetExportObject.getObjectId().hashCode();
            long l2 = bIBacnetExportObject2.getObjectId().hashCode();
            return (int)(l - l2);
        }

        ServerObjectComparator() {
        }
    }
}

