/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.network.messages;

import com.tridium.bacnet.stack.BacnetStackException;
import com.tridium.bacnet.stack.network.InvalidNetworkMsgException;
import com.tridium.bacnet.stack.network.messages.NetworkLayerMsg;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class RejectMessageToNetwork
extends NetworkLayerMsg {
    public static final int OTHER = 0;
    public static final int UNKNOWN_DNET = 1;
    public static final int ROUTER_BUSY = 2;
    public static final int UNKNOWN_MESSAGE_TYPE = 3;
    public static final int MESSAGE_TOO_LONG = 4;
    private static final String[] rejectReasons = new String[]{"Other", "Unknown DNET - cannot find router", "Router busy", "Unknown netowrk layer message type", "Message too long for DNET"};
    private int rejectReason;
    private int rejectedDNET;

    public int getRejectReason() {
        return this.rejectReason;
    }

    public String getReasonString() {
        if (this.rejectReason > 0 && this.rejectReason <= 4) {
            return rejectReasons[this.rejectReason];
        }
        return "" + this.rejectReason;
    }

    public int getRejectedDNET() {
        return this.rejectedDNET;
    }

    public String getMsgString() {
        return "RejectMessageToNetwork; rejectedDNET=" + this.rejectedDNET + ", reason=" + this.getReasonString();
    }

    public void readNetworkBytes(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        if (byteArrayInputStream.available() < 3) {
            throw new InvalidNetworkMsgException();
        }
        this.rejectReason = byteArrayInputStream.read();
        this.rejectedDNET = byteArrayInputStream.read() << 8;
        this.rejectedDNET |= byteArrayInputStream.read();
    }

    public void writeNetworkBytes(ByteArrayOutputStream byteArrayOutputStream) {
        super.writeNetworkBytes(byteArrayOutputStream);
        byteArrayOutputStream.write(this.rejectReason);
        byteArrayOutputStream.write(this.rejectedDNET >> 8 & 0xFF);
        byteArrayOutputStream.write(this.rejectedDNET & 0xFF);
    }

    public RejectMessageToNetwork(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        super(3);
        this.readNetworkBytes(byteArrayInputStream);
    }

    public RejectMessageToNetwork(int n, int n2) {
        super(3);
        this.rejectReason = n;
        this.rejectedDNET = n2;
    }
}

