/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.network.messages;

import com.tridium.bacnet.stack.BacnetStackException;
import com.tridium.bacnet.stack.network.InvalidNetworkMsgException;
import com.tridium.bacnet.stack.network.messages.NetworkLayerMsg;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class EstablishConnectionToNetwork
extends NetworkLayerMsg {
    private int networkNumber;
    private int terminationTimeValue;

    public int getNetworkNumber() {
        return this.networkNumber;
    }

    public int getTerminationTimeValue() {
        return this.terminationTimeValue;
    }

    public String getMsgString() {
        return "EstablishConnectionToNetwork; network=" + this.networkNumber + ", termTV=" + this.terminationTimeValue;
    }

    public void readNetworkBytes(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        if (byteArrayInputStream.available() < 3) {
            throw new InvalidNetworkMsgException();
        }
        this.networkNumber = byteArrayInputStream.read() << 8;
        this.networkNumber |= byteArrayInputStream.read();
        this.terminationTimeValue = byteArrayInputStream.read();
    }

    public void writeNetworkBytes(ByteArrayOutputStream byteArrayOutputStream) {
        super.writeNetworkBytes(byteArrayOutputStream);
        byteArrayOutputStream.write(this.networkNumber >> 8 & 0xFF);
        byteArrayOutputStream.write(this.networkNumber & 0xFF);
        byteArrayOutputStream.write(this.terminationTimeValue);
    }

    public EstablishConnectionToNetwork(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        super(8);
        this.readNetworkBytes(byteArrayInputStream);
    }

    public EstablishConnectionToNetwork(int n, int n2) {
        super(8);
        this.networkNumber = n;
        this.terminationTimeValue = n2;
    }
}

