/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.network.messages;

import com.tridium.bacnet.stack.BacnetInputStream;
import com.tridium.bacnet.stack.network.BNetworkPriority;
import com.tridium.bacnet.stack.network.NetworkPdu;
import com.tridium.bacnet.stack.transport.ApplicationPdu;
import java.io.ByteArrayOutputStream;
import javax.baja.bacnet.datatypes.BBacnetAddress;

public class ApplicationMsg
extends NetworkPdu {
    private BacnetInputStream rawApdu;
    private ApplicationPdu apdu;
    private byte[] rawApduBytes;

    public boolean isNetworkLayerMsg() {
        return false;
    }

    public ApplicationPdu getAPDU() {
        return this.apdu;
    }

    public BacnetInputStream getRawAPDU() {
        return this.rawApdu;
    }

    public void storeApdu() {
        this.rawApdu.mark(this.rawApdu.getPos());
        this.rawApduBytes = new byte[this.rawApdu.available()];
        this.rawApdu.read(this.rawApduBytes);
        this.rawApdu.reset();
    }

    public void writeNetworkBytes(ByteArrayOutputStream byteArrayOutputStream) {
        super.writeNetworkBytes(byteArrayOutputStream);
        if (this.apdu != null) {
            this.apdu.writeNetworkBytes(byteArrayOutputStream);
        } else {
            byteArrayOutputStream.write(this.rawApduBytes, 0, this.rawApduBytes.length);
        }
    }

    public ApplicationMsg(BacnetInputStream bacnetInputStream) {
        this.rawApdu = bacnetInputStream;
    }

    public ApplicationMsg(BBacnetAddress bBacnetAddress, BBacnetAddress bBacnetAddress2, ApplicationPdu applicationPdu, BNetworkPriority bNetworkPriority, boolean bl) {
        super(bBacnetAddress, bBacnetAddress2, bNetworkPriority, bl);
        this.apdu = applicationPdu;
    }
}

