/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.network;

import com.tridium.bacnet.stack.BacnetInputStream;
import com.tridium.bacnet.stack.BacnetStackException;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.network.BNetworkPort;
import com.tridium.bacnet.stack.network.BNetworkPriority;
import com.tridium.bacnet.stack.network.NetworkMsgType;
import com.tridium.bacnet.stack.network.PrioritizedQueueEntry;
import com.tridium.bacnet.stack.network.UnsupportedNetworkMsgException;
import com.tridium.bacnet.stack.network.UnsupportedProtocolVersionException;
import com.tridium.bacnet.stack.network.messages.ApplicationMsg;
import com.tridium.bacnet.stack.network.messages.DisconnectConnectionToNetwork;
import com.tridium.bacnet.stack.network.messages.EstablishConnectionToNetwork;
import com.tridium.bacnet.stack.network.messages.IAmRouterToNetwork;
import com.tridium.bacnet.stack.network.messages.ICouldBeRouterToNetwork;
import com.tridium.bacnet.stack.network.messages.InitializeRoutingTable;
import com.tridium.bacnet.stack.network.messages.InitializeRoutingTableAck;
import com.tridium.bacnet.stack.network.messages.NetworkLayerMsg;
import com.tridium.bacnet.stack.network.messages.RejectMessageToNetwork;
import com.tridium.bacnet.stack.network.messages.RouterAvailableToNetwork;
import com.tridium.bacnet.stack.network.messages.RouterBusyToNetwork;
import com.tridium.bacnet.stack.network.messages.WhoIsRouterToNetwork;
import com.tridium.bacnet.timers.Timers;
import java.io.ByteArrayOutputStream;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class NetworkPdu
implements NetworkMsgType,
PrioritizedQueueEntry {
    public static final int VERSION = 1;
    public static final int NETWORK_LAYER_MSG_BIT = 128;
    public static final int DEST_SPECIFIER_BIT = 32;
    public static final int SOURCE_SPECIFIER_BIT = 8;
    public static final int DATA_EXPECTING_REPLY_BIT = 4;
    public static final int NETWORK_PRIORITY_MASK = 3;
    public static final int DEFAULT_HOP_COUNT = 255;
    public static final int DNET_NOT_PRESENT = -1;
    public static final int SNET_NOT_PRESENT = -1;
    public static final int NOT_A_NETWORK_MESSAGE = -1;
    private int version;
    private BNetworkPriority networkPriority;
    private boolean dataExpectingReply;
    private int dnet;
    private byte[] dadr;
    private int snet;
    private byte[] sadr;
    private int hopCount;
    private byte[] srcMacAddress;
    private int srcNetworkNumber;
    private byte[] destMacAddress;
    private int destNetworkNumber;
    private BNetworkPort sourcePort;
    private PrioritizedQueueEntry next;

    public int getMessageType() {
        return -1;
    }

    public int getVersion() {
        return this.version;
    }

    public abstract boolean isNetworkLayerMsg();

    public boolean getDataExpectingReply() {
        return this.dataExpectingReply;
    }

    public void setDataExpectingReply(boolean bl) {
        this.dataExpectingReply = bl;
    }

    public BNetworkPriority getNetworkPriority() {
        return this.networkPriority;
    }

    public void setNetworkPriority(BNetworkPriority bNetworkPriority) {
        this.networkPriority = bNetworkPriority;
    }

    public boolean isDNET() {
        boolean bl = false;
        if (this.dnet != -1) {
            bl = true;
        }
        return bl;
    }

    public int getDNET() {
        return this.dnet;
    }

    public void setDNET(int n) {
        this.dnet = n;
    }

    public int getDLEN() {
        int n = 0;
        if (this.dadr != null) {
            n = this.dadr.length;
        }
        return n;
    }

    public byte[] getDADR() {
        return this.dadr;
    }

    public void setDADR(byte[] byArray) {
        this.dadr = byArray;
    }

    public boolean isSNET() {
        boolean bl = false;
        if (this.snet != -1) {
            bl = true;
        }
        return bl;
    }

    public int getSNET() {
        return this.snet;
    }

    public void setSNET(int n) {
        this.snet = n;
    }

    public int getSLEN() {
        int n = 0;
        if (this.sadr != null) {
            n = this.sadr.length;
        }
        return n;
    }

    public byte[] getSADR() {
        return this.sadr;
    }

    public void setSADR(byte[] byArray) {
        this.sadr = byArray;
    }

    public int getHopCount() {
        return this.hopCount;
    }

    public void decrementHopCount() {
        --this.hopCount;
    }

    public BBacnetAddress getSrcAddress() {
        if (this.snet == -1) {
            return new BBacnetAddress(this.srcNetworkNumber, this.srcMacAddress);
        }
        return new BBacnetAddress(this.snet, this.sadr);
    }

    public byte[] getSrcMacAddress() {
        return this.srcMacAddress;
    }

    public int getSrcNetworkNumber() {
        return this.srcNetworkNumber;
    }

    public BBacnetAddress getDestAddress() {
        if (this.dnet == -1) {
            return new BBacnetAddress(this.destNetworkNumber, this.destMacAddress);
        }
        return new BBacnetAddress(this.dnet, this.dadr);
    }

    public byte[] getDestMacAddress() {
        return this.destMacAddress;
    }

    public int getDestNetworkNumber() {
        return this.destNetworkNumber;
    }

    public BNetworkPort getSourcePort() {
        return this.sourcePort;
    }

    public void setSourcePort(BNetworkPort bNetworkPort) {
        this.sourcePort = bNetworkPort;
    }

    public void writeNetworkBytes(ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write(1);
        int n = 0;
        if (this.isNetworkLayerMsg()) {
            n |= 0x80;
        }
        if (this.dnet != -1) {
            n |= 0x20;
        }
        if (this.snet != -1) {
            n |= 8;
        }
        if (this.dataExpectingReply) {
            n |= 4;
        }
        byteArrayOutputStream.write(n |= this.networkPriority.getOrdinal());
        if ((n & 0x20) != 0) {
            byteArrayOutputStream.write(this.dnet >> 8);
            byteArrayOutputStream.write(this.dnet);
            if (this.dnet != (char)-1) {
                if (this.dadr != null) {
                    byteArrayOutputStream.write(this.dadr.length);
                    byteArrayOutputStream.write(this.dadr, 0, this.dadr.length);
                } else {
                    byteArrayOutputStream.write(0);
                }
            } else {
                byteArrayOutputStream.write(0);
            }
        }
        if ((n & 8) != 0) {
            byteArrayOutputStream.write(this.snet >> 8);
            byteArrayOutputStream.write(this.snet);
            byteArrayOutputStream.write(this.sadr.length);
            byteArrayOutputStream.write(this.sadr, 0, this.sadr.length);
        }
        if ((n & 0x20) != 0) {
            byteArrayOutputStream.write(this.hopCount);
        }
    }

    public static NetworkPdu parseNetworkBytes(byte[] byArray, byte[] byArray2, int n, BacnetInputStream bacnetInputStream) throws BacnetStackException {
        NetworkPdu networkPdu;
        byte[] byArray3;
        int n2;
        byte[] byArray4;
        int n3;
        int n4;
        boolean bl;
        int n5 = bacnetInputStream.read();
        if (n5 != 1) {
            throw new UnsupportedProtocolVersionException(n5);
        }
        int n6 = bacnetInputStream.read();
        BNetworkPriority bNetworkPriority = BNetworkPriority.make(n6 & 3);
        boolean bl2 = false;
        if ((n6 & 4) != 0) {
            bl2 = bl = true;
        }
        if ((n6 & 0x20) != 0) {
            n4 = bacnetInputStream.read();
            n3 = bacnetInputStream.read();
            n3 = n4 << 8 | n3;
            byArray4 = new byte[bacnetInputStream.read()];
            bacnetInputStream.read(byArray4, 0, byArray4.length);
        } else {
            n3 = -1;
            byArray4 = null;
        }
        if ((n6 & 8) != 0) {
            n4 = bacnetInputStream.read();
            n2 = bacnetInputStream.read();
            n2 = n4 << 8 | n2;
            byArray3 = new byte[bacnetInputStream.read()];
            bacnetInputStream.read(byArray3, 0, byArray3.length);
        } else {
            n2 = -1;
            byArray3 = null;
        }
        int n7 = (n6 & 0x20) != 0 ? bacnetInputStream.read() : 0;
        if ((n6 & 0x80) != 0) {
            int n8 = bacnetInputStream.read();
            if ((n8 & 0x80) != 0) {
                int n9 = bacnetInputStream.read() << 8 | bacnetInputStream.read();
                networkPdu = new NetworkLayerMsg(n8, n9, bacnetInputStream);
            } else if (n8 >= 10 && n8 <= 127) {
                networkPdu = new NetworkLayerMsg(n8, bacnetInputStream);
            } else {
                switch (n8) {
                    case 0: {
                        networkPdu = new WhoIsRouterToNetwork(bacnetInputStream);
                        break;
                    }
                    case 1: {
                        networkPdu = new IAmRouterToNetwork(bacnetInputStream);
                        break;
                    }
                    case 2: {
                        networkPdu = new ICouldBeRouterToNetwork(bacnetInputStream);
                        break;
                    }
                    case 3: {
                        networkPdu = new RejectMessageToNetwork(bacnetInputStream);
                        break;
                    }
                    case 4: {
                        networkPdu = new RouterBusyToNetwork(bacnetInputStream);
                        break;
                    }
                    case 5: {
                        networkPdu = new RouterAvailableToNetwork(bacnetInputStream);
                        break;
                    }
                    case 6: {
                        networkPdu = new InitializeRoutingTable(bacnetInputStream);
                        break;
                    }
                    case 7: {
                        networkPdu = new InitializeRoutingTableAck(bacnetInputStream);
                        break;
                    }
                    case 8: {
                        networkPdu = new EstablishConnectionToNetwork(bacnetInputStream);
                        break;
                    }
                    case 9: {
                        networkPdu = new DisconnectConnectionToNetwork(bacnetInputStream);
                        break;
                    }
                    default: {
                        throw new UnsupportedNetworkMsgException(n8);
                    }
                }
            }
            bacnetInputStream.release();
        } else {
            networkPdu = new ApplicationMsg(bacnetInputStream);
        }
        networkPdu.version = n5;
        networkPdu.dataExpectingReply = bl;
        networkPdu.dnet = n3;
        networkPdu.dadr = byArray4;
        networkPdu.snet = n2;
        networkPdu.sadr = byArray3;
        networkPdu.hopCount = n7;
        networkPdu.networkPriority = bNetworkPriority;
        networkPdu.srcMacAddress = byArray;
        networkPdu.srcNetworkNumber = n;
        networkPdu.destMacAddress = byArray2;
        networkPdu.destNetworkNumber = n;
        return networkPdu;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("Npdu: ");
        stringBuffer.append("ver: " + this.version);
        if (this.isNetworkLayerMsg()) {
            stringBuffer.append("  type: net");
        } else {
            stringBuffer.append("  type: app");
        }
        stringBuffer.append("  pri: " + (Object)((Object)this.networkPriority));
        stringBuffer.append("  DER: " + this.dataExpectingReply);
        if (this.isDNET()) {
            stringBuffer.append("\n      DNET: " + this.dnet);
            if (this.dadr == null) {
                stringBuffer.append("  DLEN: 0");
                stringBuffer.append("  DADR: N/A");
            } else {
                stringBuffer.append("  DLEN: " + this.dadr.length);
                stringBuffer.append("  DADR: ");
                if (this.dadr.length == 0) {
                    stringBuffer.append("bcast");
                } else {
                    stringBuffer.append(ByteArrayUtil.toHexString((byte[])this.dadr));
                }
                stringBuffer.append("  hopCnt: " + this.hopCount);
            }
        }
        if (this.isSNET()) {
            stringBuffer.append("\n      SNET: " + this.snet);
            if (this.sadr == null) {
                stringBuffer.append("  SLEN: 0");
                stringBuffer.append("  SADR: N/A");
            } else {
                stringBuffer.append("  SLEN: " + this.getSLEN());
                stringBuffer.append("  SADR: " + ByteArrayUtil.toHexString((byte[])this.sadr));
            }
        }
        if (this.isNetworkLayerMsg()) {
            stringBuffer.append("\n  netMsg: " + ((NetworkLayerMsg)this).getMsgString());
        }
        return stringBuffer.toString();
    }

    public PrioritizedQueueEntry getNext() {
        return this.next;
    }

    public void setNext(PrioritizedQueueEntry prioritizedQueueEntry) {
        this.next = prioritizedQueueEntry;
    }

    public int getPriority() {
        return this.networkPriority.getOrdinal();
    }

    public int startTimer(BBacnetNetworkLayer bBacnetNetworkLayer) {
        return Timers.add(bBacnetNetworkLayer, bBacnetNetworkLayer.getRouterDiscoveryTimeout(), this);
    }

    private final /* synthetic */ void this() {
        this.dnet = -1;
        this.snet = -1;
        this.srcNetworkNumber = 0;
        this.destNetworkNumber = 0;
    }

    protected NetworkPdu() {
        this.this();
        this.version = 1;
        this.hopCount = 255;
        this.networkPriority = BNetworkPriority.normal;
    }

    protected NetworkPdu(BBacnetAddress bBacnetAddress, BBacnetAddress bBacnetAddress2, BNetworkPriority bNetworkPriority, boolean bl) {
        this.this();
        if (bBacnetAddress2 != null) {
            this.snet = bBacnetAddress2.getNetworkNumber();
            this.sadr = bBacnetAddress2.getMacAddress().getBytes();
        } else {
            this.snet = -1;
        }
        if (bBacnetAddress != null) {
            this.dnet = bBacnetAddress.getNetworkNumber();
            this.dadr = bBacnetAddress.getMacAddress().getBytes();
        } else {
            this.dnet = -1;
        }
        this.networkPriority = bNetworkPriority;
        this.dataExpectingReply = bl;
        this.version = 1;
        this.hopCount = 255;
    }
}

