/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.network;

import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.network.BBacnetRouterEntry;
import com.tridium.bacnet.stack.network.BRouterStatus;
import java.util.Vector;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.log.Log;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetRouterTable
extends BComponent {
    public static final Action addRouter = BBacnetRouterTable.newAction((int)0, (BValue)new BBacnetRouterEntry(), null);
    public static final Action removeRouter = BBacnetRouterTable.newAction((int)0, (BValue)BInteger.make((int)-1), null);
    public static final Action purgeExpiredEntries = BBacnetRouterTable.newAction((int)4, null);
    public static final Action purgeAllEntries = BBacnetRouterTable.newAction((int)128, null);
    public static final Type TYPE;
    Clock.Ticket routerEntryRemovalTicket;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$network$BBacnetRouterTable;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$network$BBacnetRouterEntry;

    public void addRouter(BBacnetRouterEntry bBacnetRouterEntry) {
        this.invoke(addRouter, (BValue)bBacnetRouterEntry, null);
    }

    public void removeRouter(BInteger bInteger) {
        this.invoke(removeRouter, (BValue)bInteger, null);
    }

    public void purgeExpiredEntries() {
        this.invoke(purgeExpiredEntries, null, null);
    }

    public void purgeAllEntries() {
        this.invoke(purgeAllEntries, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.routerEntryRemovalTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeHours((int)1), (Action)purgeExpiredEntries, null);
    }

    public void added(Property property, Context context) {
        if (this.isRunning() && context != Context.decoding) {
            this.validate();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && context != Context.decoding) {
            this.validate();
        }
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BBacnetNetworkLayer;
    }

    /*
     * Unable to fully structure code
     */
    public void spy(SpyWriter var1_1) throws Exception {
        super.spy(var1_1);
        var1_1.startProps();
        var2_2 = Clock.ticks();
        var4_3 = BAbsTime.make((long)var2_2);
        var1_1.prop((Object)"ticks", (Object)("" + var2_2));
        var1_1.prop((Object)"->now", (Object)var4_3);
        var1_1.prop((Object)"routerEntryRemovalTicket", (Object)this.routerEntryRemovalTicket);
        var5_4 = this.getProperties();
        if (true) ** GOTO lbl18
        do {
            var6_5 = (BBacnetRouterEntry)var5_4.get();
            var1_1.prop((Object)var6_5.getName(), (Object)("lastUpdateTicks=" + var6_5.lastUpdateTicks));
lbl18:
            // 2 sources

            if ((v0 = BBacnetRouterTable.class$com$tridium$bacnet$stack$network$BBacnetRouterEntry) != null) continue;
            v0 = BBacnetRouterTable.class("[Lcom.tridium.bacnet.stack.network.BBacnetRouterEntry;", false);
        } while (var5_4.next(v0));
        var1_1.endProps();
    }

    /*
     * Unable to fully structure code
     */
    public void doAddRouter(BBacnetRouterEntry var1_1) {
        var2_2 = this.net().getPortByNetwork(var1_1.getRouterAddress().getNetworkNumber());
        if (var2_2 != null) {
            var1_1.setPortId(var2_2.getPortId());
        }
        var3_3 = this.getProperties();
        if (true) ** GOTO lbl12
        do {
            var4_4 = (BBacnetRouterEntry)var3_3.get();
            if (var1_1.getDnet() == var4_4.getDnet()) {
                var4_4.copyFrom((BComplex)var1_1);
                var4_4.lastUpdateTicks = var5_5 = Clock.ticks();
                return;
            }
lbl12:
            // 3 sources

            if ((v0 = BBacnetRouterTable.class$com$tridium$bacnet$stack$network$BBacnetRouterEntry) != null) continue;
            v0 = BBacnetRouterTable.class("[Lcom.tridium.bacnet.stack.network.BBacnetRouterEntry;", false);
        } while (var3_3.next(v0));
        this.add("dnet" + var1_1.getDnet(), (BValue)var1_1);
    }

    public void doRemoveRouter(BInteger bInteger) {
        BBacnetRouterEntry bBacnetRouterEntry = this.getRouterByDnet(bInteger.getInt());
        if (bBacnetRouterEntry != null) {
            this.remove((BComplex)bBacnetRouterEntry);
        }
    }

    public void doPurgeExpiredEntries() {
        long l;
        long l2 = Clock.ticks();
        long l3 = l2 - (l = this.net().getRouterEntryLifetime().getMillis());
        if (l3 < 0L) {
            l3 = 0L;
        }
        BBacnetNetworkLayer.log.trace("Purging expired router entries: now=" + l2 + " lifetime=" + l + " tooOldTime=" + l3);
        Class clazz = class$com$tridium$bacnet$stack$network$BBacnetRouterEntry;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$network$BBacnetRouterEntry = BBacnetRouterTable.class("[Lcom.tridium.bacnet.stack.network.BBacnetRouterEntry;", false);
        }
        BBacnetRouterEntry[] bBacnetRouterEntryArray = (BBacnetRouterEntry[])this.getChildren(clazz);
        int n = 0;
        while (n < bBacnetRouterEntryArray.length) {
            BBacnetRouterEntry bBacnetRouterEntry = bBacnetRouterEntryArray[n];
            if (!this.net().isDirectlyConnectedNetwork(bBacnetRouterEntry.getDnet()) && bBacnetRouterEntry.lastUpdateTicks < l3) {
                this.remove((BComplex)bBacnetRouterEntry);
            }
            ++n;
        }
    }

    public void doPurgeAllEntries() {
        BBacnetNetworkLayer.log.message("Purging all router table entries (except local ports)...");
        Class clazz = class$com$tridium$bacnet$stack$network$BBacnetRouterEntry;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$network$BBacnetRouterEntry = BBacnetRouterTable.class("[Lcom.tridium.bacnet.stack.network.BBacnetRouterEntry;", false);
        }
        BBacnetRouterEntry[] bBacnetRouterEntryArray = (BBacnetRouterEntry[])this.getChildren(clazz);
        int n = 0;
        while (n < bBacnetRouterEntryArray.length) {
            BBacnetRouterEntry bBacnetRouterEntry = bBacnetRouterEntryArray[n];
            if (!this.net().isDirectlyConnectedNetwork(bBacnetRouterEntry.getDnet())) {
                this.remove((BComplex)bBacnetRouterEntry);
            }
            ++n;
        }
    }

    public void removeRouterByDnet(int n) {
        this.removeRouter(BInteger.make((int)n));
    }

    public void removeRouterByPortId(int n) {
        Class clazz = class$com$tridium$bacnet$stack$network$BBacnetRouterEntry;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$network$BBacnetRouterEntry = BBacnetRouterTable.class("[Lcom.tridium.bacnet.stack.network.BBacnetRouterEntry;", false);
        }
        BBacnetRouterEntry[] bBacnetRouterEntryArray = (BBacnetRouterEntry[])this.getChildren(clazz);
        int n2 = 0;
        while (n2 < bBacnetRouterEntryArray.length) {
            if (bBacnetRouterEntryArray[n2].getPortId() == n) {
                this.remove((BComplex)bBacnetRouterEntryArray[n2]);
            }
            ++n2;
        }
    }

    private final BBacnetNetworkLayer net() {
        return (BBacnetNetworkLayer)this.getParent();
    }

    /*
     * Unable to fully structure code
     */
    public BBacnetRouterEntry getRouterByDnet(int var1_1) {
        var2_2 = this.getProperties();
        if (true) ** GOTO lbl6
        do {
            if ((var3_3 = (BBacnetRouterEntry)var2_2.get()).getDnet() == var1_1) {
                return var3_3;
            }
lbl6:
            // 3 sources

            if ((v0 = BBacnetRouterTable.class$com$tridium$bacnet$stack$network$BBacnetRouterEntry) != null) continue;
            v0 = BBacnetRouterTable.class("[Lcom.tridium.bacnet.stack.network.BBacnetRouterEntry;", false);
        } while (var2_2.next(v0));
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Vector getRoutersByAddress(int var1_1, byte[] var2_2) {
        var3_3 = new Vector<BBacnetRouterEntry>();
        var4_4 = this.getProperties();
        if (true) ** GOTO lbl7
        do {
            if ((var5_5 = (BBacnetRouterEntry)var4_4.get()).getRouterAddress().equals(var1_1, var2_2)) {
                var3_3.addElement(var5_5);
            }
lbl7:
            // 4 sources

            if ((v0 = BBacnetRouterTable.class$com$tridium$bacnet$stack$network$BBacnetRouterEntry) != null) continue;
            v0 = BBacnetRouterTable.class("[Lcom.tridium.bacnet.stack.network.BBacnetRouterEntry;", false);
        } while (var4_4.next(v0));
        return var3_3;
    }

    /*
     * Unable to fully structure code
     */
    public int[] getDnets(int var1_1) {
        this.loadSlots();
        var2_2 = new Vector<Integer>();
        var3_3 = this.getProperties();
        if (true) ** GOTO lbl12
        do {
            var4_4 = (Object)((BBacnetRouterEntry)var3_3.get());
            var4_4.loadSlots();
            if (var4_4.getPortId() != var1_1) {
                var2_2.addElement(new Integer(var4_4.getDnet()));
            }
lbl12:
            // 4 sources

            if ((v0 = BBacnetRouterTable.class$com$tridium$bacnet$stack$network$BBacnetRouterEntry) != null) continue;
            v0 = BBacnetRouterTable.class("[Lcom.tridium.bacnet.stack.network.BBacnetRouterEntry;", false);
        } while (var3_3.next(v0));
        var4_4 = new int[var2_2.size()];
        var5_5 = 0;
        while (var5_5 < ((Object)var4_4).length) {
            var4_4[var5_5] = (Integer)var2_2.elementAt(var5_5);
            ++var5_5;
        }
        return var4_4;
    }

    public void updateRouter(int n, int n2, byte[] byArray, int n3, String string, BRouterStatus bRouterStatus) {
        BBacnetRouterEntry bBacnetRouterEntry = this.getRouterByDnet(n);
        if (bBacnetRouterEntry == null) {
            bBacnetRouterEntry = new BBacnetRouterEntry(n, new BBacnetAddress(n2, byArray), n3, string, bRouterStatus);
            this.addRouter(bBacnetRouterEntry);
        } else {
            bBacnetRouterEntry.getRouterAddress().setNetworkNumber(n2);
            bBacnetRouterEntry.getRouterAddress().setMac(byArray, null);
            bBacnetRouterEntry.setPortId(n3);
            if (string != null) {
                bBacnetRouterEntry.setPortInfo(string);
            }
            bBacnetRouterEntry.setRouterStatus(bRouterStatus);
        }
        if (!this.net().isDirectlyConnectedNetwork(n)) {
            bBacnetRouterEntry.lastUpdateTicks = Clock.ticks();
        }
    }

    public synchronized void validate() {
        Log.getLog((String)"bacnet.network").trace("Validating router table (sc=" + this.getSlotCount() + ')');
        boolean bl = true;
        int n = 0;
        if (this.getSlotCount() < 6) {
            return;
        }
        block0: do {
            Class clazz;
            if ((clazz = class$com$tridium$bacnet$stack$network$BBacnetRouterEntry) == null) {
                clazz = BBacnetRouterTable.class("[Lcom.tridium.bacnet.stack.network.BBacnetRouterEntry;", false);
            }
            BBacnetRouterEntry[] bBacnetRouterEntryArray = (BBacnetRouterEntry[])this.getChildren(clazz);
            int n2 = 0;
            while (n2 < bBacnetRouterEntryArray.length) {
                int n3 = n2 + 1;
                while (n3 < bBacnetRouterEntryArray.length) {
                    if (bBacnetRouterEntryArray[n2].getDnet() == bBacnetRouterEntryArray[n3].getRouterAddress().getNetworkNumber() && bBacnetRouterEntryArray[n2].getRouterAddress().getNetworkNumber() == bBacnetRouterEntryArray[n3].getDnet()) {
                        Log.getLog((String)"bacnet.network").error("Conflict detected between router table entries " + n2 + " and " + n3 + "- removing entry " + n3 + "...");
                        bl = false;
                        this.remove((BComplex)bBacnetRouterEntryArray[n3]);
                        break;
                    }
                    ++n3;
                }
                if (!bl) continue block0;
                ++n2;
            }
        } while (!bl && ++n < this.getSlotCount());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.routerEntryRemovalTicket = null;
    }

    public BBacnetRouterTable() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$stack$network$BBacnetRouterTable;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$network$BBacnetRouterTable = BBacnetRouterTable.class("[Lcom.tridium.bacnet.stack.network.BBacnetRouterTable;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

