/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.network;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.link.BLinkLayerChoice;
import com.tridium.bacnet.stack.network.BBacnetRouterEntry;
import com.tridium.bacnet.stack.network.BBacnetRouterTable;
import com.tridium.bacnet.stack.network.BNetworkPort;
import com.tridium.bacnet.stack.network.BNetworkPriority;
import com.tridium.bacnet.stack.network.BRouterStatus;
import com.tridium.bacnet.stack.network.NetworkMsgType;
import com.tridium.bacnet.stack.network.NetworkPdu;
import com.tridium.bacnet.stack.network.PrioritizedQueueEntry;
import com.tridium.bacnet.stack.network.RunnablePrioritizedQueue;
import com.tridium.bacnet.stack.network.messages.ApplicationMsg;
import com.tridium.bacnet.stack.network.messages.DisconnectConnectionToNetwork;
import com.tridium.bacnet.stack.network.messages.EstablishConnectionToNetwork;
import com.tridium.bacnet.stack.network.messages.IAmRouterToNetwork;
import com.tridium.bacnet.stack.network.messages.ICouldBeRouterToNetwork;
import com.tridium.bacnet.stack.network.messages.InitializeRoutingTable;
import com.tridium.bacnet.stack.network.messages.InitializeRoutingTableAck;
import com.tridium.bacnet.stack.network.messages.NetworkLayerMsg;
import com.tridium.bacnet.stack.network.messages.RejectMessageToNetwork;
import com.tridium.bacnet.stack.network.messages.RouterAvailableToNetwork;
import com.tridium.bacnet.stack.network.messages.RouterBusyToNetwork;
import com.tridium.bacnet.stack.network.messages.WhoIsRouterToNetwork;
import com.tridium.bacnet.stack.transport.ApplicationPdu;
import com.tridium.bacnet.stack.transport.BBacnetTransportLayer;
import com.tridium.bacnet.timers.TimerListener;
import com.tridium.bacnet.timers.Timers;
import java.util.Vector;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.log.Log;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.IntHashMap;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.QueueFullException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetNetworkLayer
extends BComponent
implements NetworkMsgType,
TimerListener {
    public static final Property routerTable = BBacnetNetworkLayer.newProperty((int)0, (BValue)new BBacnetRouterTable(), null);
    public static final Property ipPort = BBacnetNetworkLayer.newProperty((int)8, (BValue)BNetworkPort.make(1, BLinkLayerChoice.ip), null);
    public static final Property routingEnabled = BBacnetNetworkLayer.newProperty((int)0, (boolean)true, null);
    public static final Property maintainRoutingEnabled = BBacnetNetworkLayer.newProperty((int)0, (boolean)false, null);
    public static final Property minimumRouterUpdateTime = BBacnetNetworkLayer.newProperty((int)0, (int)500, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"millisecond")));
    public static final Property routerDiscoveryTimeout = BBacnetNetworkLayer.newProperty((int)0, (int)5000, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"millisecond")));
    public static final Property terminationTimeValue = BBacnetNetworkLayer.newProperty((int)0, (int)120, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"second")));
    public static final Type TYPE;
    static final Log log;
    private static final int DNET_NOT_USED = -1;
    private BacnetNetworkQueue myQueue;
    private IntHashMap pendingDNETs;
    private IntHashMap networkNumberUpdates;
    private BNetworkPort[] ports;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$network$BBacnetNetworkLayer;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$network$BNetworkPort;

    public BBacnetRouterTable getRouterTable() {
        return (BBacnetRouterTable)this.get(routerTable);
    }

    public void setRouterTable(BBacnetRouterTable bBacnetRouterTable) {
        this.set(routerTable, (BValue)bBacnetRouterTable, null);
    }

    public BNetworkPort getIpPort() {
        return (BNetworkPort)this.get(ipPort);
    }

    public void setIpPort(BNetworkPort bNetworkPort) {
        this.set(ipPort, (BValue)bNetworkPort, null);
    }

    public boolean getRoutingEnabled() {
        return this.getBoolean(routingEnabled);
    }

    public void setRoutingEnabled(boolean bl) {
        this.setBoolean(routingEnabled, bl, null);
    }

    public boolean getMaintainRoutingEnabled() {
        return this.getBoolean(maintainRoutingEnabled);
    }

    public void setMaintainRoutingEnabled(boolean bl) {
        this.setBoolean(maintainRoutingEnabled, bl, null);
    }

    public int getMinimumRouterUpdateTime() {
        return this.getInt(minimumRouterUpdateTime);
    }

    public void setMinimumRouterUpdateTime(int n) {
        this.setInt(minimumRouterUpdateTime, n, null);
    }

    public int getRouterDiscoveryTimeout() {
        return this.getInt(routerDiscoveryTimeout);
    }

    public void setRouterDiscoveryTimeout(int n) {
        this.setInt(routerDiscoveryTimeout, n, null);
    }

    public int getTerminationTimeValue() {
        return this.getInt(terminationTimeValue);
    }

    public void setTerminationTimeValue(int n) {
        this.setInt(terminationTimeValue, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.myQueue = new BacnetNetworkQueue(this);
        this.myQueue.start("BnNet");
    }

    public void descendantsStarted() {
        this.initializeAsnInputPool();
    }

    /*
     * Unable to fully structure code
     */
    public void stackStopped() {
        this.myQueue.stop();
        this.myQueue = null;
        var1_1 = this.getProperties();
        if (true) ** GOTO lbl7
        do {
            ((BNetworkPort)var1_1.get()).stackStopped();
lbl7:
            // 2 sources

            if ((v0 = BBacnetNetworkLayer.class$com$tridium$bacnet$stack$network$BNetworkPort) != null) continue;
            v0 = BBacnetNetworkLayer.class("[Lcom.tridium.bacnet.stack.network.BNetworkPort;", false);
        } while (var1_1.next(v0));
    }

    public final boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BBacnetStack;
    }

    public void initializeAsnInputPool() {
        BNetworkPort[] bNetworkPortArray = this.getPorts();
        int n = 0;
        int n2 = 0;
        while (n2 < bNetworkPortArray.length) {
            n += bNetworkPortArray[n2].getPollService().getNumberOfThreads();
            ++n2;
        }
        AsnInputStream.setPoolSize(n + 5);
    }

    public BBacnetAddress getAddress(int n) {
        BNetworkPort[] bNetworkPortArray = this.getPorts();
        int n2 = 0;
        while (n2 < bNetworkPortArray.length) {
            if (bNetworkPortArray[n2].getNetworkNumber() == n) {
                return bNetworkPortArray[n2].getAddress();
            }
            ++n2;
        }
        return null;
    }

    public BNetworkPort getPortByNetwork(int n) {
        BNetworkPort bNetworkPort = null;
        boolean bl = false;
        BNetworkPort[] bNetworkPortArray = this.getPorts();
        int n2 = 0;
        while (n2 < bNetworkPortArray.length) {
            if (bNetworkPortArray[n2].getNetworkNumber() == n) {
                if (bl) {
                    log.error("BACnet network layer misconfiguration detected: two network ports with the same network number!");
                    return null;
                }
                bNetworkPort = bNetworkPortArray[n2];
                bl = true;
            }
            ++n2;
        }
        return bNetworkPort;
    }

    public BNetworkPort getPortByDNET(int n) {
        BNetworkPort bNetworkPort = null;
        BBacnetRouterEntry bBacnetRouterEntry = this.getRouter(n);
        if (bBacnetRouterEntry != null) {
            bNetworkPort = this.getPortById(bBacnetRouterEntry.getPortId());
        }
        return bNetworkPort;
    }

    public BNetworkPort getPortById(int n) {
        BNetworkPort[] bNetworkPortArray = this.getPorts();
        int n2 = 0;
        while (n2 < bNetworkPortArray.length) {
            if (bNetworkPortArray[n2].getPortId() == n) {
                return bNetworkPortArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public boolean isDirectlyConnectedNetwork(int n) {
        BNetworkPort bNetworkPort = this.getPortByNetwork(n);
        if (bNetworkPort != null) {
            return bNetworkPort.getStatus().isOk();
        }
        return false;
    }

    public boolean isEnabled() {
        this.loadSlots();
        BNetworkPort[] bNetworkPortArray = this.getPorts();
        int n = 0;
        while (n < bNetworkPortArray.length) {
            bNetworkPortArray[n].loadSlots();
            if (bNetworkPortArray[n].getStatus().isOk()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void networkReady() {
        BNetworkPort[] bNetworkPortArray = this.getPorts();
        int n = 0;
        while (n < bNetworkPortArray.length) {
            bNetworkPortArray[n].networkReady();
            ++n;
        }
        if (this.getRoutingEnabled()) {
            this.issueIAmRouterToNetworks();
        }
        this.issueWhoIsRouterToNetwork(-1);
    }

    public int getQueueSize() {
        return this.myQueue.size();
    }

    public BRelTime getRouterEntryLifetime() {
        BRelTime bRelTime = BRelTime.DAY;
        try {
            BRelTime bRelTime2 = (BRelTime)this.get("routerEntryLifetime");
            if (bRelTime2 != null) {
                bRelTime = bRelTime2;
            }
        }
        catch (Exception exception) {}
        if (bRelTime.getMinutes() < 5) {
            bRelTime = BRelTime.makeMinutes((int)5);
        }
        return bRelTime;
    }

    void receiveNpdu(NetworkPdu networkPdu) throws QueueFullException {
        this.myQueue.enqueue(networkPdu);
    }

    protected void process(NetworkPdu networkPdu) {
        if (networkPdu == null) {
            return;
        }
        if (!this.validateNpdu(networkPdu)) {
            log.error("Received Npdu indicates network misconfiguration!!!\n" + networkPdu + '\n');
            if (!this.getMaintainRoutingEnabled()) {
                this.setRoutingEnabled(false);
            }
            return;
        }
        if (networkPdu.isNetworkLayerMsg()) {
            this.receiveNetworkLayerMessage((NetworkLayerMsg)networkPdu);
        } else {
            this.receiveAPDU((ApplicationMsg)networkPdu);
        }
    }

    public void sendRequest(BBacnetAddress bBacnetAddress, ApplicationPdu applicationPdu) {
        ApplicationMsg applicationMsg;
        byte[] byArray = bBacnetAddress.getMacAddress().getBytes();
        int n = bBacnetAddress.getNetworkNumber();
        if (n == 0 || this.isDirectlyConnectedNetwork(n)) {
            applicationMsg = new ApplicationMsg(null, null, applicationPdu, applicationPdu.getPriority(), applicationPdu.getDataExpectingReply());
        } else {
            applicationMsg = new ApplicationMsg(bBacnetAddress, null, applicationPdu, applicationPdu.getPriority(), applicationPdu.getDataExpectingReply());
            if (n == (char)-1) {
                byArray = null;
            } else {
                BBacnetRouterEntry bBacnetRouterEntry = this.getRouter(n);
                if (bBacnetRouterEntry != null) {
                    n = bBacnetRouterEntry.getRouterAddress().getNetworkNumber();
                    byArray = bBacnetRouterEntry.getRouterAddress().getMacAddress().getBytes();
                } else {
                    if (log.isTraceOn()) {
                        log.trace("Unknown network number: " + n + ", attempting to discover router...");
                    }
                    this.issueWhoIsRouterToNetwork(n);
                    int n2 = applicationMsg.startTimer(this);
                    this.addPendingDNET(applicationMsg.getDNET(), n2);
                    return;
                }
            }
        }
        if (log.isTraceOn()) {
            log.trace(applicationMsg.toString());
        }
        this.sendToPort(n, byArray, applicationMsg);
    }

    private final void receiveAPDU(ApplicationMsg applicationMsg) {
        if (applicationMsg.isSNET()) {
            this.updateRouterAddress(applicationMsg.getSNET(), applicationMsg.getSrcNetworkNumber(), applicationMsg.getSrcMacAddress(), BRouterStatus.ok);
        }
        if (!applicationMsg.isDNET()) {
            this.transport().receiveIndication(applicationMsg.getSrcAddress(), applicationMsg.getDestAddress(), applicationMsg.getRawAPDU(), applicationMsg.getNetworkPriority(), applicationMsg.getDataExpectingReply());
        } else {
            applicationMsg.storeApdu();
            if (applicationMsg.getDNET() == (char)-1) {
                this.transport().receiveIndication(applicationMsg.getSrcAddress(), applicationMsg.getDestAddress(), applicationMsg.getRawAPDU(), applicationMsg.getNetworkPriority(), applicationMsg.getDataExpectingReply());
            } else {
                applicationMsg.getRawAPDU().release();
            }
            this.receiveRemoteTraffic(applicationMsg);
        }
    }

    private final void receiveNetworkLayerMessage(NetworkLayerMsg networkLayerMsg) {
        if (log.isTraceOn()) {
            log.trace("Network layer message received from network " + networkLayerMsg.getSrcNetworkNumber() + ":\n " + networkLayerMsg);
        }
        switch (networkLayerMsg.getMessageType()) {
            case 0: {
                this.processWhoIsRouterToNetwork((WhoIsRouterToNetwork)networkLayerMsg);
                break;
            }
            case 1: {
                this.processIAmRouterToNetwork((IAmRouterToNetwork)networkLayerMsg);
                break;
            }
            case 2: {
                this.processICouldBeRouterToNetwork((ICouldBeRouterToNetwork)networkLayerMsg);
                break;
            }
            case 3: {
                this.processRejectMessageToNetwork((RejectMessageToNetwork)networkLayerMsg);
                break;
            }
            case 4: {
                this.processRouterBusyToNetwork((RouterBusyToNetwork)networkLayerMsg);
                break;
            }
            case 5: {
                this.processRouterAvailableToNetwork((RouterAvailableToNetwork)networkLayerMsg);
                break;
            }
            case 6: {
                if (!this.isRouterActive()) break;
                this.processInitializeRoutingTable((InitializeRoutingTable)networkLayerMsg);
                break;
            }
            case 7: {
                this.processInitializeRoutingTableAck((InitializeRoutingTableAck)networkLayerMsg);
                break;
            }
            case 8: {
                if (!this.isRouterActive()) break;
                this.processEstablishConnectionToNetwork((EstablishConnectionToNetwork)networkLayerMsg);
                break;
            }
            case 9: {
                if (!this.isRouterActive()) break;
                this.processDisconnectConnectionToNetwork((DisconnectConnectionToNetwork)networkLayerMsg);
                break;
            }
            default: {
                this.processProprietaryNetworkMessage(networkLayerMsg);
            }
        }
        if (networkLayerMsg.isDNET()) {
            this.receiveRemoteTraffic(networkLayerMsg);
        }
    }

    private final void receiveRemoteTraffic(NetworkPdu networkPdu) {
        if (!this.getRoutingEnabled()) {
            return;
        }
        if (!networkPdu.isSNET()) {
            networkPdu.setSADR(networkPdu.getSrcMacAddress());
            networkPdu.setSNET(networkPdu.getSrcNetworkNumber());
        }
        if (this.isDirectlyConnectedNetwork(networkPdu.getDNET())) {
            log.trace("Routing message to directly connected network...");
            byte[] byArray = networkPdu.getDADR();
            int n = networkPdu.getDNET();
            networkPdu.setDNET(-1);
            this.sendToPort(n, byArray, networkPdu);
            return;
        }
        if (networkPdu.getHopCount() == 0) {
            return;
        }
        networkPdu.decrementHopCount();
        if (networkPdu.getHopCount() == 0) {
            return;
        }
        if (networkPdu.getDNET() == (char)-1) {
            BNetworkPort[] bNetworkPortArray = this.getPorts();
            int n = 0;
            while (n < bNetworkPortArray.length) {
                if (bNetworkPortArray[n] != networkPdu.getSourcePort()) {
                    bNetworkPortArray[n].sendToLink(networkPdu.getDADR(), networkPdu);
                }
                ++n;
            }
        } else {
            this.sendRemoteTraffic(networkPdu);
        }
    }

    private final void sendRemoteTraffic(NetworkPdu networkPdu) {
        int n = networkPdu.getDNET();
        if (n <= 0) {
            return;
        }
        BBacnetRouterEntry bBacnetRouterEntry = this.getRouter(n, true);
        if (log.isTraceOn()) {
            log.trace("Sending remote traffic: router=" + (Object)((Object)bBacnetRouterEntry));
        }
        if (bBacnetRouterEntry == null) {
            if (log.isTraceOn()) {
                log.trace("Unknown network number: " + n + ", attempting to discover router...");
            }
            this.issueWhoIsRouterToNetwork(n, networkPdu.getSrcNetworkNumber());
            int n2 = networkPdu.startTimer(this);
            this.addPendingDNET(n, n2);
        } else if (bBacnetRouterEntry.getRouterAddress().getNetworkNumber() != networkPdu.getSrcNetworkNumber()) {
            switch (bBacnetRouterEntry.getRouterStatus().getOrdinal()) {
                case 0: {
                    this.sendToPort(bBacnetRouterEntry.getRouterAddress().getNetworkNumber(), bBacnetRouterEntry.getRouterAddress().getMacAddress().getBytes(), networkPdu, networkPdu.getNetworkPriority(), networkPdu.getDataExpectingReply());
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    this.sendToPort(networkPdu.getSrcNetworkNumber(), networkPdu.getSrcMacAddress(), new RejectMessageToNetwork(1, n), networkPdu.getNetworkPriority(), false);
                    break;
                }
                case 2: {
                    this.sendToPort(networkPdu.getSrcNetworkNumber(), networkPdu.getSrcMacAddress(), new RejectMessageToNetwork(2, n), networkPdu.getNetworkPriority(), false);
                    break;
                }
                default: {
                    System.out.println("receiveRemoteTraffic:Unknown router status " + (Object)((Object)bBacnetRouterEntry.getRouterStatus()) + " for router " + (Object)((Object)bBacnetRouterEntry));
                }
            }
        }
    }

    private final void processWhoIsRouterToNetwork(WhoIsRouterToNetwork whoIsRouterToNetwork) {
        if (!this.getRoutingEnabled()) {
            return;
        }
        int n = whoIsRouterToNetwork.getSrcNetworkNumber();
        if (whoIsRouterToNetwork.isNetworkNumber()) {
            int n2 = whoIsRouterToNetwork.getNetworkNumber();
            if (n2 == 0) {
                return;
            }
            if (this.isDirectlyConnectedNetwork(n2)) {
                if (n2 != n) {
                    this.sendToPort(n, null, new IAmRouterToNetwork(n2), whoIsRouterToNetwork.getNetworkPriority(), false);
                }
            } else {
                BBacnetRouterEntry bBacnetRouterEntry = this.getRouter(n2, false);
                if (bBacnetRouterEntry != null) {
                    if (bBacnetRouterEntry.getPortId() != whoIsRouterToNetwork.getSourcePort().getPortId()) {
                        this.sendToPort(n, null, new IAmRouterToNetwork(n2), whoIsRouterToNetwork.getNetworkPriority(), false);
                    }
                } else {
                    if (!whoIsRouterToNetwork.isSNET()) {
                        whoIsRouterToNetwork.setSADR(whoIsRouterToNetwork.getSrcMacAddress());
                        whoIsRouterToNetwork.setSNET(whoIsRouterToNetwork.getSrcNetworkNumber());
                    }
                    BNetworkPort[] bNetworkPortArray = this.getPorts();
                    int n3 = 0;
                    while (n3 < bNetworkPortArray.length) {
                        if (bNetworkPortArray[n3] != whoIsRouterToNetwork.getSourcePort()) {
                            bNetworkPortArray[n3].sendToLink(null, whoIsRouterToNetwork);
                        }
                        ++n3;
                    }
                }
            }
        } else {
            int[] nArray = this.getRouterTable().getDnets(whoIsRouterToNetwork.getSourcePort().getPortId());
            if (nArray != null && nArray.length > 0) {
                this.sendToPort(n, null, new IAmRouterToNetwork(nArray), whoIsRouterToNetwork.getNetworkPriority(), false);
            }
        }
    }

    private final void processIAmRouterToNetwork(IAmRouterToNetwork iAmRouterToNetwork) {
        int[] nArray = iAmRouterToNetwork.getNetworkNumbers();
        boolean bl = true;
        int n = 0;
        while (n < nArray.length) {
            if (!this.checkNetworkConfig(nArray[n], true)) {
                bl = false;
            }
            ++n;
        }
        if (!bl) {
            if (!this.getMaintainRoutingEnabled()) {
                log.error("Disabling Bacnet Router functionality until network configuration is fixed!");
                this.setRoutingEnabled(false);
            }
            return;
        }
        this.updateRouterAddress(nArray, iAmRouterToNetwork.getSrcNetworkNumber(), iAmRouterToNetwork.getSrcMacAddress(), BRouterStatus.ok);
        n = 0;
        while (n < nArray.length) {
            this.processPendingNpdus(nArray[n]);
            ++n;
        }
        if (!this.getRoutingEnabled()) {
            return;
        }
        if (nArray.length == 0) {
            return;
        }
        BNetworkPort[] bNetworkPortArray = this.getPorts();
        int n2 = 0;
        while (n2 < bNetworkPortArray.length) {
            if (bNetworkPortArray[n2].getStatus().isOk() && bNetworkPortArray[n2].getNetworkNumber() != iAmRouterToNetwork.getSrcNetworkNumber()) {
                bNetworkPortArray[n2].sendToLink(null, iAmRouterToNetwork);
            }
            ++n2;
        }
    }

    private final void processICouldBeRouterToNetwork(ICouldBeRouterToNetwork iCouldBeRouterToNetwork) {
        this.updateRouterAddress(iCouldBeRouterToNetwork.getNetworkNumber(), iCouldBeRouterToNetwork.getSrcNetworkNumber(), iCouldBeRouterToNetwork.getSrcMacAddress(), BRouterStatus.routerNotConnected);
    }

    private final void processRejectMessageToNetwork(RejectMessageToNetwork rejectMessageToNetwork) {
        log.error(rejectMessageToNetwork.toString());
        switch (rejectMessageToNetwork.getRejectReason()) {
            case 1: {
                BBacnetRouterEntry bBacnetRouterEntry = this.getRouterTable().getRouterByDnet(rejectMessageToNetwork.getRejectedDNET());
                if (bBacnetRouterEntry == null) break;
                bBacnetRouterEntry.setRouterStatus(BRouterStatus.routerUnavailable);
                break;
            }
            case 2: {
                BBacnetRouterEntry bBacnetRouterEntry = this.getRouterTable().getRouterByDnet(rejectMessageToNetwork.getRejectedDNET());
                if (bBacnetRouterEntry == null) break;
                bBacnetRouterEntry.setRouterStatus(BRouterStatus.routerBusy);
                break;
            }
        }
    }

    private final void processRouterBusyToNetwork(RouterBusyToNetwork routerBusyToNetwork) {
        Object object;
        RouterBusyToNetwork routerBusyToNetwork2 = null;
        if (routerBusyToNetwork.isAllNetworks()) {
            object = this.getRouterTable().getRoutersByAddress(routerBusyToNetwork.getSrcNetworkNumber(), routerBusyToNetwork.getSrcMacAddress());
            int[] nArray = new int[((Vector)object).size()];
            if (((Vector)object).size() > 0) {
                int n = 0;
                while (n < ((Vector)object).size()) {
                    BBacnetRouterEntry bBacnetRouterEntry = (BBacnetRouterEntry)((Object)((Vector)object).elementAt(n));
                    bBacnetRouterEntry.setRouterStatus(BRouterStatus.routerBusy);
                    bBacnetRouterEntry.startBusyTimer();
                    nArray[n] = bBacnetRouterEntry.getDnet();
                    ++n;
                }
                routerBusyToNetwork2 = new RouterBusyToNetwork(nArray);
            }
        } else {
            object = routerBusyToNetwork.getNetworkNumbers();
            int n = 0;
            while (n < ((int[])object).length) {
                BBacnetRouterEntry bBacnetRouterEntry = this.getRouterTable().getRouterByDnet((int)object[n]);
                if (bBacnetRouterEntry == null) {
                    this.updateRouterAddress((int)object[n], routerBusyToNetwork.getSrcNetworkNumber(), routerBusyToNetwork.getSrcMacAddress(), BRouterStatus.routerBusy);
                } else {
                    bBacnetRouterEntry.setRouterStatus(BRouterStatus.routerBusy);
                    bBacnetRouterEntry.startBusyTimer();
                }
                ++n;
            }
            routerBusyToNetwork2 = new RouterBusyToNetwork((int[])object);
        }
        if (this.getRoutingEnabled() && routerBusyToNetwork2 != null) {
            object = this.getPorts();
            int n = 0;
            while (n < ((Object)object).length) {
                if (((BNetworkPort)object[n]).getStatus().isOk() && object[n] != routerBusyToNetwork.getSourcePort()) {
                    ((BNetworkPort)object[n]).sendToLink(null, routerBusyToNetwork2);
                }
                ++n;
            }
        }
    }

    private final void processRouterAvailableToNetwork(RouterAvailableToNetwork routerAvailableToNetwork) {
        Object object;
        RouterAvailableToNetwork routerAvailableToNetwork2 = null;
        if (routerAvailableToNetwork.isAllNetworks()) {
            object = this.getRouterTable().getRoutersByAddress(routerAvailableToNetwork.getSrcNetworkNumber(), routerAvailableToNetwork.getSrcMacAddress());
            int[] nArray = new int[((Vector)object).size()];
            if (((Vector)object).size() > 0) {
                int n = 0;
                while (n < ((Vector)object).size()) {
                    BBacnetRouterEntry bBacnetRouterEntry = (BBacnetRouterEntry)((Object)((Vector)object).elementAt(n));
                    bBacnetRouterEntry.setRouterStatus(BRouterStatus.ok);
                    bBacnetRouterEntry.stopBusyTimer();
                    nArray[n] = bBacnetRouterEntry.getDnet();
                    ++n;
                }
                routerAvailableToNetwork2 = new RouterAvailableToNetwork(nArray);
            }
        } else {
            object = routerAvailableToNetwork.getNetworkNumbers();
            int n = 0;
            while (n < ((int[])object).length) {
                BBacnetRouterEntry bBacnetRouterEntry = this.getRouterTable().getRouterByDnet((int)object[n]);
                if (bBacnetRouterEntry == null) {
                    this.updateRouterAddress((int)object[n], routerAvailableToNetwork.getSrcNetworkNumber(), routerAvailableToNetwork.getSrcMacAddress(), BRouterStatus.ok);
                } else {
                    bBacnetRouterEntry.setRouterStatus(BRouterStatus.ok);
                    bBacnetRouterEntry.stopBusyTimer();
                }
                ++n;
            }
            routerAvailableToNetwork2 = new RouterAvailableToNetwork((int[])object);
        }
        if (this.getRoutingEnabled() && routerAvailableToNetwork2 != null) {
            object = this.getPorts();
            int n = 0;
            while (n < ((Object)object).length) {
                if (((BNetworkPort)object[n]).getStatus().isOk() && object[n] != routerAvailableToNetwork.getSourcePort()) {
                    ((BNetworkPort)object[n]).sendToLink(null, routerAvailableToNetwork2);
                }
                ++n;
            }
        }
    }

    private final void processInitializeRoutingTable(InitializeRoutingTable initializeRoutingTable) {
        InitializeRoutingTableAck initializeRoutingTableAck;
        BNetworkPort bNetworkPort = this.getPortByNetwork(initializeRoutingTable.getSrcNetworkNumber());
        if (initializeRoutingTable.isEmpty()) {
            initializeRoutingTableAck = new InitializeRoutingTableAck(this.getRouterTable());
        } else {
            BBacnetRouterEntry[] bBacnetRouterEntryArray = initializeRoutingTable.getTable();
            int n = 0;
            while (n < bBacnetRouterEntryArray.length) {
                if (bBacnetRouterEntryArray[n].getPortId() == 0) {
                    this.getRouterTable().removeRouterByDnet(bBacnetRouterEntryArray[n].getDnet());
                } else {
                    this.getRouterTable().addRouter(bBacnetRouterEntryArray[n]);
                }
                ++n;
            }
            initializeRoutingTableAck = new InitializeRoutingTableAck();
        }
        if (bNetworkPort != null) {
            bNetworkPort.sendToLink(initializeRoutingTable.getSrcMacAddress(), initializeRoutingTableAck);
        }
    }

    private final void processInitializeRoutingTableAck(InitializeRoutingTableAck initializeRoutingTableAck) {
        if (log.isTraceOn()) {
            log.trace(initializeRoutingTableAck.toString());
        }
    }

    private final void processEstablishConnectionToNetwork(EstablishConnectionToNetwork establishConnectionToNetwork) {
        this.sendToPort(establishConnectionToNetwork.getSrcNetworkNumber(), establishConnectionToNetwork.getSrcMacAddress(), new RejectMessageToNetwork(0, establishConnectionToNetwork.getNetworkNumber()), establishConnectionToNetwork.getNetworkPriority(), false);
    }

    private final void processDisconnectConnectionToNetwork(DisconnectConnectionToNetwork disconnectConnectionToNetwork) {
        this.sendToPort(disconnectConnectionToNetwork.getSrcNetworkNumber(), disconnectConnectionToNetwork.getSrcMacAddress(), new RejectMessageToNetwork(0, disconnectConnectionToNetwork.getNetworkNumber()), disconnectConnectionToNetwork.getNetworkPriority(), false);
    }

    private final void processProprietaryNetworkMessage(NetworkLayerMsg networkLayerMsg) {
        if (log.isTraceOn()) {
            log.trace("Proprietary Bacnet Network Layer Msg encountered, code = " + networkLayerMsg.getMessageType());
        }
        if (!networkLayerMsg.isDNET()) {
            this.sendToPort(networkLayerMsg.getSrcNetworkNumber(), networkLayerMsg.getSrcMacAddress(), new RejectMessageToNetwork(3, 0));
        }
    }

    void issueIAmRouterToNetworks() {
        if (this.getRoutingEnabled()) {
            BNetworkPort[] bNetworkPortArray = this.getPorts();
            int n = 0;
            while (n < bNetworkPortArray.length) {
                int[] nArray;
                if (bNetworkPortArray[n].getStatus().isOk() && (nArray = this.getRouterTable().getDnets(bNetworkPortArray[n].getPortId())) != null && nArray.length != 0) {
                    bNetworkPortArray[n].sendToLink(null, new IAmRouterToNetwork(nArray));
                }
                ++n;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final BNetworkPort[] getPorts() {
        var1_1 = this.getProperties();
        var2_2 = 0;
        if (true) ** GOTO lbl10
        do {
            if (this.ports == null || var2_2 >= this.ports.length || this.ports[var2_2++] != var1_1.get()) {
                v0 = BBacnetNetworkLayer.class$com$tridium$bacnet$stack$network$BNetworkPort;
                if (v0 == null) {
                    v0 = BBacnetNetworkLayer.class("[Lcom.tridium.bacnet.stack.network.BNetworkPort;", false);
                }
                this.ports = (BNetworkPort[])this.getChildren(v0);
            }
lbl10:
            // 4 sources

            if ((v1 = BBacnetNetworkLayer.class$com$tridium$bacnet$stack$network$BNetworkPort) != null) continue;
            v1 = BBacnetNetworkLayer.class("[Lcom.tridium.bacnet.stack.network.BNetworkPort;", false);
        } while (var1_1.next(v1));
        return this.ports;
    }

    private final boolean isRouterActive() {
        if (this.getRoutingEnabled()) {
            this.loadSlots();
            BNetworkPort[] bNetworkPortArray = this.getPorts();
            boolean bl = false;
            int n = 0;
            while (n < bNetworkPortArray.length) {
                if (bNetworkPortArray[n].getStatus().isOk()) {
                    if (bl) {
                        return true;
                    }
                    bl = true;
                }
                ++n;
            }
        }
        return false;
    }

    private final void sendToPort(int n, byte[] byArray, NetworkPdu networkPdu, BNetworkPriority bNetworkPriority, boolean bl) {
        networkPdu.setNetworkPriority(bNetworkPriority);
        networkPdu.setDataExpectingReply(bl);
        this.sendToPort(n, byArray, networkPdu);
    }

    private final void sendToPort(int n, byte[] byArray, NetworkPdu networkPdu) {
        if (n == (char)-1 || n == 0) {
            BNetworkPort[] bNetworkPortArray = this.getPorts();
            int n2 = 0;
            while (n2 < bNetworkPortArray.length) {
                bNetworkPortArray[n2].sendToLink(byArray, networkPdu);
                ++n2;
            }
        } else {
            BNetworkPort bNetworkPort = this.getPortByNetwork(n);
            if (bNetworkPort != null) {
                bNetworkPort.sendToLink(byArray, networkPdu);
            } else {
                log.warning("Unable to send Npdu to port: unknown networkNumber (" + n + ')');
            }
        }
    }

    private final void connectToNetwork(BBacnetRouterEntry bBacnetRouterEntry) {
        EstablishConnectionToNetwork establishConnectionToNetwork = new EstablishConnectionToNetwork(bBacnetRouterEntry.getDnet(), this.getTerminationTimeValue());
        this.sendToPort(bBacnetRouterEntry.getRouterAddress().getNetworkNumber(), bBacnetRouterEntry.getRouterAddress().getMacAddress().getBytes(), establishConnectionToNetwork);
    }

    private final void issueWhoIsRouterToNetwork(int n) {
        this.issueWhoIsRouterToNetwork(n, -1);
    }

    private final void issueWhoIsRouterToNetwork(int n, int n2) {
        WhoIsRouterToNetwork whoIsRouterToNetwork = new WhoIsRouterToNetwork(n);
        whoIsRouterToNetwork.setNetworkPriority(BNetworkPriority.urgent);
        BNetworkPort[] bNetworkPortArray = this.getPorts();
        int n3 = 0;
        while (n3 < bNetworkPortArray.length) {
            if (bNetworkPortArray[n3].getNetworkNumber() != n2) {
                bNetworkPortArray[n3].sendToLink(null, whoIsRouterToNetwork);
            }
            ++n3;
        }
    }

    private final void addPendingDNET(int n, int n2) {
        Vector<Integer> vector = (Vector<Integer>)this.pendingDNETs.get(n);
        if (vector == null) {
            vector = new Vector<Integer>();
            vector.addElement(new Integer(n2));
            this.pendingDNETs.put(n, vector);
        } else {
            vector.addElement(new Integer(n2));
        }
    }

    private final void processPendingNpdus(int n) {
        Vector vector = (Vector)this.pendingDNETs.remove(n);
        if (vector != null) {
            int n2 = 0;
            while (n2 < vector.size()) {
                int n3 = (Integer)vector.elementAt(n2);
                NetworkPdu networkPdu = (NetworkPdu)Timers.cancel(n3);
                if (networkPdu != null) {
                    this.sendRemoteTraffic(networkPdu);
                }
                ++n2;
            }
        }
    }

    private final BBacnetRouterEntry getRouter(int n) {
        return this.getRouter(n, true);
    }

    private final BBacnetRouterEntry getRouter(int n, boolean bl) {
        BBacnetRouterEntry bBacnetRouterEntry = this.getRouterTable().getRouterByDnet(n);
        if (bBacnetRouterEntry != null) {
            if (bBacnetRouterEntry.isDisconnected()) {
                if (bl) {
                    this.connectToNetwork(bBacnetRouterEntry);
                    log.message("Requesting connection establishment to network " + n + "...");
                    return bBacnetRouterEntry;
                }
                return null;
            }
            if (bBacnetRouterEntry.isUnavailable()) {
                log.error("Router to network " + n + " is permanently unavailable!!");
                return null;
            }
            return bBacnetRouterEntry;
        }
        return bBacnetRouterEntry;
    }

    void updateRouterAddress(int n, int n2, byte[] byArray, BRouterStatus bRouterStatus) {
        this.updateRouterAddress(n, n2, byArray, bRouterStatus, null);
    }

    void updateRouterAddress(int n, int n2, byte[] byArray, BRouterStatus bRouterStatus, String string) {
        BNetworkPort bNetworkPort;
        if (n != n2 && (bNetworkPort = this.getPortByNetwork(n)) != null && bNetworkPort.getStatus().isOk()) {
            log.error("Bacnet Internetwork misconfiguration detected(5):\nReceived an update to the router table for DNET " + n + ", but we are already a router to that DNET!!");
            return;
        }
        bNetworkPort = this.getPortByNetwork(n2);
        if (bNetworkPort != null) {
            this.getRouterTable().updateRouter(n, n2, byArray, bNetworkPort.getPortId(), string, bRouterStatus);
        }
        log.trace("UpdateRouterAddress: networkNumber " + n + " router MAC Address: " + ByteArrayUtil.toHexString((byte[])byArray));
    }

    void updateRouterAddress(int[] nArray, int n, byte[] byArray, BRouterStatus bRouterStatus) {
        int n2 = 0;
        while (n2 < nArray.length) {
            this.updateRouterAddress(nArray[n2], n, byArray, bRouterStatus, null);
            ++n2;
        }
    }

    private final boolean checkNetworkConfig(int n, boolean bl) {
        BNetworkPort bNetworkPort;
        boolean bl2 = true;
        if (bl) {
            long l = Clock.ticks();
            Long l2 = (Long)this.networkNumberUpdates.get(n);
            if (l2 != null && l - l2 < (long)this.getMinimumRouterUpdateTime()) {
                log.error("Bacnet Network Misconfiguration detected(3): Network number update frequency (" + (l - l2) + "ms) indicates possible router loop on network " + n + "!!!");
                if (!this.getMaintainRoutingEnabled()) {
                    this.getRouterTable().removeRouterByDnet(n);
                }
                bl2 = false;
            }
            this.networkNumberUpdates.put(n, (Object)new Long(l));
        }
        if ((bNetworkPort = this.getPortByNetwork(n)) != null && bNetworkPort.getStatus().isOk()) {
            log.error("Bacnet Network Misconfiguration detected(4): Possible router loop, or duplicate network number " + n);
            if (!this.getMaintainRoutingEnabled()) {
                this.getRouterTable().removeRouterByDnet(n);
            }
            bl2 = false;
        }
        return bl2;
    }

    private final boolean validateNpdu(NetworkPdu networkPdu) {
        BBacnetAddress bBacnetAddress = networkPdu.getSrcAddress();
        BNetworkPort[] bNetworkPortArray = this.getPorts();
        int n = 0;
        while (n < bNetworkPortArray.length) {
            if (bNetworkPortArray[n].getStatus().isOk()) {
                byte[] byArray = bNetworkPortArray[n].getLink().getMacAddress();
                if (bBacnetAddress.equals(bNetworkPortArray[n].getNetworkNumber(), byArray)) {
                    log.error("Bacnet Network Misconfiguration detected(1): Received message from network " + networkPdu.getSrcNetworkNumber() + " sent originally by us on network " + bNetworkPortArray[n].getNetworkNumber() + "!!!");
                    if (!this.getMaintainRoutingEnabled()) {
                        this.getRouterTable().removeRouterByDnet(networkPdu.getSrcNetworkNumber());
                        if (networkPdu.isSNET()) {
                            this.getRouterTable().removeRouterByDnet(networkPdu.getSNET());
                        }
                    }
                    return false;
                }
            }
            ++n;
        }
        if (networkPdu.isSNET()) {
            n = networkPdu.getSNET();
            int n2 = 0;
            while (n2 < bNetworkPortArray.length) {
                if (n == bNetworkPortArray[n2].getNetworkNumber() && bNetworkPortArray[n2].getStatus().isOk()) {
                    log.error("Bacnet Network Misconfiguration detected(2): Received message from network " + networkPdu.getSrcNetworkNumber() + ", but we are also a router to network " + n + "!!!");
                    if (!this.getMaintainRoutingEnabled()) {
                        this.getRouterTable().removeRouterByDnet(networkPdu.getSrcNetworkNumber());
                        if (networkPdu.isSNET()) {
                            this.getRouterTable().removeRouterByDnet(networkPdu.getSNET());
                        }
                    }
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private final BBacnetTransportLayer transport() {
        return ((BBacnetStack)this.getParent()).getTransport();
    }

    public long timerExpired(int n, Object object) {
        if (object instanceof BBacnetRouterEntry) {
            ((BBacnetRouterEntry)((Object)object)).setRouterStatus(BRouterStatus.ok);
        } else if (object instanceof NetworkPdu) {
            NetworkPdu networkPdu = (NetworkPdu)object;
            if (networkPdu.getSrcMacAddress() != null) {
                log.warning("Router discovery timer expired for dnet " + networkPdu.getDNET() + ", sending reject...");
                this.sendToPort(networkPdu.getSrcNetworkNumber(), networkPdu.getSrcMacAddress(), new RejectMessageToNetwork(1, networkPdu.getDNET()), networkPdu.getNetworkPriority(), false);
            }
            Vector vector = (Vector)this.pendingDNETs.get(networkPdu.getDNET());
            vector.removeElement(new Integer(n));
        }
        return 0L;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        Object object;
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetNetworkLayer", 2);
        spyWriter.prop((Object)"ticks", (Object)("" + Clock.ticks()));
        spyWriter.prop((Object)"->now", (Object)Clock.time());
        spyWriter.prop((Object)"pendingDNETs", this.pendingDNETs.size());
        IntHashMap.Iterator iterator = this.pendingDNETs.iterator();
        while (iterator.hasNext()) {
            object = (Vector)iterator.next();
            int n = iterator.key();
            int n2 = ((Vector)object).size();
            spyWriter.prop((Object)("dnet:" + n), (Object)("pending NPDUs:" + n2));
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append(' ').append(((Vector)object).get(n3));
                ++n3;
            }
            spyWriter.prop((Object)"    timerIds", (Object)stringBuffer.toString());
        }
        spyWriter.prop((Object)"networkNumberUpdates", this.networkNumberUpdates.size());
        iterator = this.networkNumberUpdates.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            spyWriter.prop((Object)("dnet:" + iterator.key()), object);
        }
        spyWriter.prop((Object)"myQueue.size", this.myQueue.size());
        spyWriter.prop((Object)"myQueue.maxSize", this.myQueue.maxSize());
        spyWriter.endProps();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.pendingDNETs = new IntHashMap();
        this.networkNumberUpdates = new IntHashMap();
        this.ports = null;
    }

    public BBacnetNetworkLayer() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$stack$network$BBacnetNetworkLayer;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$network$BBacnetNetworkLayer = BBacnetNetworkLayer.class("[Lcom.tridium.bacnet.stack.network.BBacnetNetworkLayer;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"bacnet.network");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BacnetNetworkQueue
    extends RunnablePrioritizedQueue {
        private BBacnetNetworkLayer network;

        protected void process(PrioritizedQueueEntry prioritizedQueueEntry) {
            this.network.process((NetworkPdu)prioritizedQueueEntry);
        }

        BacnetNetworkQueue(BBacnetNetworkLayer bBacnetNetworkLayer2) {
            this.network = bBacnetNetworkLayer2;
        }
    }
}

