/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.ip;

import com.tridium.bacnet.stack.link.ip.BBacnetIpLinkLayer;
import com.tridium.bacnet.stack.link.ip.BvllMessage;
import com.tridium.bacnet.stack.link.ip.DeleteForeignDeviceTableEntry;
import com.tridium.bacnet.stack.link.ip.RegisterForeignDevice;
import com.tridium.bacnet.stack.network.BNetworkPort;
import java.net.InetAddress;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BForeignDeviceRegistration
extends BComponent {
    public static final Property enabled = BForeignDeviceRegistration.newProperty((int)64, (boolean)false, null);
    public static final Property bbmdAddress = BForeignDeviceRegistration.newProperty((int)0, (String)"null", null);
    public static final Property registrationLifetime = BForeignDeviceRegistration.newProperty((int)0, (BValue)BRelTime.make((long)900000L), null);
    public static final Action registerWithBBMD = BForeignDeviceRegistration.newAction((int)0, null);
    public static final Action unregisterWithBBMD = BForeignDeviceRegistration.newAction((int)0, null);
    public static final Type TYPE;
    private static final int REG_OVERLAP_MS = 30000;
    private static final Log log;
    private static Object FD_TICKET_LOCK;
    private String oldAddress;
    private Clock.Ticket registrationTicket;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$link$ip$BForeignDeviceRegistration;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public String getBbmdAddress() {
        return this.getString(bbmdAddress);
    }

    public void setBbmdAddress(String string) {
        this.setString(bbmdAddress, string, null);
    }

    public BRelTime getRegistrationLifetime() {
        return (BRelTime)this.get(registrationLifetime);
    }

    public void setRegistrationLifetime(BRelTime bRelTime) {
        this.set(registrationLifetime, (BValue)bRelTime, null);
    }

    public void registerWithBBMD() {
        this.invoke(registerWithBBMD, null, null);
    }

    public void unregisterWithBBMD() {
        this.invoke(unregisterWithBBMD, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBacnetIpLinkLayer linklayer() {
        return (BBacnetIpLinkLayer)this.getParent();
    }

    public BNetworkPort port() {
        return (BNetworkPort)this.linklayer().getParent();
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BBacnetIpLinkLayer;
    }

    public void started() throws Exception {
        if (this.isRunning()) {
            this.doRegisterWithBBMD();
        }
    }

    public void stopped() {
        if (this.isRunning()) {
            this.doUnregisterWithBBMD();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning()) {
            if (property.equals((Object)enabled)) {
                if (this.getEnabled()) {
                    this.doRegisterWithBBMD();
                } else {
                    this.doUnregisterWithBBMD();
                }
            } else if (property.equals((Object)bbmdAddress)) {
                if (this.oldAddress != null) {
                    this.unregister(this.oldAddress);
                    this.doRegisterWithBBMD();
                }
            } else if (property.equals((Object)registrationLifetime) && this.getEnabled()) {
                this.cancelTicket();
                this.startTicket();
                this.doRegisterWithBBMD();
            }
        }
    }

    public void doRegisterWithBBMD() {
        this.register(this.getBbmdAddress());
    }

    public void doUnregisterWithBBMD() {
        this.unregister(this.getBbmdAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void startTicket() {
        Object object = FD_TICKET_LOCK;
        synchronized (object) {
            if (this.getEnabled() && this.ticketExpired()) {
                this.registrationTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getOverlappingInterval(), (Action)registerWithBBMD, null);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void cancelTicket() {
        Object object = FD_TICKET_LOCK;
        synchronized (object) {
            if (this.registrationTicket != null) {
                this.registrationTicket.cancel();
                this.registrationTicket = null;
            }
            return;
        }
    }

    private final boolean ticketExpired() {
        boolean bl = false;
        if (this.registrationTicket == null || this.registrationTicket.isExpired()) {
            bl = true;
        }
        return bl;
    }

    private final BRelTime getOverlappingInterval() {
        return BRelTime.make((long)(this.getRegistrationLifetime().getMillis() - 30000L));
    }

    protected void register(String string) {
        this.oldAddress = string;
        if (this.getEnabled() && this.port().getEnabled()) {
            try {
                if (log.isTraceOn()) {
                    log.trace("Registering with BBMD at IP:" + string);
                }
                this.sendBvll(string, new RegisterForeignDevice(this.getRegistrationLifetime().getSeconds()));
                this.startTicket();
            }
            catch (Exception exception) {
                log.warning("Unable to send foreign device registration", (Throwable)exception);
            }
        }
    }

    protected void unregister(String string) {
        this.cancelTicket();
        this.sendBvll(string, new DeleteForeignDeviceTableEntry(this.getLocalMacAddress()));
    }

    protected void sendBvll(BvllMessage bvllMessage) {
        this.sendBvll(this.getBbmdAddress(), bvllMessage);
    }

    protected void sendBvll(String string, BvllMessage bvllMessage) {
        try {
            byte[] byArray = this.getMacBytes(string);
            if (byArray != null && byArray.length == 6) {
                InetAddress inetAddress = this.linklayer().lookupInetAddr(byArray);
                if (inetAddress != null) {
                    int n = BBacnetIpLinkLayer.getPort(byArray);
                    if (log.isTraceOn()) {
                        log.trace("Sending BVLL message to " + string);
                    }
                    this.sendBvllMessage(inetAddress, n, bvllMessage);
                }
            } else if (log.isTraceOn()) {
                log.trace("unable Sending BVLL message to " + string);
            }
        }
        catch (Exception exception) {
            log.warning("Unable to send bvll message", (Throwable)exception);
        }
    }

    protected void sendBvllMessage(InetAddress inetAddress, int n, BvllMessage bvllMessage) {
        this.linklayer().sendBvllMessage(inetAddress, n, bvllMessage);
    }

    protected byte[] getMacBytes(String string) {
        return BBacnetIpLinkLayer.getMacBytes(string);
    }

    protected byte[] getLocalMacAddress() {
        return this.linklayer().getMac();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.oldAddress = null;
        this.registrationTicket = null;
    }

    public BForeignDeviceRegistration() {
        this.this();
    }

    public BForeignDeviceRegistration(String string) {
        this(string, null);
    }

    public BForeignDeviceRegistration(String string, BRelTime bRelTime) {
        this.this();
        this.setBbmdAddress(string);
        this.setRegistrationLifetime(bRelTime);
    }

    static {
        Class clazz = class$com$tridium$bacnet$stack$link$ip$BForeignDeviceRegistration;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$link$ip$BForeignDeviceRegistration = BForeignDeviceRegistration.class("[Lcom.tridium.bacnet.stack.link.ip.BForeignDeviceRegistration;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"bacnet.link.ip");
        FD_TICKET_LOCK = new Object();
    }
}

