/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.ip;

import com.tridium.bacnet.enums.BIpDeviceType;
import com.tridium.bacnet.stack.BacnetInputStream;
import com.tridium.bacnet.stack.link.BBacnetLinkLayer;
import com.tridium.bacnet.stack.link.ip.BBdtEntry;
import com.tridium.bacnet.stack.link.ip.BBroadcastDistributionTable;
import com.tridium.bacnet.stack.link.ip.BFdtEntry;
import com.tridium.bacnet.stack.link.ip.BForeignDeviceRegistration;
import com.tridium.bacnet.stack.link.ip.BForeignDeviceTable;
import com.tridium.bacnet.stack.link.ip.BvlcResult;
import com.tridium.bacnet.stack.link.ip.BvllConst;
import com.tridium.bacnet.stack.link.ip.BvllMessage;
import com.tridium.bacnet.stack.link.ip.DistributeBroadcastToNetwork;
import com.tridium.bacnet.stack.link.ip.ForwardedNpdu;
import com.tridium.bacnet.stack.link.ip.OriginalBroadcastNpdu;
import com.tridium.bacnet.stack.link.ip.OriginalUnicastNpdu;
import com.tridium.bacnet.stack.link.ip.ReadBroadcastDistributionTable;
import com.tridium.bacnet.stack.link.ip.ReadBroadcastDistributionTableAck;
import com.tridium.bacnet.stack.link.ip.ReadForeignDeviceTableAck;
import com.tridium.bacnet.stack.link.ip.WriteBroadcastDistributionTable;
import com.tridium.bacnet.stack.network.NetworkPdu;
import com.tridium.platform.BOperatingSystemEnum;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.IntHashMap;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetIpLinkLayer
extends BBacnetLinkLayer
implements Runnable,
BvllConst {
    private static String NONE = lex.getText("ip.adapter.none");
    private static String[] noAdapterArray = new String[]{NONE};
    private static String[] noAdapterIdArray = new String[]{NONE};
    private static String[] noAdapterIpArray = new String[]{NONE};
    private static int[] noneOrdinals = new int[]{-1};
    private static String DISABLED = lex.getText("ip.adapter.disabled");
    private static String NO_ADDRESS = lex.getText("ip.adapter.noAddress");
    public static final Property adapter = BBacnetIpLinkLayer.newProperty((int)64, (BValue)BDynamicEnum.make((int)-1, (BEnumRange)BEnumRange.make((int[])noneOrdinals, (String[])noAdapterArray)), (BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:FrozenEnumFE"));
    public static final Property adapterId = BBacnetIpLinkLayer.newProperty((int)69, (BValue)BDynamicEnum.make((int)-1, (BEnumRange)BEnumRange.make((int[])noneOrdinals, (String[])noAdapterIdArray)), null);
    public static final Property ipAddress = BBacnetIpLinkLayer.newProperty((int)65, (BValue)BDynamicEnum.make((int)-1, (BEnumRange)BEnumRange.make((int[])noneOrdinals, (String[])noAdapterIpArray)), null);
    public static final Property udpPort = BBacnetIpLinkLayer.newProperty((int)0, (String)"0xBAC0", null);
    public static final Property ipDeviceType = BBacnetIpLinkLayer.newProperty((int)0, (BValue)BIpDeviceType.standard, null);
    public static final Property bbmdAddress = BBacnetIpLinkLayer.newProperty((int)0, (String)"null", null);
    public static final Property registrationLifetime = BBacnetIpLinkLayer.newProperty((int)0, (BValue)BRelTime.make((long)900000L), null);
    public static final Property broadcastDistributionTable = BBacnetIpLinkLayer.newProperty((int)0, (BValue)new BBroadcastDistributionTable(), null);
    public static final Property foreignDeviceTable = BBacnetIpLinkLayer.newProperty((int)0, (BValue)new BForeignDeviceTable(), null);
    public static final Property adapterDebug = BBacnetIpLinkLayer.newProperty((int)4, (boolean)false, null);
    public static final Property bbmdDebug = BBacnetIpLinkLayer.newProperty((int)0, (boolean)false, null);
    public static final Action dump = BBacnetIpLinkLayer.newAction((int)0, null);
    public static final Action readBroadcastDistributionTable = BBacnetIpLinkLayer.newAction((int)0, (BValue)BString.make((String)"Enter BBMD B/IP Address"), null);
    public static final Action writeBroadcastDistributionTable = BBacnetIpLinkLayer.newAction((int)0, (BValue)BString.make((String)"Enter BBMD B/IP Address"), null);
    public static final Action updateAllBDTs = BBacnetIpLinkLayer.newAction((int)20, null);
    public static final Action queryForAdapters = BBacnetIpLinkLayer.newAction((int)128, null);
    public static final Type TYPE;
    public static final int PACKET_LENGTH = 1500;
    public static final int MAX_APDU_LENGTH = 1476;
    public static final byte[] DEFAULT_SUBNET_MASK;
    public static final byte[] TWO_HOP_DIST_MASK;
    private static int IPV4_HOST_OCTETS;
    private static final Log log;
    private static final int NOT_FOUND = -1;
    private DatagramSocket server;
    private DatagramSocket broadcastServer;
    private BroadcastWorker broadcastWorker;
    private ByteArrayOutputStream os;
    private DatagramPacket datagramOut;
    private String bindType;
    private volatile boolean alive;
    private Thread myThread;
    private String oldIpAddr;
    private int myUdpPort;
    private byte[] localBroadcastAddr;
    private IntHashMap inetAddressTable;
    private Hashtable macTable;
    private InetAddress bbmdInet;
    private int bbmdPort;
    private byte[] bbmdMac;
    private int oldIpDeviceType;
    protected byte[] myIp;
    protected byte[] myMac;
    private String[] bbmdMsgs;
    private int ndx;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$link$ip$BBacnetIpLinkLayer;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$tridium$platform$tcpip$BTcpIpAdapterSettings;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$link$ip$BBdtEntry;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$link$ip$BFdtEntry;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$link$ip$BForeignDeviceRegistration;

    public BEnum getAdapter() {
        return (BEnum)this.get(adapter);
    }

    public void setAdapter(BEnum bEnum) {
        this.set(adapter, (BValue)bEnum, null);
    }

    public BEnum getAdapterId() {
        return (BEnum)this.get(adapterId);
    }

    public void setAdapterId(BEnum bEnum) {
        this.set(adapterId, (BValue)bEnum, null);
    }

    public BEnum getIpAddress() {
        return (BEnum)this.get(ipAddress);
    }

    public void setIpAddress(BEnum bEnum) {
        this.set(ipAddress, (BValue)bEnum, null);
    }

    public String getUdpPort() {
        return this.getString(udpPort);
    }

    public void setUdpPort(String string) {
        this.setString(udpPort, string, null);
    }

    public BIpDeviceType getIpDeviceType() {
        return (BIpDeviceType)this.get(ipDeviceType);
    }

    public void setIpDeviceType(BIpDeviceType bIpDeviceType) {
        this.set(ipDeviceType, (BValue)bIpDeviceType, null);
    }

    public String getBbmdAddress() {
        return this.getString(bbmdAddress);
    }

    public void setBbmdAddress(String string) {
        this.setString(bbmdAddress, string, null);
    }

    public BRelTime getRegistrationLifetime() {
        return (BRelTime)this.get(registrationLifetime);
    }

    public void setRegistrationLifetime(BRelTime bRelTime) {
        this.set(registrationLifetime, (BValue)bRelTime, null);
    }

    public BBroadcastDistributionTable getBroadcastDistributionTable() {
        return (BBroadcastDistributionTable)this.get(broadcastDistributionTable);
    }

    public void setBroadcastDistributionTable(BBroadcastDistributionTable bBroadcastDistributionTable) {
        this.set(broadcastDistributionTable, (BValue)bBroadcastDistributionTable, null);
    }

    public BForeignDeviceTable getForeignDeviceTable() {
        return (BForeignDeviceTable)this.get(foreignDeviceTable);
    }

    public void setForeignDeviceTable(BForeignDeviceTable bForeignDeviceTable) {
        this.set(foreignDeviceTable, (BValue)bForeignDeviceTable, null);
    }

    public boolean getAdapterDebug() {
        return this.getBoolean(adapterDebug);
    }

    public void setAdapterDebug(boolean bl) {
        this.setBoolean(adapterDebug, bl, null);
    }

    public boolean getBbmdDebug() {
        return this.getBoolean(bbmdDebug);
    }

    public void setBbmdDebug(boolean bl) {
        this.setBoolean(bbmdDebug, bl, null);
    }

    public void dump() {
        this.invoke(dump, null, null);
    }

    public void readBroadcastDistributionTable(BString bString) {
        this.invoke(readBroadcastDistributionTable, (BValue)bString, null);
    }

    public void writeBroadcastDistributionTable(BString bString) {
        this.invoke(writeBroadcastDistributionTable, (BValue)bString, null);
    }

    public void updateAllBDTs() {
        this.invoke(updateAllBDTs, null, null);
    }

    public void queryForAdapters() {
        this.invoke(queryForAdapters, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void linkCommInit() {
        this.updateLocalAddress();
    }

    public void linkCommStart() throws Exception {
        this.startReception();
        if (this.isBBMDActive()) {
            this.initializeBDT();
        }
    }

    public void linkCommStop() {
        this.stopReception();
    }

    public void linkCommCleanup() {
        this.myIp = null;
        this.myMac = null;
        if (this.server != null) {
            this.server.close();
        }
        this.server = null;
        if (this.broadcastServer != null) {
            this.broadcastServer.close();
        }
        this.broadcastServer = null;
        this.oldIpAddr = null;
        this.localBroadcastAddr = null;
    }

    public void started() {
        this.oldIpDeviceType = this.getIpDeviceType().getOrdinal();
        this.oldIpAddr = this.getIpAddress().getTag();
        if (this.getBbmdDebug()) {
            this.bbmdMsgs = new String[this.getBbmdMsgsSize()];
        }
        BBacnetNetwork.bacnet().postAsync(new Runnable(){

            public final void run() {
                BBacnetIpLinkLayer.this.setTcpIpAdapter();
            }
        });
    }

    public void stopped() {
        this.inetAddressTable = null;
        this.macTable = null;
        this.os = null;
        this.datagramOut = null;
        this.bbmdInet = null;
        this.bbmdMac = null;
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer("B/IP (");
        stringBuffer.append(this.getIpAddress()).append(':').append(this.getUdpPort()).append(") ").append((Object)this.getIpDeviceType());
        return stringBuffer.toString();
    }

    protected boolean processCustomBvllMessage(InetAddress inetAddress, byte[] byArray, int n, int n2, byte[] byArray2) {
        return false;
    }

    private final void debug(String string) {
        if (this.getAdapterDebug()) {
            System.out.println("BACnet TcpIpAdapterDebug:" + string);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void setTcpIpAdapter() {
        try {
            this.debug("setTcpIpAdapter()");
            if (this.getAdapterDebug()) {
                new Throwable().printStackTrace();
            }
            var1_1 = this.getAdapterId().getTag();
            var2_3 = this.getAdapterId().getOrdinal();
            this.debug("currentTag=" + var1_1 + ", currentOrdinal=" + var2_3);
            var3_5 = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
            var3_5.lease();
            var4_6 = var3_5.getSettings();
            v0 = BBacnetIpLinkLayer.class$java$lang$Integer;
            if (v0 == null) {
                v0 = BBacnetIpLinkLayer.class$java$lang$Integer = BBacnetIpLinkLayer.class("[Ljava.lang.Integer;", false);
            }
            var5_7 = new Array(v0);
            var5_7.add((Object)new Integer(-1));
            v1 = BBacnetIpLinkLayer.class$java$lang$String;
            if (v1 == null) {
                v1 = BBacnetIpLinkLayer.class$java$lang$String = BBacnetIpLinkLayer.class("[Ljava.lang.String;", false);
            }
            var6_8 = new Array(v1);
            var6_8.add((Object)BBacnetIpLinkLayer.NONE);
            v2 = BBacnetIpLinkLayer.class$java$lang$String;
            if (v2 == null) {
                v2 = BBacnetIpLinkLayer.class$java$lang$String = BBacnetIpLinkLayer.class("[Ljava.lang.String;", false);
            }
            var7_9 = new Array(v2);
            var7_9.add((Object)BBacnetIpLinkLayer.NONE);
            v3 = BBacnetIpLinkLayer.class$java$lang$String;
            if (v3 == null) {
                v3 = BBacnetIpLinkLayer.class$java$lang$String = BBacnetIpLinkLayer.class("[Ljava.lang.String;", false);
            }
            var8_10 = new Array(v3);
            var8_10.add((Object)BBacnetIpLinkLayer.NONE);
            var9_11 = -1;
            var10_12 = 0;
            var11_13 = var4_6.getAdapters().getProperties();
            if (true) ** GOTO lbl79
            do {
                var12_14 /* !! */  = (BTcpIpAdapterSettings)var11_13.get();
                if (this.getAdapterDebug()) {
                    this.debug("\nadapterSettings:");
                    this.dumpAdapter(var12_14 /* !! */ );
                }
                var13_15 = var12_14 /* !! */ .getDescription();
                var14_18 /* !! */  = var12_14 /* !! */ .getIpAddress();
                var15_19 = var12_14 /* !! */ .getAdapterId();
                if (!var12_14 /* !! */ .getIsAdapterEnabled()) {
                    this.debug("Adapter is disabled or disconnected!");
                    var13_15 = BBacnetIpLinkLayer.DISABLED + var13_15;
                    var14_18 /* !! */  = BBacnetIpLinkLayer.DISABLED + (String)var14_18 /* !! */ ;
                }
                if (var12_14 /* !! */ .getIpAddress().equals("")) {
                    this.debug("Adapter has no address - possibly disconnected!");
                    var13_15 = BBacnetIpLinkLayer.NO_ADDRESS + var13_15;
                    var14_18 /* !! */  = BBacnetIpLinkLayer.NO_ADDRESS + (String)var14_18 /* !! */ ;
                }
                var13_15 = SlotPath.escape((String)var13_15);
                var14_18 /* !! */  = SlotPath.escape((String)var14_18 /* !! */ );
                var15_19 = SlotPath.escape((String)var15_19);
                this.debug("desc=" + var13_15 + ", ip=" + (String)var14_18 /* !! */  + ", id=" + (String)var15_19 + ", == current?" + var1_1.equals(var15_19));
                if (var1_1.equals(var15_19)) {
                    var9_11 = var10_12;
                }
                var16_20 = var6_8.iterator();
                while (var16_20.hasNext()) {
                    if (!((String)var16_20.next()).equals(var13_15)) continue;
                    var13_15 = var13_15 + "$20";
                }
                var16_20 = var8_10.iterator();
                while (var16_20.hasNext()) {
                    if (!((String)var16_20.next()).equals(var14_18 /* !! */ )) continue;
                    var14_18 /* !! */  = (String)var14_18 /* !! */  + "$20";
                }
                var5_7.add((Object)new Integer(var10_12++));
                var6_8.add((Object)var13_15);
                var8_10.add((Object)var14_18 /* !! */ );
                var7_9.add((Object)var15_19);
lbl79:
                // 2 sources

                if ((v4 = BBacnetIpLinkLayer.class$com$tridium$platform$tcpip$BTcpIpAdapterSettings) != null) continue;
                v4 = BBacnetIpLinkLayer.class("[Lcom.tridium.platform.tcpip.BTcpIpAdapterSettings;", false);
            } while (var11_13.next(v4));
            var11_13 = (Integer[])var5_7.trim();
            var12_14 /* !! */  = (BTcpIpAdapterSettings)new int[var11_13.length];
            var13_16 = 0;
            while (var13_16 < var11_13.length) {
                var12_14 /* !! */ [var13_16] = (BTcpIpAdapterSettings)var11_13[var13_16];
                ++var13_16;
            }
            var13_17 = (String[])var6_8.trim();
            var14_18 /* !! */  = (String[])var8_10.trim();
            var15_19 = (String[])var7_9.trim();
            this.debug("ords.length=" + ((BTcpIpAdapterSettings)var12_14 /* !! */ ).length);
            if (var9_11 != -1) {
                var16_20 = BDynamicEnum.make((int)var9_11, (BEnumRange)BEnumRange.make((int[])var12_14 /* !! */ , (String[])var13_17));
                var17_21 = BDynamicEnum.make((int)var9_11, (BEnumRange)BEnumRange.make((int[])var12_14 /* !! */ , (String[])var14_18 /* !! */ ));
                var18_22 = BDynamicEnum.make((int)var9_11, (BEnumRange)BEnumRange.make((int[])var12_14 /* !! */ , (String[])var15_19));
            } else if (((BTcpIpAdapterSettings)var12_14 /* !! */ ).length == 2) {
                var16_20 = BDynamicEnum.make((int)var12_14 /* !! */ [1], (BEnumRange)BEnumRange.make((int[])var12_14 /* !! */ , (String[])var13_17));
                var17_21 = BDynamicEnum.make((int)var12_14 /* !! */ [1], (BEnumRange)BEnumRange.make((int[])var12_14 /* !! */ , (String[])var14_18 /* !! */ ));
                var18_22 = BDynamicEnum.make((int)var12_14 /* !! */ [1], (BEnumRange)BEnumRange.make((int[])var12_14 /* !! */ , (String[])var15_19));
            } else {
                var16_20 = BDynamicEnum.make((int)var12_14 /* !! */ [0], (BEnumRange)BEnumRange.make((int[])var12_14 /* !! */ , (String[])var13_17));
                var17_21 = BDynamicEnum.make((int)var12_14 /* !! */ [0], (BEnumRange)BEnumRange.make((int[])var12_14 /* !! */ , (String[])var14_18 /* !! */ ));
                var18_22 = BDynamicEnum.make((int)var12_14 /* !! */ [0], (BEnumRange)BEnumRange.make((int[])var12_14 /* !! */ , (String[])var15_19));
            }
            this.setAdapterId((BEnum)var18_22);
            this.setIpAddress((BEnum)var17_21);
            this.setAdapter((BEnum)var16_20);
        }
        catch (ActionInvokeException var1_2) {
            System.out.println("ActionInvokeException in setTcpIpAdapter!!");
            var1_2.printStackTrace();
            var2_4 = var1_2.getCause();
            System.out.println("\n Cause::" + var2_4);
            if (var2_4 != null) {
                var2_4.printStackTrace();
            }
            throw var1_2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        this.debug("IpLL.changed: p=" + property);
        if (property.equals((Object)ipDeviceType)) {
            if (this.alive) {
                switch (this.oldIpDeviceType) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.stopForeignDeviceRegistration();
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                int n = this.getFlags((Slot)broadcastDistributionTable);
                int n2 = this.getFlags((Slot)foreignDeviceTable);
                boolean bl = false;
                switch (this.getIpDeviceType().getOrdinal()) {
                    case 0: {
                        this.setFlags((Slot)broadcastDistributionTable, n | 4);
                        this.setFlags((Slot)foreignDeviceTable, n2 | 4);
                        break;
                    }
                    case 1: {
                        this.setFlags((Slot)broadcastDistributionTable, n | 4);
                        this.setFlags((Slot)foreignDeviceTable, n2 | 4);
                        this.startForeignDeviceRegistration();
                        bl = true;
                        break;
                    }
                    case 2: {
                        this.setFlags((Slot)broadcastDistributionTable, n & 0xFFFFFFFB);
                        this.setFlags((Slot)foreignDeviceTable, n2 & 0xFFFFFFFB);
                        this.initializeBDT();
                        break;
                    }
                }
                if (!bl) {
                    this.removeForeignDeviceRegistrations();
                }
            }
            this.oldIpDeviceType = this.getIpDeviceType().getOrdinal();
            return;
        }
        if (property.equals((Object)bbmdAddress)) {
            if (!this.alive) return;
            if (this.getIpDeviceType() == BIpDeviceType.standard) return;
            if (this.updateBBMDAddress(BBacnetIpLinkLayer.getMacBytes(this.getBbmdAddress()))) return;
            log.message("Invalid BBMD address configuration!");
            return;
        }
        if (property.equals((Object)udpPort)) {
            BBacnetIpLinkLayer bBacnetIpLinkLayer = this;
            synchronized (bBacnetIpLinkLayer) {
                block28: {
                    block27: {
                        if (!this.alive) break block27;
                        this.getNetworkPort().disable();
                        this.updateLocalAddress();
                        this.getNetworkPort().enable();
                        if (!this.isBBMDActive()) return;
                        this.checkBDT();
                        break block28;
                    }
                    this.updateLocalAddress();
                }
                return;
            }
        }
        if (property.equals((Object)adapter)) {
            this.setAdapterId(this.getAdapterId().getRange().get(this.getAdapter().getOrdinal()));
            this.setIpAddress(this.getIpAddress().getRange().get(this.getAdapter().getOrdinal()));
            return;
        }
        if (property.equals((Object)ipAddress)) {
            String string;
            block30: {
                string = this.getIpAddress().getTag();
                if (!string.equals(this.oldIpAddr)) {
                    BBacnetIpLinkLayer bBacnetIpLinkLayer = this;
                    synchronized (bBacnetIpLinkLayer) {
                        block29: {
                            if (!this.getNetworkPort().getEnabled()) break block29;
                            this.getNetworkPort().disable();
                            this.updateLocalAddress();
                            this.getNetworkPort().enable();
                            if (this.isBBMDActive()) {
                                this.checkBDT();
                            }
                            break block30;
                        }
                        this.updateLocalAddress();
                    }
                }
            }
            this.oldIpAddr = string;
            return;
        }
        if (!property.equals((Object)bbmdDebug)) {
            if (!property.getName().equals("bbmdMsgsSize")) return;
        }
        this.ndx = 0;
        if (!this.getBbmdDebug()) return;
        this.bbmdMsgs = new String[this.getBbmdMsgsSize()];
    }

    public Log log() {
        return log;
    }

    public void doDump() {
        Object object;
        String string;
        System.out.println("TCP/IP Adapter:");
        this.dumpAdapter(this.getTcpIpAdapter());
        System.out.println("MAC Address Table (Inet->MAC):");
        Enumeration enumeration = this.macTable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = (byte[])this.macTable.get(string);
            System.out.println("  inet:" + string + "\tmac:" + ByteArrayUtil.toHexString((byte[])object));
        }
        System.out.println("Inet Address Table (MAC->Inet):");
        string = this.inetAddressTable.iterator();
        while (string.hasNext()) {
            object = (InetAddress)string.next();
            System.out.println("  mac:" + Integer.toHexString(string.key()) + "\tinet:" + object);
        }
        System.out.println("local broadcast addr:" + ByteArrayUtil.toHexString((byte[])this.localBroadcastAddr));
        System.out.println("myIp:" + ByteArrayUtil.toHexString((byte[])this.myIp));
        System.out.println("oldIpAddr:" + this.oldIpAddr);
        System.out.println("myMac:" + ByteArrayUtil.toHexString((byte[])this.myMac));
        System.out.println("myUdpPort:" + this.myUdpPort);
        System.out.println("bbmdInet:" + this.bbmdInet);
        System.out.println("bbmdPort:" + this.bbmdPort);
        System.out.println("bbmdMac:" + ByteArrayUtil.toHexString((byte[])this.bbmdMac));
        System.out.println("oldIpDeviceType:" + this.oldIpDeviceType);
    }

    public void doReadBroadcastDistributionTable(BString bString) {
        if (this.getBbmdDebug()) {
            this.trace("doReadBDT:" + bString.getString());
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(bString.getString(), ":");
            InetAddress inetAddress = InetAddress.getByName(stringTokenizer.nextToken());
            this.sendBvllMessage(inetAddress, Integer.decode(stringTokenizer.nextToken()), new ReadBroadcastDistributionTable());
            this.checkBDT();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new IllegalArgumentException(bString.getString());
        }
    }

    public void doWriteBroadcastDistributionTable(BString bString) {
        if (this.getBbmdDebug()) {
            this.trace("doWriteBDT:" + bString.getString());
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(bString.getString(), ":");
            InetAddress inetAddress = InetAddress.getByName(stringTokenizer.nextToken());
            this.sendBvllMessage(inetAddress, Integer.decode(stringTokenizer.nextToken()), new WriteBroadcastDistributionTable(this.readBDT()));
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new IllegalArgumentException(bString.getString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void doUpdateAllBDTs() {
        if (BBacnetIpLinkLayer.log.isTraceOn()) {
            BBacnetIpLinkLayer.log.trace("Sending BDT to all other BBMDs...");
        }
        var1_1 = this.getBroadcastDistributionTable().getProperties();
        if (true) ** GOTO lbl10
        do {
            if (!var1_1.property().getName().equals("localDevice")) {
                var2_2 = (BBdtEntry)var1_1.get();
                var3_3 = var2_2.getBIpAddr();
                this.sendBvllMessage(var3_3, new WriteBroadcastDistributionTable(this.readBDT()));
            }
lbl10:
            // 4 sources

            if ((v0 = BBacnetIpLinkLayer.class$com$tridium$bacnet$stack$link$ip$BBdtEntry) != null) continue;
            v0 = BBacnetIpLinkLayer.class("[Lcom.tridium.bacnet.stack.link.ip.BBdtEntry;", false);
        } while (var1_1.next(v0));
    }

    public void doQueryForAdapters() {
        System.out.println("Querying IP Adapter choices...");
        this.setTcpIpAdapter();
        System.out.println("Finished querying IP Adapter choices!");
    }

    public final void run() {
        this.alive = true;
        if (this.startBroadcastWorker()) {
            if (this.broadcastWorker != null) {
                this.broadcastWorker.interrupt();
                this.broadcastWorker = null;
            }
            this.broadcastWorker = new BroadcastWorker(Thread.currentThread().getName());
            this.broadcastWorker.start();
        }
        this.listenForPackets(this.server);
    }

    protected boolean startBroadcastWorker() {
        if (BOperatingSystemEnum.isOS((BOperatingSystemEnum)BOperatingSystemEnum.qnx) || BOperatingSystemEnum.isOS((BOperatingSystemEnum)BOperatingSystemEnum.linux)) {
            return this.isLocalhost() ^ true;
        }
        return false;
    }

    protected boolean isLocalhost() {
        boolean bl = false;
        if (this.myIp != null && this.myIp.length >= IPV4_HOST_OCTETS) {
            boolean bl2 = false;
            if (this.myIp[0] == 127 && this.myIp[1] == 0 && this.myIp[2] == 0 && this.myIp[3] == 1) {
                bl2 = true;
            }
            bl = bl2;
        }
        return bl;
    }

    private final void listenForPackets(DatagramSocket datagramSocket) {
        while (this.alive) {
            try {
                byte[] byArray = new byte[1500];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, 1500);
                datagramSocket.receive(datagramPacket);
                this.processPacket(datagramPacket);
            }
            catch (NullPointerException nullPointerException) {
                if (datagramSocket != null) break;
                log.error("DatagramSocket is null!  Socket " + this.getPort() + " may be in use by another process...");
                break;
            }
            catch (SocketException socketException) {
                if (!this.alive) continue;
                log.error("SocketException in BBacnetIpLinkLayer!", (Throwable)socketException);
                if (this.recoverSocket()) continue;
                log.error("Unable to recover socket! Exiting...");
                break;
            }
            catch (IOException iOException) {
                log.error("Error receiving Bacnet/IP packet!", (Throwable)iOException);
            }
            catch (Throwable throwable) {
                log.message("Unknown exception in IP Link Layer:", throwable);
            }
        }
    }

    public byte[] getMacAddress() {
        return this.myMac;
    }

    public int getMaxAPDULengthAccepted() {
        return 1476;
    }

    public void sendRequest(byte[] byArray, NetworkPdu networkPdu) {
        if (byArray == null || byArray.length == 0) {
            this.sendBvllMessage(this.localBroadcastAddr, new OriginalBroadcastNpdu(networkPdu));
            if (this.isBBMDActive()) {
                this.distributeBroadcastToNetwork(networkPdu);
            } else if (this.isForeignDevice()) {
                this.sendBroadcastToBBMD(networkPdu);
            }
        } else {
            this.sendBvllMessage(byArray, new OriginalUnicastNpdu(networkPdu));
        }
    }

    /*
     * Unable to fully structure code
     */
    private final BTcpIpAdapterSettings getTcpIpAdapter() {
        var1_1 = SlotPath.unescape((String)this.getAdapterId().getTag());
        var2_2 = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
        var2_2.lease();
        var3_3 = var2_2.getSettings();
        var4_4 = var3_3.getAdapters().getProperties();
        if (true) ** GOTO lbl10
        do {
            if (var1_1.equals((var5_5 = (BTcpIpAdapterSettings)var4_4.get()).getAdapterId())) {
                return var5_5;
            }
lbl10:
            // 3 sources

            if ((v0 = BBacnetIpLinkLayer.class$com$tridium$platform$tcpip$BTcpIpAdapterSettings) != null) continue;
            v0 = BBacnetIpLinkLayer.class("[Lcom.tridium.platform.tcpip.BTcpIpAdapterSettings;", false);
        } while (var4_4.next(v0));
        return null;
    }

    private final int getPort() {
        return this.myUdpPort;
    }

    protected boolean isForeignDevice() {
        boolean bl = false;
        if (this.getIpDeviceType() == BIpDeviceType.foreignDevice) {
            bl = true;
        }
        return bl;
    }

    protected boolean isBBMDActive() {
        boolean bl = false;
        if (this.getIpDeviceType() == BIpDeviceType.bbmd) {
            bl = true;
        }
        return bl;
    }

    private final void updateLocalAddress() {
        try {
            BTcpIpAdapterSettings bTcpIpAdapterSettings = this.getTcpIpAdapter();
            if (bTcpIpAdapterSettings == null) {
                return;
            }
            if (bTcpIpAdapterSettings.getIpAddress().equals("")) {
                return;
            }
            try {
                int n;
                this.myUdpPort = n = Integer.decode(this.getUdpPort()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Invalid BACnet/IP UDP Port:" + this.getUdpPort());
            }
            byte[] byArray = BBacnetIpLinkLayer.parseIp(bTcpIpAdapterSettings.getSubnetMask());
            this.myMac = new byte[6];
            this.myIp = BBacnetIpLinkLayer.parseIp(bTcpIpAdapterSettings.getIpAddress());
            System.arraycopy(this.myIp, 0, this.myMac, 0, IPV4_HOST_OCTETS);
            this.myMac[4] = (byte)((this.getPort() & 0xFF00) >> 8);
            this.myMac[5] = (byte)(this.getPort() & 0xFF);
            this.localBroadcastAddr = new byte[6];
            System.arraycopy(this.myMac, 0, this.localBroadcastAddr, 0, 6);
            int n = 0;
            while (n < 4) {
                int n2 = n;
                this.localBroadcastAddr[n2] = (byte)(this.localBroadcastAddr[n2] | ~byArray[n]);
                ++n;
            }
            if (log.isTraceOn()) {
                log.trace("Local Broadcast Address:" + ByteArrayUtil.toHexString((byte[])this.localBroadcastAddr));
            }
        }
        catch (Exception exception) {
            log.error("Invalid Bacnet/IP Link layer configuration!", (Throwable)exception);
        }
    }

    private final synchronized void startReception() throws Exception {
        try {
            InetAddress inetAddress = this.lookupInetAddr(this.myIp);
            if (log.isTraceOn()) {
                log.trace("Start BACnet/IP reception on port " + this.getPort() + ", bound to " + inetAddress);
            }
            if (inetAddress == null) {
                throw new IllegalStateException("BACnet/IP adapter not ready!  Check cable connections.");
            }
            if (this.startBroadcastWorker()) {
                this.server = new DatagramSocket(this.getPort(), inetAddress);
                this.broadcastServer = new DatagramSocket(this.getPort(), this.convertMacToAddress(this.localBroadcastAddr));
            } else {
                this.server = new DatagramSocket(this.getPort(), inetAddress);
            }
            this.bindType = "specific adapter";
        }
        catch (UnknownHostException unknownHostException) {
            log.error("Unknown host:" + ByteArrayUtil.toHexString((byte[])this.myIp), (Throwable)unknownHostException);
            this.getNetworkPort().fault(lex.getText("ip.unknownHost") + ByteArrayUtil.toHexString((byte[])this.myIp));
            throw unknownHostException;
        }
        catch (BindException bindException) {
            log.error("Cannot bind datagram socket on port " + this.getPort(), (Throwable)bindException);
            String string = MessageFormat.format(lex.getText("ip.cannotBind"), new Integer(this.myUdpPort));
            this.getNetworkPort().fault(string);
            throw bindException;
        }
        catch (SocketException socketException) {
            log.error("Cannot open datagram socket!", (Throwable)socketException);
            this.getNetworkPort().fault(lex.getText("ip.cannotOpen"));
            throw socketException;
        }
        this.myThread = new Thread((Runnable)this, "BnIpLRcv");
        this.myThread.start();
        if (this.isForeignDevice()) {
            this.startForeignDeviceRegistration();
        }
    }

    private final synchronized void stopReception() {
        if (!this.alive) {
            return;
        }
        log.trace("Stop Reception");
        if (this.isForeignDevice()) {
            this.stopForeignDeviceRegistration();
        }
        this.alive = false;
        if (this.myThread != null) {
            this.myThread.interrupt();
        }
        this.myThread = null;
        if (this.broadcastWorker != null) {
            this.broadcastWorker.interrupt();
        }
        this.bindType = "none";
        if (this.server != null) {
            this.server.close();
        }
        if (this.broadcastServer != null) {
            this.broadcastServer.close();
        }
    }

    private final synchronized boolean recoverSocket() {
        try {
            this.stopReception();
            log.trace("Re-starting socket reception.");
            this.startReception();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private final void processPacket(DatagramPacket datagramPacket) {
        InetAddress inetAddress = datagramPacket.getAddress();
        byte[] byArray = inetAddress.getAddress();
        int n = datagramPacket.getPort();
        int n2 = datagramPacket.getLength();
        if (ByteArrayUtil.equals((byte[])byArray, (byte[])this.myIp) && n == this.myUdpPort) {
            return;
        }
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = datagramPacket.getData();
        System.arraycopy(byArray3, 0, byArray2, 0, n2);
        if (log.isTraceOn()) {
            log.trace("\nPacket Received(" + n2 + "): addr=" + inetAddress.getHostAddress() + ", port=" + n);
            ByteArrayUtil.hexDump((byte[])byArray2);
        }
        byte[] byArray4 = this.lookupMacAddress(inetAddress, n);
        BacnetInputStream bacnetInputStream = BacnetInputStream.make(byArray2, 0, byArray2.length);
        int n3 = bacnetInputStream.read();
        if (n3 != 129) {
            return;
        }
        int n4 = bacnetInputStream.read();
        bacnetInputStream.read();
        bacnetInputStream.read();
        if (this.getBbmdDebug()) {
            switch (n4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    this.trace("\nBBMD Message Received(" + n2 + "): addr=" + inetAddress.getHostAddress() + ", port=" + n + ": " + ByteArrayUtil.toHexString((byte[])byArray2));
                    break;
                }
            }
        }
        switch (n4) {
            case 10: {
                if (this.linkListener == null) break;
                this.linkListener.rcvIndication(byArray4, this.myMac, bacnetInputStream);
                break;
            }
            case 11: {
                if (this.isBBMDActive()) {
                    bacnetInputStream.mark(bacnetInputStream.getPos());
                    this.distributeBroadcastToNetwork(bacnetInputStream, byArray4, false);
                    bacnetInputStream.reset();
                }
                if (this.linkListener == null) break;
                this.linkListener.rcvIndication(byArray4, this.myMac, bacnetInputStream);
                break;
            }
            case 4: {
                byte[] byArray5 = new byte[6];
                int n5 = 0;
                while (n5 < 6) {
                    byArray5[n5] = (byte)bacnetInputStream.read();
                    ++n5;
                }
                if (log.isTraceOn()) {
                    log.trace("Forwarded NPDU received from original device:" + ByteArrayUtil.toHexString((byte[])byArray5));
                }
                if (this.isBBMDActive()) {
                    bacnetInputStream.mark(bacnetInputStream.getPos());
                    this.distributeBroadcastFromNetwork(bacnetInputStream, byArray5);
                    bacnetInputStream.reset();
                }
                if (this.linkListener == null) break;
                this.linkListener.rcvIndication(byArray5, this.myMac, bacnetInputStream);
                break;
            }
            case 0: {
                int n6 = bacnetInputStream.read();
                int n7 = bacnetInputStream.read();
                int n8 = n6 << 8 | n7;
                if (this.getBbmdDebug()) {
                    this.trace("BVLC-Result received: resultCode=" + n8);
                }
                if (!log.isTraceOn()) break;
                log.trace("BVLC Result " + n8 + " received from " + inetAddress);
                break;
            }
            case 1: {
                if (this.isBBMDActive()) {
                    if (this.getBbmdDebug()) {
                        this.trace("Write-BDT received");
                    }
                    if (this.writeBDT(bacnetInputStream)) {
                        this.sendBvllMessage(inetAddress, n, BvlcResult.OK);
                    } else {
                        this.sendBvllMessage(inetAddress, n, BvlcResult.WRITE_BDT_NAK);
                    }
                    if (this.getBbmdDebug()) {
                        this.trace("checkBDT() on WriteBDT rec");
                    }
                    this.checkBDT();
                    break;
                }
                this.sendBvllMessage(inetAddress, n, BvlcResult.WRITE_BDT_NAK);
                break;
            }
            case 2: {
                if (this.isBBMDActive()) {
                    byte[] byArray6;
                    if (this.getBbmdDebug()) {
                        this.trace("Read-BDT received");
                    }
                    if ((byArray6 = this.readBDT()) == null) {
                        this.sendBvllMessage(inetAddress, n, BvlcResult.READ_BDT_NAK);
                        break;
                    }
                    this.sendBvllMessage(inetAddress, n, new ReadBroadcastDistributionTableAck(byArray6));
                    break;
                }
                this.sendBvllMessage(inetAddress, n, BvlcResult.READ_BDT_NAK);
                break;
            }
            case 3: {
                if (!this.isBBMDActive()) break;
                if (this.getBbmdDebug()) {
                    this.trace("Read-BDT-Ack received");
                }
                this.writeBDT(bacnetInputStream);
                if (this.getBbmdDebug()) {
                    this.trace("checkBDT() on ReadBDTAck rec");
                }
                this.checkBDT();
                break;
            }
            case 5: {
                if (this.isBBMDActive()) {
                    if (this.getBbmdDebug()) {
                        this.trace("Register-FD received");
                    }
                    this.sendBvllMessage(inetAddress, n, this.registerForeignDevice(bacnetInputStream, byArray4));
                    break;
                }
                this.sendBvllMessage(inetAddress, n, BvlcResult.REGISTER_FD_NAK);
                break;
            }
            case 6: {
                if (this.isBBMDActive()) {
                    if (this.getBbmdDebug()) {
                        this.trace("Read-FDT received");
                    }
                    this.sendBvllMessage(inetAddress, n, this.readFDT());
                    break;
                }
                this.sendBvllMessage(inetAddress, n, BvlcResult.READ_FDT_NAK);
                break;
            }
            case 7: {
                if (!this.isBBMDActive()) break;
                if (this.getBbmdDebug()) {
                    this.trace("Read-FDT-Ack received");
                }
                this.writeFDT(bacnetInputStream);
                break;
            }
            case 8: {
                if (this.isBBMDActive()) {
                    if (this.getBbmdDebug()) {
                        this.trace("Delete-FDTE received");
                    }
                    this.sendBvllMessage(inetAddress, n, this.unregisterForeignDevice(bacnetInputStream));
                    break;
                }
                this.sendBvllMessage(inetAddress, n, BvlcResult.DELETE_FDT_ENTRY_NAK);
                break;
            }
            case 9: {
                if (this.isBBMDActive()) {
                    if (this.getBbmdDebug()) {
                        this.trace("Distribute-Broadcast received");
                    }
                    bacnetInputStream.mark(bacnetInputStream.getPos());
                    if (this.distributeBroadcastToNetwork(bacnetInputStream, byArray4, true)) {
                        this.sendBvllMessage(inetAddress, n, BvlcResult.OK);
                    } else {
                        this.sendBvllMessage(inetAddress, n, BvlcResult.DIST_BCAST_NAK);
                    }
                    bacnetInputStream.reset();
                    if (this.linkListener == null) break;
                    this.linkListener.rcvIndication(byArray4, this.myMac, bacnetInputStream);
                    break;
                }
                this.sendBvllMessage(inetAddress, n, BvlcResult.DIST_BCAST_NAK);
                break;
            }
            default: {
                if (this.processCustomBvllMessage(inetAddress, byArray, n, n2, byArray2)) break;
                log.message("Invalid BVLL function: " + n4);
            }
        }
    }

    private final boolean writeBDT(BacnetInputStream bacnetInputStream) {
        int n;
        boolean bl = this.getBbmdDebug();
        if (bl) {
            this.trace("writeBDT");
        }
        if ((n = bacnetInputStream.available()) % 10 != 0) {
            log.error("Invalid BVLL BDT size!");
            return false;
        }
        try {
            BBroadcastDistributionTable bBroadcastDistributionTable = this.getBroadcastDistributionTable();
            Class clazz = class$com$tridium$bacnet$stack$link$ip$BBdtEntry;
            if (clazz == null) {
                clazz = class$com$tridium$bacnet$stack$link$ip$BBdtEntry = BBacnetIpLinkLayer.class("[Lcom.tridium.bacnet.stack.link.ip.BBdtEntry;", false);
            }
            Array array = new Array(clazz);
            int n2 = n / 10;
            int n3 = 0;
            while (n3 < n2) {
                byte[] byArray = new byte[6];
                bacnetInputStream.read(byArray);
                byte[] byArray2 = new byte[IPV4_HOST_OCTETS];
                bacnetInputStream.read(byArray2);
                BBdtEntry bBdtEntry = new BBdtEntry(byArray, byArray2);
                if (bl) {
                    this.trace("Adding BDT Entry: " + (Object)((Object)bBdtEntry));
                }
                array.add((Object)bBdtEntry);
                ++n3;
            }
            n3 = bBroadcastDistributionTable.updateBDT((BBdtEntry[])array.trim()) ? 1 : 0;
            if (n3 != 0) {
                this.checkBDT(true);
            }
            return true;
        }
        catch (Exception exception) {
            log.error("Unable to write BDT data!", (Throwable)exception);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final byte[] readBDT() {
        boolean bl = this.getBbmdDebug();
        if (bl) {
            this.trace("readBDT");
        }
        try {
            BBroadcastDistributionTable bBroadcastDistributionTable = this.getBroadcastDistributionTable();
            SlotCursor slotCursor = bBroadcastDistributionTable.getProperties();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (true) {
                Class clazz;
                if ((clazz = class$com$tridium$bacnet$stack$link$ip$BBdtEntry) == null) {
                    clazz = BBacnetIpLinkLayer.class("[Lcom.tridium.bacnet.stack.link.ip.BBdtEntry;", false);
                }
                if (!slotCursor.next(clazz)) {
                    return byteArrayOutputStream.toByteArray();
                }
                BBdtEntry bBdtEntry = (BBdtEntry)slotCursor.get();
                if (bl) {
                    this.trace("Encoding BDTEntry:" + (Object)((Object)bBdtEntry));
                }
                byteArrayOutputStream.write(bBdtEntry.getBIpAddr());
                byteArrayOutputStream.write(bBdtEntry.getBdMask());
            }
        }
        catch (IOException iOException) {
            log.error("IOException reading BDT!", (Throwable)iOException);
            return null;
        }
    }

    private final BvllMessage registerForeignDevice(BacnetInputStream bacnetInputStream, byte[] byArray) {
        int n = bacnetInputStream.read();
        int n2 = bacnetInputStream.read();
        int n3 = n << 8 | n2;
        if (this.getBbmdDebug()) {
            this.trace("registerFD: Addr=" + ByteArrayUtil.toHexString((byte[])byArray) + "; TTL=" + n3);
        }
        this.getForeignDeviceTable().addEntry(byArray, n3);
        return BvlcResult.OK;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final BvllMessage readFDT() {
        boolean bl = this.getBbmdDebug();
        if (bl) {
            this.trace("readFDT");
        }
        try {
            BForeignDeviceTable bForeignDeviceTable = this.getForeignDeviceTable();
            SlotCursor slotCursor = bForeignDeviceTable.getProperties();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            long l = BAbsTime.make().getMillis();
            while (true) {
                Class clazz;
                if ((clazz = class$com$tridium$bacnet$stack$link$ip$BFdtEntry) == null) {
                    clazz = BBacnetIpLinkLayer.class("[Lcom.tridium.bacnet.stack.link.ip.BFdtEntry;", false);
                }
                if (!slotCursor.next(clazz)) {
                    return new ReadForeignDeviceTableAck(byteArrayOutputStream.toByteArray());
                }
                BFdtEntry bFdtEntry = (BFdtEntry)slotCursor.get();
                if (bl) {
                    this.trace("Encoding FDTEntry:" + (Object)((Object)bFdtEntry));
                }
                byteArrayOutputStream.write(bFdtEntry.getBIpAddr());
                int n = bFdtEntry.getTimeToLive();
                byteArrayOutputStream.write(n >> 8 & 0xFF);
                byteArrayOutputStream.write(n & 0xFF);
                int n2 = (int)((bFdtEntry.getPurgeTime().getMillis() - l) / 1000L);
                byteArrayOutputStream.write(n2 >> 8 & 0xFF);
                byteArrayOutputStream.write(n2 & 0xFF);
            }
        }
        catch (IOException iOException) {
            log.error("Error reading FDT!", (Throwable)iOException);
            return BvlcResult.READ_FDT_NAK;
        }
    }

    private final void writeFDT(BacnetInputStream bacnetInputStream) {
        if (this.getBbmdDebug()) {
            this.trace("writeFDT");
        }
    }

    private final BvllMessage unregisterForeignDevice(BacnetInputStream bacnetInputStream) {
        boolean bl;
        byte[] byArray = new byte[6];
        bacnetInputStream.read(byArray);
        if (this.getBbmdDebug()) {
            this.trace("unregisterFD: fdAddr=" + ByteArrayUtil.toHexString((byte[])byArray));
        }
        if (bl = this.getForeignDeviceTable().deleteEntry(byArray)) {
            return BvlcResult.OK;
        }
        return BvlcResult.DELETE_FDT_ENTRY_NAK;
    }

    /*
     * Unable to fully structure code
     */
    private final void distributeBroadcastToNetwork(NetworkPdu var1_1) {
        var2_2 = new ForwardedNpdu(var1_1, this.myMac);
        var3_3 = this.getBroadcastDistributionTable().getProperties();
        if (true) ** GOTO lbl18
        do {
            if (!var3_3.property().getName().equals("localDevice")) {
                var4_4 = (BBdtEntry)var3_3.get();
                var5_5 = new byte[6];
                var6_6 = var4_4.getBIpAddr();
                System.arraycopy(var6_6, 0, var5_5, 0, 6);
                var7_7 = var4_4.getBdMask();
                var8_8 = 0;
                while (var8_8 < 4) {
                    v0 = var8_8;
                    var5_5[v0] = (byte)(var5_5[v0] | ~var7_7[var8_8]);
                    ++var8_8;
                }
                this.sendBvllMessage(var5_5, var2_2);
            }
lbl18:
            // 4 sources

            if ((v1 = BBacnetIpLinkLayer.class$com$tridium$bacnet$stack$link$ip$BBdtEntry) != null) continue;
            v1 = BBacnetIpLinkLayer.class("[Lcom.tridium.bacnet.stack.link.ip.BBdtEntry;", false);
        } while (var3_3.next(v1));
        var3_3 = this.getForeignDeviceTable().getProperties();
        if (true) ** GOTO lbl27
        do {
            var4_4 = (BFdtEntry)var3_3.get();
            var5_5 = var4_4.getBIpAddr();
            this.sendBvllMessage(var5_5, var2_2);
lbl27:
            // 2 sources

            if ((v2 = BBacnetIpLinkLayer.class$com$tridium$bacnet$stack$link$ip$BFdtEntry) != null) continue;
            v2 = BBacnetIpLinkLayer.class("[Lcom.tridium.bacnet.stack.link.ip.BFdtEntry;", false);
        } while (var3_3.next(v2));
    }

    /*
     * Unable to fully structure code
     */
    private final boolean distributeBroadcastToNetwork(BacnetInputStream var1_1, byte[] var2_2, boolean var3_3) {
        var4_4 = new ForwardedNpdu(var1_1, var2_2);
        if (var3_3) {
            this.sendBvllMessage(this.localBroadcastAddr, var4_4);
        }
        var5_5 = this.getBroadcastDistributionTable().getProperties();
        if (true) ** GOTO lbl19
        do {
            var6_6 = (BBdtEntry)var5_5.get();
            var7_7 = new byte[6];
            var8_8 = var6_6.getBIpAddr();
            System.arraycopy(var8_8, 0, var7_7, 0, 6);
            var9_10 = var6_6.getBdMask();
            var10_11 = 0;
            while (var10_11 < 4) {
                v0 = var10_11;
                var7_7[v0] = (byte)(var7_7[v0] | ~var9_10[var10_11]);
                ++var10_11;
            }
            this.sendBvllMessage(var7_7, var4_4);
lbl19:
            // 2 sources

            if ((v1 = BBacnetIpLinkLayer.class$com$tridium$bacnet$stack$link$ip$BBdtEntry) != null) continue;
            v1 = BBacnetIpLinkLayer.class("[Lcom.tridium.bacnet.stack.link.ip.BBdtEntry;", false);
        } while (var5_5.next(v1));
        var5_5 = this.getForeignDeviceTable().getProperties();
        if (true) ** GOTO lbl37
        do {
            var6_6 = (BFdtEntry)var5_5.get();
            var7_7 = var6_6.getBIpAddr();
            if (var3_3) {
                var8_9 = 0;
                while (var8_9 < 4) {
                    if (var2_2[var8_9] != var7_7[var8_9]) {
                        this.sendBvllMessage(var7_7, var4_4);
                        break;
                    }
                    ++var8_9;
                }
            } else {
                this.sendBvllMessage(var7_7, var4_4);
            }
            if ((v2 = BBacnetIpLinkLayer.class$com$tridium$bacnet$stack$link$ip$BFdtEntry) != null) continue;
            v2 = BBacnetIpLinkLayer.class("[Lcom.tridium.bacnet.stack.link.ip.BFdtEntry;", false);
        } while (var5_5.next(v2));
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final void distributeBroadcastFromNetwork(BacnetInputStream var1_1, byte[] var2_2) {
        var3_3 = new ForwardedNpdu(var1_1, var2_2);
        var4_4 = (BBdtEntry)this.getBroadcastDistributionTable().get("localDevice");
        if (var4_4 != null && !var4_4.isDirectedBroadcast()) {
            this.sendBvllMessage(this.localBroadcastAddr, var3_3);
        }
        var5_5 = this.getForeignDeviceTable().getProperties();
        if (true) ** GOTO lbl11
        do {
            var6_6 = (BFdtEntry)var5_5.get();
            var7_7 = var6_6.getBIpAddr();
            this.sendBvllMessage(var7_7, var3_3);
lbl11:
            // 2 sources

            if ((v0 = BBacnetIpLinkLayer.class$com$tridium$bacnet$stack$link$ip$BFdtEntry) != null) continue;
            v0 = BBacnetIpLinkLayer.class("[Lcom.tridium.bacnet.stack.link.ip.BFdtEntry;", false);
        } while (var5_5.next(v0));
    }

    /*
     * Unable to fully structure code
     */
    protected void sendBroadcastToBBMD(NetworkPdu var1_1) {
        var2_2 = this.getSlots();
        if (true) ** GOTO lbl10
        do {
            try {
                var3_3 = (BForeignDeviceRegistration)var2_2.get();
                var3_3.sendBvll(new DistributeBroadcastToNetwork(var1_1));
            }
            catch (Exception var3_4) {
                BBacnetIpLinkLayer.log.error("Unable to send broadcast to BBMD!", (Throwable)var3_4);
            }
lbl10:
            // 3 sources

            if ((v0 = BBacnetIpLinkLayer.class$com$tridium$bacnet$stack$link$ip$BForeignDeviceRegistration) != null) continue;
            v0 = BBacnetIpLinkLayer.class("[Lcom.tridium.bacnet.stack.link.ip.BForeignDeviceRegistration;", false);
        } while (var2_2.next(v0));
    }

    protected void sendBvllMessage(byte[] byArray, BvllMessage bvllMessage) {
        if (byArray == null) {
            byArray = this.localBroadcastAddr;
        }
        try {
            if (byArray.length < 6) {
                throw new UnknownHostException("Invalid Bacnet/IP MAC address! " + ByteArrayUtil.toHexString((byte[])byArray));
            }
            InetAddress inetAddress = this.lookupInetAddr(byArray);
            int n = BBacnetIpLinkLayer.getPort(byArray);
            this.sendBvllMessage(inetAddress, n, bvllMessage);
        }
        catch (UnknownHostException unknownHostException) {
            log.error("Cannot find host for destAddress: " + ByteArrayUtil.toHexString((byte[])byArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sendBvllMessage(InetAddress inetAddress, int n, BvllMessage bvllMessage) {
        if (this.myIp == null) return;
        if (ByteArrayUtil.equals((byte[])this.myIp, (byte[])inetAddress.getAddress()) && n == this.myUdpPort) {
            return;
        }
        byte[] byArray = null;
        DatagramPacket datagramPacket = this.datagramOut;
        synchronized (datagramPacket) {
            try {
                this.os.reset();
                byArray = bvllMessage.encode(this.os);
                this.datagramOut.setAddress(inetAddress);
                this.datagramOut.setPort(n);
                this.datagramOut.setData(byArray);
                this.datagramOut.setLength(byArray.length);
                BBacnetIpLinkLayer bBacnetIpLinkLayer = this;
                synchronized (bBacnetIpLinkLayer) {
                    if (this.server != null) {
                        this.server.send(this.datagramOut);
                    }
                }
                if (log.isTraceOn()) {
                    log.trace("\nPacket Sent on port " + this.server.getLocalPort() + ": ip=" + inetAddress + " port=" + n + " length=" + byArray.length);
                    ByteArrayUtil.hexDump((byte[])byArray);
                }
            }
            catch (Exception exception) {
                log.error("Cannot send Bacnet/IP packet!", (Throwable)exception);
            }
            if (!this.getBbmdDebug()) return;
        }
        switch (bvllMessage.function) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.trace("Sending BBMD Message (" + byArray != null ? "" + byArray.length : "0): addr=" + inetAddress.getHostAddress() + ", port=" + n + ": " + ByteArrayUtil.toHexString((byte[])byArray));
                return;
            }
        }
    }

    private static final byte[] parseIp(String string) {
        if (string == null) {
            return DEFAULT_SUBNET_MASK;
        }
        try {
            return InetAddress.getByName(string).getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new IllegalArgumentException();
        }
    }

    protected static int getPort(byte[] byArray) {
        int n = (byArray[4] & 0xFF) << 8;
        return n |= byArray[5] & 0xFF;
    }

    protected InetAddress lookupInetAddr(byte[] byArray) throws UnknownHostException {
        this.debug("lookupInetAddr:" + ByteArrayUtil.toHexString((byte[])byArray));
        if (byArray == null) {
            return null;
        }
        int n = BBacnetIpLinkLayer.ipHash(byArray);
        if (this.inetAddressTable == null) {
            return null;
        }
        InetAddress inetAddress = (InetAddress)this.inetAddressTable.get(n);
        if (inetAddress == null) {
            StringBuffer stringBuffer = new StringBuffer(15);
            stringBuffer.append(byArray[0] & 0xFF);
            stringBuffer.append(".");
            stringBuffer.append(byArray[1] & 0xFF);
            stringBuffer.append(".");
            stringBuffer.append(byArray[2] & 0xFF);
            stringBuffer.append(".");
            stringBuffer.append(byArray[3] & 0xFF);
            inetAddress = InetAddress.getByName(stringBuffer.toString());
            this.inetAddressTable.put(n, (Object)inetAddress);
        }
        return inetAddress;
    }

    private final byte[] lookupMacAddress(InetAddress inetAddress, int n) {
        String string = inetAddress.getHostAddress() + n;
        byte[] byArray = (byte[])this.macTable.get(string);
        if (byArray == null) {
            byArray = new byte[6];
            byte[] byArray2 = inetAddress.getAddress();
            System.arraycopy(byArray2, 0, byArray, 0, IPV4_HOST_OCTETS);
            byArray[4] = (byte)((n & 0xFF00) >> 8);
            byArray[5] = (byte)(n & 0xFF);
            this.macTable.put(string, byArray);
        }
        return byArray;
    }

    private static final int ipHash(byte[] byArray) {
        int n = byArray[3] & 0xFF;
        n |= byArray[2] << 8 & 0xFF00;
        n |= byArray[1] << 16 & 0xFF0000;
        return n |= byArray[0] << 24 & 0xFF000000;
    }

    protected static byte[] getMacBytes(String string) {
        if (string == null || string.length() == 0 || string.equalsIgnoreCase("null")) {
            return null;
        }
        try {
            byte[] byArray = null;
            int n = string.indexOf(".");
            if (n > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".:");
                if (stringTokenizer.countTokens() < 5) {
                    return null;
                }
                byArray = new byte[6];
                int n2 = 0;
                while (n2 < IPV4_HOST_OCTETS) {
                    byArray[n2] = (byte)Integer.decode(stringTokenizer.nextToken()).intValue();
                    ++n2;
                }
                n2 = Integer.decode(stringTokenizer.nextToken());
                byArray[4] = (byte)(n2 >> 8 & 0xFF);
                byArray[5] = (byte)(n2 & 0xFF);
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " :");
                if (stringTokenizer.countTokens() < 6) {
                    return null;
                }
                byArray = new byte[6];
                int n3 = 0;
                while (n3 < 6) {
                    byArray[n3] = (byte)Integer.parseInt(stringTokenizer.nextToken(), 16);
                    ++n3;
                }
            }
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private final InetAddress convertMacToAddress(byte[] byArray) throws UnknownHostException {
        byte[] byArray2;
        if (byArray.length == IPV4_HOST_OCTETS) {
            byArray2 = byArray;
        } else {
            byArray2 = new byte[IPV4_HOST_OCTETS];
            System.arraycopy(byArray, 0, byArray2, 0, IPV4_HOST_OCTETS);
        }
        return InetAddress.getByAddress(byArray2);
    }

    /*
     * Unable to fully structure code
     */
    protected void startForeignDeviceRegistration() {
        BBacnetIpLinkLayer.log.trace("Starting foreign device registration...");
        var1_1 = this.getSlots();
        var2_2 = null;
        if (true) ** GOTO lbl8
        do {
            var2_2 = (BForeignDeviceRegistration)var1_1.get();
            var2_2.registerWithBBMD();
lbl8:
            // 2 sources

            if ((v0 = BBacnetIpLinkLayer.class$com$tridium$bacnet$stack$link$ip$BForeignDeviceRegistration) != null) continue;
            v0 = BBacnetIpLinkLayer.class("[Lcom.tridium.bacnet.stack.link.ip.BForeignDeviceRegistration;", false);
        } while (var1_1.next(v0));
        if (var2_2 == null) {
            var2_2 = new BForeignDeviceRegistration(this.getBbmdAddress(), this.getRegistrationLifetime());
            var2_2.setEnabled(true);
            this.add("ForeignDeviceReg?", (BValue)var2_2);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void stopForeignDeviceRegistration() {
        var1_1 = this.getSlots();
        var2_2 = null;
        if (true) ** GOTO lbl7
        do {
            var2_2 = (BForeignDeviceRegistration)var1_1.get();
            var2_2.unregisterWithBBMD();
lbl7:
            // 2 sources

            if ((v0 = BBacnetIpLinkLayer.class$com$tridium$bacnet$stack$link$ip$BForeignDeviceRegistration) != null) continue;
            v0 = BBacnetIpLinkLayer.class("[Lcom.tridium.bacnet.stack.link.ip.BForeignDeviceRegistration;", false);
        } while (var1_1.next(v0));
    }

    protected void removeForeignDeviceRegistrations() {
        Class clazz = class$com$tridium$bacnet$stack$link$ip$BForeignDeviceRegistration;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$link$ip$BForeignDeviceRegistration = BBacnetIpLinkLayer.class("[Lcom.tridium.bacnet.stack.link.ip.BForeignDeviceRegistration;", false);
        }
        BForeignDeviceRegistration[] bForeignDeviceRegistrationArray = (BForeignDeviceRegistration[])this.getChildren(clazz);
        int n = 0;
        while (n < bForeignDeviceRegistrationArray.length) {
            this.remove((BComplex)bForeignDeviceRegistrationArray[n]);
            ++n;
        }
    }

    protected boolean updateBBMDAddress(byte[] byArray) {
        if (this.isBBMDActive()) {
            this.initializeBDT();
        }
        return true;
    }

    private final void initializeBDT() {
        block3: {
            log.trace("Initializing the Broadcast Distribution Table");
            byte[] byArray = BBacnetIpLinkLayer.getMacBytes(this.getBbmdAddress());
            try {
                if (byArray != null && byArray.length == 6) {
                    this.sendBvllMessage(byArray, new ReadBroadcastDistributionTable());
                }
                this.checkBDT();
            }
            catch (Exception exception) {
                log.message(" - Unable to read BroadcastDistributionTable from BBMD", (Throwable)exception);
                if (byArray == null) break block3;
                ByteArrayUtil.hexDump((byte[])byArray);
            }
        }
    }

    boolean checkBDT() {
        return this.checkBDT(false);
    }

    private final boolean checkBDT(boolean bl) {
        boolean bl2 = this.getBbmdDebug();
        if (bl2) {
            this.trace("checkBDT(" + (bl ? "T)" : "F)"));
        }
        boolean bl3 = false;
        if (this.getBroadcastDistributionTable().get("localDevice") == null) {
            log.trace("Adding ourself to the BDT...");
            if (bl2) {
                this.trace("adding local to BDT");
            }
            this.getBroadcastDistributionTable().add("localDevice", (BValue)new BBdtEntry(this.myMac, TWO_HOP_DIST_MASK), BBroadcastDistributionTable.noValidation);
            bl3 = true;
        } else if (!((BBdtEntry)this.getBroadcastDistributionTable().get("localDevice")).ipEquals(this.myMac)) {
            if (bl2) {
                this.trace("updating local in BDT");
            }
            this.getBroadcastDistributionTable().remove("localDevice");
            this.getBroadcastDistributionTable().add("localDevice", (BValue)new BBdtEntry(this.myMac, TWO_HOP_DIST_MASK), BBroadcastDistributionTable.noValidation);
            bl3 = true;
        }
        if (bl3 || bl) {
            this.updateAllBDTs();
        }
        return bl3;
    }

    private final int getBbmdMsgsSize() {
        int n = 500;
        try {
            Property property = this.getProperty("bbmdMsgsSize");
            if (property != null && property.getType().is(BInteger.TYPE)) {
                n = this.getInt(property);
            }
        }
        catch (Exception exception) {}
        return n;
    }

    private final void trace(String string) {
        System.out.println(">>>BBMD<<< " + string);
        this.bbmdMsgs[this.ndx] = Clock.time() + ':' + string;
        if (++this.ndx >= this.bbmdMsgs.length) {
            this.ndx = 0;
        }
    }

    private final void dumpAdapter(BTcpIpAdapterSettings bTcpIpAdapterSettings) {
        if (bTcpIpAdapterSettings == null) {
            System.out.println("Adapter is NULL!");
            return;
        }
        System.out.println("  adapterId = " + bTcpIpAdapterSettings.getAdapterId());
        System.out.println("  isAdapterEnabled = " + bTcpIpAdapterSettings.getIsAdapterEnabled());
        System.out.println("  canDisableAdapter = " + bTcpIpAdapterSettings.getCanDisableAdapter());
        System.out.println("  description = " + bTcpIpAdapterSettings.getDescription());
        System.out.println("  isDhcpEnabled = " + bTcpIpAdapterSettings.getIsDhcpEnabled());
        System.out.println("  canUseDhcp = " + bTcpIpAdapterSettings.getCanUseDhcp());
        System.out.println("  defaultGateway = " + bTcpIpAdapterSettings.getDefaultGateway());
        System.out.println("  dnsHosts = " + this.dumpVec(bTcpIpAdapterSettings.getDnsHosts()));
        System.out.println("  domain = " + bTcpIpAdapterSettings.getDomain());
        System.out.println("  ipaddress = " + bTcpIpAdapterSettings.getIpAddress());
        System.out.println("  subnetmask = " + bTcpIpAdapterSettings.getSubnetMask());
        System.out.println("  dhcpHost = " + bTcpIpAdapterSettings.getDhcpHost());
        System.out.println("  dchpLeaseGranted = " + bTcpIpAdapterSettings.getDhcpLeaseGranted());
        System.out.println("  dhcpLeaseExpires = " + bTcpIpAdapterSettings.getDhcpLeaseExpires());
    }

    private final String dumpVec(BVector bVector) {
        StringBuffer stringBuffer = new StringBuffer();
        SlotCursor slotCursor = bVector.getProperties();
        while (slotCursor.next()) {
            stringBuffer.append(slotCursor.get().toString()).append(';');
        }
        return stringBuffer.toString();
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetIpLinkLayer", 2);
        BTcpIpAdapterSettings bTcpIpAdapterSettings = this.getTcpIpAdapter();
        spyWriter.prop((Object)"TCP/IP Adapter:", (Object)bTcpIpAdapterSettings);
        if (bTcpIpAdapterSettings != null) {
            spyWriter.prop((Object)"  adapterId", (Object)bTcpIpAdapterSettings.getAdapterId());
            spyWriter.prop((Object)"  isAdapterEnabled", bTcpIpAdapterSettings.getIsAdapterEnabled());
            spyWriter.prop((Object)"  canDisableAdapter", bTcpIpAdapterSettings.getCanDisableAdapter());
            spyWriter.prop((Object)"  description", (Object)bTcpIpAdapterSettings.getDescription());
            spyWriter.prop((Object)"  isDhcpEnabled", bTcpIpAdapterSettings.getIsDhcpEnabled());
            spyWriter.prop((Object)"  canUseDhcp", bTcpIpAdapterSettings.getCanUseDhcp());
            spyWriter.prop((Object)"  defaultGateway", (Object)bTcpIpAdapterSettings.getDefaultGateway());
            spyWriter.prop((Object)"  dnsHosts", (Object)this.dumpVec(bTcpIpAdapterSettings.getDnsHosts()));
            spyWriter.prop((Object)"  domain", (Object)bTcpIpAdapterSettings.getDomain());
            spyWriter.prop((Object)"  ipaddress", (Object)bTcpIpAdapterSettings.getIpAddress());
            spyWriter.prop((Object)"  subnetmask", (Object)bTcpIpAdapterSettings.getSubnetMask());
            spyWriter.prop((Object)"  dhcpHost", (Object)bTcpIpAdapterSettings.getDhcpHost());
            spyWriter.prop((Object)"  dchpLeaseGranted", (Object)bTcpIpAdapterSettings.getDhcpLeaseGranted());
            spyWriter.prop((Object)"  dhcpLeaseExpires", (Object)bTcpIpAdapterSettings.getDhcpLeaseExpires());
        }
        spyWriter.prop((Object)"MAC Address Table", (Object)"Inet -> MAC");
        Enumeration enumeration = this.macTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            byte[] byArray = (byte[])this.macTable.get(string);
            spyWriter.prop((Object)("  " + string), (Object)byArray);
        }
        spyWriter.prop((Object)"Inet Address Table", (Object)"MAC -> Inet");
        IntHashMap.Iterator iterator = this.inetAddressTable.iterator();
        while (iterator.hasNext()) {
            InetAddress inetAddress = (InetAddress)iterator.next();
            spyWriter.prop((Object)("  " + iterator.key()), (Object)inetAddress);
        }
        spyWriter.prop((Object)"localAddress", (Object)this.server.getLocalAddress());
        spyWriter.prop((Object)"localPort", this.server.getLocalPort());
        spyWriter.prop((Object)"bindType", (Object)this.bindType);
        spyWriter.prop((Object)"localBroadcastAddr", (Object)ByteArrayUtil.toHexString((byte[])this.localBroadcastAddr));
        spyWriter.prop((Object)"myIp", (Object)ByteArrayUtil.toHexString((byte[])this.myIp));
        spyWriter.prop((Object)"oldIpAddr", (Object)this.oldIpAddr);
        spyWriter.prop((Object)"myMac", (Object)ByteArrayUtil.toHexString((byte[])this.myMac));
        spyWriter.prop((Object)"myUdpPort", this.myUdpPort);
        spyWriter.prop((Object)"bbmdInet", (Object)this.bbmdInet);
        spyWriter.prop((Object)"bbmdPort", this.bbmdPort);
        spyWriter.prop((Object)"bbmdMac", (Object)ByteArrayUtil.toHexString((byte[])this.bbmdMac));
        spyWriter.prop((Object)"oldIpDeviceType", this.oldIpDeviceType);
        if (this.getBbmdDebug()) {
            spyWriter.prop((Object)("BBMD Messages (last " + this.bbmdMsgs.length + "): now="), (Object)Clock.time());
            int n = this.ndx;
            while (n < this.bbmdMsgs.length) {
                if (this.bbmdMsgs[n] != null) {
                    spyWriter.prop((Object)("" + n + ':'), (Object)this.bbmdMsgs[n]);
                }
                ++n;
            }
            if (this.ndx != 0) {
                n = 0;
                while (n < this.ndx) {
                    if (this.bbmdMsgs[n] != null) {
                        spyWriter.prop((Object)("" + n + ':'), (Object)this.bbmdMsgs[n]);
                    }
                    ++n;
                }
            }
        }
        spyWriter.endProps();
    }

    protected byte[] getMac() {
        return this.myMac;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.broadcastServer = null;
        this.broadcastWorker = null;
        this.os = new ByteArrayOutputStream();
        this.datagramOut = new DatagramPacket(new byte[0], 0);
        this.bindType = "none";
        this.alive = false;
        this.inetAddressTable = new IntHashMap();
        this.macTable = new Hashtable();
        this.bbmdInet = null;
        this.bbmdPort = -1;
        this.oldIpDeviceType = 0;
        this.ndx = 0;
    }

    public BBacnetIpLinkLayer() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$stack$link$ip$BBacnetIpLinkLayer;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$link$ip$BBacnetIpLinkLayer = BBacnetIpLinkLayer.class("[Lcom.tridium.bacnet.stack.link.ip.BBacnetIpLinkLayer;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        byte[] byArray = new byte[4];
        byArray[0] = -1;
        byArray[1] = -1;
        byArray[2] = -1;
        DEFAULT_SUBNET_MASK = byArray;
        TWO_HOP_DIST_MASK = new byte[]{-1, -1, -1, -1};
        IPV4_HOST_OCTETS = 4;
        log = Log.getLog((String)"bacnet.link.ip");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class BroadcastWorker
    extends Thread {
        public void run() {
            BBacnetIpLinkLayer.this.listenForPackets(BBacnetIpLinkLayer.this.broadcastServer);
        }

        public BroadcastWorker(String string) {
            super(string + "_broadcast");
        }
    }
}

