/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.ethernet;

import com.tridium.bacnet.stack.BacnetInputStream;
import com.tridium.bacnet.stack.link.BBacnetLinkLayer;
import com.tridium.bacnet.stack.network.NetworkPdu;
import com.tridium.platBacnet.BBacnetEthernetPlatformService;
import com.tridium.platBacnet.BacnetEthernetAdapter;
import com.tridium.platBacnet.EthernetConst;
import com.tridium.platBacnet.EthernetListener;
import java.io.ByteArrayOutputStream;
import java.util.Vector;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ByteArrayUtil;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetEthernetLinkLayer
extends BBacnetLinkLayer
implements EthernetConst,
EthernetListener {
    private static Lexicon lex = Lexicon.make((String)"bacnet");
    private static String NONE = SlotPath.escape((String)lex.getText("ethernet.adapter.none"));
    private static String[] noTitleArray = new String[]{NONE};
    private static String[] noNameArray = new String[]{NONE};
    private static String[] noDescriptionArray = new String[]{NONE};
    private static int[] noneOrdinals = new int[]{-1};
    public static final Property adapterTitle = BBacnetEthernetLinkLayer.newProperty((int)64, (BValue)BDynamicEnum.make((int)-1, (BEnumRange)BEnumRange.make((int[])noneOrdinals, (String[])noTitleArray)), null);
    public static final Property adapterDescription = BBacnetEthernetLinkLayer.newProperty((int)65, (BValue)BDynamicEnum.make((int)-1, (BEnumRange)BEnumRange.make((int[])noneOrdinals, (String[])noDescriptionArray)), null);
    public static final Property adapterName = BBacnetEthernetLinkLayer.newProperty((int)65, (BValue)BDynamicEnum.make((int)-1, (BEnumRange)BEnumRange.make((int[])noneOrdinals, (String[])noNameArray)), null);
    public static final Type TYPE;
    private static final Log log;
    private boolean commStarted;
    private byte[] myMacAddress;
    private String oldDeviceName;
    private ByteArrayOutputStream os;
    private BacnetEthernetAdapter adapter;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$link$ethernet$BBacnetEthernetLinkLayer;

    public BEnum getAdapterTitle() {
        return (BEnum)this.get(adapterTitle);
    }

    public void setAdapterTitle(BEnum bEnum) {
        this.set(adapterTitle, (BValue)bEnum, null);
    }

    public BEnum getAdapterDescription() {
        return (BEnum)this.get(adapterDescription);
    }

    public void setAdapterDescription(BEnum bEnum) {
        this.set(adapterDescription, (BValue)bEnum, null);
    }

    public BEnum getAdapterName() {
        return (BEnum)this.get(adapterName);
    }

    public void setAdapterName(BEnum bEnum) {
        this.set(adapterName, (BValue)bEnum, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBacnetEthernetPlatformService getPlatformService() {
        try {
            return (BBacnetEthernetPlatformService)Sys.getService((Type)BBacnetEthernetPlatformService.TYPE);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public final void linkCommInit() {
        try {
            this.getPlatformService().init();
        }
        catch (Exception exception) {
            log.error("Unable to initialize Ethernet Link Layer!", (Throwable)exception);
        }
    }

    public final void linkCommStart() throws Exception {
        this.myMacAddress = new byte[6];
        BBacnetEthernetPlatformService bBacnetEthernetPlatformService = this.getPlatformService();
        this.adapter = bBacnetEthernetPlatformService.openAdapter(SlotPath.unescape((String)this.getAdapterName().getTag()));
        this.adapter.addListener((EthernetListener)this);
        this.adapter.commStart();
        this.adapter.getAddress(this.myMacAddress);
        if (log.isTraceOn()) {
            log.trace("My MAC address:" + ByteArrayUtil.toHexString((byte[])this.myMacAddress));
        }
        this.commStarted = true;
    }

    public final void linkCommStop() {
        this.adapter.removeListener((EthernetListener)this);
        this.adapter.commStop();
        this.commStarted = false;
    }

    public final void linkCommCleanup() {
        this.adapter.commCleanup();
        this.adapter.removeListener((EthernetListener)this);
    }

    private final void setAdapter() {
        BDynamicEnum bDynamicEnum;
        BDynamicEnum bDynamicEnum2;
        int n;
        String string;
        String string2 = SlotPath.unescape((String)this.getAdapterTitle().getTag());
        int n2 = this.getAdapterTitle().getOrdinal();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        try {
            this.getPlatformService().getAdapterChoices(vector, vector2, vector3);
        }
        catch (Exception exception) {
            log.warning("Exception querying ethernet platform service for adapter choices: " + exception, (Throwable)exception);
        }
        boolean bl = log.isTraceOn();
        if (bl) {
            log.trace("Ethernet Adapter Title list size:" + vector.size());
        }
        int n3 = vector.size() + 1;
        String[] stringArray = new String[n3];
        int[] nArray = new int[n3];
        String[] stringArray2 = new String[vector2.size() + 1];
        int[] nArray2 = new int[vector2.size() + 1];
        String[] stringArray3 = new String[vector3.size() + 1];
        int[] nArray3 = new int[vector3.size() + 1];
        stringArray[0] = NONE;
        nArray[0] = -1;
        boolean bl2 = false;
        int n4 = 0;
        while (n4 < vector.size()) {
            string = SlotPath.escape((String)((String)vector.elementAt(n4)));
            n = 0;
            while (n <= n4) {
                if (stringArray[n].equals(string)) {
                    string = string + "$20";
                }
                ++n;
            }
            stringArray[n4 + 1] = string;
            nArray[n4 + 1] = n4;
            if (string2.equals(vector.elementAt(n4))) {
                bl2 = true;
            }
            ++n4;
        }
        stringArray2[0] = NONE;
        nArray2[0] = -1;
        n4 = 0;
        while (n4 < vector2.size()) {
            string = SlotPath.escape((String)((String)vector2.elementAt(n4)));
            n = 0;
            while (n <= n4) {
                if (stringArray2[n].equals(string)) {
                    string = string + "$20";
                }
                ++n;
            }
            stringArray2[n4 + 1] = string;
            nArray2[n4 + 1] = n4;
            ++n4;
        }
        stringArray3[0] = NONE;
        nArray3[0] = -1;
        n4 = 0;
        while (n4 < vector3.size()) {
            stringArray3[n4 + 1] = SlotPath.escape((String)((String)vector3.elementAt(n4)));
            nArray3[n4 + 1] = n4;
            ++n4;
        }
        if (bl) {
            log.trace("Adapter lists:");
            n4 = 0;
            while (n4 < n3) {
                System.out.println(n4 + ": title=" + stringArray[n4] + " descr=" + stringArray2[n4] + " name=" + stringArray3[n4]);
                ++n4;
            }
        }
        if (bl2) {
            bDynamicEnum2 = BDynamicEnum.make((int)n2, (BEnumRange)BEnumRange.make((int[])nArray, (String[])stringArray));
            string = BDynamicEnum.make((int)n2, (BEnumRange)BEnumRange.make((int[])nArray2, (String[])stringArray2));
            bDynamicEnum = BDynamicEnum.make((int)n2, (BEnumRange)BEnumRange.make((int[])nArray3, (String[])stringArray3));
        } else if (nArray.length == 2) {
            bDynamicEnum2 = BDynamicEnum.make((int)nArray[1], (BEnumRange)BEnumRange.make((int[])nArray, (String[])stringArray));
            string = BDynamicEnum.make((int)nArray2[1], (BEnumRange)BEnumRange.make((int[])nArray2, (String[])stringArray2));
            bDynamicEnum = BDynamicEnum.make((int)nArray3[1], (BEnumRange)BEnumRange.make((int[])nArray3, (String[])stringArray3));
        } else {
            bDynamicEnum2 = BDynamicEnum.make((int)nArray[0], (BEnumRange)BEnumRange.make((int[])nArray, (String[])stringArray));
            string = BDynamicEnum.make((int)nArray2[0], (BEnumRange)BEnumRange.make((int[])nArray2, (String[])stringArray2));
            bDynamicEnum = BDynamicEnum.make((int)nArray3[0], (BEnumRange)BEnumRange.make((int[])nArray3, (String[])stringArray3));
        }
        this.setAdapterDescription((BEnum)string);
        this.setAdapterName((BEnum)bDynamicEnum);
        this.setAdapterTitle((BEnum)bDynamicEnum2);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == adapterTitle) {
            this.setAdapterDescription(this.getAdapterDescription().getRange().get(this.getAdapterTitle().getOrdinal()));
            this.setAdapterName(this.getAdapterName().getRange().get(this.getAdapterTitle().getOrdinal()));
        } else if (property == adapterName) {
            String string = this.getAdapterName().getTag();
            if (!string.equals(this.oldDeviceName) && this.commStarted && !this.getAdapterTitle().getTag().equals(this.getLexicon().getText("ethernet.adapterTitle.none"))) {
                this.getNetworkPort().disable();
                this.getNetworkPort().enable();
            }
            this.oldDeviceName = string;
        }
    }

    public void started() {
        this.oldDeviceName = this.getAdapterName().getTag();
        BBacnetNetwork.bacnet().postAsync(new Runnable(){

            public final void run() {
                BBacnetEthernetLinkLayer.this.setAdapter();
            }
        });
    }

    public Log log() {
        return log;
    }

    public void receivePacket(byte[] byArray, int n) {
        if (log.isTraceOn()) {
            log.trace("\nPacket Received (" + n + " bytes):");
            ByteArrayUtil.hexDump((byte[])byArray, (int)0, (int)n);
        }
        BacnetInputStream bacnetInputStream = BacnetInputStream.make(byArray, 0, n);
        bacnetInputStream.skip(6L);
        byte[] byArray2 = new byte[6];
        bacnetInputStream.read(byArray2, 0, 6);
        int n2 = bacnetInputStream.read();
        n2 <<= 8;
        if (bacnetInputStream.available() < (n2 |= bacnetInputStream.read())) {
            log.error("LLC Length does not match!" + bacnetInputStream.available() + " != " + n2 + " packetLength: " + n);
            return;
        }
        int n3 = bacnetInputStream.read();
        int n4 = bacnetInputStream.read();
        int n5 = bacnetInputStream.read();
        if (n3 != 130 || n4 != 130 || n5 != 3) {
            log.message("Invalid packet received!  DSAP=" + n3 + ", SSAP=" + n4 + ", llcCtl=" + n5);
            ByteArrayUtil.hexDump((byte[])byArray);
            return;
        }
        if (this.linkListener != null) {
            this.linkListener.rcvIndication(byArray2, this.myMacAddress, bacnetInputStream);
        }
    }

    public byte[] getMacAddress() {
        return this.myMacAddress;
    }

    public int getMaxAPDULengthAccepted() {
        return 1476;
    }

    public synchronized void sendRequest(byte[] byArray, NetworkPdu networkPdu) {
        this.os.reset();
        if (byArray == null || byArray.length == 0) {
            this.os.write(EthernetConst.BCAST_MAC_ADDRESS, 0, EthernetConst.BCAST_MAC_ADDRESS.length);
        } else {
            this.os.write(byArray, 0, byArray.length);
        }
        this.os.write(this.myMacAddress, 0, this.myMacAddress.length);
        this.os.write(0);
        this.os.write(0);
        this.os.write(130);
        this.os.write(130);
        this.os.write(3);
        networkPdu.writeNetworkBytes(this.os);
        byte[] byArray2 = this.os.toByteArray();
        int n = byArray2.length - 14;
        byArray2[12] = (byte)((n & 0xFF00) >> 8);
        byArray2[13] = (byte)(n & 0xFF);
        try {
            this.adapter.sendPacket(byArray2);
            if (log.isTraceOn()) {
                log.trace("\nPacket Sent:");
                ByteArrayUtil.hexDump((byte[])byArray2);
            }
        }
        catch (Exception exception) {
            this.getNetworkPort().fault("Cannot send Bacnet/Ethernet packet! Is the adapter enabled in the TCP/IP Platform Service?");
            log.error("Cannot send Bacnet/Ethernet packet!", (Throwable)exception);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.commStarted = false;
        this.oldDeviceName = null;
        this.os = new ByteArrayOutputStream();
    }

    public BBacnetEthernetLinkLayer() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$stack$link$ethernet$BBacnetEthernetLinkLayer;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$link$ethernet$BBacnetEthernetLinkLayer = BBacnetEthernetLinkLayer.class("[Lcom.tridium.bacnet.stack.link.ethernet.BBacnetEthernetLinkLayer;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"bacnet.link.ethernet");
    }
}

