/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.client;

import com.tridium.bacnet.asn.NReadAccessResult;
import com.tridium.bacnet.asn.NReadAccessSpec;
import com.tridium.bacnet.services.BacnetComplexAck;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.BacnetUnconfirmedRequest;
import com.tridium.bacnet.services.confirmed.AcknowledgeAlarmRequest;
import com.tridium.bacnet.services.confirmed.AtomicReadFileRequest;
import com.tridium.bacnet.services.confirmed.AtomicWriteFileRequest;
import com.tridium.bacnet.services.confirmed.ConfirmedCovNotificationRequest;
import com.tridium.bacnet.services.confirmed.ConfirmedEventNotificationRequest;
import com.tridium.bacnet.services.confirmed.GetEventInformationRequest;
import com.tridium.bacnet.services.confirmed.ListElementRequest;
import com.tridium.bacnet.services.confirmed.ReadPropertyAck;
import com.tridium.bacnet.services.confirmed.ReadPropertyMultipleAck;
import com.tridium.bacnet.services.confirmed.ReadPropertyMultipleRequest;
import com.tridium.bacnet.services.confirmed.ReadPropertyRequest;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.services.confirmed.ReadRangeRequest;
import com.tridium.bacnet.services.confirmed.SubscribeCovRequest;
import com.tridium.bacnet.services.confirmed.WritePropertyMultipleRequest;
import com.tridium.bacnet.services.confirmed.WritePropertyRequest;
import com.tridium.bacnet.services.unconfirmed.IAmRequest;
import com.tridium.bacnet.services.unconfirmed.IHaveRequest;
import com.tridium.bacnet.services.unconfirmed.UnconfirmedCovNotificationRequest;
import com.tridium.bacnet.services.unconfirmed.UnconfirmedEventNotificationRequest;
import com.tridium.bacnet.services.unconfirmed.WhoHasRequest;
import com.tridium.bacnet.stack.AppDebugListener;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import java.util.ListIterator;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BClientDebugListener
extends BComponent
implements AppDebugListener {
    public static final Property enabled = BClientDebugListener.newProperty((int)0, (boolean)true, null);
    public static final Property deviceNameEnabled = BClientDebugListener.newProperty((int)0, (boolean)false, null);
    public static final Property deviceName = BClientDebugListener.newProperty((int)0, (String)"", null);
    public static final Property addressEnabled = BClientDebugListener.newProperty((int)0, (boolean)false, null);
    public static final Property deviceAddress = BClientDebugListener.newProperty((int)0, (BValue)BBacnetAddress.DEFAULT, null);
    public static final Property serviceChoiceEnabled = BClientDebugListener.newProperty((int)0, (boolean)false, null);
    public static final Property serviceChoices = BClientDebugListener.newProperty((int)0, (BValue)BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetServicesSupported")), (BFacets)BacnetBitStringUtil.BACNET_SERVICES_SUPPORTED_FACETS);
    public static final Property objectIdEnabled = BClientDebugListener.newProperty((int)0, (boolean)false, null);
    public static final Property objectId = BClientDebugListener.newProperty((int)0, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    public static final Type TYPE;
    private static final int[] confirmedServiceChoiceMap;
    private static final int[] unconfirmedServiceChoiceMap;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$client$BClientDebugListener;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public boolean getDeviceNameEnabled() {
        return this.getBoolean(deviceNameEnabled);
    }

    public void setDeviceNameEnabled(boolean bl) {
        this.setBoolean(deviceNameEnabled, bl, null);
    }

    public String getDeviceName() {
        return this.getString(deviceName);
    }

    public void setDeviceName(String string) {
        this.setString(deviceName, string, null);
    }

    public boolean getAddressEnabled() {
        return this.getBoolean(addressEnabled);
    }

    public void setAddressEnabled(boolean bl) {
        this.setBoolean(addressEnabled, bl, null);
    }

    public BBacnetAddress getDeviceAddress() {
        return (BBacnetAddress)this.get(deviceAddress);
    }

    public void setDeviceAddress(BBacnetAddress bBacnetAddress) {
        this.set(deviceAddress, (BValue)bBacnetAddress, null);
    }

    public boolean getServiceChoiceEnabled() {
        return this.getBoolean(serviceChoiceEnabled);
    }

    public void setServiceChoiceEnabled(boolean bl) {
        this.setBoolean(serviceChoiceEnabled, bl, null);
    }

    public BBacnetBitString getServiceChoices() {
        return (BBacnetBitString)this.get(serviceChoices);
    }

    public void setServiceChoices(BBacnetBitString bBacnetBitString) {
        this.set(serviceChoices, (BValue)bBacnetBitString, null);
    }

    public boolean getObjectIdEnabled() {
        return this.getBoolean(objectIdEnabled);
    }

    public void setObjectIdEnabled(boolean bl) {
        this.setBoolean(objectIdEnabled, bl, null);
    }

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(objectId, (BValue)bBacnetObjectIdentifier, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.getClient().addDebugListener(this);
    }

    public void stopped() throws Exception {
        super.stopped();
        this.getClient().removeDebugListener(this);
    }

    public void receive(BBacnetAddress bBacnetAddress, BacnetServicePrimitive bacnetServicePrimitive) {
        if (this.passFilter(bBacnetAddress, bacnetServicePrimitive, true)) {
            this.display(bBacnetAddress, bacnetServicePrimitive, true);
        }
    }

    public void send(BBacnetAddress bBacnetAddress, BacnetServicePrimitive bacnetServicePrimitive) {
        if (this.passFilter(bBacnetAddress, bacnetServicePrimitive, false)) {
            this.display(bBacnetAddress, bacnetServicePrimitive, false);
        }
    }

    protected boolean passFilter(BBacnetAddress bBacnetAddress, BacnetServicePrimitive bacnetServicePrimitive, boolean bl) {
        if (bacnetServicePrimitive == null) {
            return false;
        }
        try {
            if (!this.getEnabled()) {
                return false;
            }
            boolean bl2 = true;
            if (this.getAddressEnabled()) {
                bl2 = this.checkAddress(bBacnetAddress);
            }
            if (!bl2) {
                return false;
            }
            if (this.getDeviceNameEnabled()) {
                bl2 = this.checkDeviceName(bBacnetAddress);
            }
            if (!bl2) {
                return false;
            }
            if (this.getServiceChoiceEnabled()) {
                bl2 = this.checkServiceChoice(bacnetServicePrimitive);
            }
            if (!bl2) {
                return false;
            }
            if (this.getObjectIdEnabled()) {
                bl2 = this.checkObjectId(bacnetServicePrimitive);
            }
            if (!bl2) {
                return false;
            }
            return bl2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private final boolean checkAddress(BBacnetAddress bBacnetAddress) {
        return BClientDebugListener.equals(bBacnetAddress, this.getDeviceAddress());
    }

    private final boolean checkDeviceName(BBacnetAddress bBacnetAddress) {
        BBacnetNetwork bBacnetNetwork = BBacnetNetwork.bacnet();
        BBacnetDevice bBacnetDevice = bBacnetNetwork.lookupDeviceByAddress(bBacnetAddress);
        if (bBacnetDevice == null) {
            return false;
        }
        return bBacnetDevice.getName().equals(this.getDeviceName());
    }

    private final boolean checkServiceChoice(BacnetServicePrimitive bacnetServicePrimitive) {
        int n = bacnetServicePrimitive.getServiceType();
        int n2 = bacnetServicePrimitive.getServiceChoice();
        switch (n) {
            case 1: {
                return this.getServiceChoices().getBit(unconfirmedServiceChoiceMap[n2]);
            }
            case 0: 
            case 2: 
            case 3: {
                return this.getServiceChoices().getBit(confirmedServiceChoiceMap[n2]);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return false;
            }
        }
        return false;
    }

    private final boolean checkObjectId(BacnetServicePrimitive bacnetServicePrimitive) {
        int n = bacnetServicePrimitive.getServiceType();
        int n2 = bacnetServicePrimitive.getServiceChoice();
        switch (n) {
            case 0: {
                return this.checkConfirmed(n2, (BacnetConfirmedRequest)bacnetServicePrimitive);
            }
            case 1: {
                return this.checkUnconfirmed(n2, (BacnetUnconfirmedRequest)bacnetServicePrimitive);
            }
            case 3: {
                return this.checkComplexAck(n2, (BacnetComplexAck)bacnetServicePrimitive);
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return false;
            }
        }
        return false;
    }

    private final boolean checkConfirmed(int n, BacnetConfirmedRequest bacnetConfirmedRequest) {
        BBacnetObjectIdentifier bBacnetObjectIdentifier = this.getObjectId();
        switch (n) {
            case 0: {
                return bBacnetObjectIdentifier.equals((Object)((AcknowledgeAlarmRequest)bacnetConfirmedRequest).getEventObjectId());
            }
            case 1: {
                return bBacnetObjectIdentifier.equals((Object)((ConfirmedCovNotificationRequest)bacnetConfirmedRequest).getCovNotificationParameters().getMonitoredObjectId());
            }
            case 2: {
                return bBacnetObjectIdentifier.equals((Object)((ConfirmedEventNotificationRequest)bacnetConfirmedRequest).getEventNotificationParameters().getEventObjectId());
            }
            case 29: {
                return bBacnetObjectIdentifier.equals((Object)((GetEventInformationRequest)bacnetConfirmedRequest).getLastReceivedObjectId());
            }
            case 5: {
                return bBacnetObjectIdentifier.equals((Object)((SubscribeCovRequest)bacnetConfirmedRequest).getMonitoredObjectId());
            }
            case 6: {
                return bBacnetObjectIdentifier.equals((Object)((AtomicReadFileRequest)bacnetConfirmedRequest).getFileId());
            }
            case 7: {
                return bBacnetObjectIdentifier.equals((Object)((AtomicWriteFileRequest)bacnetConfirmedRequest).getFileId());
            }
            case 8: {
                return bBacnetObjectIdentifier.equals((Object)((ListElementRequest)bacnetConfirmedRequest).getObjectId());
            }
            case 9: {
                return bBacnetObjectIdentifier.equals((Object)((ListElementRequest)bacnetConfirmedRequest).getObjectId());
            }
            case 12: {
                return bBacnetObjectIdentifier.equals((Object)((ReadPropertyRequest)bacnetConfirmedRequest).getObjectId());
            }
            case 14: {
                ListIterator listIterator = ((ReadPropertyMultipleRequest)bacnetConfirmedRequest).getReadAccessSpecs();
                while (listIterator.hasNext()) {
                    if (!bBacnetObjectIdentifier.equals((Object)((NReadAccessSpec)listIterator.next()).getObjectId())) continue;
                    return true;
                }
                return false;
            }
            case 26: {
                return bBacnetObjectIdentifier.equals((Object)((ReadRangeRequest)bacnetConfirmedRequest).getObjectId());
            }
            case 15: {
                return bBacnetObjectIdentifier.equals((Object)((WritePropertyRequest)bacnetConfirmedRequest).getObjectId());
            }
            case 16: {
                ListIterator listIterator = ((WritePropertyMultipleRequest)bacnetConfirmedRequest).getWriteAccessSpecs();
                while (listIterator.hasNext()) {
                    if (!bBacnetObjectIdentifier.equals((Object)((NReadAccessSpec)listIterator.next()).getObjectId())) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private final boolean checkUnconfirmed(int n, BacnetUnconfirmedRequest bacnetUnconfirmedRequest) {
        BBacnetObjectIdentifier bBacnetObjectIdentifier = this.getObjectId();
        switch (n) {
            case 0: {
                return bBacnetObjectIdentifier.equals((Object)((IAmRequest)bacnetUnconfirmedRequest).getObjectId());
            }
            case 1: {
                return bBacnetObjectIdentifier.equals((Object)((IHaveRequest)bacnetUnconfirmedRequest).getObjectId());
            }
            case 2: {
                return bBacnetObjectIdentifier.equals((Object)((UnconfirmedCovNotificationRequest)bacnetUnconfirmedRequest).getCovNotificationParameters().getMonitoredObjectId());
            }
            case 3: {
                return bBacnetObjectIdentifier.equals((Object)((UnconfirmedEventNotificationRequest)bacnetUnconfirmedRequest).getEventNotificationParameters().getEventObjectId());
            }
            case 7: {
                return bBacnetObjectIdentifier.equals((Object)((WhoHasRequest)bacnetUnconfirmedRequest).getObjectId());
            }
        }
        return false;
    }

    private final boolean checkComplexAck(int n, BacnetComplexAck bacnetComplexAck) {
        BBacnetObjectIdentifier bBacnetObjectIdentifier = this.getObjectId();
        switch (n) {
            case 12: {
                return this.getObjectId().equals((Object)((ReadPropertyAck)bacnetComplexAck).getObjectId());
            }
            case 14: {
                ListIterator listIterator = ((ReadPropertyMultipleAck)bacnetComplexAck).getReadAccessResults();
                while (listIterator.hasNext()) {
                    if (!bBacnetObjectIdentifier.equals((Object)((NReadAccessResult)listIterator.next()).getObjectId())) continue;
                    return true;
                }
                return false;
            }
            case 26: {
                return bBacnetObjectIdentifier.equals((Object)((ReadRangeAck)bacnetComplexAck).getObjectId());
            }
        }
        return false;
    }

    private final BBacnetClientLayer getClient() {
        BClientDebugListener bClientDebugListener = this;
        while (bClientDebugListener != null) {
            if (!((bClientDebugListener = bClientDebugListener.getParent()) instanceof BBacnetClientLayer)) continue;
            return (BBacnetClientLayer)((Object)bClientDebugListener);
        }
        return null;
    }

    private static final boolean equals(BBacnetAddress bBacnetAddress, BBacnetAddress bBacnetAddress2) {
        if (bBacnetAddress == null) {
            boolean bl = false;
            if (bBacnetAddress2 == null) {
                bl = true;
            }
            return bl;
        }
        if (bBacnetAddress2 == null) {
            return false;
        }
        return bBacnetAddress.equals(bBacnetAddress2.getNetworkNumber(), bBacnetAddress2.getMacAddress().getBytes());
    }

    private final void display(BBacnetAddress bBacnetAddress, BacnetServicePrimitive bacnetServicePrimitive, boolean bl) {
        if (bl) {
            System.out.println("BACnet Recv [" + bBacnetAddress + "]:" + bacnetServicePrimitive);
        } else {
            System.out.println("BACnet Send [" + bBacnetAddress + "]:" + bacnetServicePrimitive);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$bacnet$stack$client$BClientDebugListener;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$client$BClientDebugListener = BClientDebugListener.class("[Lcom.tridium.bacnet.stack.client.BClientDebugListener;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        int[] nArray = new int[30];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[12] = 12;
        nArray[13] = 13;
        nArray[14] = 14;
        nArray[15] = 15;
        nArray[16] = 16;
        nArray[17] = 17;
        nArray[18] = 18;
        nArray[19] = 19;
        nArray[20] = 20;
        nArray[21] = 21;
        nArray[22] = 22;
        nArray[23] = 23;
        nArray[24] = 24;
        nArray[25] = 25;
        nArray[26] = 35;
        nArray[27] = 37;
        nArray[28] = 38;
        nArray[29] = 39;
        confirmedServiceChoiceMap = nArray;
        unconfirmedServiceChoiceMap = new int[]{26, 27, 28, 29, 30, 31, 32, 33, 34, 36};
    }
}

