/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.client;

import com.tridium.bacnet.asn.CovNotificationParameters;
import com.tridium.bacnet.asn.EventNotificationParameters;
import com.tridium.bacnet.asn.NEventSummary;
import com.tridium.bacnet.asn.NReadAccessResult;
import com.tridium.bacnet.asn.NReadAccessSpec;
import com.tridium.bacnet.services.BacnetComplexAck;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.BacnetSimpleAck;
import com.tridium.bacnet.services.confirmed.AcknowledgeAlarmRequest;
import com.tridium.bacnet.services.confirmed.AddListElementRequest;
import com.tridium.bacnet.services.confirmed.AtomicReadFileAck;
import com.tridium.bacnet.services.confirmed.AtomicReadFileRequest;
import com.tridium.bacnet.services.confirmed.AtomicWriteFileAck;
import com.tridium.bacnet.services.confirmed.AtomicWriteFileRequest;
import com.tridium.bacnet.services.confirmed.ConfirmedCovNotificationRequest;
import com.tridium.bacnet.services.confirmed.ConfirmedEventNotificationRequest;
import com.tridium.bacnet.services.confirmed.ConfirmedPrivateTransferAck;
import com.tridium.bacnet.services.confirmed.ConfirmedPrivateTransferRequest;
import com.tridium.bacnet.services.confirmed.CreateObjectAck;
import com.tridium.bacnet.services.confirmed.CreateObjectRequest;
import com.tridium.bacnet.services.confirmed.DeleteObjectRequest;
import com.tridium.bacnet.services.confirmed.DeviceCommunicationControlRequest;
import com.tridium.bacnet.services.confirmed.GetAlarmSummaryAck;
import com.tridium.bacnet.services.confirmed.GetAlarmSummaryRequest;
import com.tridium.bacnet.services.confirmed.GetEnrollmentSummaryAck;
import com.tridium.bacnet.services.confirmed.GetEnrollmentSummaryRequest;
import com.tridium.bacnet.services.confirmed.GetEventInformationAck;
import com.tridium.bacnet.services.confirmed.GetEventInformationRequest;
import com.tridium.bacnet.services.confirmed.ReadPropertyAck;
import com.tridium.bacnet.services.confirmed.ReadPropertyMultipleAck;
import com.tridium.bacnet.services.confirmed.ReadPropertyMultipleRequest;
import com.tridium.bacnet.services.confirmed.ReadPropertyRequest;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.services.confirmed.ReadRangeRequest;
import com.tridium.bacnet.services.confirmed.ReinitializeDeviceRequest;
import com.tridium.bacnet.services.confirmed.RemoveListElementRequest;
import com.tridium.bacnet.services.confirmed.SubscribeCovPropertyRequest;
import com.tridium.bacnet.services.confirmed.SubscribeCovRequest;
import com.tridium.bacnet.services.confirmed.WritePropertyMultipleRequest;
import com.tridium.bacnet.services.confirmed.WritePropertyRequest;
import com.tridium.bacnet.services.unconfirmed.TimeSynchronizationRequest;
import com.tridium.bacnet.services.unconfirmed.UnconfirmedCovNotificationRequest;
import com.tridium.bacnet.services.unconfirmed.UnconfirmedEventNotificationRequest;
import com.tridium.bacnet.services.unconfirmed.UnconfirmedPrivateTransferRequest;
import com.tridium.bacnet.services.unconfirmed.UtcTimeSynchronizationRequest;
import com.tridium.bacnet.services.unconfirmed.WhoHasRequest;
import com.tridium.bacnet.services.unconfirmed.WhoIsRequest;
import com.tridium.bacnet.stack.AppDebugListener;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.BacnetStackErrorCodes;
import com.tridium.bacnet.stack.BacnetStackException;
import com.tridium.bacnet.stack.DeviceRegistry;
import com.tridium.bacnet.stack.network.BNetworkPriority;
import com.tridium.bacnet.stack.transport.BBacnetTransportLayer;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetRecipient;
import javax.baja.bacnet.datatypes.BBacnetRecipientProcess;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.enums.BBacnetCommControl;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetReinitializedDeviceState;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.io.FileData;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetClientLayer
extends BComponent
implements BacnetConst,
BacnetStackErrorCodes {
    public static final Type TYPE;
    public static final int LOWEST_LIFE_SAFETY_PRIORITY = 63;
    public static final int LOWEST_CRITICAL_EQUIPMENT_PRIORITY = 127;
    public static final int LOWEST_URGENT_PRIORITY = 191;
    public static final int LOWEST_NORMAL_PRIORITY = 255;
    protected static Log log;
    protected Vector debugListeners;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$client$BBacnetClientLayer;

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BBacnetStack;
    }

    public void acknowledgeAlarm(BBacnetAddress bBacnetAddress, long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetEventState bBacnetEventState, BBacnetTimeStamp bBacnetTimeStamp, String string, BBacnetTimeStamp bBacnetTimeStamp2, BCharacterSetEncoding bCharacterSetEncoding) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.acknowledgeAlarm(" + (Object)((Object)bBacnetObjectIdentifier) + ';' + bBacnetEventState + ';' + bBacnetTimeStamp + ')');
        }
        AcknowledgeAlarmRequest acknowledgeAlarmRequest = new AcknowledgeAlarmRequest(l, bBacnetObjectIdentifier, (BEnum)bBacnetEventState, bBacnetTimeStamp, string, bBacnetTimeStamp2, bCharacterSetEncoding);
        this.debugSend(bBacnetAddress, acknowledgeAlarmRequest);
        BacnetSimpleAck bacnetSimpleAck = this.transport().sendConfirmedRequestSimple(acknowledgeAlarmRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetSimpleAck);
    }

    public void confirmedCovNotification(BBacnetAddress bBacnetAddress, CovNotificationParameters covNotificationParameters) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        ConfirmedCovNotificationRequest confirmedCovNotificationRequest = new ConfirmedCovNotificationRequest(covNotificationParameters);
        this.debugSend(bBacnetAddress, confirmedCovNotificationRequest);
        BacnetSimpleAck bacnetSimpleAck = this.transport().sendConfirmedRequestSimple(confirmedCovNotificationRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetSimpleAck);
    }

    public void confirmedEventNotification(BBacnetAddress bBacnetAddress, EventNotificationParameters eventNotificationParameters) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.confirmedEventNotification(" + bBacnetAddress + ");enp=" + eventNotificationParameters);
        }
        ConfirmedEventNotificationRequest confirmedEventNotificationRequest = new ConfirmedEventNotificationRequest(eventNotificationParameters);
        BNetworkPriority bNetworkPriority = BNetworkPriority.normal;
        int n = eventNotificationParameters.getPriority();
        if (n < 63) {
            bNetworkPriority = BNetworkPriority.lifeSafety;
        } else if (n < 127) {
            bNetworkPriority = BNetworkPriority.criticalEquipment;
        } else if (n < 191) {
            bNetworkPriority = BNetworkPriority.urgent;
        }
        this.debugSend(bBacnetAddress, confirmedEventNotificationRequest);
        BacnetSimpleAck bacnetSimpleAck = this.transport().sendConfirmedRequestSimple(confirmedEventNotificationRequest, bBacnetAddress, bNetworkPriority);
        this.debugReceive(bBacnetAddress, bacnetSimpleAck);
    }

    public Vector getAlarmSummary(BBacnetAddress bBacnetAddress) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.getAlarmSummary()");
        }
        GetAlarmSummaryRequest getAlarmSummaryRequest = new GetAlarmSummaryRequest();
        this.debugSend(bBacnetAddress, getAlarmSummaryRequest);
        GetAlarmSummaryAck getAlarmSummaryAck = (GetAlarmSummaryAck)this.transport().sendConfirmedRequestComplex(getAlarmSummaryRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, getAlarmSummaryAck);
        return getAlarmSummaryAck.getListOfAlarmSummaries();
    }

    public Vector getEnrollmentSummary(BBacnetAddress bBacnetAddress, int n, BBacnetRecipientProcess bBacnetRecipientProcess, int n2, BEnum bEnum, int[] nArray, long l) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.getEnrollmentSummary(" + n + ';' + bBacnetRecipientProcess + ';' + n2 + ';' + bEnum + ';' + nArray + ';' + l + ')');
        }
        GetEnrollmentSummaryRequest getEnrollmentSummaryRequest = new GetEnrollmentSummaryRequest(n, bBacnetRecipientProcess, n2, bEnum, nArray, l);
        this.debugSend(bBacnetAddress, getEnrollmentSummaryRequest);
        GetEnrollmentSummaryAck getEnrollmentSummaryAck = (GetEnrollmentSummaryAck)this.transport().sendConfirmedRequestComplex(getEnrollmentSummaryRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, getEnrollmentSummaryAck);
        return getEnrollmentSummaryAck.getListOfEnrollmentSummaries();
    }

    public Vector getEventInformation(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.getEventInformation(" + (Object)((Object)bBacnetObjectIdentifier) + ')');
        }
        GetEventInformationRequest getEventInformationRequest = new GetEventInformationRequest(bBacnetObjectIdentifier);
        this.debugSend(bBacnetAddress, getEventInformationRequest);
        GetEventInformationAck getEventInformationAck = (GetEventInformationAck)this.transport().sendConfirmedRequestComplex(getEventInformationRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, getEventInformationAck);
        if (getEventInformationAck.isMoreEvents()) {
            boolean bl = true;
            Vector<NEventSummary> vector = new Vector<NEventSummary>();
            BBacnetObjectIdentifier bBacnetObjectIdentifier2 = null;
            while (bl && getEventInformationAck != null) {
                ListIterator listIterator = getEventInformationAck.getEventSummaries();
                while (listIterator.hasNext()) {
                    NEventSummary nEventSummary = (NEventSummary)listIterator.next();
                    vector.addElement(nEventSummary);
                    bBacnetObjectIdentifier2 = nEventSummary.getObjectId();
                }
                getEventInformationRequest.setLastReceivedObjectId(bBacnetObjectIdentifier2);
                this.debugSend(bBacnetAddress, getEventInformationRequest);
                getEventInformationAck = (GetEventInformationAck)this.transport().sendConfirmedRequestComplex(getEventInformationRequest, bBacnetAddress, BNetworkPriority.normal);
                this.debugReceive(bBacnetAddress, getEventInformationAck);
                if (getEventInformationAck == null) continue;
                bl = getEventInformationAck.isMoreEvents();
            }
            return vector;
        }
        return getEventInformationAck.getListOfEventSummaries();
    }

    public void subscribeCov(BBacnetAddress bBacnetAddress, long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, boolean bl, long l2) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        SubscribeCovRequest subscribeCovRequest = new SubscribeCovRequest(l, bBacnetObjectIdentifier, bl, l2);
        this.debugSend(bBacnetAddress, subscribeCovRequest);
        BacnetSimpleAck bacnetSimpleAck = this.transport().sendConfirmedRequestSimple(subscribeCovRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetSimpleAck);
    }

    public void unsubscribeCov(BBacnetAddress bBacnetAddress, long l, BBacnetObjectIdentifier bBacnetObjectIdentifier) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        SubscribeCovRequest subscribeCovRequest = new SubscribeCovRequest(l, bBacnetObjectIdentifier);
        this.debugSend(bBacnetAddress, subscribeCovRequest);
        BacnetSimpleAck bacnetSimpleAck = this.transport().sendConfirmedRequestSimple(subscribeCovRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetSimpleAck);
    }

    public void subscribeCovProperty(BBacnetAddress bBacnetAddress, long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, boolean bl, long l2, PropertyReference propertyReference, BDouble bDouble) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        SubscribeCovPropertyRequest subscribeCovPropertyRequest = new SubscribeCovPropertyRequest(l, bBacnetObjectIdentifier, bl, l2, propertyReference, bDouble);
        this.debugSend(bBacnetAddress, subscribeCovPropertyRequest);
        BacnetSimpleAck bacnetSimpleAck = this.transport().sendConfirmedRequestSimple(subscribeCovPropertyRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetSimpleAck);
    }

    public void unsubscribeCovProperty(BBacnetAddress bBacnetAddress, long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, PropertyReference propertyReference) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        SubscribeCovPropertyRequest subscribeCovPropertyRequest = new SubscribeCovPropertyRequest(l, bBacnetObjectIdentifier, propertyReference);
        this.debugSend(bBacnetAddress, subscribeCovPropertyRequest);
        BacnetSimpleAck bacnetSimpleAck = this.transport().sendConfirmedRequestSimple(subscribeCovPropertyRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetSimpleAck);
    }

    public FileData atomicReadFileStream(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, long l) throws BacnetException {
        return this.atomicReadFile(bBacnetAddress, bBacnetObjectIdentifier, 0, n, l);
    }

    public FileData atomicReadFile(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, long l) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("Read " + l + " bytes from File " + (Object)((Object)bBacnetObjectIdentifier) + ", starting at " + n2);
        }
        AtomicReadFileRequest atomicReadFileRequest = new AtomicReadFileRequest(n, bBacnetObjectIdentifier, n2, l);
        this.debugSend(bBacnetAddress, atomicReadFileRequest);
        BacnetComplexAck bacnetComplexAck = this.transport().sendConfirmedRequestComplex(atomicReadFileRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetComplexAck);
        AtomicReadFileAck atomicReadFileAck = (AtomicReadFileAck)bacnetComplexAck;
        if (log.isTraceOn()) {
            if (n == 0) {
                log.trace("Read File data size:" + atomicReadFileAck.getFileData().length);
            } else {
                log.trace("Read File record count:" + atomicReadFileAck.getFileRecordData().length);
            }
        }
        return atomicReadFileAck;
    }

    public int atomicWriteFileRecord(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, long l, BBacnetOctetString[] bBacnetOctetStringArray) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("Write " + bBacnetOctetStringArray.length + " records to File " + (Object)((Object)bBacnetObjectIdentifier) + ", starting at record " + n);
        }
        AtomicWriteFileRequest atomicWriteFileRequest = new AtomicWriteFileRequest(bBacnetObjectIdentifier, n, l, bBacnetOctetStringArray);
        this.debugSend(bBacnetAddress, atomicWriteFileRequest);
        BacnetComplexAck bacnetComplexAck = this.transport().sendConfirmedRequestComplex(atomicWriteFileRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetComplexAck);
        AtomicWriteFileAck atomicWriteFileAck = (AtomicWriteFileAck)bacnetComplexAck;
        if (log.isTraceOn()) {
            log.trace("Write File ok: start record=" + atomicWriteFileAck.getFileStart());
        }
        return atomicWriteFileAck.getFileStart();
    }

    public int atomicWriteFileStream(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, byte[] byArray) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        AtomicWriteFileRequest atomicWriteFileRequest = new AtomicWriteFileRequest(bBacnetObjectIdentifier, n, byArray);
        if (log.isTraceOn()) {
            log.trace("Write " + byArray.length + " bytes to File " + (Object)((Object)bBacnetObjectIdentifier) + ", starting at " + n);
        }
        this.debugSend(bBacnetAddress, atomicWriteFileRequest);
        BacnetComplexAck bacnetComplexAck = this.transport().sendConfirmedRequestComplex(atomicWriteFileRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetComplexAck);
        AtomicWriteFileAck atomicWriteFileAck = (AtomicWriteFileAck)bacnetComplexAck;
        if (log.isTraceOn()) {
            log.trace("Write File ok: start position=" + atomicWriteFileAck.getFileStart());
        }
        return atomicWriteFileAck.getFileStart();
    }

    public void addListElement(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, byte[] byArray) throws BacnetException {
        this.addListElement(bBacnetAddress, bBacnetObjectIdentifier, n, -1, byArray);
    }

    public void addListElement(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, byte[] byArray) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.addListElement(" + (Object)((Object)bBacnetObjectIdentifier) + ';' + n + ';' + n2 + ')');
        }
        AddListElementRequest addListElementRequest = new AddListElementRequest(bBacnetObjectIdentifier, n, n2, byArray);
        this.debugSend(bBacnetAddress, addListElementRequest);
        BacnetSimpleAck bacnetSimpleAck = this.transport().sendConfirmedRequestSimple(addListElementRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetSimpleAck);
    }

    public void removeListElement(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, byte[] byArray) throws BacnetException {
        this.removeListElement(bBacnetAddress, bBacnetObjectIdentifier, n, -1, byArray);
    }

    public void removeListElement(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, byte[] byArray) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.removeListElement(" + (Object)((Object)bBacnetObjectIdentifier) + ';' + n + ';' + n2 + ')');
        }
        RemoveListElementRequest removeListElementRequest = new RemoveListElementRequest(bBacnetObjectIdentifier, n, n2, byArray);
        this.debugSend(bBacnetAddress, removeListElementRequest);
        BacnetSimpleAck bacnetSimpleAck = this.transport().sendConfirmedRequestSimple(removeListElementRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetSimpleAck);
    }

    public BBacnetObjectIdentifier createObject(BBacnetAddress bBacnetAddress, int n, Array array) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.createObject(" + n + ')');
        }
        CreateObjectRequest createObjectRequest = new CreateObjectRequest(n, array);
        this.debugSend(bBacnetAddress, createObjectRequest);
        BacnetComplexAck bacnetComplexAck = this.transport().sendConfirmedRequestComplex(createObjectRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetComplexAck);
        if (log.isTraceOn()) {
            log.trace("  response = " + bacnetComplexAck);
        }
        return ((CreateObjectAck)bacnetComplexAck).getObjectId();
    }

    public BBacnetObjectIdentifier createObject(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, Array array) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.createObject(" + (Object)((Object)bBacnetObjectIdentifier) + ')');
        }
        CreateObjectRequest createObjectRequest = new CreateObjectRequest(bBacnetObjectIdentifier, array);
        this.debugSend(bBacnetAddress, createObjectRequest);
        BacnetComplexAck bacnetComplexAck = this.transport().sendConfirmedRequestComplex(createObjectRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetComplexAck);
        if (log.isTraceOn()) {
            log.trace("  response = " + bacnetComplexAck);
        }
        return ((CreateObjectAck)bacnetComplexAck).getObjectId();
    }

    public void deleteObject(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.deleteObject(" + (Object)((Object)bBacnetObjectIdentifier) + ')');
        }
        DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(bBacnetObjectIdentifier);
        this.debugSend(bBacnetAddress, deleteObjectRequest);
        BacnetSimpleAck bacnetSimpleAck = this.transport().sendConfirmedRequestSimple(deleteObjectRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetSimpleAck);
        if (log.isTraceOn()) {
            log.trace(bacnetSimpleAck == null ? "  >>>> FAILED!" : "  ---- OK!");
        }
    }

    public byte[] readProperty(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n) throws BacnetException {
        return this.readProperty(bBacnetAddress, bBacnetObjectIdentifier, n, -1);
    }

    public byte[] readProperty(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.readProperty(" + bBacnetAddress + ';' + (Object)((Object)bBacnetObjectIdentifier) + ';' + n + ';' + n2 + ')');
        }
        ReadPropertyRequest readPropertyRequest = new ReadPropertyRequest(bBacnetObjectIdentifier, n, n2);
        this.debugSend(bBacnetAddress, readPropertyRequest);
        BacnetComplexAck bacnetComplexAck = this.transport().sendConfirmedRequestComplex(readPropertyRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetComplexAck);
        if (log.isTraceOn()) {
            log.trace("  response = " + bacnetComplexAck);
        }
        return ((ReadPropertyAck)bacnetComplexAck).getEncodedValue();
    }

    public Vector readPropertyMultiple(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, Vector vector) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        log.trace("BacnetClientLayer.readPropertyMultiple() addr=" + bBacnetAddress);
        ReadPropertyMultipleRequest readPropertyMultipleRequest = new ReadPropertyMultipleRequest(new NReadAccessSpec(bBacnetObjectIdentifier, vector));
        this.debugSend(bBacnetAddress, readPropertyMultipleRequest);
        ReadPropertyMultipleAck readPropertyMultipleAck = (ReadPropertyMultipleAck)this.transport().sendConfirmedRequestComplex(readPropertyMultipleRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, readPropertyMultipleAck);
        if (log.isTraceOn()) {
            log.trace("  response = " + readPropertyMultipleAck);
        }
        NReadAccessResult nReadAccessResult = (NReadAccessResult)readPropertyMultipleAck.getListOfReadAccessResults().elementAt(0);
        return nReadAccessResult.getListOfResults();
    }

    public Vector readPropertyMultiple(BBacnetAddress bBacnetAddress, Vector vector) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        ReadPropertyMultipleRequest readPropertyMultipleRequest = new ReadPropertyMultipleRequest(vector);
        log.trace("BacnetClientLayer.readPropertyMultiple() addr=" + bBacnetAddress);
        this.debugSend(bBacnetAddress, readPropertyMultipleRequest);
        BacnetComplexAck bacnetComplexAck = this.transport().sendConfirmedRequestComplex(readPropertyMultipleRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetComplexAck);
        if (log.isTraceOn()) {
            log.trace("  response = " + bacnetComplexAck);
        }
        ReadPropertyMultipleAck readPropertyMultipleAck = (ReadPropertyMultipleAck)bacnetComplexAck;
        return readPropertyMultipleAck.getListOfReadAccessResults();
    }

    public Iterator readPropertyMultiple(BBacnetAddress bBacnetAddress, Array array) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        ReadPropertyMultipleRequest readPropertyMultipleRequest = new ReadPropertyMultipleRequest(array);
        log.trace("BacnetClientLayer.readPropertyMultiple() addr=" + bBacnetAddress);
        this.debugSend(bBacnetAddress, readPropertyMultipleRequest);
        BacnetComplexAck bacnetComplexAck = this.transport().sendConfirmedRequestComplex(readPropertyMultipleRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetComplexAck);
        if (log.isTraceOn()) {
            log.trace("  response = " + bacnetComplexAck);
        }
        ReadPropertyMultipleAck readPropertyMultipleAck = (ReadPropertyMultipleAck)bacnetComplexAck;
        return readPropertyMultipleAck.getResults();
    }

    public ReadRangeAck readRange(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, int n3, long l, BBacnetDateTime bBacnetDateTime, int n4) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.readRange(" + (Object)((Object)bBacnetObjectIdentifier) + ';' + n + ';' + n2 + ';' + n3 + ';' + l + ';' + bBacnetDateTime + ';' + n4 + ')');
        }
        ReadRangeRequest readRangeRequest = new ReadRangeRequest(bBacnetObjectIdentifier, n, n2, n3, l, bBacnetDateTime, n4);
        this.debugSend(bBacnetAddress, readRangeRequest);
        BacnetComplexAck bacnetComplexAck = this.transport().sendConfirmedRequestComplex(readRangeRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetComplexAck);
        if (log.isTraceOn()) {
            log.trace("  response = " + bacnetComplexAck);
        }
        return (ReadRangeAck)bacnetComplexAck;
    }

    public void writeProperty(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, byte[] byArray) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (n == 87) {
            if (log.isTraceOn()) {
                log.trace("Priority array write converted to present-value@" + n2);
            }
            this.writeProperty(bBacnetAddress, bBacnetObjectIdentifier, 85, -1, byArray, n2);
        } else {
            this.writeProperty(bBacnetAddress, bBacnetObjectIdentifier, n, n2, byArray, -1);
        }
    }

    public void writeProperty(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, byte[] byArray) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        this.writeProperty(bBacnetAddress, bBacnetObjectIdentifier, n, -1, byArray, -1);
    }

    public void writeProperty(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, byte[] byArray, int n3) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.writeProperty(" + (Object)((Object)bBacnetObjectIdentifier) + ';' + n + '[' + n2 + "]@" + n3 + "): encodedValue=" + ByteArrayUtil.toHexString((byte[])byArray));
        }
        WritePropertyRequest writePropertyRequest = new WritePropertyRequest(bBacnetObjectIdentifier, n, n2, byArray, n3);
        this.debugSend(bBacnetAddress, writePropertyRequest);
        BacnetSimpleAck bacnetSimpleAck = this.transport().sendConfirmedRequestSimple(writePropertyRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetSimpleAck);
        if (log.isTraceOn()) {
            log.trace(bacnetSimpleAck == null ? "  >>>> FAILED!" : "  ---- OK!");
        }
    }

    public void writePropertyMultiple(BBacnetAddress bBacnetAddress, Vector vector) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        log.trace("BacnetClientLayer.writePropertyMultiple");
        WritePropertyMultipleRequest writePropertyMultipleRequest = new WritePropertyMultipleRequest(vector);
        this.debugSend(bBacnetAddress, writePropertyMultipleRequest);
        BacnetSimpleAck bacnetSimpleAck = this.transport().sendConfirmedRequestSimple(writePropertyMultipleRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetSimpleAck);
        if (log.isTraceOn()) {
            log.trace(bacnetSimpleAck == null ? "  >>>> FAILED!" : "  ---- OK!");
        }
    }

    public void deviceCommunicationControl(BBacnetAddress bBacnetAddress, BBacnetCommControl bBacnetCommControl, BRelTime bRelTime, String string, BCharacterSetEncoding bCharacterSetEncoding) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.deviceCommunicationControl(" + (Object)((Object)bBacnetCommControl) + "; " + bRelTime + "; " + string + "; " + (Object)((Object)bCharacterSetEncoding) + ')');
        }
        DeviceCommunicationControlRequest deviceCommunicationControlRequest = new DeviceCommunicationControlRequest(bRelTime, bBacnetCommControl, string, bCharacterSetEncoding);
        this.debugSend(bBacnetAddress, deviceCommunicationControlRequest);
        BacnetSimpleAck bacnetSimpleAck = this.transport().sendConfirmedRequestSimple(deviceCommunicationControlRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetSimpleAck);
    }

    public byte[] confirmedPrivateTransfer(BBacnetAddress bBacnetAddress, int n, int n2, byte[] byArray) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.confirmedPrivateTransfer(" + n + ';' + n2 + ':' + ByteArrayUtil.toHexString((byte[])byArray));
        }
        ConfirmedPrivateTransferRequest confirmedPrivateTransferRequest = new ConfirmedPrivateTransferRequest(n, n2, byArray);
        this.debugSend(bBacnetAddress, confirmedPrivateTransferRequest);
        BacnetComplexAck bacnetComplexAck = this.transport().sendConfirmedRequestComplex(confirmedPrivateTransferRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetComplexAck);
        if (log.isTraceOn()) {
            log.trace("  response = " + bacnetComplexAck);
        }
        return ((ConfirmedPrivateTransferAck)bacnetComplexAck).getResultBlock();
    }

    public void reinitializeDevice(BBacnetAddress bBacnetAddress, BBacnetReinitializedDeviceState bBacnetReinitializedDeviceState, String string, BCharacterSetEncoding bCharacterSetEncoding) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.reinitializeDevice(" + (Object)((Object)bBacnetReinitializedDeviceState) + "; " + string + "; " + (Object)((Object)bCharacterSetEncoding) + ')');
        }
        ReinitializeDeviceRequest reinitializeDeviceRequest = new ReinitializeDeviceRequest(bBacnetReinitializedDeviceState, string, bCharacterSetEncoding);
        this.debugSend(bBacnetAddress, reinitializeDeviceRequest);
        BacnetSimpleAck bacnetSimpleAck = this.transport().sendConfirmedRequestSimple(reinitializeDeviceRequest, bBacnetAddress, BNetworkPriority.normal);
        this.debugReceive(bBacnetAddress, bacnetSimpleAck);
    }

    public void unconfirmedCovNotification(BBacnetAddress bBacnetAddress, CovNotificationParameters covNotificationParameters) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        UnconfirmedCovNotificationRequest unconfirmedCovNotificationRequest = new UnconfirmedCovNotificationRequest(covNotificationParameters);
        this.debugSend(bBacnetAddress, unconfirmedCovNotificationRequest);
        this.transport().sendUnconfirmedRequest(unconfirmedCovNotificationRequest, bBacnetAddress, BNetworkPriority.normal);
    }

    public void unconfirmedEventNotification(BBacnetAddress bBacnetAddress, EventNotificationParameters eventNotificationParameters) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.unconfirmedEventNotification(" + bBacnetAddress + ");enp=" + eventNotificationParameters);
        }
        UnconfirmedEventNotificationRequest unconfirmedEventNotificationRequest = new UnconfirmedEventNotificationRequest(eventNotificationParameters);
        BNetworkPriority bNetworkPriority = BNetworkPriority.normal;
        int n = eventNotificationParameters.getPriority();
        if (n < 63) {
            bNetworkPriority = BNetworkPriority.lifeSafety;
        } else if (n < 127) {
            bNetworkPriority = BNetworkPriority.criticalEquipment;
        } else if (n < 191) {
            bNetworkPriority = BNetworkPriority.urgent;
        }
        this.debugSend(bBacnetAddress, unconfirmedEventNotificationRequest);
        this.transport().sendUnconfirmedRequest(unconfirmedEventNotificationRequest, bBacnetAddress, bNetworkPriority);
    }

    public void unconfirmedPrivateTransfer(BBacnetAddress bBacnetAddress, int n, int n2, byte[] byArray) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.unconfirmedPrivateTransfer(" + n + ';' + n2 + ':' + ByteArrayUtil.toHexString((byte[])byArray));
        }
        UnconfirmedPrivateTransferRequest unconfirmedPrivateTransferRequest = new UnconfirmedPrivateTransferRequest(n, n2, byArray);
        this.debugSend(bBacnetAddress, unconfirmedPrivateTransferRequest);
        this.transport().sendUnconfirmedRequest(unconfirmedPrivateTransferRequest, bBacnetAddress, BNetworkPriority.normal);
    }

    public void timeSynch(BBacnetRecipient bBacnetRecipient) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.timeSynch(" + bBacnetRecipient + ')');
        }
        TimeSynchronizationRequest timeSynchronizationRequest = new TimeSynchronizationRequest(Clock.time((int)10));
        BBacnetAddress bBacnetAddress = null;
        bBacnetAddress = bBacnetRecipient.isDevice() ? DeviceRegistry.getDeviceAddress(bBacnetRecipient.getDevice()) : bBacnetRecipient.getAddress();
        this.debugSend(bBacnetAddress, timeSynchronizationRequest);
        this.transport().sendUnconfirmedRequest(timeSynchronizationRequest, bBacnetAddress, BNetworkPriority.normal);
    }

    public void whoHas(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        WhoHasRequest whoHasRequest = new WhoHasRequest(bBacnetObjectIdentifier);
        this.debugSend(bBacnetAddress, whoHasRequest);
        this.transport().sendUnconfirmedRequest(whoHasRequest, bBacnetAddress, BNetworkPriority.normal);
    }

    public void whoHas(BBacnetAddress bBacnetAddress, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        WhoHasRequest whoHasRequest = new WhoHasRequest(n, n2, bBacnetObjectIdentifier);
        this.debugSend(bBacnetAddress, whoHasRequest);
        this.transport().sendUnconfirmedRequest(whoHasRequest, bBacnetAddress, BNetworkPriority.normal);
    }

    public void whoHas(BBacnetAddress bBacnetAddress, String string, BCharacterSetEncoding bCharacterSetEncoding) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.whoHas(" + string + ") to " + bBacnetAddress);
        }
        WhoHasRequest whoHasRequest = new WhoHasRequest(string, bCharacterSetEncoding);
        this.debugSend(bBacnetAddress, whoHasRequest);
        this.transport().sendUnconfirmedRequest(whoHasRequest, bBacnetAddress, BNetworkPriority.normal);
    }

    public void whoHas(BBacnetAddress bBacnetAddress, String string, BCharacterSetEncoding bCharacterSetEncoding, int n, int n2) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        WhoHasRequest whoHasRequest = new WhoHasRequest(n, n2, string, bCharacterSetEncoding);
        this.debugSend(bBacnetAddress, whoHasRequest);
        this.transport().sendUnconfirmedRequest(whoHasRequest, bBacnetAddress, BNetworkPriority.normal);
    }

    public void whoIs(BBacnetAddress bBacnetAddress) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.whoIs()");
        }
        WhoIsRequest whoIsRequest = new WhoIsRequest();
        this.debugSend(bBacnetAddress, whoIsRequest);
        this.transport().sendUnconfirmedRequest(whoIsRequest, bBacnetAddress, BNetworkPriority.normal);
    }

    public void whoIs(BBacnetAddress bBacnetAddress, int n, int n2) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.whoIs(" + n + " - " + n2 + ')');
        }
        WhoIsRequest whoIsRequest = new WhoIsRequest(n, n2);
        this.debugSend(bBacnetAddress, whoIsRequest);
        this.transport().sendUnconfirmedRequest(whoIsRequest, bBacnetAddress, BNetworkPriority.normal);
    }

    public void utcTimeSynch(BBacnetRecipient bBacnetRecipient) throws BacnetException {
        if (!this.stack().isCommInitiationEnabled()) {
            throw new BacnetStackException("Stack Disabled");
        }
        if (log.isTraceOn()) {
            log.trace("BacnetClientLayer.utcTimeSynch(" + bBacnetRecipient + ')');
        }
        BAbsTime bAbsTime = BAbsTime.make();
        BRelTime bRelTime = BRelTime.make((long)bAbsTime.getTimeZoneOffset());
        UtcTimeSynchronizationRequest utcTimeSynchronizationRequest = new UtcTimeSynchronizationRequest(bAbsTime.subtract(bRelTime));
        BBacnetAddress bBacnetAddress = null;
        bBacnetAddress = bBacnetRecipient.isDevice() ? DeviceRegistry.getDeviceAddress(bBacnetRecipient.getDevice()) : bBacnetRecipient.getAddress();
        this.debugSend(bBacnetAddress, utcTimeSynchronizationRequest);
        this.transport().sendUnconfirmedRequest(utcTimeSynchronizationRequest, bBacnetAddress, BNetworkPriority.normal);
    }

    private final BBacnetTransportLayer transport() {
        return ((BBacnetStack)this.getParent()).getTransport();
    }

    public final BBacnetStack stack() {
        return (BBacnetStack)this.getParent();
    }

    public void addDebugListener(AppDebugListener appDebugListener) {
        this.debugListeners.add(appDebugListener);
    }

    public void removeDebugListener(AppDebugListener appDebugListener) {
        this.debugListeners.remove(appDebugListener);
    }

    private final void debugSend(BBacnetAddress bBacnetAddress, BacnetServicePrimitive bacnetServicePrimitive) {
        int n = this.debugListeners.size();
        int n2 = 0;
        while (n2 < n) {
            ((AppDebugListener)this.debugListeners.get(n2)).send(bBacnetAddress, bacnetServicePrimitive);
            ++n2;
        }
    }

    private final void debugReceive(BBacnetAddress bBacnetAddress, BacnetServicePrimitive bacnetServicePrimitive) {
        int n = this.debugListeners.size();
        int n2 = 0;
        while (n2 < n) {
            ((AppDebugListener)this.debugListeners.get(n2)).receive(bBacnetAddress, bacnetServicePrimitive);
            ++n2;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.debugListeners = new Vector();
    }

    public BBacnetClientLayer() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$stack$client$BBacnetClientLayer;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$client$BBacnetClientLayer = BBacnetClientLayer.class("[Lcom.tridium.bacnet.stack.client.BBacnetClientLayer;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"bacnet.client");
    }
}

