/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.client;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.BacnetNotificationParameters;
import com.tridium.bacnet.asn.EventNotificationParameters;
import com.tridium.bacnet.asn.NBacnetPropertyReference;
import com.tridium.bacnet.asn.NBacnetPropertyStates;
import com.tridium.bacnet.asn.notificationParameters.BufferReady;
import com.tridium.bacnet.asn.notificationParameters.ChangeOfState;
import com.tridium.bacnet.asn.notificationParameters.CommandFailure;
import com.tridium.bacnet.asn.notificationParameters.FloatingLimit;
import com.tridium.bacnet.asn.notificationParameters.OutOfRange;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.DeviceRegistry;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetAlarmConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetRecipient;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.enums.BBacnetBinaryPv;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.export.BBacnetEventSource;
import javax.baja.bacnet.export.BBacnetNotificationClassDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AsyncEventNotificationRequest
implements Runnable,
BacnetAlarmConst {
    private BAlarmRecord alarm;
    private BComponent eventObject;
    private long processId;
    private BBacnetRecipient recipient;
    private boolean useConfirmed;
    private boolean ackAlarmAndNormal;
    private BBacnetEventSource eventSrc;
    private BFacets alarmData;
    private BBacnetAddress address;
    private BLocalBacnetDevice local;
    private BAlarmService alarmService;
    private BBacnetObjectIdentifier eventObjectId;
    private BEnum toState;
    private BEnum fromState;
    private BEnum offnormalToState;

    public void run() {
        EventNotificationParameters eventNotificationParameters = null;
        try {
            this.alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            boolean bl = Log.getLog((String)"bacnet.server").isTraceOn();
            BOrd bOrd = this.eventObject.getOrdInSession();
            this.eventObjectId = this.local.lookupBacnetObjectId(bOrd);
            if (this.eventObjectId == null) {
                Log.getLog((String)"bacnet.server").warning("Alarm " + this.alarm.getUuid() + " not sent to " + this.recipient + ": object " + this.eventObject.getName() + " not exposed to BACnet!");
                return;
            }
            if (this.alarm.getSourceState() == BSourceState.alert) {
                Log.getLog((String)"bacnet.server").warning(" Alarm " + this.alarm.getUuid() + " not sent to " + this.recipient + ": incorrect alarm state " + this.alarm.getSourceState() + '/' + this.alarm.getAckState());
                return;
            }
            try {
                this.eventSrc = (BBacnetEventSource)this.local.lookupBacnetObject(this.eventObjectId);
            }
            catch (ClassCastException classCastException) {
                Log.getLog((String)"bacnet.server").warning(" Alarm " + this.alarm.getUuid() + " not sent to " + this.recipient + ": eventObjectId not a BacnetEventSource!");
                return;
            }
            if (this.eventSrc == null) {
                Log.getLog((String)"bacnet.server").warning("Alarm " + this.alarm.getUuid() + " not sent to " + this.recipient + ": object " + this.eventObject.getName() + " not exposed to BACnet!");
                return;
            }
            BObject bObject = this.alarm.getSource().get(0).get((BObject)this.eventObject);
            if (!this.eventSrc.isValidAlarmExt((BIAlarmSource)bObject)) {
                Log.getLog((String)"bacnet.server").warning(" Alarm " + this.alarm.getUuid() + " not sent to " + this.recipient + ": incorrect alarm algorithm for exported BACnet point!");
                return;
            }
            BBacnetNotificationClassDescriptor bBacnetNotificationClassDescriptor = this.eventSrc.getNotificationClass();
            if (bBacnetNotificationClassDescriptor == null) {
                Log.getLog((String)"bacnet.server").warning(" Alarm " + this.alarm.getUuid() + " not sent to " + this.recipient + ": object " + this.eventObject.getName() + " is using non-BACnet alarm class " + this.alarm.getAlarmClass() + '!');
                return;
            }
            long l = bBacnetNotificationClassDescriptor.getNotificationClass();
            BBacnetNetwork bBacnetNetwork = BBacnetNetwork.bacnet();
            this.address = this.recipient.getChoice() == 0 ? DeviceRegistry.getDeviceAddress(this.recipient.getDevice()) : this.recipient.getAddress();
            if (this.address == null) {
                Log.getLog((String)"bacnet.server").warning(" Alarm " + this.alarm.getUuid() + " not sent to " + this.recipient + ": address is unknown");
                return;
            }
            EventNotificationParameters eventNotificationParameters2 = this.buildEventNotificationParameters(l);
            if (this.alarm.getAckState() == BAckState.acked) {
                if (bl) {
                    System.out.println("AsEvtNot(" + this.recipient + "): BAC_STATE_ACKED=" + this.alarm.getAlarmFacet("stateAcked") + ", removing to prevent re-use...");
                }
                this.alarm.removeAlarmFacet("stateAcked");
                if (this.ackAlarmAndNormal) {
                    Object object = eventNotificationParameters2.getToState();
                    int n = eventNotificationParameters2.getPriority();
                    BInteger bInteger = (BInteger)this.alarmData.getFacet("offnormalToState");
                    if (bInteger != null) {
                        object = BBacnetEventState.make(bInteger.getInt());
                    }
                    if (BBacnetEventState.isNormal(object)) {
                        BInteger bInteger2 = (BInteger)this.alarmData.getFacet("normalPriority");
                        if (bInteger2 != null) {
                            n = bInteger2.getInt();
                        }
                    } else if (BBacnetEventState.isFault(object)) {
                        BInteger bInteger3 = (BInteger)this.alarmData.getFacet("faultPriority");
                        if (bInteger3 != null) {
                            n = bInteger3.getInt();
                        }
                    } else {
                        BInteger bInteger4 = (BInteger)this.alarmData.getFacet("offnormalPriority");
                        if (bInteger4 != null) {
                            n = bInteger4.getInt();
                        }
                    }
                    eventNotificationParameters = new EventNotificationParameters(eventNotificationParameters2.getProcessId(), eventNotificationParameters2.getInitiatingDeviceId(), eventNotificationParameters2.getEventObjectId(), (BBacnetTimeStamp)eventNotificationParameters2.getTimeStamp().newCopy(), eventNotificationParameters2.getNotificationClass(), n, eventNotificationParameters2.getEventType(), eventNotificationParameters2.getMessageText(), eventNotificationParameters2.getNotifyType(), eventNotificationParameters2.getAckRequired(), eventNotificationParameters2.getFromState(), (BEnum)object, BacnetNotificationParameters.make(eventNotificationParameters2.getEventValues()), eventNotificationParameters2.getEncoding());
                }
                try {
                    if (this.alarmService.getAlarmDb().getRecord(this.alarm.getUuid()) == null) {
                        this.alarmService.getAlarmDb().append(this.alarm);
                    } else {
                        this.alarmService.getAlarmDb().update(this.alarm);
                    }
                }
                catch (Exception exception) {
                    Log.getLog((String)"bacnet.server").warning("Cannot update alarm " + this.alarm.getUuid(), (Throwable)exception);
                }
            }
            if (bl) {
                Log.getLog((String)"bacnet.server").trace("Sending BACnet event notification to " + this.address);
            }
            if (this.useConfirmed) {
                ((BBacnetStack)bBacnetNetwork.getBacnetComm()).getClient().confirmedEventNotification(this.address, eventNotificationParameters2);
            } else {
                ((BBacnetStack)bBacnetNetwork.getBacnetComm()).getClient().unconfirmedEventNotification(this.address, eventNotificationParameters2);
            }
            if (eventNotificationParameters != null) {
                if (bl) {
                    Log.getLog((String)"bacnet.server").trace("Sending BACnet event notification(2) to " + this.address);
                }
                if (this.useConfirmed) {
                    ((BBacnetStack)bBacnetNetwork.getBacnetComm()).getClient().confirmedEventNotification(this.address, eventNotificationParameters);
                } else {
                    ((BBacnetStack)bBacnetNetwork.getBacnetComm()).getClient().unconfirmedEventNotification(this.address, eventNotificationParameters);
                }
            }
        }
        catch (BacnetException bacnetException) {
            Log.getLog((String)"bacnet.server").error("BacnetException sending Event Notification: " + (Object)((Object)bacnetException), (Throwable)((Object)bacnetException));
        }
        catch (Exception exception) {
            Log.getLog((String)"bacnet.server").error("Unable to send event notification to Bacnet!", (Throwable)exception);
        }
    }

    private final EventNotificationParameters buildEventNotificationParameters(long l) throws Exception {
        BInteger bInteger;
        Object object;
        BBacnetObjectIdentifier bBacnetObjectIdentifier = this.local.getObjectId();
        BBacnetNotifyType bBacnetNotifyType = this.getNotifyType();
        this.toState = this.parseToState();
        this.fromState = this.parseFromState(this.toState);
        int n = this.alarm.getPriority();
        BEnum bEnum = this.parseEventType();
        boolean bl = this.getAckRequired(this.toState);
        BBacnetTimeStamp bBacnetTimeStamp = null;
        String string = null;
        BacnetNotificationParameters bacnetNotificationParameters = null;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        this.offnormalToState = null;
        if (bBacnetNotifyType.getOrdinal() == 2) {
            object = this.alarm.getAckTime();
            if (object.equals((Object)BAbsTime.NULL)) {
                object = BAbsTime.now();
            }
            bBacnetTimeStamp = new BBacnetTimeStamp((BAbsTime)object);
            this.fromState = null;
            bInteger = (BInteger)this.alarmData.getFacet("stateAcked");
            if (bInteger != null) {
                BInteger bInteger2;
                this.toState = BBacnetEventState.make(bInteger.getInt());
                if (BBacnetEventState.isNormal(this.toState)) {
                    bInteger2 = (BInteger)this.alarmData.getFacet("normalPriority");
                    if (bInteger2 != null) {
                        n = bInteger2.getInt();
                    }
                } else if (BBacnetEventState.isFault(this.toState)) {
                    bInteger2 = (BInteger)this.alarmData.getFacet("faultPriority");
                    if (bInteger2 != null) {
                        n = bInteger2.getInt();
                    }
                } else {
                    bInteger2 = (BInteger)this.alarmData.getFacet("offnormalPriority");
                    if (bInteger2 != null) {
                        n = bInteger2.getInt();
                    }
                }
            }
        } else {
            switch (this.toState.getOrdinal()) {
                case 0: {
                    n2 = n;
                    break;
                }
                case 1: {
                    n3 = n;
                    this.offnormalToState = this.toState;
                    break;
                }
                default: {
                    n4 = n;
                    this.offnormalToState = this.toState;
                }
            }
            bBacnetTimeStamp = this.alarm.getSourceState() == BSourceState.normal ? new BBacnetTimeStamp(this.alarm.getNormalTime()) : new BBacnetTimeStamp(this.alarm.getTimestamp());
            string = ((BString)this.alarmData.getFacet("msgText")).getString();
            bacnetNotificationParameters = this.buildEventValues(bEnum);
        }
        object = this.local.getCharacterSet();
        bInteger = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        if (this.offnormalToState != null) {
            this.alarm.addAlarmFacet("offnormalToState", (BIDataValue)BInteger.make((int)this.offnormalToState.getOrdinal()));
        }
        if (n2 >= 0) {
            this.alarm.addAlarmFacet("normalPriority", (BIDataValue)BInteger.make((int)n2));
        }
        if (n3 >= 0) {
            this.alarm.addAlarmFacet("faultPriority", (BIDataValue)BInteger.make((int)n3));
        }
        if (n4 >= 0) {
            this.alarm.addAlarmFacet("offnormalPriority", (BIDataValue)BInteger.make((int)n4));
        }
        this.alarm.setLastUpdate(BAbsTime.now());
        try {
            if (bInteger.getAlarmDb().getRecord(this.alarm.getUuid()) == null) {
                bInteger.getAlarmDb().append(this.alarm);
            } else {
                bInteger.getAlarmDb().update(this.alarm);
            }
        }
        catch (Exception exception) {
            Log.getLog((String)"bacnet.server").warning("Cannot update alarm with BACnet facets.", (Throwable)exception);
        }
        return new EventNotificationParameters(this.processId, bBacnetObjectIdentifier, this.eventObjectId, bBacnetTimeStamp, l, n, bEnum, string, bBacnetNotifyType, bl, this.fromState, this.toState, bacnetNotificationParameters, (BCharacterSetEncoding)((Object)object));
    }

    private final boolean getAckRequired(BEnum bEnum) {
        BAlarmClass bAlarmClass = this.alarmService.lookupAlarmClass(this.alarm.getAlarmClass());
        BAlarmTransitionBits bAlarmTransitionBits = bAlarmClass.getAckRequired();
        if (BBacnetEventState.isFault(bEnum)) {
            return bAlarmTransitionBits.isToFault();
        }
        if (BBacnetEventState.isNormal(bEnum)) {
            return bAlarmTransitionBits.isToNormal();
        }
        return bAlarmTransitionBits.isToOffnormal();
    }

    private final BEnum parseEventType() {
        BDynamicEnum bDynamicEnum = this.local.getEnumerationList().getEventType();
        switch (this.eventObjectId.getObjectType()) {
            case 0: 
            case 1: 
            case 2: {
                return BBacnetEventType.outOfRange;
            }
            case 3: 
            case 5: 
            case 13: 
            case 19: {
                return BBacnetEventType.changeOfState;
            }
            case 4: 
            case 14: {
                return BBacnetEventType.commandFailure;
            }
            case 12: {
                return BBacnetEventType.floatingLimit;
            }
            case 20: {
                return BBacnetEventType.bufferReady;
            }
        }
        return bDynamicEnum;
    }

    private final BBacnetNotifyType getNotifyType() {
        BInteger bInteger = (BInteger)this.alarm.getAlarmFacet("stateAcked");
        if (bInteger != null) {
            return BBacnetNotifyType.ackNotification;
        }
        BAckState bAckState = this.alarm.getAckState();
        BBacnetNotifyType bBacnetNotifyType = BBacnetNotifyType.alarm;
        BIBacnetExportObject bIBacnetExportObject = this.local.lookupBacnetObject(this.eventObjectId);
        if (bIBacnetExportObject != null && bIBacnetExportObject instanceof BBacnetEventSource) {
            bBacnetNotifyType = ((BBacnetEventSource)bIBacnetExportObject).getNotifyType();
        }
        BAlarmClass bAlarmClass = this.alarmService.lookupAlarmClass(this.alarm.getAlarmClass());
        if (bAckState != BAckState.acked || !bAlarmClass.getAckRequired().includes(this.alarm.getSourceState())) {
            return bBacnetNotifyType;
        }
        return BBacnetNotifyType.ackNotification;
    }

    private final BEnum parseFromState(BEnum bEnum) {
        BInteger bInteger;
        BDynamicEnum bDynamicEnum = this.local.getEnumerationList().getEventState();
        if (bEnum.getOrdinal() == 0 && (bInteger = (BInteger)this.alarmData.getFacet("offnormalToState")) != null) {
            return bDynamicEnum.getRange().get(bInteger.getInt());
        }
        bInteger = (BString)this.alarmData.getFacet("fromState");
        if (bInteger != null) {
            return bDynamicEnum.getRange().get(bDynamicEnum.getRange().tagToOrdinal(bInteger.getString()));
        }
        return null;
    }

    private final BEnum parseToState() {
        BDynamicEnum bDynamicEnum = this.local.getEnumerationList().getEventState();
        BString bString = (BString)this.alarmData.getFacet("toState");
        try {
            if (bString != null) {
                return bDynamicEnum.getRange().get(bDynamicEnum.getRange().tagToOrdinal(bString.getString()));
            }
        }
        catch (InvalidEnumException invalidEnumException) {
            System.out.println("InvalidEnumException parsing toState: Event State " + bString + " not found!");
        }
        return BBacnetEventState.make(this.alarm.getSourceState());
    }

    private final BacnetNotificationParameters buildEventValues(BEnum bEnum) throws Exception {
        BString bString = (BString)this.alarmData.getFacet("presentValue");
        if (bString == null) {
            return null;
        }
        String string = bString.getString();
        boolean bl = false;
        int n = this.eventObjectId.getObjectType();
        BBacnetBitString bBacnetBitString = BacnetBitStringUtil.getBacnetStatusFlags(BStatus.ok);
        if (bEnum.getOrdinal() != 10) {
            PropertyValue propertyValue = this.eventSrc.readProperty(new NBacnetPropertyReference(111));
            if (!propertyValue.isError()) {
                bBacnetBitString = AsnUtil.fromAsnBitString(propertyValue.getPropertyValue());
            } else {
                bl = true;
            }
        }
        switch (bEnum.getOrdinal()) {
            case 1: {
                switch (n) {
                    case 3: 
                    case 5: {
                        return this.getBinaryCOSValues(bString, bBacnetBitString);
                    }
                    case 13: 
                    case 19: {
                        return this.getMultistateCOSValues(bString, bBacnetBitString);
                    }
                }
                throw new IllegalArgumentException("Invalid object type:" + n + " for ChangeOfState event type!");
            }
            case 5: {
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: {
                        return this.getAnalogOORValues(string, bBacnetBitString, this.toState.getOrdinal(), this.fromState.getOrdinal());
                    }
                }
                throw new IllegalArgumentException("Invalid object type:" + n + " for OutOfRange event type!");
            }
            case 3: {
                switch (n) {
                    case 4: {
                        return this.getBinaryCFValues(bString, bBacnetBitString);
                    }
                    case 14: {
                        return this.getMultistateCFValues(string, bBacnetBitString);
                    }
                }
                throw new IllegalArgumentException("Invalid object type:" + n + " for CommandFailure event type!");
            }
            case 4: {
                if (n == 12) {
                    return this.getLoopFLValues(bBacnetBitString, bl);
                }
                throw new IllegalArgumentException("Invalid object type:" + n + " for FloatingLimit event type!");
            }
            case 10: {
                if (n == 20) {
                    return this.getTLogBRValues(string);
                }
                throw new IllegalArgumentException("Invalid object type:" + n + " for BufferReady event type!");
            }
        }
        throw new IllegalArgumentException("Invalid combination: EventType=" + bEnum + "; object type=" + this.eventObjectId.getObjectType() + '!');
    }

    private static final float parseFloat(String string) {
        int n = string.indexOf(" ");
        if (n < 0) {
            return Float.parseFloat(string);
        }
        return Float.parseFloat(string.substring(0, n));
    }

    private final ChangeOfState getBinaryCOSValues(BString bString, BBacnetBitString bBacnetBitString) {
        BBoolean bBoolean;
        NBacnetPropertyStates nBacnetPropertyStates = null;
        BInteger bInteger = (BInteger)this.alarmData.get("numericValue");
        if (bInteger != null) {
            nBacnetPropertyStates = new NBacnetPropertyStates(bInteger.getInt() != 0 ? BBacnetBinaryPv.active : BBacnetBinaryPv.inactive);
        }
        if (nBacnetPropertyStates == null && (bBoolean = (BBoolean)this.alarmData.get("alarmValue")) != null) {
            nBacnetPropertyStates = new NBacnetPropertyStates(bBoolean.getBoolean() ? BBacnetBinaryPv.active : BBacnetBinaryPv.inactive);
        }
        if (nBacnetPropertyStates == null && (bBoolean = (BString)this.eventObject.getSlotFacets((Slot)BBooleanPoint.out).get("trueText")) != null) {
            nBacnetPropertyStates = new NBacnetPropertyStates(bBoolean.equals((Object)bString) ? BBacnetBinaryPv.active : BBacnetBinaryPv.inactive);
        }
        if (nBacnetPropertyStates != null) {
            return new ChangeOfState(nBacnetPropertyStates, bBacnetBitString);
        }
        Log.getLog((String)"bacnet.server").trace("alarmData:" + this.alarmData);
        throw new IllegalArgumentException("Cannot build BACnet COS Event Values for Binary point " + (Object)((Object)this.eventObjectId));
    }

    private final ChangeOfState getMultistateCOSValues(BString bString, BBacnetBitString bBacnetBitString) {
        NBacnetPropertyStates nBacnetPropertyStates = null;
        BInteger bInteger = (BInteger)this.alarmData.get("numericValue");
        if (bInteger != null) {
            nBacnetPropertyStates = new NBacnetPropertyStates(bInteger.getInt());
        }
        if (nBacnetPropertyStates == null) {
            BEnumRange bEnumRange = (BEnumRange)this.eventObject.getSlotFacets((Slot)BEnumPoint.out).get("range");
            BString bString2 = (BString)this.alarmData.get("alarmValue");
            if (bString2 != null && bEnumRange != null && bEnumRange.isTag(bString2.getString())) {
                nBacnetPropertyStates = new NBacnetPropertyStates(bEnumRange.get(bString2.getString()).getOrdinal());
            }
            if (nBacnetPropertyStates == null && bEnumRange != null && bEnumRange.isTag(bString.getString())) {
                nBacnetPropertyStates = new NBacnetPropertyStates(bEnumRange.get(bString.getString()).getOrdinal());
            }
        }
        if (nBacnetPropertyStates != null) {
            return new ChangeOfState(nBacnetPropertyStates, bBacnetBitString);
        }
        Log.getLog((String)"bacnet.server").trace("alarmData:" + this.alarmData);
        throw new IllegalArgumentException("Cannot build BACnet COS Event Values for Multistate point " + (Object)((Object)this.eventObjectId));
    }

    private final OutOfRange getAnalogOORValues(String string, BBacnetBitString bBacnetBitString, int n, int n2) {
        BString bString = (BString)this.alarmData.getFacet("deadband");
        BString bString2 = null;
        if (n == 3) {
            bString2 = (BString)this.alarmData.getFacet("highLimit");
        } else if (n == 4) {
            bString2 = (BString)this.alarmData.getFacet("lowLimit");
        } else if (n == 0) {
            if (n2 == 3) {
                bString2 = (BString)this.alarmData.getFacet("highLimit");
            } else if (n2 == 4) {
                bString2 = (BString)this.alarmData.getFacet("lowLimit");
            }
        }
        if (string != null && bString != null && bString2 != null) {
            return new OutOfRange(AsyncEventNotificationRequest.parseFloat(string), bBacnetBitString, AsyncEventNotificationRequest.parseFloat(bString.getString()), AsyncEventNotificationRequest.parseFloat(bString2.getString()));
        }
        Log.getLog((String)"bacnet.server").trace("alarmData:" + this.alarmData);
        throw new IllegalArgumentException("Cannot build BACnet OOR Event Values: Missing value, deadband, or exceededLimit!");
    }

    private final FloatingLimit getLoopFLValues(BBacnetBitString bBacnetBitString, boolean bl) {
        BString bString = (BString)this.alarmData.get("controlledValue");
        BString bString2 = (BString)this.alarmData.get("setptValue");
        BString bString3 = (BString)this.alarmData.get("errorLimit");
        if (bString != null && bString2 != null && bString3 != null) {
            BInteger bInteger;
            float f = AsyncEventNotificationRequest.parseFloat(bString.getString());
            float f2 = AsyncEventNotificationRequest.parseFloat(bString2.getString());
            if (this.toState.getOrdinal() == 2) {
                if (f > f2) {
                    this.toState = BBacnetEventState.highLimit;
                } else if (f < f2) {
                    this.toState = BBacnetEventState.lowLimit;
                }
                this.offnormalToState = this.toState;
                if (bl) {
                    bBacnetBitString = BacnetBitStringUtil.getBacnetStatusFlags(BStatus.alarm);
                }
            } else if (this.fromState.getOrdinal() == 2 && (bInteger = (BInteger)this.alarmData.get("offnormalToState")) != null) {
                this.fromState = BBacnetEventState.make(bInteger.getInt());
            }
            return new FloatingLimit(AsyncEventNotificationRequest.parseFloat(bString.getString()), bBacnetBitString, AsyncEventNotificationRequest.parseFloat(bString2.getString()), AsyncEventNotificationRequest.parseFloat(bString3.getString()));
        }
        Log.getLog((String)"bacnet.server").trace("alarmData:" + this.alarmData);
        throw new IllegalArgumentException("Cannot build BACnet FL Event Values: Missing referenced value, setpoint value, or error limit!");
    }

    private final CommandFailure getBinaryCFValues(BString bString, BBacnetBitString bBacnetBitString) {
        BBoolean bBoolean;
        byte[] byArray = null;
        byte[] byArray2 = null;
        BString bString2 = (BString)this.eventObject.getSlotFacets((Slot)BBooleanPoint.out).get("trueText");
        BInteger bInteger = (BInteger)this.alarmData.get("numericValue");
        if (bInteger != null) {
            boolean bl = false;
            if (bInteger.getInt() != 0) {
                bl = true;
            }
            byArray = AsnUtil.toAsnEnumerated(bl);
        }
        if (byArray == null && (bBoolean = (BBoolean)this.alarmData.get("alarmValue")) != null) {
            byArray = AsnUtil.toAsnEnumerated(bBoolean.getBoolean());
        }
        if (byArray == null && bString2 != null) {
            byArray = AsnUtil.toAsnEnumerated(bString2.equals((Object)bString));
        }
        if (bString2 != null) {
            byArray2 = AsnUtil.toAsnEnumerated(bString2.equals((Object)((BString)this.alarmData.getFacet("feedbackValue"))));
        }
        if (byArray != null && byArray2 != null) {
            return new CommandFailure(byArray, bBacnetBitString, byArray2);
        }
        Log.getLog((String)"bacnet.server").trace("alarmData:" + this.alarmData);
        throw new IllegalArgumentException("Cannot build BACnet CF Event Values for Binary point " + (Object)((Object)this.eventObjectId));
    }

    private final CommandFailure getMultistateCFValues(String string, BBacnetBitString bBacnetBitString) {
        BString bString;
        byte[] byArray = null;
        byte[] byArray2 = null;
        BEnumRange bEnumRange = (BEnumRange)this.eventObject.getSlotFacets((Slot)BEnumPoint.out).get("range");
        BInteger bInteger = (BInteger)this.alarmData.get("numericValue");
        if (bInteger != null) {
            byArray = AsnUtil.toAsnUnsigned(bInteger.getInt());
        }
        if (byArray == null && (bString = (BString)this.alarmData.get("alarmValue")) != null && bEnumRange != null && bEnumRange.isTag(bString.getString())) {
            byArray = AsnUtil.toAsnUnsigned(bEnumRange.get(bString.getString()));
        }
        if (byArray == null && bEnumRange != null && bEnumRange.isTag(string)) {
            byArray = AsnUtil.toAsnUnsigned(bEnumRange.get(string));
        }
        if (byArray == null) {
            try {
                byArray = AsnUtil.toAsnUnsigned(Integer.parseInt(string));
            }
            catch (Exception exception) {
                Log.getLog((String)"bacnet.server").trace("MS CmdFailure: v=" + string);
            }
        }
        if ((bString = (BString)this.alarmData.getFacet("feedbackValue")) != null) {
            if (bEnumRange != null) {
                byArray2 = AsnUtil.toAsnUnsigned(bEnumRange.get(bString.getString()));
            } else {
                try {
                    byArray2 = AsnUtil.toAsnUnsigned(Integer.parseInt(bString.getString()));
                }
                catch (Exception exception) {
                    Log.getLog((String)"bacnet.server").trace("MS CmdFailure: fvf=" + bString);
                }
            }
        }
        if (byArray != null && byArray2 != null) {
            return new CommandFailure(byArray, bBacnetBitString, byArray2);
        }
        Log.getLog((String)"bacnet.server").trace("cv=" + byArray + "; fv=" + byArray2 + ";\nalarmData:" + this.alarmData);
        throw new IllegalArgumentException("Cannot build BACnet CF Event Values for Multistate point " + (Object)((Object)this.eventObjectId));
    }

    private final BufferReady getTLogBRValues(String string) throws Exception {
        BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference = new BBacnetDeviceObjectPropertyReference();
        bBacnetDeviceObjectPropertyReference = (BBacnetDeviceObjectPropertyReference)bBacnetDeviceObjectPropertyReference.decodeFromString(string);
        long l = Long.parseLong(((BString)this.alarmData.getFacet("previousNotification")).getString());
        long l2 = Long.parseLong(((BString)this.alarmData.getFacet("currentNotification")).getString());
        return new BufferReady(bBacnetDeviceObjectPropertyReference, l, l2);
    }

    private final /* synthetic */ void this() {
        this.local = BBacnetNetwork.localDevice();
    }

    public AsyncEventNotificationRequest(BAlarmRecord bAlarmRecord, BComponent bComponent, long l, BBacnetRecipient bBacnetRecipient, boolean bl, boolean bl2) {
        this.this();
        this.alarm = bAlarmRecord;
        this.eventObject = bComponent;
        this.processId = l;
        this.recipient = bBacnetRecipient;
        this.useConfirmed = bl;
        this.ackAlarmAndNormal = bl2;
        this.alarmData = bAlarmRecord.getAlarmData();
    }
}

