/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack;

import com.tridium.bacnet.stack.DeviceEntry;
import java.util.Iterator;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetSegmentation;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.LongHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DeviceRegistry {
    private static DeviceRegistry registry = new DeviceRegistry();
    private static final int BYTE = 8;
    private static final int SIX_BYTES = 48;
    private static final int TWO_BYTE_MASK = 65535;
    private static final long BYTE_MASK = 255L;
    private static final long NET_MASK = -281474976710656L;
    private LongHashMap byAddress;
    private IntHashMap byId;

    public static Iterator addressIterator() {
        return DeviceRegistry.registry.byAddress.iterator();
    }

    public static Iterator idIterator() {
        return DeviceRegistry.registry.byId.iterator();
    }

    public static void dump() {
        DeviceEntry deviceEntry;
        System.out.println("By Address Table");
        LongHashMap.Iterator iterator = DeviceRegistry.registry.byAddress.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            deviceEntry = (DeviceEntry)iterator.next();
            long l = iterator.key();
            System.out.println(++n + "  k=" + l + " -> " + deviceEntry);
        }
        System.out.println("\nBy ID Table");
        deviceEntry = DeviceRegistry.registry.byId.iterator();
        n = 0;
        while (deviceEntry.hasNext()) {
            DeviceEntry deviceEntry2 = (DeviceEntry)deviceEntry.next();
            int n2 = deviceEntry.key();
            System.out.println(++n + "  k=" + n2 + " -> " + deviceEntry2);
        }
        System.out.println();
    }

    public static void update(BBacnetDevice bBacnetDevice) {
        registry.updateEntry(bBacnetDevice.getObjectId(), bBacnetDevice.getAddress(), bBacnetDevice.getMaxAPDULengthAccepted(), bBacnetDevice.getSegmentationSupported(), bBacnetDevice.getProtocolRevision());
    }

    public static void update(BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetAddress bBacnetAddress, int n, BBacnetSegmentation bBacnetSegmentation) {
        registry.updateEntry(bBacnetObjectIdentifier, bBacnetAddress, n, bBacnetSegmentation);
    }

    public static void remove(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        registry.removeEntry(bBacnetObjectIdentifier);
    }

    public static int getMaxApduLengthSupported(BBacnetAddress bBacnetAddress) {
        return registry.getMaxLength(bBacnetAddress);
    }

    public static BBacnetObjectIdentifier getDeviceId(BBacnetAddress bBacnetAddress) {
        return registry.getDeviceObjectId(bBacnetAddress);
    }

    public static BBacnetAddress getDeviceAddress(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        return registry.getAddress(bBacnetObjectIdentifier);
    }

    public static int getProtocolRevision(BBacnetAddress bBacnetAddress) {
        return registry.getProtRev(bBacnetAddress);
    }

    public static BBacnetSegmentation getSegmentationSupported(BBacnetAddress bBacnetAddress) {
        return registry.getSegSupp(bBacnetAddress);
    }

    public void updateEntry(BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetAddress bBacnetAddress, int n, BBacnetSegmentation bBacnetSegmentation) {
        this.updateEntry(bBacnetObjectIdentifier, bBacnetAddress, n, bBacnetSegmentation, 0);
    }

    public void updateEntry(BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetAddress bBacnetAddress, int n, BBacnetSegmentation bBacnetSegmentation, int n2) {
        if (bBacnetObjectIdentifier.equals((Object)BBacnetObjectIdentifier.DEFAULT_DEVICE)) {
            return;
        }
        DeviceEntry deviceEntry = (DeviceEntry)this.byId.get(bBacnetObjectIdentifier.hashCode());
        if (deviceEntry != null) {
            deviceEntry.deviceId = bBacnetObjectIdentifier;
            deviceEntry.maxApduLengthSupported = n;
            deviceEntry.segmentationSupported = bBacnetSegmentation;
            deviceEntry.protocolRevision = n2;
            this.byAddress.remove(DeviceRegistry.getKey(bBacnetAddress));
            deviceEntry.address = bBacnetAddress;
        } else {
            deviceEntry = new DeviceEntry(bBacnetObjectIdentifier, bBacnetAddress, n, bBacnetSegmentation, n2);
            this.byId.put(bBacnetObjectIdentifier.hashCode(), (Object)deviceEntry);
        }
        this.byAddress.put(DeviceRegistry.getKey(deviceEntry.address), (Object)deviceEntry);
    }

    private final void removeEntry(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        DeviceEntry deviceEntry = (DeviceEntry)this.byId.remove(bBacnetObjectIdentifier.hashCode());
        if (deviceEntry != null) {
            this.byAddress.remove(DeviceRegistry.getKey(deviceEntry.address));
        }
    }

    private final int getMaxLength(BBacnetAddress bBacnetAddress) {
        DeviceEntry deviceEntry = this.getByAddress(bBacnetAddress);
        if (deviceEntry == null) {
            return 50;
        }
        return deviceEntry.maxApduLengthSupported;
    }

    public BBacnetObjectIdentifier getDeviceObjectId(BBacnetAddress bBacnetAddress) {
        DeviceEntry deviceEntry = this.getByAddress(bBacnetAddress);
        if (deviceEntry != null) {
            return deviceEntry.deviceId;
        }
        return null;
    }

    private final BBacnetAddress getAddress(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        DeviceEntry deviceEntry = (DeviceEntry)this.byId.get(bBacnetObjectIdentifier.hashCode());
        if (deviceEntry != null) {
            return deviceEntry.address;
        }
        return null;
    }

    private final int getProtRev(BBacnetAddress bBacnetAddress) {
        DeviceEntry deviceEntry = this.getByAddress(bBacnetAddress);
        if (deviceEntry == null) {
            return 0;
        }
        return deviceEntry.protocolRevision;
    }

    private final BBacnetSegmentation getSegSupp(BBacnetAddress bBacnetAddress) {
        DeviceEntry deviceEntry = this.getByAddress(bBacnetAddress);
        if (deviceEntry == null) {
            return BBacnetSegmentation.noSegmentation;
        }
        return deviceEntry.segmentationSupported;
    }

    private final DeviceEntry getByAddress(BBacnetAddress bBacnetAddress) {
        return (DeviceEntry)this.byAddress.get(DeviceRegistry.getKey(bBacnetAddress));
    }

    public int getOidCount() {
        return this.byId.size();
    }

    public int getAddrCount() {
        return this.byAddress.size();
    }

    public static long getKey(BBacnetAddress bBacnetAddress) {
        long l = bBacnetAddress.getNetworkNumber();
        long l2 = 0xFFFF000000000000L & (0xFFFFL & l) << 48;
        byte[] byArray = bBacnetAddress.getMacAddress().getAddr();
        if (byArray != null && byArray.length > 0) {
            long l3 = byArray.length * 8;
            int n = 0;
            while (n < byArray.length) {
                long l4 = (long)byArray[n] & 0xFFL;
                l2 |= l4 << (int)(l3 -= 8L);
                ++n;
            }
        }
        return l2;
    }

    private final /* synthetic */ void this() {
        this.byAddress = new LongHashMap();
        this.byId = new IntHashMap();
    }

    public DeviceRegistry() {
        this.this();
    }
}

