/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack;

import com.tridium.bacnet.stack.network.BNetworkPort;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.util.BIBacnetPollable;
import javax.baja.bacnet.util.PollList;
import javax.baja.bacnet.util.PollListEntry;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BAbstractPollService;
import javax.baja.driver.util.BIPollable;
import javax.baja.log.Log;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetPoll
extends BAbstractPollService
implements Runnable {
    public static final Property fastRate = BBacnetPoll.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    public static final Property normalRate = BBacnetPoll.newProperty((int)0, (BValue)BRelTime.make((long)5000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    public static final Property slowRate = BBacnetPoll.newProperty((int)0, (BValue)BRelTime.make((long)30000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    public static final Property statisticsStart = BBacnetPoll.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Property averagePoll = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property busyTime = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property totalPolls = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property dibsPolls = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property fastPolls = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property normalPolls = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property slowPolls = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property dibsCount = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property fastCount = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property normalCount = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property slowCount = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property fastCycleTime = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property normalCycleTime = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property slowCycleTime = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property deviceCount = BBacnetPoll.newProperty((int)7, (int)0, null);
    public static final Property pointCount = BBacnetPoll.newProperty((int)3, (int)0, null);
    public static final Property objectCount = BBacnetPoll.newProperty((int)3, (int)0, null);
    public static final Property virtualCount = BBacnetPoll.newProperty((int)3, (int)0, null);
    public static final Action resetStatistics = BBacnetPoll.newAction((int)128, null);
    public static final Type TYPE;
    protected static final DecimalFormat timeFormat;
    private static final int DOUBLE_PLE_SIZE = -1;
    boolean isAlive;
    Thread thread;
    protected long start;
    protected long lastPollTime;
    protected long totalPollTime;
    protected int totalPollCount;
    protected double average;
    protected Stack dibs;
    protected int dibsPollTotal;
    protected int dibsSizeTotal;
    protected Object lock;
    protected int statsCount;
    protected BacnetBucket fast;
    protected BacnetBucket norm;
    protected BacnetBucket slow;
    protected long subTime;
    protected int subs;
    protected long unsubTime;
    protected int unsubs;
    protected long getPLEsSubTime;
    protected long getPLEsUnsubTime;
    protected long dibsSubTime;
    protected long pleAddTime;
    protected int pleAdds;
    protected int pleRems;
    protected long dibsUnsubTime;
    protected long pleRemTime;
    protected Log log;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$BBacnetPoll;

    public BRelTime getFastRate() {
        return (BRelTime)this.get(fastRate);
    }

    public void setFastRate(BRelTime bRelTime) {
        this.set(fastRate, (BValue)bRelTime, null);
    }

    public BRelTime getNormalRate() {
        return (BRelTime)this.get(normalRate);
    }

    public void setNormalRate(BRelTime bRelTime) {
        this.set(normalRate, (BValue)bRelTime, null);
    }

    public BRelTime getSlowRate() {
        return (BRelTime)this.get(slowRate);
    }

    public void setSlowRate(BRelTime bRelTime) {
        this.set(slowRate, (BValue)bRelTime, null);
    }

    public BAbsTime getStatisticsStart() {
        return (BAbsTime)this.get(statisticsStart);
    }

    public void setStatisticsStart(BAbsTime bAbsTime) {
        this.set(statisticsStart, (BValue)bAbsTime, null);
    }

    public String getAveragePoll() {
        return this.getString(averagePoll);
    }

    public void setAveragePoll(String string) {
        this.setString(averagePoll, string, null);
    }

    public String getBusyTime() {
        return this.getString(busyTime);
    }

    public void setBusyTime(String string) {
        this.setString(busyTime, string, null);
    }

    public String getTotalPolls() {
        return this.getString(totalPolls);
    }

    public void setTotalPolls(String string) {
        this.setString(totalPolls, string, null);
    }

    public String getDibsPolls() {
        return this.getString(dibsPolls);
    }

    public void setDibsPolls(String string) {
        this.setString(dibsPolls, string, null);
    }

    public String getFastPolls() {
        return this.getString(fastPolls);
    }

    public void setFastPolls(String string) {
        this.setString(fastPolls, string, null);
    }

    public String getNormalPolls() {
        return this.getString(normalPolls);
    }

    public void setNormalPolls(String string) {
        this.setString(normalPolls, string, null);
    }

    public String getSlowPolls() {
        return this.getString(slowPolls);
    }

    public void setSlowPolls(String string) {
        this.setString(slowPolls, string, null);
    }

    public String getDibsCount() {
        return this.getString(dibsCount);
    }

    public void setDibsCount(String string) {
        this.setString(dibsCount, string, null);
    }

    public String getFastCount() {
        return this.getString(fastCount);
    }

    public void setFastCount(String string) {
        this.setString(fastCount, string, null);
    }

    public String getNormalCount() {
        return this.getString(normalCount);
    }

    public void setNormalCount(String string) {
        this.setString(normalCount, string, null);
    }

    public String getSlowCount() {
        return this.getString(slowCount);
    }

    public void setSlowCount(String string) {
        this.setString(slowCount, string, null);
    }

    public String getFastCycleTime() {
        return this.getString(fastCycleTime);
    }

    public void setFastCycleTime(String string) {
        this.setString(fastCycleTime, string, null);
    }

    public String getNormalCycleTime() {
        return this.getString(normalCycleTime);
    }

    public void setNormalCycleTime(String string) {
        this.setString(normalCycleTime, string, null);
    }

    public String getSlowCycleTime() {
        return this.getString(slowCycleTime);
    }

    public void setSlowCycleTime(String string) {
        this.setString(slowCycleTime, string, null);
    }

    public int getDeviceCount() {
        return this.getInt(deviceCount);
    }

    public void setDeviceCount(int n) {
        this.setInt(deviceCount, n, null);
    }

    public int getPointCount() {
        return this.getInt(pointCount);
    }

    public void setPointCount(int n) {
        this.setInt(pointCount, n, null);
    }

    public int getObjectCount() {
        return this.getInt(objectCount);
    }

    public void setObjectCount(int n) {
        this.setInt(objectCount, n, null);
    }

    public int getVirtualCount() {
        return this.getInt(virtualCount);
    }

    public void setVirtualCount(int n) {
        this.setInt(virtualCount, n, null);
    }

    public void resetStatistics() {
        this.invoke(resetStatistics, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String toString(Context context) {
        if (this.isRunning()) {
            return "BacnetPoll in " + this.getParent().getName();
        }
        return "BacnetPoll";
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (!this.isAlive) {
            return;
        }
        if (property.equals((Object)fastRate)) {
            this.fast.resetTicks();
        } else if (property.equals((Object)normalRate)) {
            this.norm.resetTicks();
        } else if (property.equals((Object)slowRate)) {
            this.slow.resetTicks();
        }
    }

    public final boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BNetworkPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void poll(PollList pollList) {
        long l;
        block11: {
            l = Clock.ticks();
            try {
                if (!this.getPollEnabled()) {
                    return;
                }
                BBacnetDevice bBacnetDevice = pollList.getDevice();
                if (bBacnetDevice.isRunning()) {
                    boolean bl = bBacnetDevice.poll(pollList);
                    if (bl) break block11;
                    Object object = this.lock;
                    synchronized (object) {
                        if (pollList.size() > 1) {
                            if (this.log.isTraceOn()) {
                                this.log.trace("Redistributing items in poll list:\n " + pollList);
                            }
                            this.redistribute(pollList);
                        }
                        break block11;
                    }
                }
                try {
                    this.getQueue(pollList.getPollFrequency()).remove(pollList);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                System.out.println("Poll exception on " + pollList.debug());
            }
        }
        this.lastPollTime = Clock.ticks() - l;
        ++this.totalPollCount;
        this.totalPollTime += this.lastPollTime;
        this.average = (double)this.totalPollTime / (double)this.totalPollCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initializeBuckets() {
        Object object = this.lock;
        synchronized (object) {
            if (this.fast == null) {
                this.fast = new BacnetBucket(fastRate);
            }
            if (this.norm == null) {
                this.norm = new BacnetBucket(normalRate);
            }
            if (this.slow == null) {
                this.slow = new BacnetBucket(slowRate);
            }
            this.rebuildPollBucket(this.getQueue(0));
            this.rebuildPollBucket(this.getQueue(2));
            this.rebuildPollBucket(this.getQueue(1));
            return;
        }
    }

    public void pollStart() {
        this.initializeBuckets();
        this.doResetStatistics();
        this.pollStop();
        this.isAlive = true;
        this.thread = new Thread((Runnable)this, "BacnetPoll" + ((BNetworkPort)this.getParent()).getPortId());
        this.thread.start();
    }

    public void pollStop() {
        this.isAlive = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public int getNumberOfThreads() {
        return 1;
    }

    public void run() {
        long l = Clock.ticks() + 10000L;
        while (this.isAlive) {
            try {
                if (!this.getPollEnabled()) {
                    Thread.sleep(1000L);
                    continue;
                }
                this.pollDibs();
                this.pollQueues();
                long l2 = this.computeSleep();
                if (l2 > 0L) {
                    Thread.sleep(l2);
                }
                if (Clock.ticks() <= l) continue;
                this.checkBucketConfig();
                this.updateStats();
                l = Clock.ticks() + 10000L;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void pollDibs() {
        while (true) {
            PollList pollList = null;
            Object object = this.lock;
            synchronized (object) {
                if (this.dibs.isEmpty()) {
                    return;
                }
                pollList = (PollList)this.dibs.pop();
                ++this.dibsPollTotal;
            }
            this.poll(pollList);
        }
    }

    private final void pollQueues() {
        this.pollQueue(this.fast);
        this.pollQueue(this.norm);
        this.pollQueue(this.slow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void pollQueue(BacnetBucket bacnetBucket) {
        long l;
        if (bacnetBucket.nextTicks > Clock.ticks() + (long)5) {
            return;
        }
        PollList pollList = null;
        int n = 0;
        Object object = this.lock;
        synchronized (object) {
            int n2 = bacnetBucket.index;
            n = bacnetBucket.q.size();
            if (n > 0) {
                if (n2 >= n) {
                    n2 = 0;
                    ++bacnetBucket.cycleTotal;
                }
                pollList = (PollList)bacnetBucket.q.get(n2);
                bacnetBucket.index = n2 + 1;
            } else {
                ++bacnetBucket.cycleTotal;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl18 : MonitorExitStatement: MONITOREXIT : var4_4
            if (pollList != null) {
                this.poll(pollList);
                ++bacnetBucket.pollTotal;
            }
        }
        long l2 = l = ((BRelTime)this.get(bacnetBucket.rateProp)).getMillis();
        if (n > 0) {
            double d = l;
            double d2 = n;
            l2 = (long)((d - d2 * (double)this.lastPollTime) / d2);
        }
        bacnetBucket.nextTicks = Clock.ticks() + l2;
    }

    protected long computeSleep() {
        long l = Clock.ticks();
        long l2 = 1000L;
        l2 = Math.min(this.fast.nextTicks - l, l2);
        l2 = Math.min(this.norm.nextTicks - l, l2);
        l2 = Math.min(this.slow.nextTicks - l, l2);
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkBucketConfig() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            BBacnetPoll.reSort(this.fast.q, arrayList, arrayList2, arrayList3);
            BBacnetPoll.reSort(this.norm.q, arrayList, arrayList2, arrayList3);
            BBacnetPoll.reSort(this.slow.q, arrayList, arrayList2, arrayList3);
            this.fast.q = arrayList;
            this.norm.q = arrayList2;
            this.slow.q = arrayList3;
            return;
        }
    }

    protected static void reSort(List list, List list2, List list3, List list4) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            PollList pollList = (PollList)list.get(n2);
            switch (pollList.getPollFrequency()) {
                case 0: {
                    list2.add(pollList);
                    break;
                }
                case 1: {
                    list3.add(pollList);
                    break;
                }
                case 2: {
                    list4.add(pollList);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++n2;
        }
    }

    public void doResetStatistics() {
        this.totalPollTime = 0L;
        this.totalPollCount = 0;
        this.average = 0.0;
        this.statsCount = 0;
        this.dibsPollTotal = 0;
        this.dibsSizeTotal = 0;
        this.fast.reset();
        this.norm.reset();
        this.slow.reset();
        this.start = Clock.ticks();
        this.setStatisticsStart(BAbsTime.make());
        this.updateStats();
    }

    protected void updateStats() {
        long l = Clock.ticks();
        long l2 = l - this.start;
        ++this.statsCount;
        this.setAveragePoll(timeFormat.format(this.average));
        if (this.totalPollTime > 0L) {
            double d = (double)this.totalPollTime / (double)this.getNumberOfThreads();
            this.setBusyTime((int)(100.0 * d / (double)l2) + "% (" + BBacnetPoll.duration(this.totalPollTime) + '/' + BBacnetPoll.duration(l2) + " over " + this.getNumberOfThreads() + " thds");
        }
        this.setTotalPolls(BBacnetPoll.count(this.totalPollCount) + " over " + BBacnetPoll.duration(this.totalPollTime));
        this.setDibsPolls(this.toPollTotal(this.dibsPollTotal));
        this.setFastPolls(this.toPollTotal(this.fast.pollTotal));
        this.setNormalPolls(this.toPollTotal(this.norm.pollTotal));
        this.setSlowPolls(this.toPollTotal(this.slow.pollTotal));
        this.setDibsCount(this.toCount(this.dibs.size(), this.dibsSizeTotal));
        this.dibsSizeTotal += this.dibs.size();
        this.setFastCount(this.toCount(this.fast.q.size(), this.fast.sizeTotal));
        this.fast.sizeTotal += this.fast.q.size();
        this.setNormalCount(this.toCount(this.norm.q.size(), this.norm.sizeTotal));
        this.norm.sizeTotal += this.norm.q.size();
        this.setSlowCount(this.toCount(this.slow.q.size(), this.slow.sizeTotal));
        this.slow.sizeTotal += this.slow.q.size();
        this.setFastCycleTime(this.toCycle(this.fast, l2));
        this.setNormalCycleTime(this.toCycle(this.norm, l2));
        this.setSlowCycleTime(this.toCycle(this.slow, l2));
    }

    protected String toPollTotal(int n) {
        int n2 = this.totalPollCount;
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 == 0) {
            stringBuffer.append('-');
        } else {
            stringBuffer.append((int)(100.0 * (double)n / (double)n2));
        }
        stringBuffer.append("% (").append(BBacnetPoll.count(n)).append('/').append(BBacnetPoll.count(n2)).append(')');
        return stringBuffer.toString();
    }

    protected String toCount(int n, int n2) {
        return "current=" + n + " average=" + n2 / this.statsCount;
    }

    protected String toCycle(BacnetBucket bacnetBucket, long l) {
        int n = bacnetBucket.cycleTotal;
        if (n == 0) {
            return "-";
        }
        return "average = " + l / (long)n + "ms";
    }

    protected static String count(int n) {
        if (n < 10000) {
            return String.valueOf(n);
        }
        return String.valueOf(n / 1000) + 'k';
    }

    protected static String duration(long l) {
        if (l < 10000L) {
            return String.valueOf(l) + "ms";
        }
        return String.valueOf(l / 1000L) + "sec";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pollNow(BIBacnetPollable bIBacnetPollable) {
        if (bIBacnetPollable.getPollableType() == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            PollListEntry[] pollListEntryArray = bIBacnetPollable.getPollListEntries();
            if (pollListEntryArray == null) {
                return;
            }
            int n = 0;
            while (n < pollListEntryArray.length) {
                if (!this.contains(this.dibs, pollListEntryArray[n])) {
                    this.add(this.dibs, pollListEntryArray[n], true);
                }
                ++n;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void subscribe(BIPollable var1_1) {
        var2_2 = Clock.ticks();
        if (!(var1_1 instanceof BIBacnetPollable)) {
            throw new IllegalArgumentException(Lexicon.make((String)"bacnet").getText("IllegalArgumentException.notBacnetPollable"));
        }
        if (!this.isAlive) {
            return;
        }
        var20_3 = (BIBacnetPollable)var1_1;
        var21_4 = this.lock;
        synchronized (var21_4) {
            var4_5 = Clock.ticks();
            this.pollNow(var20_3);
            var6_6 = Clock.ticks();
            var23_7 = var20_3.getPollableType();
            switch (var23_7) {
                case 0: {
                    System.out.println("BBacnetPoll.subscribe(device) no longer used!");
                    break;
                }
                case 1: {
                    this.setPointCount(this.getPointCount() + 1);
                    break;
                }
                case 2: {
                    this.setObjectCount(this.getObjectCount() + 1);
                    break;
                }
                case 3: {
                    this.setVirtualCount(this.getVirtualCount() + 1);
                    break;
                }
                case -1: {
                    break;
                }
            }
            var14_8 = Clock.ticks();
            var24_9 = var20_3.getPollListEntries();
            var16_10 = Clock.ticks();
            if (var24_9 == null) {
                return;
            }
            var18_11 = 0L;
            var25_12 = 0;
            if (true) ** GOTO lbl47
            do {
                var8_13 = Clock.ticks();
                var26_15 = this.getQueue(var20_3.getPollFrequency().getOrdinal());
                this.add(var26_15, var24_9[var25_12], false);
                var10_14 = Clock.ticks();
                ++this.pleAdds;
                var18_11 += var10_14 - var8_13;
                ++var25_12;
lbl47:
                // 2 sources

            } while (var25_12 < var24_9.length);
        }
        var12_16 = Clock.ticks();
        ++this.subs;
        this.subTime += var12_16 - var2_2;
        this.dibsSubTime += var6_6 - var4_5;
        this.pleAddTime += var18_11;
        this.getPLEsSubTime += var16_10 - var14_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean unsubscribe(BIPollable bIPollable) {
        long l;
        long l2;
        long l3;
        long l4;
        long l5 = Clock.ticks();
        if (!(bIPollable instanceof BIBacnetPollable)) {
            throw new IllegalArgumentException(Lexicon.make((String)"bacnet").getText("IllegalArgumentException.notBacnetPollable"));
        }
        if (!this.isAlive) {
            return false;
        }
        BIBacnetPollable bIBacnetPollable = (BIBacnetPollable)bIPollable;
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            int n = bIBacnetPollable.getPollableType();
            l4 = Clock.ticks();
            PollListEntry[] pollListEntryArray = bIBacnetPollable.getPollListEntries();
            l3 = Clock.ticks();
            if (pollListEntryArray == null) {
                return false;
            }
            l2 = 0L;
            l = 0L;
            int n2 = 0;
            while (n2 < pollListEntryArray.length) {
                boolean bl2 = true;
                long l6 = Clock.ticks();
                bl2 = this.remove(this.dibs, pollListEntryArray[n2]);
                long l7 = Clock.ticks();
                bl2 = this.remove(this.fast.q, pollListEntryArray[n2]);
                if (!bl2) {
                    bl2 = this.remove(this.norm.q, pollListEntryArray[n2]);
                }
                if (!bl2) {
                    bl2 = this.remove(this.slow.q, pollListEntryArray[n2]);
                }
                long l8 = Clock.ticks();
                ++this.pleRems;
                l2 += l7 - l6;
                l += l8 - l7;
                bl |= bl2;
                ++n2;
            }
            if (bl) {
                switch (n) {
                    case 0: {
                        System.out.println("BBacnetPoll.unsubscribe(device) no longer used!");
                        break;
                    }
                    case 1: {
                        this.setPointCount(this.getPointCount() - 1);
                        break;
                    }
                    case 2: {
                        this.setObjectCount(this.getObjectCount() - 1);
                        break;
                    }
                    case 3: {
                        this.setVirtualCount(this.getVirtualCount() - 1);
                        break;
                    }
                    case -1: {
                        break;
                    }
                }
            }
        }
        long l9 = Clock.ticks();
        ++this.unsubs;
        this.dibsUnsubTime += l2;
        this.pleRemTime += l;
        this.unsubTime += l9 - l5;
        this.getPLEsUnsubTime += l3 - l4;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removePLE(BIBacnetPollable bIBacnetPollable, PollListEntry pollListEntry) {
        Object object = this.lock;
        synchronized (object) {
            this.remove(this.getQueue(bIBacnetPollable.getPollFrequency().getOrdinal()), pollListEntry);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean contains(List list, PollListEntry pollListEntry) {
        Object object = this.lock;
        synchronized (object) {
            PollList pollList;
            Iterator iterator = list.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(pollList = (PollList)iterator.next()).contains(pollListEntry));
            return true;
        }
    }

    private final void redistribute(PollList pollList) {
        this.setSize(pollList, -1);
        this.rebuildQueue(this.getQueue(pollList.getPollFrequency()));
    }

    private final void rebuildQueue(List list) {
        Object object;
        ArrayList<PollListEntry> arrayList = new ArrayList<PollListEntry>();
        int n = 0;
        while (n < list.size()) {
            int n2;
            object = (PollList)list.get(n);
            int n3 = ((PollList)object).getDevice().getMaxAPDULengthAccepted();
            if (n3 > (n2 = BBacnetNetwork.localDevice().getMaxAPDULengthAccepted())) {
                n3 = n2;
            }
            n3 -= 5;
            PollListEntry[] pollListEntryArray = ((PollList)object).getPollEntries();
            int n4 = 0;
            while (n4 < pollListEntryArray.length) {
                if (pollListEntryArray[n4] != null) {
                    arrayList.add(pollListEntryArray[n4]);
                }
                ++n4;
            }
            ++n;
        }
        list.clear();
        n = 0;
        while (n < arrayList.size()) {
            object = (PollListEntry)arrayList.get(n);
            this.add(list, (PollListEntry)object, false);
            ++n;
        }
    }

    private final void rebuildPollBucket(List list) {
        int n = 0;
        while (n < list.size()) {
            PollList pollList = (PollList)list.get(n);
            this.setSize(pollList, 11);
            ++n;
        }
        this.rebuildQueue(list);
    }

    private final void setSize(PollList pollList, int n) {
        PollListEntry[] pollListEntryArray = pollList.getPollEntries();
        int n2 = 0;
        while (n2 < pollListEntryArray.length) {
            PollListEntry pollListEntry = pollListEntryArray[n2];
            if (pollListEntry != null) {
                if (n == -1) {
                    pollListEntry.doubleDataSize(pollList.getDevice().getMaxAPDULengthAccepted());
                } else {
                    int n3 = Math.min(pollList.getDevice().getMaxAPDULengthAccepted(), n);
                    pollListEntry.setDataSize(n3);
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void add(List list, PollListEntry pollListEntry, boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            PollList pollList;
            BBacnetDevice bBacnetDevice = pollListEntry.getDevice();
            Iterator iterator = list.iterator();
            boolean bl2 = false;
            while (!bl2 && iterator.hasNext()) {
                pollList = (PollList)iterator.next();
                if (bBacnetDevice != pollList.getDevice()) continue;
                int n = pollListEntry.getDevice().getMaxAPDULengthAccepted() - 5;
                if (pollList.getDataSize() + pollListEntry.getDataSize() >= n) continue;
                pollList.add(pollListEntry);
                return;
            }
            if (bl2) return;
            pollList = new PollList(pollListEntry);
            if (bl) {
                ((Stack)list).push(pollList);
            } else {
                list.add(pollList);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean remove(List list, PollListEntry pollListEntry) {
        Object object = this.lock;
        synchronized (object) {
            BBacnetDevice bBacnetDevice = pollListEntry.getDevice();
            boolean bl = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PollList pollList = (PollList)iterator.next();
                if (bBacnetDevice != pollList.getDevice()) continue;
                bl |= pollList.remove(pollListEntry);
                if (pollList.size() != 0) continue;
                list.remove(pollList);
                break;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final List getQueue(int n) {
        Object object = this.lock;
        synchronized (object) {
            switch (n) {
                case 0: {
                    return this.fast.q;
                }
                case 2: {
                    return this.slow.q;
                }
                case 1: {
                    return this.norm.q;
                }
            }
            return this.norm.q;
        }
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps();
        spyWriter.prop((Object)"subs", (Object)BInteger.make((int)this.subs));
        spyWriter.prop((Object)"subTime", (Object)BLong.make((long)this.subTime));
        spyWriter.prop((Object)"subAvg", (Object)BDouble.make((double)((double)this.subTime / (double)this.subs)));
        spyWriter.prop((Object)"unsubs", (Object)BInteger.make((int)this.unsubs));
        spyWriter.prop((Object)"unsubTime", (Object)BLong.make((long)this.unsubTime));
        spyWriter.prop((Object)"unsubAvg", (Object)BDouble.make((double)((double)this.unsubTime / (double)this.unsubs)));
        spyWriter.prop((Object)"getPLEsSubTime", (Object)BLong.make((long)this.getPLEsSubTime));
        spyWriter.prop((Object)"getPLEsSubAvg", (Object)BDouble.make((double)((double)this.getPLEsSubTime / (double)this.subs)));
        spyWriter.prop((Object)"pleAdds", (Object)BInteger.make((int)this.pleAdds));
        spyWriter.prop((Object)"pleAddTime", (Object)BLong.make((long)this.pleAddTime));
        spyWriter.prop((Object)"pleAddAvg", (Object)BDouble.make((double)((double)this.pleAddTime / (double)this.pleAdds)));
        spyWriter.prop((Object)"dibsSubTime", (Object)BLong.make((long)this.dibsSubTime));
        spyWriter.prop((Object)"dibsSubAvg", (Object)BDouble.make((double)((double)this.dibsSubTime / (double)this.subs)));
        spyWriter.prop((Object)"getPLEsUnsubTime", (Object)BLong.make((long)this.getPLEsUnsubTime));
        spyWriter.prop((Object)"getPLEsUnsubAvg", (Object)BDouble.make((double)((double)this.getPLEsUnsubTime / (double)this.subs)));
        spyWriter.prop((Object)"pleRems", (Object)BInteger.make((int)this.pleRems));
        spyWriter.prop((Object)"pleRemTime", (Object)BLong.make((long)this.pleRemTime));
        spyWriter.prop((Object)"pleRemAvg", (Object)BDouble.make((double)((double)this.pleRemTime / (double)this.pleRems)));
        spyWriter.prop((Object)"dibsUnsubTime", (Object)BLong.make((long)this.dibsUnsubTime));
        spyWriter.prop((Object)"dibsUnsubAvg", (Object)BDouble.make((double)((double)this.dibsUnsubTime / (double)this.unsubs)));
        spyWriter.endProps();
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetPoll", 2);
        spyWriter.prop((Object)"isAlive", this.isAlive);
        spyWriter.prop((Object)"ticks", (Object)BLong.make((long)Clock.ticks()));
        spyWriter.prop((Object)"dibs size", this.dibs.size());
        spyWriter.prop((Object)"statsCount", this.statsCount);
        if (this.fast != null) {
            spyWriter.prop((Object)"fast", this.fast.q.size());
            spyWriter.prop((Object)"fast.nextTicks", (Object)BLong.make((long)this.fast.nextTicks));
            spyWriter.prop((Object)"fast.index", this.fast.index);
            spyWriter.prop((Object)"fast.pollCount", this.fast.pollCount);
            Iterator iterator = this.fast.q.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                spyWriter.prop((Object)("fast[" + n++ + ']'), (Object)((PollList)iterator.next()).debug());
            }
            spyWriter.prop((Object)"norm", this.norm.q.size());
            spyWriter.prop((Object)"norm.nextTicks", (Object)BLong.make((long)this.norm.nextTicks));
            spyWriter.prop((Object)"norm.index", this.norm.index);
            spyWriter.prop((Object)"norm.pollCount", this.norm.pollCount);
            iterator = this.norm.q.iterator();
            n = 0;
            while (iterator.hasNext()) {
                spyWriter.prop((Object)("norm[" + n++ + ']'), (Object)((PollList)iterator.next()).debug());
            }
            spyWriter.prop((Object)"slow", this.slow.q.size());
            spyWriter.prop((Object)"slow.nextTicks", (Object)BLong.make((long)this.slow.nextTicks));
            spyWriter.prop((Object)"slow.index", this.slow.index);
            spyWriter.prop((Object)"slow.pollCount", this.slow.pollCount);
            iterator = this.slow.q.iterator();
            n = 0;
            while (iterator.hasNext()) {
                spyWriter.prop((Object)("slow[" + n++ + ']'), (Object)((PollList)iterator.next()).debug());
            }
        }
        spyWriter.endProps();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.dibs = new Stack();
        this.lock = new Object();
        this.subTime = 0L;
        this.subs = 0;
        this.unsubTime = 0L;
        this.unsubs = 0;
        this.getPLEsSubTime = 0L;
        this.getPLEsUnsubTime = 0L;
        this.dibsSubTime = 0L;
        this.pleAddTime = 0L;
        this.pleAdds = 0;
        this.pleRems = 0;
        this.dibsUnsubTime = 0L;
        this.pleRemTime = 0L;
        this.log = Log.getLog((String)"bacnet.point");
    }

    public BBacnetPoll() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$stack$BBacnetPoll;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$BBacnetPoll = BBacnetPoll.class("[Lcom.tridium.bacnet.stack.BBacnetPoll;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        timeFormat = new DecimalFormat("0.0#ms");
    }

    protected static class BacnetBucket {
        public Property rateProp;
        public List q = new ArrayList();
        public int index;
        public int pollCount;
        public long nextTicks;
        public int pollTotal;
        public int sizeTotal;
        public int cycleTotal;
        public BacnetBucket nextBucket;

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.rateProp.getName()).append('[').append(this.index).append('/').append(this.q.size()).append(']');
            return stringBuffer.toString();
        }

        public boolean removeAll(BIBacnetPollable bIBacnetPollable) {
            int n = 0;
            boolean bl = false;
            if (this.q.size() >= 1) {
                bl = true;
            }
            boolean bl2 = bl;
            boolean bl3 = false;
            while (bl2) {
                if (this.q.get(n) == bIBacnetPollable) {
                    this.q.remove(n);
                    bl3 = true;
                } else {
                    ++n;
                }
                boolean bl4 = false;
                if (n >= this.q.size()) continue;
                bl4 = bl2 = true;
            }
            return bl3;
        }

        public boolean remove(BIBacnetPollable bIBacnetPollable) {
            int n = this.q.size();
            int n2 = 0;
            while (n2 < n) {
                if (this.q.get(n2) == bIBacnetPollable) {
                    this.q.remove(n2);
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void reset() {
            this.resetDone();
            this.index = 0;
            this.nextTicks = 0L;
            this.pollTotal = 0;
            this.sizeTotal = 0;
            this.cycleTotal = 0;
            this.pollCount = 0;
        }

        public void resetDone() {
            int n = 0;
            while (n < this.q.size()) {
                ((PollList)this.q.get(n)).setDone(false);
                ++n;
            }
        }

        public void resetTicks() {
            this.nextTicks = 0L;
        }

        public int count(BIBacnetPollable bIBacnetPollable) {
            int n = 0;
            int n2 = this.q.size();
            int n3 = 0;
            while (n3 < n2) {
                if (this.q.get(n3) == bIBacnetPollable) {
                    ++n;
                }
                ++n3;
            }
            return n;
        }

        public BacnetBucket(Property property) {
            this.rateProp = property;
        }
    }
}

