/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.unconfirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.services.BacnetUnconfirmedRequest;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetUnconfirmedServiceChoice;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.io.AsnException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WhoHasRequest
extends BacnetUnconfirmedRequest {
    private static final int LIMITS_NOT_USED = -1;
    private static final int DEVICE_INSTANCE_LOW_RANGE_TAG = 0;
    private static final int DEVICE_INSTANCE_HIGH_RANGE_TAG = 1;
    private static final int OBJECT_IDENTIFIER_TAG = 2;
    private static final int OBJECT_NAME_TAG = 3;
    private int deviceInstanceRangeLowLimit;
    private int deviceInstanceRangeHighLimit;
    private BBacnetObjectIdentifier objectId;
    private String objectName;
    private BCharacterSetEncoding encoding;

    public int getDeviceInstanceRangeLowLimit() {
        return this.deviceInstanceRangeLowLimit;
    }

    public int getDeviceInstanceRangeHighLimit() {
        return this.deviceInstanceRangeHighLimit;
    }

    public boolean useLimits() {
        boolean bl = false;
        if (this.deviceInstanceRangeLowLimit != -1) {
            bl = true;
        }
        return bl;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public BBacnetObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public BCharacterSetEncoding getEncoding() {
        return this.encoding;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        if (this.deviceInstanceRangeLowLimit != -1) {
            asnOutputStream.writeUnsignedInteger(0, this.deviceInstanceRangeLowLimit);
            asnOutputStream.writeUnsignedInteger(1, this.deviceInstanceRangeHighLimit);
        }
        if (this.objectId != null) {
            asnOutputStream.writeObjectIdentifier(2, this.objectId);
        } else {
            asnOutputStream.writeCharacterString(3, this.objectName, this.encoding);
        }
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        if (asnInputStream.peekTag() == 0) {
            this.deviceInstanceRangeLowLimit = asnInputStream.readUnsignedInt(0);
            this.deviceInstanceRangeHighLimit = asnInputStream.readUnsignedInt(1);
        } else {
            this.deviceInstanceRangeLowLimit = -1;
            this.deviceInstanceRangeHighLimit = -1;
        }
        if (asnInputStream.peekTag() == 2) {
            this.objectId = asnInputStream.readObjectIdentifier(2);
            this.encoding = BBacnetNetwork.localDevice().getCharacterSet();
        } else {
            this.encoding = asnInputStream.peekEncoding(3);
            this.objectName = asnInputStream.readCharacterString(3);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(BacnetUnconfirmedServiceChoice.TAGS[7]);
        if (this.deviceInstanceRangeLowLimit != -1) {
            stringBuffer.append("\n  deviceInstanceRangeLowLimit " + this.deviceInstanceRangeLowLimit);
            stringBuffer.append("\n  deviceInstanceRangeHighLimit " + this.deviceInstanceRangeHighLimit);
        } else {
            stringBuffer.append("\n  ALL DEVICES");
        }
        if (this.objectId != null) {
            stringBuffer.append("\n  objectId " + (Object)((Object)this.objectId));
        } else {
            stringBuffer.append("\n  objectName " + this.objectName);
            stringBuffer.append("\n  encoding " + this.encoding.getTag());
        }
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.deviceInstanceRangeLowLimit = -1;
        this.deviceInstanceRangeHighLimit = -1;
        this.objectId = null;
        this.objectName = null;
        this.encoding = null;
    }

    public WhoHasRequest() {
        this(-1, -1, null, null);
    }

    public WhoHasRequest(int n, int n2, BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this(n, n2, bBacnetObjectIdentifier, null, null);
    }

    public WhoHasRequest(int n, int n2, String string, BCharacterSetEncoding bCharacterSetEncoding) {
        this(n, n2, null, string, bCharacterSetEncoding);
    }

    public WhoHasRequest(String string, BCharacterSetEncoding bCharacterSetEncoding) {
        this(-1, -1, null, string, bCharacterSetEncoding);
    }

    public WhoHasRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this(-1, -1, bBacnetObjectIdentifier, null, null);
    }

    private WhoHasRequest(int n, int n2, BBacnetObjectIdentifier bBacnetObjectIdentifier, String string, BCharacterSetEncoding bCharacterSetEncoding) {
        super(7);
        this.this();
        this.deviceInstanceRangeLowLimit = n;
        this.deviceInstanceRangeHighLimit = n2;
        this.objectId = bBacnetObjectIdentifier;
        this.objectName = string;
        this.encoding = bCharacterSetEncoding;
    }
}

