/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.unconfirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.services.BacnetUnconfirmedRequest;
import javax.baja.bacnet.BacnetUnconfirmedServiceChoice;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.io.AsnException;
import javax.baja.sys.BAbsTime;

public abstract class GenericTimeSyncRequest
extends BacnetUnconfirmedRequest {
    private BBacnetDateTime dateTime;

    public BBacnetDateTime getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(BBacnetDateTime bBacnetDateTime) {
        this.dateTime = bBacnetDateTime;
    }

    public BAbsTime getBAbsTime() {
        return this.getDateTime().toBAbsTime();
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeDate(this.dateTime.getDate());
        asnOutputStream.writeTime(this.dateTime.getTime());
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.dateTime = new BBacnetDateTime(asnInputStream.readDate(), asnInputStream.readTime());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(BacnetUnconfirmedServiceChoice.TAGS[this.getServiceChoice()]);
        stringBuffer.append("\n  dateTime " + this.dateTime);
        return stringBuffer.toString();
    }

    protected GenericTimeSyncRequest(int n, BAbsTime bAbsTime) {
        super(n);
        if (bAbsTime != null) {
            this.dateTime = new BBacnetDateTime(bAbsTime);
        }
    }
}

