/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.error;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.services.error.SimpleError;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.ChangeListError;

public class NChangeListError
extends SimpleError
implements ChangeListError {
    private long firstFailedElementNumber;

    public long getFirstFailedElementNumber() {
        return this.firstFailedElementNumber;
    }

    public Object[] getErrorParameters() {
        return new Object[]{new Long(this.firstFailedElementNumber)};
    }

    public void writeAsn(AsnOutput asnOutput) {
        asnOutput.writeOpeningTag(0);
        this.error.writeEncoded(asnOutput);
        asnOutput.writeClosingTag(0);
        asnOutput.writeUnsignedInteger(1, this.firstFailedElementNumber);
    }

    public void readAsn(AsnInput asnInput) throws AsnException {
        asnInput.skipTag();
        this.error = new NErrorType();
        this.error.readEncoded(asnInput);
        asnInput.skipTag();
        this.firstFailedElementNumber = asnInput.readUnsignedInteger(1);
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        this.writeAsn(asnOutputStream);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.readAsn(asnInputStream);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ChangeListError: ");
        stringBuffer.append("\n  errorType = " + this.error);
        stringBuffer.append("\n  firstFailedElementNumber = " + this.firstFailedElementNumber);
        return stringBuffer.toString();
    }

    public String toUserString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.error.toString());
        stringBuffer.append(" ");
        stringBuffer.append(this.firstFailedElementNumber);
        return stringBuffer.toString();
    }

    public NChangeListError(int n, NErrorType nErrorType, long l) {
        super(n, nErrorType);
        this.firstFailedElementNumber = l;
    }

    public NChangeListError(int n, byte[] byArray) throws AsnException {
        super(n);
        AsnInputStream asnInputStream = new AsnInputStream(byArray);
        this.readEncoded(asnInputStream);
    }
}

