/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.error;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.services.error.SimpleError;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.sys.BBlob;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConfirmedPrivateTransferError
extends SimpleError {
    public static final int ERROR_TYPE_TAG = 0;
    public static final int VENDOR_ID_TAG = 1;
    public static final int SERVICE_NUMBER_TAG = 2;
    public static final int ERROR_PARAMETERS_TAG = 3;
    private long vendorId;
    private long serviceNumber;
    private byte[] rawErrorParameters;

    public long getVendorId() {
        return this.vendorId;
    }

    public long getServiceNumber() {
        return this.serviceNumber;
    }

    public byte[] getRawErrorParameters() {
        return this.rawErrorParameters;
    }

    public Object[] getErrorParameters() {
        return new Object[]{new Long(this.vendorId), new Long(this.serviceNumber), BBlob.make((byte[])this.rawErrorParameters)};
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeOpeningTag(0);
        this.error.writeEncoded(asnOutputStream);
        asnOutputStream.writeClosingTag(0);
        asnOutputStream.writeUnsignedInteger(1, this.vendorId);
        asnOutputStream.writeUnsignedInteger(2, this.serviceNumber);
        if (this.rawErrorParameters != null) {
            asnOutputStream.writeEncodedValue(3, this.rawErrorParameters);
        }
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        asnInputStream.skipTag();
        this.error = new NErrorType();
        this.error.readEncoded(asnInputStream);
        asnInputStream.skipTag();
        this.vendorId = asnInputStream.readUnsignedInteger(1);
        this.serviceNumber = asnInputStream.readUnsignedInteger(2);
        asnInputStream.peekTag();
        this.rawErrorParameters = asnInputStream.isOpeningTag(3) ? asnInputStream.readEncodedValue(3) : new byte[0];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CreateObjectError: ");
        stringBuffer.append("\n  errorType:" + this.error.toString());
        stringBuffer.append("\n  vendorId:" + this.vendorId);
        stringBuffer.append("\n  serviceNumber:" + this.serviceNumber);
        if (this.rawErrorParameters != null && this.rawErrorParameters.length > 0) {
            stringBuffer.append("\n  errorParameters:" + ByteArrayUtil.toHexString((byte[])this.rawErrorParameters));
        }
        return stringBuffer.toString();
    }

    public String toUserString() {
        return this.error.toString();
    }

    private final /* synthetic */ void this() {
        this.rawErrorParameters = new byte[0];
    }

    public ConfirmedPrivateTransferError(ErrorType errorType, long l, long l2) {
        super(18, errorType);
        this.this();
        this.vendorId = l;
        this.serviceNumber = l2;
    }

    public ConfirmedPrivateTransferError(ErrorType errorType, long l, long l2, byte[] byArray) {
        super(18, errorType);
        this.this();
        this.vendorId = l;
        this.serviceNumber = l2;
        this.rawErrorParameters = byArray != null ? byArray : new byte[]{};
    }

    public ConfirmedPrivateTransferError(int n, byte[] byArray) throws AsnException {
        super(n);
        this.this();
        AsnInputStream asnInputStream = new AsnInputStream(byArray);
        this.readEncoded(asnInputStream);
    }
}

