/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.NBacnetPropertyValue;
import com.tridium.bacnet.asn.NWriteAccessSpec;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.BacnetError;
import com.tridium.bacnet.services.error.WritePropertyMultipleError;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.RejectException;

public class WritePropertyMultipleRequest
extends BacnetConfirmedRequest {
    private Vector listOfWriteAccessSpecs;

    public void addWriteAccessSpec(NWriteAccessSpec nWriteAccessSpec) {
        this.listOfWriteAccessSpecs.addElement(nWriteAccessSpec);
    }

    public void addWriteAccessSpec(BBacnetObjectIdentifier bBacnetObjectIdentifier, int[] nArray, Vector vector) {
        Vector<NBacnetPropertyValue> vector2 = new Vector<NBacnetPropertyValue>();
        int n = 0;
        while (n < nArray.length) {
            vector2.addElement(new NBacnetPropertyValue(nArray[n], (byte[])vector.elementAt(n)));
            ++n;
        }
        this.listOfWriteAccessSpecs.addElement(new NWriteAccessSpec(bBacnetObjectIdentifier, vector2));
    }

    public void addWriteAccessSpec(BBacnetObjectIdentifier bBacnetObjectIdentifier, int[] nArray, Vector vector, int[] nArray2) {
        Vector<NBacnetPropertyValue> vector2 = new Vector<NBacnetPropertyValue>();
        int n = 0;
        while (n < nArray.length) {
            vector2.addElement(new NBacnetPropertyValue(nArray[n], (byte[])vector.elementAt(n), nArray2[n]));
            ++n;
        }
        this.listOfWriteAccessSpecs.addElement(new NWriteAccessSpec(bBacnetObjectIdentifier, vector2));
    }

    public ListIterator getWriteAccessSpecs() {
        return this.listOfWriteAccessSpecs.listIterator();
    }

    public Vector getListOfWriteAccessSpecs() {
        return this.listOfWriteAccessSpecs;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        Iterator iterator = this.listOfWriteAccessSpecs.iterator();
        while (iterator.hasNext()) {
            NWriteAccessSpec nWriteAccessSpec = (NWriteAccessSpec)iterator.next();
            nWriteAccessSpec.writeAsn(asnOutputStream);
        }
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException, RejectException {
        while (asnInputStream.peekTag() != -1) {
            NWriteAccessSpec nWriteAccessSpec = new NWriteAccessSpec();
            nWriteAccessSpec.readAsn(asnInputStream);
            this.listOfWriteAccessSpecs.addElement(nWriteAccessSpec);
        }
    }

    public BacnetError doParseError(int n, byte[] byArray) throws AsnException {
        return new WritePropertyMultipleError(n, byArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("WritePropertyMultipleRequest: ");
        Iterator iterator = this.listOfWriteAccessSpecs.iterator();
        while (iterator.hasNext()) {
            NWriteAccessSpec nWriteAccessSpec = (NWriteAccessSpec)iterator.next();
            stringBuffer.append(nWriteAccessSpec.toString());
        }
        return stringBuffer.toString();
    }

    public WritePropertyMultipleRequest() {
        super(16);
        this.listOfWriteAccessSpecs = new Vector();
    }

    public WritePropertyMultipleRequest(Vector vector) {
        super(16);
        this.listOfWriteAccessSpecs = vector;
    }
}

