/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.RejectException;

public class SubscribeCovRequest
extends BacnetConfirmedRequest {
    public static final int SUBSCRIBER_PROCESS_ID_TAG = 0;
    public static final int MONITORED_OBJECT_ID_TAG = 1;
    public static final int ISSUE_CONFIRMED_NOTIFICATIONS_TAG = 2;
    public static final int LIFETIME_TAG = 3;
    private long subscriberProcessId;
    private BBacnetObjectIdentifier monitoredObjectId;
    private boolean issueConfirmedNotifications;
    private long lifetime;
    private boolean isCancellation;

    public long getSubscriberProcessId() {
        return this.subscriberProcessId;
    }

    public void setSubscriberProcessId(long l) {
        this.subscriberProcessId = l;
    }

    public BBacnetObjectIdentifier getMonitoredObjectId() {
        return this.monitoredObjectId;
    }

    public void setMonitoredObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.monitoredObjectId = bBacnetObjectIdentifier;
    }

    public boolean getIssueConfirmedNotifications() {
        return this.issueConfirmedNotifications;
    }

    public void setIssueConfirmedNotifications(boolean bl) {
        this.issueConfirmedNotifications = bl;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(long l) {
        this.lifetime = l;
    }

    public boolean isCancellation() {
        return this.isCancellation;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeUnsignedInteger(0, this.subscriberProcessId);
        asnOutputStream.writeObjectIdentifier(1, this.monitoredObjectId);
        if (!this.isCancellation) {
            asnOutputStream.writeBoolean(2, this.issueConfirmedNotifications);
            asnOutputStream.writeUnsignedInteger(3, this.lifetime);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readEncoded(AsnInputStream asnInputStream) throws AsnException, RejectException {
        this.subscriberProcessId = asnInputStream.readUnsignedInteger(0);
        this.monitoredObjectId = asnInputStream.readObjectIdentifier(1);
        int n = asnInputStream.peekTag();
        if (n == -1) {
            this.isCancellation = true;
        } else {
            if (!asnInputStream.isValueTag(2)) throw new RejectException(2);
            this.issueConfirmedNotifications = asnInputStream.readBoolean(2);
        }
        n = asnInputStream.peekTag();
        if (n == -1) {
            this.lifetime = 0L;
            return;
        }
        if (!asnInputStream.isValueTag(3)) throw new RejectException(4);
        try {
            this.lifetime = asnInputStream.readUnsignedInteger(3);
            return;
        }
        catch (AsnException asnException) {
            String string = asnException.getMessage();
            if (string == null || !string.equalsIgnoreCase("Integer overflow")) return;
            throw new RejectException(6);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SubscribeCovRequest: ");
        stringBuffer.append("\n processId: " + this.subscriberProcessId);
        stringBuffer.append("\n objectId: " + (Object)((Object)this.monitoredObjectId));
        if (this.isCancellation) {
            stringBuffer.append("\n CANCELLATION");
        } else {
            stringBuffer.append("\n issueConf: " + this.issueConfirmedNotifications);
            stringBuffer.append("\n lifetime: " + this.lifetime);
        }
        return stringBuffer.toString();
    }

    public SubscribeCovRequest() {
        super(5);
    }

    public SubscribeCovRequest(long l, BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this(l, bBacnetObjectIdentifier, false, 0L, true);
    }

    public SubscribeCovRequest(long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, boolean bl) {
        this(l, bBacnetObjectIdentifier, bl, 0L, false);
    }

    public SubscribeCovRequest(long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, boolean bl, long l2) {
        this(l, bBacnetObjectIdentifier, bl, l2, false);
    }

    private SubscribeCovRequest(long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, boolean bl, long l2, boolean bl2) {
        super(5);
        this.subscriberProcessId = l;
        this.monitoredObjectId = bBacnetObjectIdentifier;
        this.issueConfirmedNotifications = bl;
        this.lifetime = l2;
        this.isCancellation = bl2;
    }
}

