/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.NBacnetPropertyReference;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.sys.BDouble;

public class SubscribeCovPropertyRequest
extends BacnetConfirmedRequest {
    public static final int SUBSCRIBER_PROCESS_ID_TAG = 0;
    public static final int MONITORED_OBJECT_ID_TAG = 1;
    public static final int ISSUE_CONFIRMED_NOTIFICATIONS_TAG = 2;
    public static final int LIFETIME_TAG = 3;
    public static final int MONITORED_PROPERTY_ID_TAG = 4;
    public static final int COV_INCREMENT_TAG = 5;
    private long subscriberProcessId;
    private BBacnetObjectIdentifier monitoredObjectId;
    private boolean issueConfirmedNotifications;
    private long lifetime;
    private boolean isCancellation;
    private PropertyReference monitoredPropertyId;
    private BDouble covIncrement;

    public long getSubscriberProcessId() {
        return this.subscriberProcessId;
    }

    public void setSubscriberProcessId(long l) {
        this.subscriberProcessId = l;
    }

    public BBacnetObjectIdentifier getMonitoredObjectId() {
        return this.monitoredObjectId;
    }

    public void setMonitoredObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.monitoredObjectId = bBacnetObjectIdentifier;
    }

    public boolean getIssueConfirmedNotifications() {
        return this.issueConfirmedNotifications;
    }

    public void setIssueConfirmedNotifications(boolean bl) {
        this.issueConfirmedNotifications = bl;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(long l) {
        this.lifetime = l;
    }

    public PropertyReference getMonitoredPropertyId() {
        return this.monitoredPropertyId;
    }

    public void setMonitoredPropertyId(PropertyReference propertyReference) {
        this.monitoredPropertyId = propertyReference;
    }

    public int getMonitoredPropertyIdentifier() {
        return this.monitoredPropertyId.getPropertyId();
    }

    public int getMonitoredPropertyArrayIndex() {
        return this.monitoredPropertyId.getPropertyArrayIndex();
    }

    public BDouble getCovIncrement() {
        return this.covIncrement;
    }

    public void setCovIncrement(BDouble bDouble) {
        this.covIncrement = bDouble;
    }

    public boolean isCancellation() {
        return this.isCancellation;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeUnsignedInteger(0, this.subscriberProcessId);
        asnOutputStream.writeObjectIdentifier(1, this.monitoredObjectId);
        if (!this.isCancellation) {
            asnOutputStream.writeBoolean(2, this.issueConfirmedNotifications);
            asnOutputStream.writeUnsignedInteger(3, this.lifetime);
        }
        asnOutputStream.writeOpeningTag(4);
        this.monitoredPropertyId.writeAsn(asnOutputStream);
        asnOutputStream.writeClosingTag(4);
        if (this.covIncrement != null) {
            asnOutputStream.writeReal(5, this.covIncrement.getFloat());
        }
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException, RejectException {
        this.subscriberProcessId = asnInputStream.readUnsignedInteger(0);
        this.monitoredObjectId = asnInputStream.readObjectIdentifier(1);
        asnInputStream.peekTag();
        if (asnInputStream.isOpeningTag(4)) {
            this.isCancellation = true;
        } else if (asnInputStream.isValueTag(2)) {
            this.issueConfirmedNotifications = asnInputStream.readBoolean(2);
        } else {
            throw new RejectException(2);
        }
        asnInputStream.peekTag();
        if (asnInputStream.isOpeningTag(4)) {
            this.lifetime = 0L;
        } else if (asnInputStream.isValueTag(3)) {
            this.lifetime = asnInputStream.readUnsignedInteger(3);
        } else {
            throw new RejectException(4);
        }
        asnInputStream.peekTag();
        if (asnInputStream.isOpeningTag(4)) {
            asnInputStream.skipTag();
            this.monitoredPropertyId = new NBacnetPropertyReference();
            this.monitoredPropertyId.readAsn(asnInputStream);
            asnInputStream.skipTag();
        }
        asnInputStream.peekTag();
        this.covIncrement = asnInputStream.isValueTag(5) ? BDouble.make((double)asnInputStream.readReal(5)) : null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SubscribeCovRequest: ");
        stringBuffer.append("\n processId: " + this.subscriberProcessId);
        stringBuffer.append("\n objectId: " + (Object)((Object)this.monitoredObjectId));
        if (this.isCancellation) {
            stringBuffer.append("\n CANCELLATION");
        } else {
            stringBuffer.append("\n issueConf: " + this.issueConfirmedNotifications);
            stringBuffer.append("\n lifetime: " + this.lifetime);
        }
        stringBuffer.append("\n propertyId: " + this.monitoredPropertyId);
        if (this.covIncrement != null) {
            stringBuffer.append("\n covIncrement: " + this.covIncrement);
        }
        return stringBuffer.toString();
    }

    public SubscribeCovPropertyRequest() {
        super(28);
    }

    public SubscribeCovPropertyRequest(long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, PropertyReference propertyReference) {
        this(l, bBacnetObjectIdentifier, false, 0L, propertyReference, null, true);
    }

    public SubscribeCovPropertyRequest(long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, boolean bl, PropertyReference propertyReference, BDouble bDouble) {
        this(l, bBacnetObjectIdentifier, bl, 0L, propertyReference, bDouble, false);
    }

    public SubscribeCovPropertyRequest(long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, boolean bl, long l2, PropertyReference propertyReference, BDouble bDouble) {
        this(l, bBacnetObjectIdentifier, bl, l2, propertyReference, bDouble, false);
    }

    private SubscribeCovPropertyRequest(long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, boolean bl, long l2, PropertyReference propertyReference, BDouble bDouble, boolean bl2) {
        super(28);
        this.subscriberProcessId = l;
        this.monitoredObjectId = bBacnetObjectIdentifier;
        this.issueConfirmedNotifications = bl;
        this.lifetime = l2;
        this.monitoredPropertyId = propertyReference;
        this.covIncrement = bDouble;
        this.isCancellation = bl2;
    }
}

