/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import javax.baja.bacnet.enums.BBacnetReinitializedDeviceState;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.io.AsnException;
import javax.baja.sys.BEnum;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ReinitializeDeviceRequest
extends BacnetConfirmedRequest {
    public static final int REINITIALIZED_STATE_OF_DEVICE_TAG = 0;
    public static final int PASSWORD_TAG = 1;
    private BBacnetReinitializedDeviceState reinitializedStateOfDevice;
    private String password;
    private BCharacterSetEncoding encoding;

    public BBacnetReinitializedDeviceState getReinitializedStateOfDevice() {
        return this.reinitializedStateOfDevice;
    }

    public void setReinitializedStateOfDevice(BBacnetReinitializedDeviceState bBacnetReinitializedDeviceState) {
        this.reinitializedStateOfDevice = bBacnetReinitializedDeviceState;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public boolean isPasswordUsed() {
        boolean bl = false;
        if (this.password != null) {
            bl = true;
        }
        return bl;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeEnumerated(0, (BEnum)this.reinitializedStateOfDevice);
        if (this.isPasswordUsed()) {
            asnOutputStream.writeCharacterString(1, this.password, this.encoding);
        }
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.reinitializedStateOfDevice = BBacnetReinitializedDeviceState.make(asnInputStream.readEnumerated(0));
        if (asnInputStream.peekTag() == 1) {
            this.encoding = asnInputStream.peekEncoding(1);
            this.password = asnInputStream.readCharacterString(1);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ReinitializeDeviceRequest: ");
        stringBuffer.append("\n reinitializedStateOfDevice: " + (Object)((Object)this.reinitializedStateOfDevice));
        if (this.isPasswordUsed()) {
            stringBuffer.append("\n password: " + this.password);
            stringBuffer.append("\n encoding: " + this.encoding.getTag());
        }
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.password = null;
        this.encoding = null;
    }

    public ReinitializeDeviceRequest() {
        super(20);
        this.this();
    }

    public ReinitializeDeviceRequest(BBacnetReinitializedDeviceState bBacnetReinitializedDeviceState) {
        this(bBacnetReinitializedDeviceState, null, null);
    }

    public ReinitializeDeviceRequest(BBacnetReinitializedDeviceState bBacnetReinitializedDeviceState, String string, BCharacterSetEncoding bCharacterSetEncoding) {
        super(20);
        this.this();
        this.reinitializedStateOfDevice = bBacnetReinitializedDeviceState;
        this.password = string;
        this.encoding = bCharacterSetEncoding;
    }
}

