/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.services.BacnetComplexAck;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.sys.BEnum;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ReadRangeAck
extends BacnetComplexAck
implements RangeData {
    public static final int OBJECT_ID_TAG = 0;
    public static final int PROPERTY_ID_TAG = 1;
    public static final int PROPERTY_ARRAY_INDEX_TAG = 2;
    public static final int RESULT_FLAGS_TAG = 3;
    public static final int ITEM_COUNT_TAG = 4;
    public static final int ITEM_DATA_TAG = 5;
    public static final int FIRST_SEQUENCE_NUMBER_TAG = 6;
    public static final int READ_RANGE_ACK_MAX_APP_HEADER_SIZE = 23;
    private BBacnetObjectIdentifier objectId;
    private int propertyId;
    private int propertyArrayIndex;
    private BBacnetBitString resultFlags;
    private long itemCount;
    private long firstSequenceNumber;
    private byte[] itemData;
    private boolean isError;
    private int errorClass;
    private int errorCode;

    public BBacnetObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.objectId = bBacnetObjectIdentifier;
    }

    public int getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(BEnum bEnum) {
        this.propertyId = bEnum.getOrdinal();
    }

    public void setPropertyId(int n) {
        this.propertyId = n;
    }

    public boolean isPropertyArrayIndexUsed() {
        boolean bl = false;
        if (this.propertyArrayIndex != -1) {
            bl = true;
        }
        return bl;
    }

    public int getPropertyArrayIndex() {
        return this.propertyArrayIndex;
    }

    public void setPropertyArrayIndex(int n) {
        this.propertyArrayIndex = n;
    }

    public BBacnetBitString getResultFlags() {
        return this.resultFlags;
    }

    public boolean includesFirstItem() {
        return this.resultFlags.getBit(0);
    }

    public boolean includesLastItem() {
        return this.resultFlags.getBit(1);
    }

    public boolean isMoreItems() {
        return this.resultFlags.getBit(2);
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.itemCount <= 0L) {
            bl = true;
        }
        return bl;
    }

    public long getItemCount() {
        return this.itemCount;
    }

    public boolean isFirstSequenceNumberUsed() {
        boolean bl = false;
        if (this.firstSequenceNumber != (long)-1) {
            bl = true;
        }
        return bl;
    }

    public long getFirstSequenceNumber() {
        return this.firstSequenceNumber;
    }

    public byte[] getItemData() {
        return this.itemData;
    }

    public ErrorType getError() {
        return new NErrorType(this.errorClass, this.errorCode);
    }

    public int getErrorClass() {
        return this.errorClass;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public boolean isError() {
        return this.isError;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ReadRangeAck)) {
            return false;
        }
        ReadRangeAck readRangeAck = (ReadRangeAck)object;
        if (this.isError) {
            if (!readRangeAck.isError) {
                return false;
            }
            boolean bl = false;
            if (this.errorClass == readRangeAck.errorClass && this.errorCode == readRangeAck.errorCode) {
                bl = true;
            }
            return bl;
        }
        if (readRangeAck.isError) {
            return false;
        }
        if (!this.objectId.equals((Object)readRangeAck.objectId)) {
            return false;
        }
        if (this.propertyId != readRangeAck.propertyId) {
            return false;
        }
        if (this.propertyArrayIndex != readRangeAck.propertyArrayIndex) {
            return false;
        }
        if (this.itemCount != readRangeAck.itemCount) {
            return false;
        }
        if (this.firstSequenceNumber != readRangeAck.firstSequenceNumber) {
            return false;
        }
        if (this.resultFlags != null) {
            if (readRangeAck.resultFlags == null) {
                return false;
            }
            if (!this.resultFlags.equals((Object)readRangeAck.resultFlags)) {
                return false;
            }
        } else if (readRangeAck.resultFlags != null) {
            return false;
        }
        return ByteArrayUtil.equals((byte[])this.itemData, (byte[])readRangeAck.itemData);
    }

    public void writeAsn(AsnOutput asnOutput) {
        this.writeEncoded((AsnOutputStream)asnOutput);
    }

    public void readAsn(AsnInput asnInput) throws AsnException {
        this.readEncoded((AsnInputStream)asnInput);
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        if (this.isError) {
            asnOutputStream.writeEnumerated(this.errorClass);
            asnOutputStream.writeEnumerated(this.errorCode);
        } else {
            asnOutputStream.writeObjectIdentifier(0, this.objectId);
            asnOutputStream.writeEnumerated(1, this.propertyId);
            if (this.propertyArrayIndex != -1) {
                asnOutputStream.writeUnsignedInteger(2, this.propertyArrayIndex);
            }
            asnOutputStream.writeBitString(3, this.resultFlags);
            asnOutputStream.writeUnsignedInteger(4, this.itemCount);
            asnOutputStream.writeEncodedValue(5, this.itemData);
            if (this.isFirstSequenceNumberUsed()) {
                asnOutputStream.writeUnsignedInteger(6, this.firstSequenceNumber);
            }
        }
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.objectId = asnInputStream.readObjectIdentifier(0);
        this.propertyId = asnInputStream.readEnumerated(1);
        asnInputStream.peekTag();
        this.propertyArrayIndex = asnInputStream.isValueTag(2) ? asnInputStream.readUnsignedInt(2) : -1;
        this.resultFlags = asnInputStream.readBitString(3);
        this.itemCount = asnInputStream.readUnsignedInteger(4);
        this.itemData = asnInputStream.readEncodedValue(5);
        int n = asnInputStream.peekTag();
        this.firstSequenceNumber = n != -1 ? asnInputStream.readUnsignedInteger(6) : (long)-1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ReadRangeACK: ");
        stringBuffer.append("\n  objId  " + (Object)((Object)this.objectId));
        stringBuffer.append("\n  propId " + this.propertyId);
        if (this.propertyArrayIndex != -1) {
            stringBuffer.append("[" + this.propertyArrayIndex + ']');
        }
        stringBuffer.append("\n  rFlags " + this.resultFlags.toString(BacnetBitStringUtil.BacnetResultFlags));
        stringBuffer.append("\n  itmCnt " + this.itemCount);
        stringBuffer.append("\n  frstSN " + this.firstSequenceNumber);
        stringBuffer.append("\n  itmDta " + ByteArrayUtil.toHexString((byte[])this.itemData));
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.objectId = null;
        this.propertyId = -1;
        this.propertyArrayIndex = -1;
        this.resultFlags = null;
        this.itemCount = -1;
        this.firstSequenceNumber = -1;
        this.itemData = null;
        this.isError = false;
        this.errorClass = -1;
        this.errorCode = -1;
    }

    public ReadRangeAck() {
        super(26);
        this.this();
    }

    public ReadRangeAck(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, BBacnetBitString bBacnetBitString, long l, long l2, byte[] byArray) {
        this(bBacnetObjectIdentifier, n, -1, bBacnetBitString, l, l2, byArray);
    }

    public ReadRangeAck(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, BBacnetBitString bBacnetBitString, long l, byte[] byArray) {
        this(bBacnetObjectIdentifier, n, n2, bBacnetBitString, l, -1, byArray);
    }

    public ReadRangeAck(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, BBacnetBitString bBacnetBitString, long l, long l2, byte[] byArray) {
        super(26);
        this.this();
        this.objectId = bBacnetObjectIdentifier;
        this.propertyId = n;
        this.propertyArrayIndex = n2;
        this.resultFlags = bBacnetBitString;
        this.itemCount = l;
        this.firstSequenceNumber = l2;
        this.itemData = byArray;
    }

    public ReadRangeAck(int n, AsnInputStream asnInputStream) throws AsnException {
        super(n);
        this.this();
        this.readEncoded(asnInputStream);
    }

    public ReadRangeAck(int n, int n2) {
        super(26);
        this.this();
        this.isError = true;
        this.errorClass = n;
        this.errorCode = n2;
    }
}

