/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.NBacnetPropertyReference;
import com.tridium.bacnet.asn.NReadAccessSpec;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.confirmed.ReadPropertyMultipleAck;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.RejectException;
import javax.baja.nre.util.Array;

public class ReadPropertyMultipleRequest
extends BacnetConfirmedRequest {
    private Vector listOfReadAccessSpecs;

    public void addReadAccessSpec(NReadAccessSpec nReadAccessSpec) {
        this.listOfReadAccessSpecs.addElement(nReadAccessSpec);
    }

    public void addReadAccessSpec(BBacnetObjectIdentifier bBacnetObjectIdentifier, int[] nArray) {
        Vector<NBacnetPropertyReference> vector = new Vector<NBacnetPropertyReference>();
        int n = 0;
        while (n < nArray.length) {
            vector.addElement(new NBacnetPropertyReference(nArray[n]));
            ++n;
        }
        this.listOfReadAccessSpecs.addElement(new NReadAccessSpec(bBacnetObjectIdentifier, vector));
    }

    public ListIterator getReadAccessSpecs() {
        return this.listOfReadAccessSpecs.listIterator();
    }

    public Vector getListOfReadAccessSpecs() {
        return this.listOfReadAccessSpecs;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        Iterator iterator = this.listOfReadAccessSpecs.iterator();
        while (iterator.hasNext()) {
            NReadAccessSpec nReadAccessSpec = (NReadAccessSpec)iterator.next();
            nReadAccessSpec.writeAsn(asnOutputStream);
        }
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException, RejectException {
        while (asnInputStream.peekTag() != -1) {
            NReadAccessSpec nReadAccessSpec = new NReadAccessSpec();
            nReadAccessSpec.readAsn(asnInputStream);
            this.listOfReadAccessSpecs.addElement(nReadAccessSpec);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ReadPropertyMultipleRequest: ");
        Iterator iterator = this.listOfReadAccessSpecs.iterator();
        while (iterator.hasNext()) {
            NReadAccessSpec nReadAccessSpec = (NReadAccessSpec)iterator.next();
            stringBuffer.append(nReadAccessSpec.toString());
        }
        return stringBuffer.toString();
    }

    protected BacnetServicePrimitive doParseAck(int n, AsnInputStream asnInputStream) throws AsnException {
        return new ReadPropertyMultipleAck(n, asnInputStream);
    }

    public ReadPropertyMultipleRequest() {
        super(14);
        this.listOfReadAccessSpecs = new Vector();
    }

    public ReadPropertyMultipleRequest(NReadAccessSpec nReadAccessSpec) {
        super(14);
        this.listOfReadAccessSpecs = new Vector();
        this.listOfReadAccessSpecs.addElement(nReadAccessSpec);
    }

    public ReadPropertyMultipleRequest(Vector vector) {
        super(14);
        this.listOfReadAccessSpecs = vector;
    }

    public ReadPropertyMultipleRequest(Array array) {
        super(14);
        this.listOfReadAccessSpecs = new Vector();
        if (array == null) {
            return;
        }
        ListIterator listIterator = array.iterator();
        while (listIterator.hasNext()) {
            this.listOfReadAccessSpecs.addElement(listIterator.next());
        }
    }
}

