/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.confirmed.GetEventInformationAck;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.RejectException;

public class GetEventInformationRequest
extends BacnetConfirmedRequest {
    public static final int LAST_RECEIVED_OBJECT_ID_TAG = 0;
    private BBacnetObjectIdentifier lastReceivedObjectId;

    public BBacnetObjectIdentifier getLastReceivedObjectId() {
        return this.lastReceivedObjectId;
    }

    public void setLastReceivedObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.lastReceivedObjectId = bBacnetObjectIdentifier;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        if (this.lastReceivedObjectId != null) {
            asnOutputStream.writeObjectIdentifier(0, this.lastReceivedObjectId);
        }
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException, RejectException {
        if (asnInputStream.peekTag() != -1) {
            this.lastReceivedObjectId = asnInputStream.readObjectIdentifier(0);
        }
    }

    public BacnetServicePrimitive doParseAck(int n, AsnInputStream asnInputStream) throws AsnException {
        return new GetEventInformationAck(n, asnInputStream);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("GetEventInformationRequest: ");
        stringBuffer.append("\n  " + (Object)((Object)this.lastReceivedObjectId));
        return stringBuffer.toString();
    }

    public GetEventInformationRequest() {
        super(29);
    }

    public GetEventInformationRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        super(29);
        this.lastReceivedObjectId = bBacnetObjectIdentifier;
    }
}

