/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.datatypes.BPriorityFilter;
import com.tridium.bacnet.enums.BAcknowledgmentFilter;
import com.tridium.bacnet.enums.BEventStateFilter;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.confirmed.GetEnrollmentSummaryAck;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetRecipientProcess;
import javax.baja.bacnet.enums.BExtensibleEnumList;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.RejectException;
import javax.baja.sys.BEnum;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GetEnrollmentSummaryRequest
extends BacnetConfirmedRequest {
    public static final int ACKNOWLEDGMENT_FILTER_TAG = 0;
    public static final int ENROLLMENT_FILTER_TAG = 1;
    public static final int EVENT_STATE_FILTER_TAG = 2;
    public static final int EVENT_TYPE_FILTER_TAG = 3;
    public static final int PRIORITY_FILTER_TAG = 4;
    public static final int NOTIFICATION_CLASS_FILTER_TAG = 5;
    public static final int MIN_PRIORITY_TAG = 0;
    public static final int MAX_PRIORITY_TAG = 1;
    private BAcknowledgmentFilter acknowledgmentFilter;
    private BBacnetRecipientProcess enrollmentFilter;
    private BEventStateFilter eventStateFilter;
    private BEnum eventTypeFilter;
    private BPriorityFilter priorityFilter;
    private long notificationClassFilter;

    public boolean isEnrollmentFilter() {
        boolean bl = false;
        if (this.enrollmentFilter != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isEventStateFilter() {
        boolean bl = false;
        if (this.eventStateFilter != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isEventTypeFilter() {
        boolean bl = false;
        if (this.eventTypeFilter != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isPriorityFilter() {
        boolean bl = false;
        if (this.priorityFilter != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isNotificationClassFilter() {
        boolean bl = false;
        if (this.notificationClassFilter >= 0L) {
            bl = true;
        }
        return bl;
    }

    public BAcknowledgmentFilter getAcknowledgmentFilter() {
        return this.acknowledgmentFilter;
    }

    public void setAcknowledgmentFilter(BAcknowledgmentFilter bAcknowledgmentFilter) {
        this.acknowledgmentFilter = bAcknowledgmentFilter;
    }

    public BBacnetRecipientProcess getEnrollmentFilter() {
        return this.enrollmentFilter;
    }

    public void setEnrollmentFilter(BBacnetRecipientProcess bBacnetRecipientProcess) {
        this.enrollmentFilter = bBacnetRecipientProcess;
    }

    public BEventStateFilter getEventStateFilter() {
        return this.eventStateFilter;
    }

    public void setEventStateFilter(BEventStateFilter bEventStateFilter) {
        this.eventStateFilter = bEventStateFilter;
    }

    public BEnum getEventTypeFilter() {
        return this.eventTypeFilter;
    }

    public void setEventTypeFilter(BEnum bEnum) {
        this.eventTypeFilter = bEnum;
    }

    public BPriorityFilter getPriorityFilter() {
        return this.priorityFilter;
    }

    public void setPriorityFilter(BPriorityFilter bPriorityFilter) {
        this.priorityFilter = bPriorityFilter;
    }

    public long getNotificationClassFilter() {
        return this.notificationClassFilter;
    }

    public void setNotificationClassFilter(long l) {
        this.notificationClassFilter = l;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeEnumerated(0, (BEnum)this.acknowledgmentFilter);
        if (this.enrollmentFilter != null) {
            asnOutputStream.writeOpeningTag(1);
            this.enrollmentFilter.writeAsn(asnOutputStream);
            asnOutputStream.writeClosingTag(1);
        }
        if (this.eventStateFilter != null) {
            asnOutputStream.writeEnumerated(2, (BEnum)this.eventStateFilter);
        }
        if (this.eventTypeFilter != null) {
            asnOutputStream.writeEnumerated(3, this.eventTypeFilter);
        }
        if (this.priorityFilter != null) {
            asnOutputStream.writeOpeningTag(4);
            asnOutputStream.writeUnsignedInteger(0, this.priorityFilter.getMinPriority());
            asnOutputStream.writeUnsignedInteger(1, this.priorityFilter.getMaxPriority());
            asnOutputStream.writeClosingTag(4);
        }
        if (this.notificationClassFilter >= 0L) {
            asnOutputStream.writeUnsignedInteger(5, this.notificationClassFilter);
        }
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException, RejectException {
        this.readEncoded(null, asnInputStream);
    }

    public void readEncoded(BBacnetObjectIdentifier bBacnetObjectIdentifier, AsnInputStream asnInputStream) throws AsnException, RejectException {
        BBacnetDevice bBacnetDevice;
        BExtensibleEnumList bExtensibleEnumList = BBacnetNetwork.localDevice().getEnumerationList();
        if (bBacnetObjectIdentifier != null && (bBacnetDevice = BBacnetNetwork.bacnet().doLookupDeviceById(bBacnetObjectIdentifier)) != null) {
            bExtensibleEnumList = bBacnetDevice.getEnumerationList();
        }
        this.acknowledgmentFilter = BAcknowledgmentFilter.make(asnInputStream.readEnumerated(0));
        int n = asnInputStream.peekTag();
        if (asnInputStream.isOpeningTag(1)) {
            asnInputStream.skipTag();
            this.enrollmentFilter = new BBacnetRecipientProcess();
            this.enrollmentFilter.readAsn(asnInputStream);
            asnInputStream.skipTag();
            n = asnInputStream.peekTag();
        }
        if (asnInputStream.isValueTag(2)) {
            this.eventStateFilter = BEventStateFilter.make(asnInputStream.readEnumerated(2));
            n = asnInputStream.peekTag();
        }
        if (asnInputStream.isValueTag(3)) {
            int n2 = asnInputStream.readEnumerated(3);
            this.eventTypeFilter = bExtensibleEnumList.getEventType().getRange().get(n2);
            n = asnInputStream.peekTag();
        }
        if (asnInputStream.isOpeningTag(4)) {
            asnInputStream.skipTag();
            this.priorityFilter = new BPriorityFilter(asnInputStream.readUnsignedInt(0), asnInputStream.readUnsignedInt(1));
            asnInputStream.skipTag();
            n = asnInputStream.peekTag();
        }
        if (asnInputStream.isValueTag(5)) {
            this.notificationClassFilter = asnInputStream.readUnsignedInteger(5);
        } else if (n != -1) {
            throw new RejectException(4);
        }
    }

    public BacnetServicePrimitive doParseAck(int n, AsnInputStream asnInputStream) throws AsnException {
        return new GetEnrollmentSummaryAck(n, asnInputStream);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("GetEnrollmentSummaryRequest: ");
        stringBuffer.append("\n  " + (Object)((Object)this.acknowledgmentFilter));
        stringBuffer.append("\n  " + this.enrollmentFilter);
        stringBuffer.append("\n  " + (Object)((Object)this.eventStateFilter));
        stringBuffer.append("\n  " + this.eventTypeFilter);
        stringBuffer.append("\n  " + (Object)((Object)this.priorityFilter));
        stringBuffer.append("\n  " + this.notificationClassFilter);
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.notificationClassFilter = -1;
    }

    public GetEnrollmentSummaryRequest() {
        super(4);
        this.this();
    }

    public GetEnrollmentSummaryRequest(int n, BBacnetRecipientProcess bBacnetRecipientProcess, int n2, BEnum bEnum, int[] nArray, long l) {
        super(4);
        this.this();
        this.acknowledgmentFilter = BAcknowledgmentFilter.make(n);
        this.enrollmentFilter = bBacnetRecipientProcess;
        if (n2 >= 0) {
            this.eventStateFilter = BEventStateFilter.make(n2);
        }
        this.eventTypeFilter = bEnum;
        if (nArray != null && nArray.length >= 2) {
            this.priorityFilter = new BPriorityFilter(nArray[0], nArray[1]);
        }
        this.notificationClassFilter = l;
    }

    public GetEnrollmentSummaryRequest(BAcknowledgmentFilter bAcknowledgmentFilter, BBacnetRecipientProcess bBacnetRecipientProcess, BEventStateFilter bEventStateFilter, BEnum bEnum, BPriorityFilter bPriorityFilter, long l) {
        super(4);
        this.this();
        this.acknowledgmentFilter = bAcknowledgmentFilter;
        this.enrollmentFilter = bBacnetRecipientProcess;
        this.eventStateFilter = bEventStateFilter;
        this.eventTypeFilter = bEnum;
        this.priorityFilter = bPriorityFilter;
        this.notificationClassFilter = l;
    }
}

