/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import javax.baja.bacnet.enums.BBacnetCommControl;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.io.AsnException;
import javax.baja.sys.BEnum;
import javax.baja.sys.BRelTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DeviceCommunicationControlRequest
extends BacnetConfirmedRequest {
    public static final int DURATION_TAG = 0;
    public static final int ENABLE_DISABLE_TAG = 1;
    public static final int PASSWORD_TAG = 2;
    private BRelTime duration;
    private BBacnetCommControl enableDisable;
    private String password;
    private BCharacterSetEncoding encoding;

    public BRelTime getDuration() {
        return this.duration;
    }

    public void setDuration(BRelTime bRelTime) {
        this.duration = bRelTime;
    }

    public boolean isDurationUsed() {
        boolean bl = false;
        if (this.duration != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isIndefinite() {
        boolean bl = false;
        if (this.duration.getMillis() == 0L) {
            bl = true;
        }
        return bl;
    }

    public BBacnetCommControl getEnableDisable() {
        return this.enableDisable;
    }

    public void setEnableDisable(BBacnetCommControl bBacnetCommControl) {
        this.enableDisable = bBacnetCommControl;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public boolean isPasswordUsed() {
        boolean bl = false;
        if (this.password != null) {
            bl = true;
        }
        return bl;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        if (this.isDurationUsed()) {
            asnOutputStream.writeUnsignedInteger(0, this.duration.getMinutes());
        }
        asnOutputStream.writeEnumerated(1, (BEnum)this.enableDisable);
        if (this.isPasswordUsed()) {
            asnOutputStream.writeCharacterString(2, this.password, this.encoding);
        }
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        asnInputStream.peekTag();
        if (asnInputStream.isValueTag(0)) {
            this.duration = BRelTime.make((long)(asnInputStream.readUnsignedInteger(0) * 60000L));
        }
        this.enableDisable = BBacnetCommControl.make(asnInputStream.readEnumerated(1));
        if (asnInputStream.peekTag() == 2) {
            this.encoding = asnInputStream.peekEncoding(2);
            this.password = asnInputStream.readCharacterString(2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("DeviceCommunicationControlRequest: ");
        stringBuffer.append("\n duration: ");
        if (this.isDurationUsed()) {
            if (this.isIndefinite()) {
                stringBuffer.append("indefinite");
            } else {
                stringBuffer.append(this.duration.toString());
            }
        } else {
            stringBuffer.append("not used");
        }
        stringBuffer.append("\n enableDisable: " + (Object)((Object)this.enableDisable));
        if (this.isPasswordUsed()) {
            stringBuffer.append("\n password: " + this.password);
            stringBuffer.append("\n encoding: " + this.encoding.getTag());
        }
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.duration = null;
        this.password = null;
        this.encoding = null;
    }

    public DeviceCommunicationControlRequest() {
        super(17);
        this.this();
    }

    public DeviceCommunicationControlRequest(BBacnetCommControl bBacnetCommControl) {
        this(null, bBacnetCommControl, null, null);
    }

    public DeviceCommunicationControlRequest(BRelTime bRelTime, BBacnetCommControl bBacnetCommControl) {
        this(bRelTime, bBacnetCommControl, null, null);
    }

    public DeviceCommunicationControlRequest(BRelTime bRelTime, BBacnetCommControl bBacnetCommControl, String string, BCharacterSetEncoding bCharacterSetEncoding) {
        super(17);
        this.this();
        this.duration = bRelTime;
        this.enableDisable = bBacnetCommControl;
        this.password = string;
        this.encoding = bCharacterSetEncoding;
    }
}

