/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.services.BacnetComplexAck;
import javax.baja.bacnet.io.AsnException;
import javax.baja.util.ByteArrayUtil;

public class ConfirmedPrivateTransferAck
extends BacnetComplexAck {
    public static final int VENDOR_ID_TAG = 0;
    public static final int SERVICE_NUMBER_TAG = 1;
    public static final int RESULT_BLOCK_TAG = 2;
    private long vendorId;
    private long serviceNumber;
    private byte[] resultBlock;

    public byte[] getResultBlock() {
        return this.resultBlock;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeUnsignedInteger(0, this.vendorId);
        asnOutputStream.writeUnsignedInteger(1, this.serviceNumber);
        if (this.resultBlock != null && this.resultBlock.length > 0) {
            asnOutputStream.writeEncodedValue(2, this.resultBlock);
        }
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.vendorId = asnInputStream.readUnsignedInteger(0);
        this.serviceNumber = asnInputStream.readUnsignedInteger(1);
        asnInputStream.peekTag();
        if (asnInputStream.isOpeningTag(2)) {
            this.resultBlock = asnInputStream.readEncodedValue(2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ConfirmedPrivateTransferACK: ");
        stringBuffer.append("\n  vId=" + this.vendorId);
        stringBuffer.append("\n  svc#=" + this.serviceNumber);
        if (this.resultBlock != null && this.resultBlock.length > 0) {
            stringBuffer.append(ByteArrayUtil.toHexString((byte[])this.resultBlock));
        }
        return stringBuffer.toString();
    }

    public ConfirmedPrivateTransferAck() {
        super(18);
    }

    public ConfirmedPrivateTransferAck(long l, long l2) {
        this(l, l2, null);
    }

    public ConfirmedPrivateTransferAck(long l, long l2, byte[] byArray) {
        super(18);
        this.vendorId = l;
        this.serviceNumber = l2;
        this.resultBlock = byArray;
    }

    public ConfirmedPrivateTransferAck(int n, AsnInputStream asnInputStream) throws AsnException {
        super(n);
        this.readEncoded(asnInputStream);
    }
}

