/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.services.BacnetComplexAck;
import javax.baja.bacnet.io.AsnException;

public class AtomicWriteFileAck
extends BacnetComplexAck {
    public static final int STREAM_ACCESS_TAG = 0;
    public static final int RECORD_ACCESS_TAG = 1;
    private int accessMethod;
    private int start;

    public int getFileStart() {
        return this.start;
    }

    public boolean isStreamAccess() {
        boolean bl = false;
        if (this.accessMethod == 0) {
            bl = true;
        }
        return bl;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeSignedInteger(this.accessMethod, this.start);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        asnInputStream.peekTag();
        this.accessMethod = asnInputStream.isValueTag(0) ? 0 : 1;
        this.start = asnInputStream.readSignedInteger(this.accessMethod);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("AtomicWriteFileACK: ");
        stringBuffer.append("\n  access method:" + this.accessMethod);
        stringBuffer.append("\n  " + this.start);
        return stringBuffer.toString();
    }

    public AtomicWriteFileAck() {
        super(7);
    }

    public AtomicWriteFileAck(int n, int n2) {
        super(7);
        this.accessMethod = n;
        this.start = n2;
    }

    public AtomicWriteFileAck(int n, AsnInputStream asnInputStream) throws AsnException {
        super(n);
        this.readEncoded(asnInputStream);
    }
}

