/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.confirmed.AtomicReadFileAck;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.RejectException;

public class AtomicReadFileRequest
extends BacnetConfirmedRequest {
    private BBacnetObjectIdentifier fileId;
    private int accessMethod;
    private int start;
    private long count;

    public BBacnetObjectIdentifier getFileId() {
        return this.fileId;
    }

    public void setFileId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.fileId = bBacnetObjectIdentifier;
    }

    public boolean isStreamAccess() {
        boolean bl = false;
        if (this.accessMethod == 0) {
            bl = true;
        }
        return bl;
    }

    public int getFileStartPosition() {
        return this.start;
    }

    public long getRequestedOctetCount() {
        return this.count;
    }

    public void setFileStartPosition(int n) {
        this.start = n;
    }

    public void setRequestedOctetCount(long l) {
        this.count = l;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeObjectIdentifier(this.fileId);
        asnOutputStream.writeOpeningTag(this.accessMethod);
        asnOutputStream.writeSignedInteger(this.start);
        asnOutputStream.writeUnsignedInteger(this.count);
        asnOutputStream.writeClosingTag(this.accessMethod);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException, RejectException {
        this.fileId = asnInputStream.readObjectIdentifier();
        asnInputStream.peekTag();
        this.accessMethod = asnInputStream.isOpeningTag(0) ? 0 : 1;
        asnInputStream.skipTag();
        this.start = asnInputStream.readSignedInteger();
        this.count = asnInputStream.readUnsignedInteger();
        asnInputStream.skipTag();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("AtomicReadFileRequest: ");
        stringBuffer.append("\n  " + (Object)((Object)this.fileId));
        stringBuffer.append("\n  access method:" + this.accessMethod);
        stringBuffer.append("\n  " + this.start);
        stringBuffer.append("\n  " + this.count);
        return stringBuffer.toString();
    }

    public BacnetServicePrimitive doParseAck(int n, AsnInputStream asnInputStream) throws AsnException {
        return new AtomicReadFileAck(n, asnInputStream);
    }

    public AtomicReadFileRequest() {
        this(0, null, 0, 0L);
    }

    public AtomicReadFileRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this(0, bBacnetObjectIdentifier, 0, 0L);
    }

    public AtomicReadFileRequest(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, long l) {
        this(0, bBacnetObjectIdentifier, n, l);
    }

    public AtomicReadFileRequest(int n, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n2, long l) {
        super(6);
        this.accessMethod = n;
        this.fileId = bBacnetObjectIdentifier;
        this.start = n2;
        this.count = l;
    }
}

