/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services.confirmed;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.RejectException;
import javax.baja.sys.BEnum;

public class AcknowledgeAlarmRequest
extends BacnetConfirmedRequest {
    public static final int ACKNOWLEDGING_PROCESS_ID_TAG = 0;
    public static final int EVENT_OBJECT_ID_TAG = 1;
    public static final int EVENT_STATE_ACKNOWLEDGED_TAG = 2;
    public static final int TIMESTAMP_TAG = 3;
    public static final int ACKNOWLEDGEMENT_SOURCE_TAG = 4;
    public static final int TIME_OF_ACKNOWLEDGEMENT_TAG = 5;
    private long acknowledgingProcessId;
    private BBacnetObjectIdentifier eventObjectId;
    private BEnum eventStateAcknowledged;
    private BBacnetTimeStamp timeStamp;
    private String acknowledgementSource;
    private BBacnetTimeStamp timeOfAcknowledgement;
    private BCharacterSetEncoding encoding;

    public long getAcknowledgingProcessId() {
        return this.acknowledgingProcessId;
    }

    public BBacnetObjectIdentifier getEventObjectId() {
        return this.eventObjectId;
    }

    public BEnum getEventStateAcknowledged() {
        return this.eventStateAcknowledged;
    }

    public BBacnetTimeStamp getTimeStamp() {
        return this.timeStamp;
    }

    public String getAcknowledgementSource() {
        return this.acknowledgementSource;
    }

    public BBacnetTimeStamp getTimeOfAcknowledgement() {
        return this.timeOfAcknowledgement;
    }

    public BCharacterSetEncoding getEncoding() {
        return this.encoding;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeUnsignedInteger(0, this.acknowledgingProcessId);
        asnOutputStream.writeObjectIdentifier(1, this.eventObjectId);
        asnOutputStream.writeEnumerated(2, this.eventStateAcknowledged.getOrdinal());
        asnOutputStream.writeOpeningTag(3);
        this.timeStamp.writeAsn(asnOutputStream);
        asnOutputStream.writeClosingTag(3);
        asnOutputStream.writeCharacterString(4, this.acknowledgementSource, this.encoding);
        asnOutputStream.writeOpeningTag(5);
        this.timeOfAcknowledgement.writeAsn(asnOutputStream);
        asnOutputStream.writeClosingTag(5);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException, RejectException {
        this.acknowledgingProcessId = asnInputStream.readUnsignedInteger(0);
        this.eventObjectId = asnInputStream.readObjectIdentifier(1);
        this.eventStateAcknowledged = BBacnetEventState.make(asnInputStream.readEnumerated(2));
        asnInputStream.skipTag();
        this.timeStamp = new BBacnetTimeStamp();
        this.timeStamp.readAsn(asnInputStream);
        asnInputStream.skipTag();
        this.encoding = asnInputStream.peekEncoding(4);
        this.acknowledgementSource = asnInputStream.readCharacterString(4);
        asnInputStream.skipTag();
        this.timeOfAcknowledgement = new BBacnetTimeStamp();
        this.timeOfAcknowledgement.readAsn(asnInputStream);
        asnInputStream.skipTag();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("AcknowledgeAlarmRequest: ");
        stringBuffer.append("\n  " + this.acknowledgingProcessId);
        stringBuffer.append("\n  " + (Object)((Object)this.eventObjectId));
        stringBuffer.append("\n  " + this.eventStateAcknowledged);
        stringBuffer.append("\n  " + this.timeStamp);
        stringBuffer.append("\n  " + this.acknowledgementSource);
        stringBuffer.append("\n  " + this.timeOfAcknowledgement);
        stringBuffer.append("\n  " + (Object)((Object)this.encoding));
        return stringBuffer.toString();
    }

    public AcknowledgeAlarmRequest() {
        super(0);
    }

    public AcknowledgeAlarmRequest(long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, BEnum bEnum, BBacnetTimeStamp bBacnetTimeStamp, String string, BBacnetTimeStamp bBacnetTimeStamp2, BCharacterSetEncoding bCharacterSetEncoding) {
        super(0);
        this.acknowledgingProcessId = l;
        this.eventObjectId = bBacnetObjectIdentifier;
        this.eventStateAcknowledged = bEnum;
        this.timeStamp = bBacnetTimeStamp;
        this.acknowledgementSource = string;
        this.timeOfAcknowledgement = bBacnetTimeStamp2;
        this.encoding = bCharacterSetEncoding;
    }
}

