/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.services;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.unconfirmed.IAmRequest;
import com.tridium.bacnet.services.unconfirmed.IHaveRequest;
import com.tridium.bacnet.services.unconfirmed.TimeSynchronizationRequest;
import com.tridium.bacnet.services.unconfirmed.UnconfirmedCovNotificationRequest;
import com.tridium.bacnet.services.unconfirmed.UnconfirmedEventNotificationRequest;
import com.tridium.bacnet.services.unconfirmed.UnconfirmedPrivateTransferRequest;
import com.tridium.bacnet.services.unconfirmed.UtcTimeSynchronizationRequest;
import com.tridium.bacnet.services.unconfirmed.WhoHasRequest;
import com.tridium.bacnet.services.unconfirmed.WhoIsRequest;
import com.tridium.bacnet.stack.transport.UnconfirmedRequestPdu;
import javax.baja.bacnet.BacnetUnconfirmedServiceChoice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.RejectException;
import javax.baja.log.Log;

public abstract class BacnetUnconfirmedRequest
extends BacnetServicePrimitive
implements BacnetUnconfirmedServiceChoice {
    private static Log log = Log.getLog((String)"bacnet.server");
    private static AsnInputStream staticInputStream = new AsnInputStream();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final BacnetUnconfirmedRequest parseAPDU(UnconfirmedRequestPdu unconfirmedRequestPdu) {
        BacnetUnconfirmedRequest bacnetUnconfirmedRequest = BacnetUnconfirmedRequest.decodeServiceChoice(unconfirmedRequestPdu.getServiceChoice());
        if (bacnetUnconfirmedRequest == null) return bacnetUnconfirmedRequest;
        try {
            AsnInputStream asnInputStream = staticInputStream;
            synchronized (asnInputStream) {
                staticInputStream.setBuffer(unconfirmedRequestPdu.getServiceRequest());
                bacnetUnconfirmedRequest.readEncoded(staticInputStream);
                return bacnetUnconfirmedRequest;
            }
        }
        catch (AsnException asnException) {
            log.message(asnException.getMessage());
            return null;
        }
        catch (RejectException rejectException) {
            log.message(rejectException.getMessage());
            return null;
        }
    }

    private static final BacnetUnconfirmedRequest decodeServiceChoice(int n) {
        switch (n) {
            case 0: {
                return new IAmRequest();
            }
            case 8: {
                return new WhoIsRequest();
            }
            case 1: {
                return new IHaveRequest();
            }
            case 7: {
                return new WhoHasRequest();
            }
            case 6: {
                return new TimeSynchronizationRequest();
            }
            case 9: {
                return new UtcTimeSynchronizationRequest();
            }
            case 3: {
                return new UnconfirmedEventNotificationRequest();
            }
            case 2: {
                return new UnconfirmedCovNotificationRequest();
            }
            case 4: {
                return new UnconfirmedPrivateTransferRequest();
            }
        }
        log.trace("Unsupported unconfirmed service " + n);
        return null;
    }

    protected BacnetUnconfirmedRequest(int n) {
        super(1, n);
    }
}

