/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.schedule;

import com.tridium.bacnet.asn.AsnConst;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.schedule.BBacnetScheduleDeviceExt;
import com.tridium.bacnet.schedule.BBacnetScheduleExport;
import com.tridium.bacnet.schedule.BBacnetScheduleImportExt;
import com.tridium.bacnet.schedule.ScheduleType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.export.BBacnetCalendarDescriptor;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.DataTypeNotSupportedException;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BCalendarSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BCustomSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDateRangeSchedule;
import javax.baja.schedule.BDateSchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.schedule.BScheduleReference;
import javax.baja.schedule.BStringSchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.schedule.BWeekAndDaySchedule;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ScheduleSupport0
implements AsnConst {
    static final BFacets SCHEDULE_CALENDAR_OBJECT_ID_FACETS = BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{17, 6}, (String[])new String[]{BBacnetObjectType.tag(17), BBacnetObjectType.tag(6)}));
    private static final BacnetScheduleComparator scheduleOrder = new BacnetScheduleComparator();
    public static final String BACNET_IDX = "bacnetIdx";
    private static final BDateSchedule ALWAYS_EFFECTIVE_DATE_SCHEDULE = new BDateSchedule();
    private static final boolean CALCULATE_WEEKDAY = true;
    protected BBacnetScheduleDeviceExt devext;
    static /* synthetic */ Class class$javax$baja$schedule$BDailySchedule;
    static /* synthetic */ Class class$javax$baja$schedule$BAbstractSchedule;

    public String getVersion() {
        return "ScheduleSupport 1.0";
    }

    public BAbstractSchedule decodeCalendarEntry(AsnInput asnInput) throws AsnException {
        int n = asnInput.peekTag();
        if (asnInput.isValueTag(0)) {
            return this.decodeDate(0, asnInput);
        }
        if (asnInput.isOpeningTag(1)) {
            return this.decodeDateRange(1, asnInput);
        }
        if (asnInput.isValueTag(2)) {
            return this.decodeWeekAndDay(2, asnInput);
        }
        throw new AsnException("Invalid tag: " + n);
    }

    public BDaySchedule decodeDailySchedule(BStatusValue bStatusValue, AsnInput asnInput, int n) throws AsnException {
        TimeValue[] timeValueArray = this.decodeTimeValues(0, asnInput, bStatusValue, n);
        return this.makeDay(timeValueArray, this.bajaToJavaNullOk(bStatusValue));
    }

    public BDateSchedule decodeDate(AsnInput asnInput) throws AsnException {
        BBacnetDate bBacnetDate = asnInput.readDate();
        BDateSchedule bDateSchedule = new BDateSchedule();
        bDateSchedule.setYear(bBacnetDate.getYear());
        bDateSchedule.setMonth(bBacnetDate.isMonthUnspecified() ? bBacnetDate.getMonth() : bBacnetDate.getMonth() - 1);
        bDateSchedule.setDay(bBacnetDate.getDayOfMonth());
        if (!bBacnetDate.isDayOfWeekUnspecified()) {
            bDateSchedule.setWeekday(bBacnetDate.getBWeekday().getOrdinal());
        }
        return bDateSchedule;
    }

    public BDateSchedule decodeDate(int n, AsnInput asnInput) throws AsnException {
        BBacnetDate bBacnetDate = asnInput.readDate(n);
        BDateSchedule bDateSchedule = new BDateSchedule();
        bDateSchedule.setYear(bBacnetDate.getYear());
        bDateSchedule.setMonth(bBacnetDate.isMonthUnspecified() ? bBacnetDate.getMonth() : bBacnetDate.getMonth() - 1);
        bDateSchedule.setDay(bBacnetDate.getDayOfMonth());
        if (!bBacnetDate.isDayOfWeekUnspecified()) {
            bDateSchedule.setWeekday(bBacnetDate.getBWeekday().getOrdinal());
        }
        return bDateSchedule;
    }

    public BCalendarSchedule decodeDateList(AsnInput asnInput) throws AsnException {
        BCalendarSchedule bCalendarSchedule = new BCalendarSchedule();
        while (asnInput.peekTag() != -1) {
            bCalendarSchedule.add(this.decodeCalendarEntry(asnInput));
        }
        return bCalendarSchedule;
    }

    public BDateRangeSchedule decodeDateRange(AsnInput asnInput) throws AsnException {
        BDateRangeSchedule bDateRangeSchedule = new BDateRangeSchedule();
        bDateRangeSchedule.setStart(this.decodeDate(asnInput));
        bDateRangeSchedule.setEnd(this.decodeDate(asnInput));
        return bDateRangeSchedule;
    }

    public BDateRangeSchedule decodeDateRange(int n, AsnInput asnInput) throws AsnException {
        BDateRangeSchedule bDateRangeSchedule = new BDateRangeSchedule();
        asnInput.skipTag();
        bDateRangeSchedule.setStart(this.decodeDate(asnInput));
        bDateRangeSchedule.setEnd(this.decodeDate(asnInput));
        asnInput.skipTag();
        return bDateRangeSchedule;
    }

    public BCompositeSchedule decodeExceptionSchedule(BStatusValue bStatusValue, AsnInput asnInput, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n) throws AsnException {
        ListIterator listIterator;
        BCompositeSchedule bCompositeSchedule = new BCompositeSchedule();
        Class clazz = class$javax$baja$schedule$BDailySchedule;
        if (clazz == null) {
            clazz = class$javax$baja$schedule$BDailySchedule = ScheduleSupport0.class("[Ljavax.baja.schedule.BDailySchedule;", false);
        }
        Array array = new Array(clazz);
        int n2 = asnInput.peekTag();
        int n3 = 0;
        while (n2 != -1) {
            listIterator = this.decodeSpecialEvent(bStatusValue, asnInput, bBacnetObjectIdentifier, n, n3++);
            int n4 = ((BInteger)listIterator.get("priority")).getInt();
            boolean bl = false;
            int n5 = 0;
            while (n5 < array.size()) {
                BDailySchedule bDailySchedule = (BDailySchedule)array.get(n5);
                Property property = bDailySchedule.getProperty("priority");
                int n6 = 1;
                if (property != null) {
                    n6 = bDailySchedule.getInt(property);
                }
                if (n4 < n6) {
                    array.add(n5, (Object)listIterator);
                    bl = true;
                    break;
                }
                ++n5;
            }
            if (!bl) {
                array.add((Object)listIterator);
            }
            n2 = asnInput.peekTag();
        }
        listIterator = array.iterator();
        while (listIterator.hasNext()) {
            bCompositeSchedule.add(null, (BValue)((BDailySchedule)listIterator.next()));
        }
        return bCompositeSchedule;
    }

    public BAbstractSchedule decodePeriod(AsnInput asnInput, BBacnetObjectIdentifier bBacnetObjectIdentifier) throws AsnException {
        int n = asnInput.peekTag();
        if (asnInput.isOpeningTag(0)) {
            asnInput.skipTag();
            BAbstractSchedule bAbstractSchedule = this.decodeCalendarEntry(asnInput);
            asnInput.skipTag();
            return bAbstractSchedule;
        }
        if (asnInput.isValueTag(1)) {
            BScheduleReference bScheduleReference = new BScheduleReference();
            BBacnetObjectIdentifier bBacnetObjectIdentifier2 = asnInput.readObjectIdentifier(1);
            try {
                BBacnetDevice bBacnetDevice = BBacnetNetwork.bacnet().doLookupDeviceById(bBacnetObjectIdentifier);
                if (bBacnetDevice == null) {
                    if (BBacnetNetwork.localDevice().getObjectId().equals((Object)bBacnetObjectIdentifier)) {
                        BBacnetCalendarDescriptor bBacnetCalendarDescriptor = (BBacnetCalendarDescriptor)BBacnetNetwork.localDevice().lookupBacnetObject(bBacnetObjectIdentifier2);
                        if (bBacnetCalendarDescriptor != null) {
                            bScheduleReference.setRef(bBacnetCalendarDescriptor.getObject().asComponent().getSlotPathOrd());
                        }
                    } else {
                        ScheduleSupport0.log().message("Unable to find BACnet device for deviceId " + (Object)((Object)bBacnetObjectIdentifier) + "!!! Calendar Reference could fail...");
                        bScheduleReference.setRef((BOrd)BOrd.NULL.decodeFromString("bac:" + bBacnetObjectIdentifier.toString() + ';' + bBacnetObjectIdentifier2.toString() + "{schedule}"));
                    }
                } else {
                    BAbstractSchedule bAbstractSchedule = (BAbstractSchedule)bBacnetDevice.lookupBacnetObject(bBacnetObjectIdentifier2, -1, -1, "schedule");
                    if (bAbstractSchedule != null) {
                        bScheduleReference.setRef(bAbstractSchedule.getSlotPathOrd());
                    } else {
                        ScheduleSupport0.log().message("Unable to find BACnet calendar " + (Object)((Object)bBacnetObjectIdentifier2) + " in device " + (Object)((Object)bBacnetObjectIdentifier) + "!!! Calendar Reference could fail...");
                        bScheduleReference.setRef((BOrd)BOrd.NULL.decodeFromString("bac:" + bBacnetObjectIdentifier.toString() + ';' + bBacnetObjectIdentifier2.toString() + "{schedule}"));
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Exception decoding schedule reference:" + (Object)((Object)bBacnetObjectIdentifier2));
                throw new RuntimeException(exception.getMessage());
            }
            return bScheduleReference;
        }
        throw new AsnException("Invalid tag: " + n);
    }

    public BStatusValue decodeScheduleDefault(BStatusValue bStatusValue, AsnInput asnInput, int n) throws AsnException {
        Type type = bStatusValue.getType();
        if (type.is(BStatusBoolean.TYPE)) {
            return this.decodeScheduleDefaultBoolean((BStatusBoolean)bStatusValue, asnInput);
        }
        if (type.is(BStatusNumeric.TYPE)) {
            return this.decodeScheduleDefaultNumeric((BStatusNumeric)bStatusValue, asnInput);
        }
        if (type.is(BStatusEnum.TYPE)) {
            return this.decodeScheduleDefaultEnum((BStatusEnum)bStatusValue, asnInput, n);
        }
        if (type.is(BStatusString.TYPE)) {
            return this.decodeScheduleDefaultString((BStatusString)bStatusValue, asnInput);
        }
        throw new IllegalArgumentException(bStatusValue.getClass().toString());
    }

    public BDailySchedule decodeSpecialEvent(BStatusValue bStatusValue, AsnInput asnInput, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2) throws AsnException {
        BDailySchedule bDailySchedule = new BDailySchedule(this.decodePeriod(asnInput, bBacnetObjectIdentifier));
        TimeValue[] timeValueArray = this.decodeTimeValues(2, asnInput, bStatusValue, n);
        bDailySchedule.setDay(this.makeDay(timeValueArray, this.bajaToJavaNullOk(bStatusValue)));
        bDailySchedule.add("priority", (BValue)BInteger.make((int)asnInput.readUnsignedInt(3)));
        bDailySchedule.add(BACNET_IDX, (BValue)BInteger.make((int)n2));
        return bDailySchedule;
    }

    public BWeekAndDaySchedule decodeWeekAndDay(int n, AsnInput asnInput) throws AsnException {
        BWeekAndDaySchedule bWeekAndDaySchedule = new BWeekAndDaySchedule();
        byte[] byArray = asnInput.readOctetString(n);
        byte by = byArray[0];
        bWeekAndDaySchedule.setMonth(by <= 0 || by > 14 ? -1 : by - 1);
        by = byArray[1];
        bWeekAndDaySchedule.setWeek((int)by);
        by = byArray[2];
        switch (by) {
            case 7: {
                bWeekAndDaySchedule.setWeekday(0);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                bWeekAndDaySchedule.setWeekday((int)by);
                break;
            }
            default: {
                bWeekAndDaySchedule.setWeekday(-1);
            }
        }
        return bWeekAndDaySchedule;
    }

    public void encodeCalendarEntry(BAbstractSchedule bAbstractSchedule, AsnOutput asnOutput) {
        if (bAbstractSchedule instanceof BDateSchedule) {
            this.encodeDate((BDateSchedule)bAbstractSchedule, 0, asnOutput);
        } else if (bAbstractSchedule instanceof BDateRangeSchedule) {
            this.encodeDateRange((BDateRangeSchedule)bAbstractSchedule, 1, asnOutput);
        } else if (bAbstractSchedule instanceof BWeekAndDaySchedule) {
            this.encodeWeekAndDay((BWeekAndDaySchedule)bAbstractSchedule, 2, asnOutput);
        } else if (bAbstractSchedule instanceof BCustomSchedule) {
            BAbsTime bAbsTime = BAbsTime.make();
            BAbsTime bAbsTime2 = bAbsTime.nextYear();
            int n = 0;
            BAbsTime bAbsTime3 = bAbstractSchedule.nextEvent(bAbsTime);
            while (n < 10 && bAbsTime3.isBefore(bAbsTime2)) {
                if (bAbstractSchedule.isEffective(bAbsTime3)) {
                    this.encodeDate(bAbsTime3, 0, asnOutput);
                    ++n;
                }
                bAbsTime3 = bAbstractSchedule.nextEvent(bAbsTime3);
            }
        } else {
            throw new IllegalArgumentException("Invalid calendar entry: " + bAbstractSchedule.getClass());
        }
    }

    public void encodeDailySchedule(BDaySchedule bDaySchedule, BStatusValue bStatusValue, AsnOutput asnOutput, int n) {
        TimeValue[] timeValueArray = this.makeDay(bDaySchedule, this.bajaToJava(bStatusValue));
        this.encodeTimeValues(timeValueArray, 0, asnOutput, n);
    }

    public void encodeDate(BDateSchedule bDateSchedule, AsnOutput asnOutput) {
        this.encodeDate(bDateSchedule, asnOutput, false);
    }

    public void encodeDate(BDateSchedule bDateSchedule, AsnOutput asnOutput, boolean bl) {
        int n = bDateSchedule.getYear();
        int n2 = bDateSchedule.getMonth();
        int n3 = bDateSchedule.getDay();
        int n4 = bDateSchedule.getWeekday();
        if (bl && n2 >= 0 && n >= 0 && n3 >= 0) {
            n4 = BAbsTime.getWeekday((int)n, (BMonth)BMonth.make((int)n2), (int)n3).getOrdinal();
        }
        asnOutput.writeDate(n < 0 ? 255 : n - 1900, n2 < 0 ? n2 : n2 + 1, n3, n4 == 0 ? 7 : n4);
    }

    public void encodeDate(BDateSchedule bDateSchedule, int n, AsnOutput asnOutput) {
        int n2 = bDateSchedule.getYear();
        int n3 = bDateSchedule.getMonth();
        int n4 = bDateSchedule.getDay();
        int n5 = bDateSchedule.getWeekday();
        asnOutput.writeDate(n, n2 < 0 ? 255 : n2 - 1900, n3 < 0 ? n3 : n3 + 1, n4, n5 == 0 ? 7 : n5);
    }

    public void encodeDate(BAbsTime bAbsTime, int n, AsnOutput asnOutput) {
        int n2 = bAbsTime.getYear();
        int n3 = bAbsTime.getMonth().getOrdinal();
        int n4 = bAbsTime.getDay();
        int n5 = bAbsTime.getWeekday().getOrdinal();
        asnOutput.writeDate(n, n2 - 1900, n3 + 1, n4, n5 == 0 ? 7 : n5);
    }

    /*
     * Unable to fully structure code
     */
    public void encodeDateList(BCalendarSchedule var1_1, AsnOutput var2_2) {
        var3_3 = var1_1.getProperties();
        if (true) ** GOTO lbl5
        do {
            this.encodeCalendarEntry((BAbstractSchedule)var3_3.get(), var2_2);
lbl5:
            // 2 sources

            if ((v0 = ScheduleSupport0.class$javax$baja$schedule$BAbstractSchedule) != null) continue;
            v0 = ScheduleSupport0.class("[Ljavax.baja.schedule.BAbstractSchedule;", false);
        } while (var3_3.next(v0));
    }

    public void encodeDateRange(BDateRangeSchedule bDateRangeSchedule, AsnOutput asnOutput) {
        if (bDateRangeSchedule.getAlwaysEffective()) {
            this.encodeDate(ALWAYS_EFFECTIVE_DATE_SCHEDULE, asnOutput);
            this.encodeDate(ALWAYS_EFFECTIVE_DATE_SCHEDULE, asnOutput);
        } else {
            this.encodeDate(bDateRangeSchedule.getStart(), asnOutput, true);
            this.encodeDate(bDateRangeSchedule.getEnd(), asnOutput, true);
        }
    }

    public void encodeDateRange(BDateRangeSchedule bDateRangeSchedule, int n, AsnOutput asnOutput) {
        asnOutput.writeOpeningTag(n);
        if (bDateRangeSchedule.getAlwaysEffective()) {
            this.encodeDate(ALWAYS_EFFECTIVE_DATE_SCHEDULE, asnOutput);
            this.encodeDate(ALWAYS_EFFECTIVE_DATE_SCHEDULE, asnOutput);
        } else {
            this.encodeDate(bDateRangeSchedule.getStart(), asnOutput, true);
            this.encodeDate(bDateRangeSchedule.getEnd(), asnOutput, true);
        }
        asnOutput.writeClosingTag(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encodeEntry(BAbstractSchedule bAbstractSchedule, AsnOutput asnOutput, BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        if (bAbstractSchedule instanceof BScheduleReference) {
            BBacnetObjectIdentifier bBacnetObjectIdentifier2 = BBacnetObjectIdentifier.make(6);
            BOrd bOrd = ((BScheduleReference)bAbstractSchedule).getRef();
            if (BBacnetNetwork.localDevice().getObjectId().equals((Object)bBacnetObjectIdentifier)) {
                BBacnetObjectIdentifier bBacnetObjectIdentifier3 = BBacnetNetwork.localDevice().lookupBacnetObjectId(bOrd);
                asnOutput.writeObjectIdentifier(1, bBacnetObjectIdentifier3 != null ? bBacnetObjectIdentifier3 : bBacnetObjectIdentifier2);
                return;
            } else {
                BObject bObject = bOrd.get((BObject)bAbstractSchedule.getComponentSpace());
                if (bObject == null) {
                    throw new IllegalArgumentException("Invalid calendar reference: ref=" + bOrd + "; unresolved!");
                }
                if (!(bObject instanceof BCalendarSchedule)) throw new IllegalArgumentException("Invalid calendar reference: ref=" + bOrd + "; o=" + bObject + " [" + bObject.getType() + ']');
                BCalendarSchedule bCalendarSchedule = (BCalendarSchedule)bObject;
                BBacnetScheduleImportExt bBacnetScheduleImportExt = BBacnetScheduleDeviceExt.getBacnetImportExt((BAbstractSchedule)bCalendarSchedule);
                if (bBacnetScheduleImportExt != null) {
                    asnOutput.writeObjectIdentifier(1, bBacnetScheduleImportExt.getObjectId());
                    return;
                } else {
                    if (this.devext == null) throw new IllegalArgumentException("ScheduleSupport device extension reference not set!");
                    BBacnetScheduleExport bBacnetScheduleExport = this.devext.getBacnetExportExt((BAbstractSchedule)bCalendarSchedule);
                    if (bBacnetScheduleExport == null) throw new IllegalArgumentException("No schedule import or export is available for calendar:" + bOrd);
                    asnOutput.writeObjectIdentifier(1, bBacnetScheduleExport.getObjectId());
                }
            }
            return;
        } else {
            asnOutput.writeOpeningTag(0);
            this.encodeCalendarEntry(bAbstractSchedule, asnOutput);
            asnOutput.writeClosingTag(0);
        }
    }

    public void encodeExceptionScheduleWithIdx(BCompositeSchedule bCompositeSchedule, BStatusValue bStatusValue, AsnOutput asnOutput, int n, BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        List list = ScheduleSupport0.sortSpecialEvents(bCompositeSchedule);
        int n2 = 0;
        while (n2 < list.size()) {
            this.encodeSpecialEvent((BDailySchedule)list.get(n2), bStatusValue, asnOutput, n, bBacnetObjectIdentifier);
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void encodeExceptionSchedule(BCompositeSchedule var1_1, BStatusValue var2_2, AsnOutput var3_3, int var4_4, BBacnetObjectIdentifier var5_5) {
        var6_6 = var1_1.getProperties();
        if (true) ** GOTO lbl6
        do {
            var7_7 = (BDailySchedule)var6_6.get();
            this.encodeSpecialEvent(var7_7, var2_2, var3_3, var4_4, var5_5);
lbl6:
            // 2 sources

            if ((v0 = ScheduleSupport0.class$javax$baja$schedule$BDailySchedule) != null) continue;
            v0 = ScheduleSupport0.class("[Ljavax.baja.schedule.BDailySchedule;", false);
        } while (var6_6.next(v0));
    }

    public void encodeScheduleDefault(BStatusValue bStatusValue, AsnOutput asnOutput, int n) {
        Type type = bStatusValue.getType();
        if (type.is(BStatusBoolean.TYPE)) {
            this.encodeScheduleDefault((BStatusBoolean)bStatusValue, asnOutput, n);
            return;
        }
        if (type.is(BStatusNumeric.TYPE)) {
            this.encodeScheduleDefault((BStatusNumeric)bStatusValue, asnOutput, n);
            return;
        }
        if (type.is(BStatusEnum.TYPE)) {
            this.encodeScheduleDefault((BStatusEnum)bStatusValue, asnOutput, n);
            return;
        }
        if (type.is(BStatusString.TYPE)) {
            this.encodeScheduleDefault((BStatusString)bStatusValue, asnOutput, n);
            return;
        }
        throw new IllegalArgumentException(bStatusValue.getClass().toString());
    }

    public void encodeSpecialEvent(BDailySchedule bDailySchedule, BStatusValue bStatusValue, AsnOutput asnOutput, int n, BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.encodeEntry(bDailySchedule.getDays(), asnOutput, bBacnetObjectIdentifier);
        TimeValue[] timeValueArray = this.makeDay(bDailySchedule.getDay(), this.bajaToJava(bStatusValue));
        this.encodeTimeValues(timeValueArray, 2, asnOutput, n);
        Property property = bDailySchedule.getProperty("priority");
        asnOutput.writeUnsignedInteger(3, property != null ? bDailySchedule.getInt(property) : 16);
    }

    public void encodeSpecialEvent(int n, BCompositeSchedule bCompositeSchedule, BStatusValue bStatusValue, AsnOutput asnOutput, int n2, BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        if (n <= 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        SlotCursor slotCursor = bCompositeSchedule.getProperties();
        while (n-- > 0) {
            Class clazz = class$javax$baja$schedule$BDailySchedule;
            if (clazz == null) {
                clazz = ScheduleSupport0.class("[Ljavax.baja.schedule.BDailySchedule;", false);
            }
            if (slotCursor.next(clazz)) continue;
            throw new ArrayIndexOutOfBoundsException();
        }
        this.encodeSpecialEvent((BDailySchedule)slotCursor.get(), bStatusValue, asnOutput, n2, bBacnetObjectIdentifier);
    }

    public void encodeWeekAndDay(BWeekAndDaySchedule bWeekAndDaySchedule, int n, AsnOutput asnOutput) {
        byte[] byArray = new byte[3];
        int n2 = bWeekAndDaySchedule.getMonth();
        int n3 = bWeekAndDaySchedule.getWeek();
        int n4 = bWeekAndDaySchedule.getWeekday();
        byArray[0] = n2 == -1 ? -1 : (byte)(n2 + 1);
        byArray[1] = (byte)n3;
        switch (n4) {
            case -1: {
                byArray[2] = -1;
                break;
            }
            case 0: {
                byArray[2] = 7;
                break;
            }
            default: {
                byArray[2] = (byte)n4;
            }
        }
        asnOutput.writeOctetString(n, byArray);
    }

    protected TimeValue[] makeDay(BDaySchedule bDaySchedule, Object object) {
        TimeValue timeValue;
        BTimeSchedule bTimeSchedule;
        if (ScheduleSupport0.log().isTraceOn()) {
            ScheduleSupport0.log().trace("makeDay(1.0): daySch=");
            BBacnetScheduleDeviceExt.dump(bDaySchedule);
        }
        TreeSet<TimeValue> treeSet = new TreeSet<TimeValue>(new Comparator(){

            public final int compare(Object object, Object object2) {
                return ((TimeValue)object).compareTo(object2);
            }
        });
        TimeValue timeValue2 = null;
        BTimeSchedule[] bTimeScheduleArray = bDaySchedule.getTimesInOrder();
        if (bTimeScheduleArray.length > 0) {
            bTimeSchedule = bTimeScheduleArray[0];
            timeValue = new TimeValue(bTimeSchedule.getStart(), this.bajaToJava(bTimeSchedule.getEffectiveValue()));
            treeSet.add(timeValue);
            if (timeValue.millis() > 0) {
                timeValue = new TimeValue(BTime.make((int)0, (int)0, (int)0, (int)0), object);
                treeSet.add(timeValue);
            }
            timeValue2 = new TimeValue(bTimeSchedule.getFinish(), object);
        } else {
            treeSet.add(new TimeValue(BTime.make((int)0, (int)0, (int)0, (int)0), object));
        }
        int n = 1;
        while (n < bTimeScheduleArray.length) {
            bTimeSchedule = bTimeScheduleArray[n];
            timeValue = new TimeValue(bTimeSchedule.getStart(), this.bajaToJava(bTimeSchedule.getEffectiveValue()));
            treeSet.add(timeValue);
            if (timeValue2.millis() != timeValue.millis()) {
                treeSet.add(timeValue2);
            }
            timeValue2 = new TimeValue(bTimeSchedule.getFinish(), object);
            ++n;
        }
        if (timeValue2 != null && timeValue2.millis() > 0) {
            treeSet.add(timeValue2);
        }
        TimeValue[] timeValueArray = new TimeValue[treeSet.size()];
        Iterator iterator = treeSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            timeValueArray[n2++] = (TimeValue)iterator.next();
        }
        if (ScheduleSupport0.log().isTraceOn()) {
            System.out.println("TimeValue[] return array:");
            int n3 = 0;
            while (n3 < timeValueArray.length) {
                System.out.println("ret[" + n3 + "]:" + timeValueArray[n3]);
                ++n3;
            }
        }
        return timeValueArray;
    }

    protected BDaySchedule makeDay(TimeValue[] timeValueArray, Object object) {
        if (ScheduleSupport0.log().isTraceOn()) {
            ScheduleSupport0.log().trace("makeDay(1.0): tvs=");
            int n = 0;
            while (n < timeValueArray.length) {
                System.out.println("tvs[" + n + "]:" + timeValueArray[n]);
                ++n;
            }
        }
        BDaySchedule bDaySchedule = new BDaySchedule();
        int n = 0;
        while (n < timeValueArray.length) {
            BTimeSchedule bTimeSchedule = new BTimeSchedule();
            bTimeSchedule.setStart(this.makeTime(timeValueArray[n], true));
            if (n + 1 >= timeValueArray.length) {
                bTimeSchedule.setFinish(BTime.make((int)0, (int)0, (int)0, (int)0));
            } else {
                bTimeSchedule.setFinish(this.makeTime(timeValueArray[n + 1], true));
            }
            bTimeSchedule.setEffectiveValue(this.javaToBaja(timeValueArray[n].value, object));
            bDaySchedule.add(bTimeSchedule);
            ++n;
        }
        if (ScheduleSupport0.log().isTraceOn()) {
            System.out.println("ret daySch=");
            BBacnetScheduleDeviceExt.dump(bDaySchedule);
        }
        return bDaySchedule;
    }

    public void setDeviceExt(BBacnetScheduleDeviceExt bBacnetScheduleDeviceExt) {
        this.devext = bBacnetScheduleDeviceExt;
    }

    public ScheduleType getScheduleType(int n, AsnInput asnInput) throws AsnException {
        int n2 = asnInput.peekTag();
        if (!asnInput.isOpeningTag(n)) {
            throw new AsnException("Invalid tag: " + n2);
        }
        asnInput.skipTag();
        n2 = asnInput.peekTag();
        while (!asnInput.isClosingTag(n)) {
            if (n2 == -1) {
                throw new AsnException("Invalid tag: " + n2);
            }
            asnInput.readTime();
            n2 = asnInput.peekApplicationTag();
            switch (n2) {
                case 0: {
                    break;
                }
                case 1: {
                    return new ScheduleType(BBooleanSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(n2));
                }
                case 2: {
                    return new ScheduleType(BEnumSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(n2));
                }
                case 3: {
                    return new ScheduleType(BEnumSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(n2));
                }
                case 4: {
                    return new ScheduleType(BNumericSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(n2));
                }
                case 5: {
                    return new ScheduleType(BNumericSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(n2));
                }
                case 6: {
                    return new ScheduleType(BStringSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(n2));
                }
                case 7: {
                    return new ScheduleType(BStringSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(n2));
                }
                case 8: {
                    return new ScheduleType(BStringSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(n2));
                }
                case 9: {
                    return new ScheduleType(BEnumSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(n2));
                }
                case 10: {
                    return new ScheduleType(BStringSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(n2));
                }
                case 11: {
                    return new ScheduleType(BStringSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(n2));
                }
                case 12: {
                    return new ScheduleType(BStringSchedule.TYPE.toString(), AsnUtil.getAsnTypeName(n2));
                }
            }
            n2 = asnInput.peekTag();
        }
        n2 = asnInput.peekTag();
        return null;
    }

    protected final BTime makeTime(TimeValue timeValue, boolean bl) {
        return BTime.make((int)(timeValue.hour < 0 || timeValue.hour > 23 ? (bl ? 0 : 23) : timeValue.hour), (int)(timeValue.minute < 0 || timeValue.minute > 59 ? (bl ? 0 : 59) : timeValue.minute), (int)(timeValue.second < 0 || timeValue.second > 59 ? (bl ? 0 : 59) : timeValue.second), (int)(timeValue.millis < 0 || timeValue.millis > 999 ? (bl ? 0 : 999) : timeValue.millis));
    }

    protected Object bajaToJava(BStatusValue bStatusValue) {
        if (bStatusValue == null || bStatusValue.getStatus().isNull()) {
            return null;
        }
        if (bStatusValue instanceof BStatusBoolean) {
            return ((BStatusBoolean)bStatusValue).getValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (bStatusValue instanceof BStatusNumeric) {
            return new Double(((BStatusNumeric)bStatusValue).getValue());
        }
        if (bStatusValue instanceof BStatusEnum) {
            return new Integer(((BStatusEnum)bStatusValue).getValue().getOrdinal());
        }
        if (bStatusValue instanceof BStatusString) {
            return ((BStatusString)bStatusValue).getValue();
        }
        throw new IllegalArgumentException("Invalid BStatusValue: " + bStatusValue.getClass());
    }

    protected Object bajaToJavaNullOk(BStatusValue bStatusValue) {
        if (bStatusValue == null) {
            return null;
        }
        if (bStatusValue instanceof BStatusBoolean) {
            return ((BStatusBoolean)bStatusValue).getValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (bStatusValue instanceof BStatusNumeric) {
            return new Double(((BStatusNumeric)bStatusValue).getValue());
        }
        if (bStatusValue instanceof BStatusEnum) {
            return new Integer(((BStatusEnum)bStatusValue).getValue().getOrdinal());
        }
        if (bStatusValue instanceof BStatusString) {
            return ((BStatusString)bStatusValue).getValue();
        }
        throw new IllegalArgumentException("Invalid BStatusValue:" + bStatusValue + " {" + bStatusValue.getType() + '}');
    }

    protected BStatusValue javaToBaja(Object object, Object object2) {
        BStatusBoolean bStatusBoolean = null;
        Object object3 = object;
        if (object3 == null) {
            object3 = object2;
        }
        if (object3 instanceof Boolean) {
            bStatusBoolean = new BStatusBoolean(((Boolean)object3).booleanValue());
        } else if (object3 instanceof Double) {
            bStatusBoolean = new BStatusNumeric(((Double)object3).doubleValue());
        } else if (object3 instanceof Integer) {
            bStatusBoolean = new BStatusEnum((BEnum)BDynamicEnum.make((int)((Integer)object3)));
        } else if (object3 instanceof String) {
            bStatusBoolean = new BStatusString((String)object3);
        } else {
            throw new IllegalStateException("Unexpected output type: " + object3.getClass());
        }
        if (object == null) {
            bStatusBoolean.setStatusNull(true);
        }
        return bStatusBoolean;
    }

    protected BStatusValue javaToBaja(Object object, BStatusValue bStatusValue) {
        BStatusBoolean bStatusBoolean = null;
        Object object2 = object;
        if (object2 == null) {
            return bStatusValue;
        }
        if (object2 instanceof Boolean) {
            bStatusBoolean = new BStatusBoolean(((Boolean)object2).booleanValue());
        } else if (object2 instanceof Double) {
            bStatusBoolean = new BStatusNumeric(((Double)object2).doubleValue());
        } else if (object2 instanceof Integer) {
            bStatusBoolean = new BStatusEnum((BEnum)BDynamicEnum.make((int)((Integer)object2)));
        } else if (object2 instanceof String) {
            bStatusBoolean = new BStatusString((String)object2);
        } else {
            throw new IllegalStateException("Unexpected output type: " + object2.getClass());
        }
        if (object == null) {
            bStatusBoolean.setStatusNull(true);
        }
        return bStatusBoolean;
    }

    /*
     * Unable to fully structure code
     */
    private static final List sortSpecialEvents(BCompositeSchedule var0) {
        var1_1 = new ArrayList<BValue>();
        var2_2 = var0.getProperties();
        if (true) ** GOTO lbl8
        do {
            var3_3 = (BDailySchedule)var2_2.get();
            var1_1.add(var3_3.newCopy());
lbl8:
            // 2 sources

            if ((v0 = ScheduleSupport0.class$javax$baja$schedule$BDailySchedule) != null) continue;
            v0 = ScheduleSupport0.class("[Ljavax.baja.schedule.BDailySchedule;", false);
        } while (var2_2.next(v0));
        if (var1_1.size() > 0) {
            Collections.sort(var1_1, ScheduleSupport0.scheduleOrder);
        }
        return var1_1;
    }

    private final BStatusValue decodeScheduleDefaultBoolean(BStatusBoolean bStatusBoolean, AsnInput asnInput) throws AsnException {
        int n = asnInput.peekApplicationTag();
        switch (n) {
            case 0: {
                return bStatusBoolean;
            }
            case 1: {
                return new BStatusBoolean(asnInput.readBoolean());
            }
        }
        throw new DataTypeNotSupportedException("Invalid tag: " + n);
    }

    private final BStatusValue decodeScheduleDefaultNumeric(BStatusNumeric bStatusNumeric, AsnInput asnInput) throws AsnException {
        int n = asnInput.peekApplicationTag();
        switch (n) {
            case 0: {
                return bStatusNumeric;
            }
            case 4: {
                return new BStatusNumeric((double)asnInput.readReal());
            }
        }
        throw new DataTypeNotSupportedException("Invalid tag: " + n);
    }

    private final BStatusValue decodeScheduleDefaultEnum(BStatusEnum bStatusEnum, AsnInput asnInput, int n) throws AsnException {
        BEnumRange bEnumRange = bStatusEnum.getValue().getRange();
        int n2 = asnInput.peekApplicationTag();
        switch (n2) {
            case 0: {
                return bStatusEnum;
            }
            case 2: {
                if (n < 0 || n == n2) {
                    return new BStatusEnum(bEnumRange.get(asnInput.readUnsignedInt()));
                }
                throw new AsnException("Invalid tag: " + n2);
            }
            case 3: {
                if (n < 0 || n == n2) {
                    return new BStatusEnum(bEnumRange.get(asnInput.readSignedInteger()));
                }
                throw new AsnException("Invalid tag: " + n2);
            }
            case 9: {
                if (n < 0 || n == n2) {
                    return new BStatusEnum(bEnumRange.get(asnInput.readEnumerated()));
                }
                throw new AsnException("Invalid tag: " + n2);
            }
        }
        throw new DataTypeNotSupportedException("Invalid tag: " + n2);
    }

    private final BStatusValue decodeScheduleDefaultString(BStatusString bStatusString, AsnInput asnInput) throws AsnException {
        int n = asnInput.peekApplicationTag();
        switch (n) {
            case 0: {
                return bStatusString;
            }
            case 7: {
                return new BStatusString(asnInput.readCharacterString());
            }
        }
        throw new DataTypeNotSupportedException("Invalid tag: " + n);
    }

    private final TimeValue decodeTimeValue(AsnInput asnInput, BStatusValue bStatusValue, int n) throws AsnException {
        Type type = bStatusValue.getType();
        if (type.is(BStatusBoolean.TYPE)) {
            return this.decodeTimeValueBoolean(asnInput, (BStatusBoolean)bStatusValue);
        }
        if (type.is(BStatusNumeric.TYPE)) {
            return this.decodeTimeValueNumeric(asnInput, (BStatusNumeric)bStatusValue);
        }
        if (type.is(BStatusEnum.TYPE)) {
            return this.decodeTimeValueEnum(asnInput, (BStatusEnum)bStatusValue, n);
        }
        if (type.is(BStatusString.TYPE)) {
            return this.decodeTimeValueString(asnInput, (BStatusString)bStatusValue);
        }
        throw new IllegalArgumentException(bStatusValue.getClass().toString());
    }

    private final TimeValue decodeTimeValueBoolean(AsnInput asnInput, BStatusBoolean bStatusBoolean) throws AsnException {
        BBacnetTime bBacnetTime = asnInput.readTime();
        int n = asnInput.peekApplicationTag();
        boolean bl = false;
        switch (n) {
            case 0: {
                asnInput.readNull();
                return new TimeValue(bBacnetTime, null);
            }
            case 1: {
                bl = asnInput.readBoolean();
                break;
            }
            default: {
                throw new DataTypeNotSupportedException("Invalid tag: " + n);
            }
        }
        return new TimeValue(bBacnetTime, (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
    }

    private final TimeValue decodeTimeValueNumeric(AsnInput asnInput, BStatusNumeric bStatusNumeric) throws AsnException {
        BBacnetTime bBacnetTime = asnInput.readTime();
        int n = asnInput.peekApplicationTag();
        double d = 0.0;
        switch (n) {
            case 0: {
                asnInput.readNull();
                return new TimeValue(bBacnetTime, null);
            }
            case 4: {
                d = asnInput.readReal();
                break;
            }
            default: {
                throw new DataTypeNotSupportedException("Invalid tag: " + n);
            }
        }
        return new TimeValue(bBacnetTime, (Object)new Double(d));
    }

    private final TimeValue decodeTimeValueEnum(AsnInput asnInput, BStatusEnum bStatusEnum, int n) throws AsnException {
        BBacnetTime bBacnetTime = asnInput.readTime();
        int n2 = asnInput.peekApplicationTag();
        int n3 = 0;
        switch (n2) {
            case 0: {
                asnInput.readNull();
                return new TimeValue(bBacnetTime, null);
            }
            case 2: {
                if (n == -1 || n == n2) {
                    n3 = asnInput.readUnsignedInt();
                    break;
                }
                throw new AsnException("Invalid tag: " + n2);
            }
            case 3: {
                if (n == -1 || n == n2) {
                    n3 = asnInput.readSignedInteger();
                    break;
                }
                throw new AsnException("Invalid tag: " + n2);
            }
            case 9: {
                if (n == -1 || n == n2) {
                    n3 = asnInput.readEnumerated();
                    break;
                }
                throw new AsnException("Invalid tag: " + n2);
            }
            default: {
                throw new DataTypeNotSupportedException("Invalid tag: " + n2);
            }
        }
        return new TimeValue(bBacnetTime, (Object)new Integer(n3));
    }

    private final TimeValue decodeTimeValueString(AsnInput asnInput, BStatusString bStatusString) throws AsnException {
        String string;
        BBacnetTime bBacnetTime = asnInput.readTime();
        int n = asnInput.peekApplicationTag();
        switch (n) {
            case 0: {
                asnInput.readNull();
                return new TimeValue(bBacnetTime, null);
            }
            case 7: {
                string = asnInput.readCharacterString();
                break;
            }
            default: {
                throw new DataTypeNotSupportedException("Invalid tag: " + n);
            }
        }
        return new TimeValue(bBacnetTime, (Object)string);
    }

    private final TimeValue[] decodeTimeValues(int n, AsnInput asnInput, BStatusValue bStatusValue, int n2) throws AsnException {
        int n3 = asnInput.peekTag();
        if (!asnInput.isOpeningTag(n)) {
            throw new AsnException("Invalid tag: " + n3);
        }
        asnInput.skipTag();
        n3 = asnInput.peekTag();
        Vector<TimeValue> vector = new Vector<TimeValue>();
        while (!asnInput.isClosingTag(n)) {
            if (n3 == -1) {
                throw new AsnException("Invalid tag: " + n3);
            }
            vector.addElement(this.decodeTimeValue(asnInput, bStatusValue, n2));
            n3 = asnInput.peekTag();
        }
        asnInput.skipTag();
        Object[] objectArray = new TimeValue[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private final void encodeScheduleDefault(BStatusBoolean bStatusBoolean, AsnOutput asnOutput, int n) {
        if (bStatusBoolean == null || bStatusBoolean.getStatus().isNull()) {
            asnOutput.writeNull();
        } else {
            int n2 = bStatusBoolean.getValue();
            switch (n) {
                case 1: {
                    asnOutput.writeBoolean(n2 != 0);
                    break;
                }
                case 2: {
                    asnOutput.writeUnsignedInteger(n2);
                    break;
                }
                case 3: {
                    asnOutput.writeSignedInteger(n2);
                    break;
                }
                case 4: {
                    asnOutput.writeReal(n2 != 0 ? 1.0f : 0.0f);
                    break;
                }
                case 5: {
                    asnOutput.writeDouble(n2 != 0 ? 1.0 : 0.0);
                    break;
                }
                case 6: {
                    asnOutput.writeOctetString(new byte[]{(byte)n2});
                    break;
                }
                case 7: {
                    asnOutput.writeCharacterString(String.valueOf(n2 != 0));
                    break;
                }
                case 9: {
                    asnOutput.writeEnumerated(n2);
                    break;
                }
                default: {
                    asnOutput.writeNull();
                }
            }
        }
    }

    private final void encodeScheduleDefault(BStatusNumeric bStatusNumeric, AsnOutput asnOutput, int n) {
        if (bStatusNumeric == null || bStatusNumeric.getStatus().isNull()) {
            asnOutput.writeNull();
        } else {
            double d = bStatusNumeric.getValue();
            switch (n) {
                case 1: {
                    asnOutput.writeBoolean(BDouble.equals((double)d, (double)0.0));
                    break;
                }
                case 2: {
                    asnOutput.writeUnsignedInteger((int)d & Integer.MAX_VALUE);
                    break;
                }
                case 3: {
                    asnOutput.writeSignedInteger((int)d);
                    break;
                }
                case 4: {
                    asnOutput.writeReal((float)d);
                    break;
                }
                case 5: {
                    asnOutput.writeDouble(d);
                    break;
                }
                case 6: {
                    asnOutput.writeOctetString(new byte[]{(byte)d});
                    break;
                }
                case 7: {
                    asnOutput.writeCharacterString(String.valueOf(d));
                    break;
                }
                case 9: {
                    asnOutput.writeEnumerated((int)d);
                    break;
                }
                default: {
                    asnOutput.writeNull();
                }
            }
        }
    }

    private final void encodeScheduleDefault(BStatusEnum bStatusEnum, AsnOutput asnOutput, int n) {
        if (bStatusEnum == null || bStatusEnum.getStatus().isNull()) {
            asnOutput.writeNull();
        } else {
            int n2 = bStatusEnum.getValue().getOrdinal();
            BEnumRange bEnumRange = bStatusEnum.getValue().getRange();
            switch (n) {
                case 1: {
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    asnOutput.writeBoolean(bl);
                    break;
                }
                case 2: {
                    asnOutput.writeUnsignedInteger(n2 & Integer.MAX_VALUE);
                    break;
                }
                case 3: {
                    asnOutput.writeSignedInteger(n2);
                    break;
                }
                case 4: {
                    asnOutput.writeReal(n2);
                    break;
                }
                case 5: {
                    asnOutput.writeDouble(n2);
                    break;
                }
                case 6: {
                    asnOutput.writeOctetString(new byte[]{(byte)n2});
                    break;
                }
                case 7: {
                    asnOutput.writeCharacterString(bEnumRange.getTag(n2));
                    break;
                }
                case 9: {
                    asnOutput.writeEnumerated(n2);
                    break;
                }
                default: {
                    asnOutput.writeNull();
                }
            }
        }
    }

    private final void encodeScheduleDefault(BStatusString bStatusString, AsnOutput asnOutput, int n) {
        if (bStatusString == null || bStatusString.getStatus().isNull()) {
            asnOutput.writeNull();
        } else {
            String string = bStatusString.getValue();
            switch (n) {
                case 1: {
                    asnOutput.writeBoolean(string.equalsIgnoreCase("true"));
                    break;
                }
                case 2: {
                    asnOutput.writeUnsignedInteger(Long.parseLong(string) & Integer.MAX_VALUE);
                    break;
                }
                case 3: {
                    asnOutput.writeSignedInteger(Integer.parseInt(string));
                    break;
                }
                case 4: {
                    asnOutput.writeReal(Float.parseFloat(string));
                    break;
                }
                case 5: {
                    asnOutput.writeDouble(Double.parseDouble(string));
                    break;
                }
                case 6: {
                    asnOutput.writeOctetString(new byte[]{Byte.parseByte(string)});
                    break;
                }
                case 7: {
                    asnOutput.writeCharacterString(string);
                    break;
                }
                case 9: {
                    asnOutput.writeEnumerated(Integer.parseInt(string));
                    break;
                }
                default: {
                    asnOutput.writeNull();
                }
            }
        }
    }

    private final void encodeTimeValue(TimeValue timeValue, AsnOutput asnOutput, int n) {
        asnOutput.writeTime(timeValue.hour, timeValue.minute, timeValue.second, timeValue.hund());
        if (timeValue.value == null) {
            asnOutput.writeNull();
        } else if (timeValue.value instanceof Boolean) {
            this.encodeValue((Boolean)timeValue.value, asnOutput, n);
        } else if (timeValue.value instanceof Double) {
            this.encodeValue((Double)timeValue.value, asnOutput, n);
        } else if (timeValue.value instanceof Integer) {
            this.encodeValue((Integer)timeValue.value, asnOutput, n);
        } else if (timeValue.value instanceof String) {
            this.encodeValue((String)timeValue.value, asnOutput, n);
        } else {
            System.out.println("tv value=" + timeValue.value + (timeValue.value != null ? " " + timeValue.value.getClass() : ""));
        }
    }

    private final void encodeTimeValues(TimeValue[] timeValueArray, int n, AsnOutput asnOutput, int n2) {
        if (timeValueArray == null) {
            return;
        }
        asnOutput.writeOpeningTag(n);
        int n3 = 0;
        while (n3 < timeValueArray.length) {
            this.encodeTimeValue(timeValueArray[n3], asnOutput, n2);
            ++n3;
        }
        asnOutput.writeClosingTag(n);
    }

    private final void encodeValue(Boolean bl, AsnOutput asnOutput, int n) {
        switch (n) {
            case 1: {
                asnOutput.writeBoolean(bl);
                break;
            }
            case 2: {
                asnOutput.writeUnsignedInteger((long)bl.booleanValue());
                break;
            }
            case 3: {
                asnOutput.writeSignedInteger(bl.booleanValue() ? 1 : 0);
                break;
            }
            case 4: {
                asnOutput.writeReal(bl != false ? 1.0f : 0.0f);
                break;
            }
            case 5: {
                asnOutput.writeDouble(bl != false ? 1.0 : 0.0);
                break;
            }
            case 6: {
                asnOutput.writeOctetString(new byte[]{(byte)(bl.booleanValue() ? 1 : 0)});
                break;
            }
            case 7: {
                asnOutput.writeCharacterString(bl.toString());
                break;
            }
            case 9: {
                asnOutput.writeEnumerated(bl.booleanValue() ? 1 : 0);
                break;
            }
            default: {
                asnOutput.writeBoolean(bl);
            }
        }
    }

    private final void encodeValue(Double d, AsnOutput asnOutput, int n) {
        switch (n) {
            case 1: {
                asnOutput.writeBoolean(BDouble.equals((double)d, (double)0.0) ^ true);
                break;
            }
            case 2: {
                asnOutput.writeUnsignedInteger((int)d.doubleValue());
                break;
            }
            case 3: {
                asnOutput.writeSignedInteger((int)d.doubleValue());
                break;
            }
            case 4: {
                asnOutput.writeReal((float)d.doubleValue());
                break;
            }
            case 5: {
                asnOutput.writeDouble(d);
                break;
            }
            case 6: {
                asnOutput.writeOctetString(new byte[]{(byte)d.doubleValue()});
                break;
            }
            case 7: {
                asnOutput.writeCharacterString(d.toString());
                break;
            }
            case 9: {
                asnOutput.writeEnumerated((int)d.doubleValue());
                break;
            }
            default: {
                asnOutput.writeReal((float)d.doubleValue());
            }
        }
    }

    private final void encodeValue(Integer n, AsnOutput asnOutput, int n2) {
        switch (n2) {
            case 1: {
                boolean bl = false;
                if (n != 0) {
                    bl = true;
                }
                asnOutput.writeBoolean(bl);
                break;
            }
            case 2: {
                asnOutput.writeUnsignedInteger((long)(n & Integer.MAX_VALUE));
                break;
            }
            case 3: {
                asnOutput.writeSignedInteger(n);
                break;
            }
            case 4: {
                asnOutput.writeReal(n.intValue());
                break;
            }
            case 5: {
                asnOutput.writeDouble(n.intValue());
                break;
            }
            case 6: {
                asnOutput.writeOctetString(new byte[]{(byte)n.intValue()});
                break;
            }
            case 7: {
                asnOutput.writeCharacterString(n.toString());
                break;
            }
            case 9: {
                asnOutput.writeEnumerated(n);
                break;
            }
            default: {
                asnOutput.writeUnsignedInteger((long)(n & Integer.MAX_VALUE));
            }
        }
    }

    private final void encodeValue(String string, AsnOutput asnOutput, int n) {
        switch (n) {
            case 1: {
                asnOutput.writeBoolean(string.equalsIgnoreCase("true"));
                break;
            }
            case 2: {
                asnOutput.writeUnsignedInteger(Long.parseLong(string) & Integer.MAX_VALUE);
                break;
            }
            case 3: {
                asnOutput.writeSignedInteger(Integer.parseInt(string));
                break;
            }
            case 4: {
                asnOutput.writeReal(Float.parseFloat(string));
                break;
            }
            case 5: {
                asnOutput.writeDouble(Double.parseDouble(string));
                break;
            }
            case 6: {
                asnOutput.writeOctetString(new byte[]{Byte.parseByte(string)});
                break;
            }
            case 7: {
                asnOutput.writeCharacterString(string);
                break;
            }
            case 9: {
                asnOutput.writeEnumerated(Integer.parseInt(string));
                break;
            }
            default: {
                asnOutput.writeCharacterString(string);
            }
        }
    }

    static Log log() {
        return Log.getLog((String)"bacnet.schedule");
    }

    public static void main(String[] stringArray) {
    }

    static void dumpSet(TreeSet treeSet, String string) {
        System.out.println(string + ", set:");
        int n = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            System.out.println("" + n + ':' + iterator.next());
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.devext = null;
    }

    public ScheduleSupport0() {
        this.this();
    }

    public ScheduleSupport0(BBacnetScheduleDeviceExt bBacnetScheduleDeviceExt) {
        this.this();
        this.devext = bBacnetScheduleDeviceExt;
    }

    static class TimeValue {
        public int hour;
        public int minute;
        public int second;
        public int millis;
        public Object value;

        public int compareTo(Object object) {
            int n;
            int n2 = this.millis();
            if (n2 < (n = ((TimeValue)object).millis())) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return 0;
        }

        public int millis() {
            int n = this.second * 1000;
            n += this.minute * 60000;
            n += this.hour * 3600000;
            return n += this.millis;
        }

        public int hund() {
            return this.millis < 0 ? this.millis : this.millis / 10;
        }

        public String toString() {
            return "" + this.hour + ':' + this.minute + ':' + this.second + '.' + this.millis + ", " + this.value;
        }

        public TimeValue() {
        }

        public TimeValue(BTime bTime, Object object) {
            this.hour = bTime.getHour();
            this.minute = bTime.getMinute();
            this.second = bTime.getSecond();
            this.millis = bTime.getMillisecond();
            this.value = object;
        }

        public TimeValue(BBacnetTime bBacnetTime, Object object) {
            this.hour = bBacnetTime.getHour();
            this.minute = bBacnetTime.getMinute();
            this.second = bBacnetTime.getSecond();
            this.millis = bBacnetTime.getHundredth();
            if (this.millis > 0) {
                this.millis *= 10;
            }
            this.value = object;
        }
    }

    private static class BacnetScheduleComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object != null && object2 != null && object instanceof BDailySchedule && object2 instanceof BDailySchedule) {
                BDailySchedule bDailySchedule = (BDailySchedule)object;
                BDailySchedule bDailySchedule2 = (BDailySchedule)object2;
                BValue bValue = bDailySchedule.get(ScheduleSupport0.BACNET_IDX);
                BValue bValue2 = bDailySchedule2.get(ScheduleSupport0.BACNET_IDX);
                if (bValue != null && bValue2 != null && bValue instanceof BInteger && bValue2 instanceof BInteger) {
                    BInteger bInteger = (BInteger)bValue;
                    BInteger bInteger2 = (BInteger)bValue2;
                    return bInteger.getInt() - bInteger2.getInt();
                }
            }
            return 0;
        }

        private BacnetScheduleComparator() {
        }
    }
}

