/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.job;

import com.tridium.bacnet.datatypes.BDiscoveryNetworks;
import com.tridium.bacnet.datatypes.BWhoHasConfig;
import com.tridium.bacnet.job.BDeviceManagerJob;
import com.tridium.bacnet.services.unconfirmed.IHaveRequest;
import com.tridium.bacnet.stack.IHaveListener;
import java.text.MessageFormat;
import java.util.Vector;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetUnconfirmedServiceChoice;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWhoHasJob
extends BDeviceManagerJob
implements IHaveListener {
    public static final Type TYPE;
    private BWhoHasConfig params;
    private Vector iHaves;
    static /* synthetic */ Class class$com$tridium$bacnet$job$BWhoHasJob;

    public Type getType() {
        return TYPE;
    }

    public void run(Context context) throws Exception {
        Object object;
        if (this.bacnet == null) {
            throw new IllegalStateException("Must submit thru BacnetNetwork.submitDeviceManagerJob()");
        }
        if (this.params == null) {
            return;
        }
        this.server().registerIHaveListener(this);
        BDiscoveryNetworks bDiscoveryNetworks = this.params.getNetworks();
        if (bDiscoveryNetworks.isAllNetworks()) {
            object = BBacnetAddress.GLOBAL_BROADCAST_ADDRESS;
            try {
                if (this.params.isDefaultRange()) {
                    if (this.params.getUse().getOrdinal() == 0) {
                        this.client().whoHas((BBacnetAddress)object, this.params.getObjectId());
                    }
                    this.client().whoHas((BBacnetAddress)object, this.params.getObjectName(), this.bacnet.getLocalDevice().getCharacterSet());
                }
                if (this.params.getUse().getOrdinal() == 0) {
                    this.client().whoHas((BBacnetAddress)object, this.params.getObjectId(), this.params.getDeviceLowLimit(), this.params.getDeviceHighLimit());
                }
                this.client().whoHas((BBacnetAddress)object, this.params.getObjectName(), this.bacnet.getLocalDevice().getCharacterSet(), this.params.getDeviceLowLimit(), this.params.getDeviceHighLimit());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        } else {
            try {
                object = bDiscoveryNetworks.getNetworks();
                int n = 0;
                while (n < ((Object)object).length) {
                    BBacnetAddress bBacnetAddress = new BBacnetAddress((int)object[n], null);
                    if (this.params.isDefaultRange()) {
                        if (this.params.getUse().getOrdinal() == 0) {
                            this.client().whoHas(bBacnetAddress, this.params.getObjectId());
                        } else {
                            this.client().whoHas(bBacnetAddress, this.params.getObjectName(), this.bacnet.getLocalDevice().getCharacterSet());
                        }
                    } else if (this.params.getUse().getOrdinal() == 0) {
                        this.client().whoHas(bBacnetAddress, this.params.getObjectId(), this.params.getDeviceLowLimit(), this.params.getDeviceHighLimit());
                    } else {
                        this.client().whoHas(bBacnetAddress, this.params.getObjectName(), this.bacnet.getLocalDevice().getCharacterSet(), this.params.getDeviceLowLimit(), this.params.getDeviceHighLimit());
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        object = BAbsTime.make();
        long l = object.getMillis();
        BRelTime bRelTime = BRelTime.makeSeconds((int)this.params.getWaitResponseTime());
        BAbsTime bAbsTime = object.add(bRelTime);
        double d = bAbsTime.getMillis() - l;
        BAbsTime bAbsTime2 = BAbsTime.make();
        int n = 0;
        while (bAbsTime2.isBefore(bAbsTime) || n < this.iHaves.size()) {
            if (n == this.iHaves.size()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                IHave iHave = (IHave)this.iHaves.elementAt(n);
                IHaveRequest iHaveRequest = iHave.iHave;
                this.add(null, (BValue)iHaveRequest.toJob());
                ++n;
            }
            bAbsTime2 = BAbsTime.make();
            int n2 = (int)((double)(bAbsTime2.getMillis() - l) / d * 100.0);
            if (n2 > 100) {
                n2 = 100;
            }
            this.progress(n2);
        }
        this.server().unregisterIHaveListener(this);
    }

    public void receiveIHave(IHaveRequest iHaveRequest, BBacnetAddress bBacnetAddress) {
        this.iHaves.addElement(new IHave(iHaveRequest, bBacnetAddress));
        this.log().message(MessageFormat.format(lex.getText("whoHas.found"), new Object[]{BacnetUnconfirmedServiceChoice.TAGS[1], bBacnetAddress, iHaveRequest.getObjectId(), iHaveRequest.getObjectName()}));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.iHaves = new Vector();
    }

    public BWhoHasJob() {
        this.this();
    }

    public BWhoHasJob(BBacnetNetwork bBacnetNetwork, BWhoHasConfig bWhoHasConfig) {
        super(bBacnetNetwork);
        this.this();
        this.params = bWhoHasConfig;
        this.add(SlotPath.escape((String)"Who Has"), (BValue)BString.make((String)bWhoHasConfig.toString()));
    }

    static {
        Class clazz = class$com$tridium$bacnet$job$BWhoHasJob;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$job$BWhoHasJob = BWhoHasJob.class("[Lcom.tridium.bacnet.job.BWhoHasJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class IHave {
        IHaveRequest iHave;
        BBacnetAddress addr;

        IHave(IHaveRequest iHaveRequest, BBacnetAddress bBacnetAddress) {
            this.iHave = iHaveRequest;
            this.addr = bBacnetAddress;
        }
    }
}

