/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.job;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.history.BBacnetHistoryDeviceExt;
import com.tridium.bacnet.history.BacnetTrendLogUtil;
import com.tridium.bacnet.job.BBacnetDiscoverJob;
import com.tridium.bacnet.job.BDiscoveryLog;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.driver.BDeviceExt;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetDiscoverTrendLogsJob
extends BBacnetDiscoverJob {
    public static final Type TYPE;
    private static final Lexicon lex;
    private static final String HISTORY_TYPE_UNKNOWN;
    static /* synthetic */ Class class$com$tridium$bacnet$job$BBacnetDiscoverTrendLogsJob;

    public Type getType() {
        return TYPE;
    }

    protected boolean doForId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        boolean bl = false;
        if (bBacnetObjectIdentifier.getObjectType() == 20 || bBacnetObjectIdentifier.getObjectType() == 27) {
            bl = true;
        }
        return bl;
    }

    int[] getDiscoveryPropIds(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        return new int[]{132, 28};
    }

    void addDiscoveryChild(BBacnetDiscoverJob.IdVals idVals) {
        String string = this.findHistoryType(idVals);
        BDiscoveryLog bDiscoveryLog = new BDiscoveryLog(idVals.name, idVals.id, string);
        BBacnetDiscoverJob.PropVal propVal = idVals.get(28);
        if (propVal != null) {
            bDiscoveryLog.setDescription(propVal.toString());
        }
        this.add(null, (BValue)bDiscoveryLog);
    }

    private final String findHistoryType(BBacnetDiscoverJob.IdVals idVals) {
        String string = null;
        try {
            BTypeSpec bTypeSpec;
            BBacnetDiscoverJob.PropVal propVal = idVals.get(132);
            if (propVal != null) {
                if (log.isTraceOn()) {
                    log.trace("findHistoryType: ldop=" + propVal.dbg());
                }
                if (!propVal.err) {
                    string = BBacnetDiscoverTrendLogsJob.getHistoryType((BBacnetDeviceObjectPropertyReference)propVal.val);
                }
            }
            if (string == null && idVals.id != null && (bTypeSpec = BacnetTrendLogUtil.findHistoryTypeByRecords(this.device, idVals.id)) != null) {
                String string2 = bTypeSpec.getTypeName();
                string = string2.substring(6, string2.length() - 11);
            }
            if (string == null && propVal != null) {
                string = this.guessHistoryTypeByAsn((BBacnetDeviceObjectPropertyReference)propVal.val);
            }
        }
        catch (Exception exception) {
            this.log().message("Unable to determine history type for history " + idVals);
            string = HISTORY_TYPE_UNKNOWN;
        }
        return string;
    }

    private static final String getHistoryType(BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference) {
        int n = bBacnetDeviceObjectPropertyReference.getObjectId().getObjectType();
        int n2 = bBacnetDeviceObjectPropertyReference.getPropertyId();
        if (bBacnetDeviceObjectPropertyReference.getObjectId().getInstanceNumber() == 0x3FFFFF) {
            return null;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                if (n2 != 85) break;
                return "Numeric";
            }
            case 3: 
            case 4: 
            case 5: {
                if (n2 != 85) break;
                return "Boolean";
            }
            case 13: 
            case 14: 
            case 19: {
                if (n2 != 85) break;
                return "Enum";
            }
        }
        return null;
    }

    private final String guessHistoryTypeByAsn(BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference) {
        int n;
        int n2 = bBacnetDeviceObjectPropertyReference.getObjectId().getObjectType();
        PropertyInfo propertyInfo = this.device.getPropertyInfo(n2, n = bBacnetDeviceObjectPropertyReference.getPropertyId());
        if (propertyInfo != null) {
            int n3 = propertyInfo.getAsnType();
            if (n3 == -2) {
                if (bBacnetDeviceObjectPropertyReference.getPropertyArrayIndex() == -1) {
                    return "String";
                }
                String string = propertyInfo.getType();
                Type type = BTypeSpec.make((String)string).getResolvedType();
                n3 = AsnUtil.getAsnType(type);
            }
            return BBacnetDiscoverTrendLogsJob.asnTypeToHistoryRecordType(propertyInfo.getAsnType());
        }
        return "String";
    }

    private static final String asnTypeToHistoryRecordType(int n) {
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return "Boolean";
            }
            case 2: {
                return "Enum";
            }
            case 3: {
                return "Enum";
            }
            case 4: {
                return "Numeric";
            }
            case 5: {
                return "Numeric";
            }
            case 6: {
                return "String";
            }
            case 7: {
                return "String";
            }
            case 8: {
                return "String";
            }
            case 9: {
                return "Enum";
            }
            case 10: {
                return "String";
            }
            case 11: {
                return "String";
            }
            case 12: {
                return "String";
            }
        }
        return "String";
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BBacnetDiscoverTrendLogsJob() {
    }

    public BBacnetDiscoverTrendLogsJob(BBacnetHistoryDeviceExt bBacnetHistoryDeviceExt) {
        super((BDeviceExt)bBacnetHistoryDeviceExt);
    }

    static {
        Class clazz = class$com$tridium$bacnet$job$BBacnetDiscoverTrendLogsJob;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$job$BBacnetDiscoverTrendLogsJob = BBacnetDiscoverTrendLogsJob.class("[Lcom.tridium.bacnet.job.BBacnetDiscoverTrendLogsJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"bacnet");
        HISTORY_TYPE_UNKNOWN = lex.getText("historyType.unknown");
    }
}

