/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.job;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.datatypes.BDeviceDiscoveryConfig;
import com.tridium.bacnet.datatypes.BDiscoveryNetworks;
import com.tridium.bacnet.job.BDeviceManagerJob;
import com.tridium.bacnet.job.BDiscoveryDevice;
import com.tridium.bacnet.services.unconfirmed.IAmRequest;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.IAmListener;
import com.tridium.bacnet.stack.link.BBacnetLinkLayer;
import com.tridium.bacnet.stack.link.ethernet.BBacnetEthernetLinkLayer;
import com.tridium.bacnet.stack.link.ip.BBacnetIpLinkLayer;
import com.tridium.bacnet.stack.link.mstp.BBacnetMstpLinkLayer;
import com.tridium.bacnet.stack.network.BNetworkPort;
import java.text.MessageFormat;
import java.util.Vector;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetDiscoverDevicesJob
extends BDeviceManagerJob
implements IAmListener {
    public static final Type TYPE;
    private BDeviceDiscoveryConfig params;
    private Vector iAmDevices;
    private int count;
    static /* synthetic */ Class class$com$tridium$bacnet$job$BBacnetDiscoverDevicesJob;
    static /* synthetic */ Class class$com$tridium$bacnet$job$BDiscoveryDevice;

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(Context var1_1) throws Exception {
        if (this.bacnet == null) {
            throw new IllegalStateException("Must submit thru BacnetNetwork.submitDeviceManagerJob()");
        }
        if (this.params == null) {
            return;
        }
        this.log().start(BBacnetDiscoverDevicesJob.lex.getText("deviceManager.begin"));
        var2_2 = null;
        this.server().registerIAmListener(this);
        var3_3 = this.params.getNetworks();
        if (var3_3.isAllNetworks()) {
            var4_4 = BBacnetAddress.GLOBAL_BROADCAST_ADDRESS;
            var2_2 = BBacnetDiscoverDevicesJob.lex.getText("deviceManager.params.global");
            try {
                if (this.params.isDefaultRange()) {
                    this.log().message(var2_2 + BBacnetDiscoverDevicesJob.lex.getText("deviceManager.params.all"));
                    this.client().whoIs((BBacnetAddress)var4_4);
                }
                var2_2 = var2_2 + MessageFormat.format(BBacnetDiscoverDevicesJob.lex.getText("deviceManager.params.range"), new Object[]{new Integer(this.params.getDeviceLowLimit()), new Integer(this.params.getDeviceHighLimit())});
                this.log().message(var2_2);
                this.client().whoIs((BBacnetAddress)var4_4, this.params.getDeviceLowLimit(), this.params.getDeviceHighLimit());
            }
            catch (Exception var5_6) {
                this.log().failed(BBacnetDiscoverDevicesJob.lex.getText("deviceManager.failed") + "\n  " + var5_6);
                Log.getLog((String)"bacnet.client").error("Exception sending " + var2_2 + ": " + var5_6, (Throwable)var5_6);
                return;
            }
        } else {
            var2_2 = BBacnetDiscoverDevicesJob.lex.getText("deviceManager.params.local");
            try {
                var4_4 = var3_3.getNetworks();
                var5_7 = 0;
                while (var5_7 < ((Object)var4_4).length) {
                    var6_9 = new BBacnetAddress((int)var4_4[var5_7], null);
                    if (this.params.isDefaultRange()) {
                        this.log().message(var2_2 + BBacnetDiscoverDevicesJob.lex.getText("deviceManager.params.all"));
                        this.client().whoIs(var6_9);
                    } else {
                        var2_2 = var2_2 + MessageFormat.format(BBacnetDiscoverDevicesJob.lex.getText("deviceManager.params.range"), new Object[]{new Integer(this.params.getDeviceLowLimit()), new Integer(this.params.getDeviceHighLimit())});
                        this.log().message(var2_2);
                        this.client().whoIs(var6_9, this.params.getDeviceLowLimit(), this.params.getDeviceHighLimit());
                    }
                    ++var5_7;
                }
            }
            catch (Exception var4_5) {
                this.log().failed(BBacnetDiscoverDevicesJob.lex.getText("deviceManager.failed") + "\n  " + var4_5);
                Log.getLog((String)"bacnet.client").error("Exception sending " + var2_2 + ": " + var4_5, (Throwable)var4_5);
                return;
            }
        }
        var4_4 = BAbsTime.make();
        var5_8 = var4_4.getMillis();
        var7_10 = BRelTime.makeSeconds((int)this.params.getWaitResponseTime());
        var8_11 = var4_4.add(var7_10);
        var9_12 = var8_11.getMillis() - var5_8;
        var11_13 = BAbsTime.make();
        this.count = 0;
        var12_14 = 0;
        var13_15 = null;
        var14_16 = new Vector<BBacnetObjectIdentifier>();
        var15_17 = this.iAmDevices;
        synchronized (var15_17) {
            var12_14 = this.iAmDevices.size();
            ** GOTO lbl112
        }
        while (this.isAlive()) {
            if (this.count == var12_14) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException v1) {}
            } else {
                block35: {
                    var17_19 = this.iAmDevices;
                    synchronized (var17_19) {
                        var13_15 = (IAmDevice)this.iAmDevices.get(this.count);
                        // MONITOREXIT @DISABLED, blocks:[16, 4, 7, 31] lbl76 : MonitorExitStatement: MONITOREXIT : var17_19
                        var19_23 = var13_15.iAm.getObjectId().getInstanceNumber();
                        if (!this.params.isDefaultRange() && (var19_23 < this.params.getDeviceLowLimit() || var19_23 > this.params.getDeviceHighLimit())) break block35;
                    }
                    this.log().message("Reading parameters for " + (Object)var13_15.iAm.getObjectId() + ", " + (this.count + 1) + " of " + var12_14);
                    var20_27 = this.discoverDevice(var13_15);
                    if (var13_15.dup) {
                        var20_27.setDuplicate(true);
                        var14_16.add(var13_15.iAm.getObjectId());
                    }
                    this.add(null, (BValue)var20_27);
                }
                ++this.count;
            }
            var11_13 = BAbsTime.make();
            var17_18 = (int)((double)(var11_13.getMillis() - var5_8) / var9_12 * 100.0);
            var18_21 = (int)((double)this.count * 100.0 / (double)var12_14);
            var20_26 = var19_23 = this.getProgress();
            if (var17_18 < var18_21) {
                if (var17_18 > var20_26) {
                    var20_26 = var17_18;
                }
            } else {
                if (var18_21 > var20_26) {
                    var20_26 = var18_21;
                }
                if (var18_21 == 0) {
                    var20_26 = var17_18;
                }
            }
            if (var20_26 > 100) {
                var20_26 = 100;
                this.log().message(BBacnetDiscoverDevicesJob.lex.getText("deviceManager.finishing"));
            }
            this.progress(var20_26);
            var21_28 = this.iAmDevices;
            synchronized (var21_28) {
                var12_14 = this.iAmDevices.size();
            }
lbl112:
            // 2 sources

            if (var11_13.isBefore(var8_11) || this.count < var12_14) continue;
        }
        var17_20 = var14_16.iterator();
        while (var17_20.hasNext()) {
            var18_22 = (BBacnetObjectIdentifier)var17_20.next();
            var19_25 = this.getDuplicateDevices(var18_22);
            if (var19_25.length <= 1) continue;
            var20_26 = 0;
            while (var20_26 < var19_25.length) {
                var19_25[var20_26].setDuplicate(true);
                ++var20_26;
            }
        }
        this.log().success(BBacnetDiscoverDevicesJob.lex.getText("deviceManager.end"));
        this.server().unregisterIAmListener(this);
    }

    private final BDiscoveryDevice discoverDevice(IAmDevice iAmDevice) {
        Object object;
        IAmRequest iAmRequest = iAmDevice.iAm;
        BBacnetAddress bBacnetAddress = iAmDevice.addr;
        BBacnetObjectIdentifier bBacnetObjectIdentifier = iAmRequest.getObjectId();
        String string = bBacnetObjectIdentifier.toString(BacnetConst.nameContext);
        BCharacterSetEncoding bCharacterSetEncoding = BCharacterSetEncoding.unknown;
        int n = -1;
        BBacnetBitString bBacnetBitString = BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetServicesSupported"));
        String string2 = lex.getText("deviceManager.unknown");
        String string3 = lex.getText("deviceManager.unknown");
        String string4 = lex.getText("deviceManager.unknown");
        String string5 = lex.getText("deviceManager.unknown");
        try {
            object = this.client().readProperty(bBacnetAddress, bBacnetObjectIdentifier, 77);
            if (object != null) {
                bCharacterSetEncoding = AsnUtil.getCharacterSetEncoding(object);
                string = AsnUtil.fromAsnCharacterString(object);
                if (!this.isValidName(string)) {
                    string = "";
                }
            }
            if ((object = this.client().readProperty(bBacnetAddress, bBacnetObjectIdentifier, 76, 0)) != null) {
                n = AsnUtil.fromAsnUnsignedInt(object);
            }
            if ((object = this.client().readProperty(bBacnetAddress, bBacnetObjectIdentifier, 97)) != null) {
                bBacnetBitString = AsnUtil.fromAsnBitString(object);
            }
            if ((object = this.client().readProperty(bBacnetAddress, bBacnetObjectIdentifier, 121)) != null) {
                string2 = AsnUtil.fromAsnCharacterString(object);
            }
            if ((object = this.client().readProperty(bBacnetAddress, bBacnetObjectIdentifier, 70)) != null) {
                string3 = AsnUtil.fromAsnCharacterString(object);
            }
            if ((object = this.client().readProperty(bBacnetAddress, bBacnetObjectIdentifier, 44)) != null) {
                string4 = AsnUtil.fromAsnCharacterString(object);
            }
            if ((object = this.client().readProperty(bBacnetAddress, bBacnetObjectIdentifier, 12)) != null) {
                string5 = AsnUtil.fromAsnCharacterString(object);
            }
        }
        catch (AsnException asnException) {
            this.log().failed("Unable to convert device name/listSize for " + string + ':' + (Object)((Object)asnException));
        }
        catch (BacnetException bacnetException) {
            this.log().failed("BacnetException " + (Object)((Object)bacnetException) + " trying to read device parameters for " + (Object)((Object)bBacnetObjectIdentifier));
            Log.getLog((String)"bacnet.client").error("BacnetException trying to read device parameters: " + (Object)((Object)bacnetException), (Throwable)((Object)bacnetException));
        }
        catch (Exception exception) {
            this.log().failed("Unable to read device parameters for " + string + " [" + (Object)((Object)bBacnetObjectIdentifier) + "]:" + exception);
        }
        object = (Object)new BDiscoveryDevice(string, iAmRequest, bBacnetAddress, n, bCharacterSetEncoding, bBacnetBitString, string2, string3, string4, string5);
        return object;
    }

    /*
     * Unable to fully structure code
     */
    BDiscoveryDevice[] getDuplicateDevices(BBacnetObjectIdentifier var1_1) {
        v0 = BBacnetDiscoverDevicesJob.class$com$tridium$bacnet$job$BDiscoveryDevice;
        if (v0 == null) {
            v0 = BBacnetDiscoverDevicesJob.class$com$tridium$bacnet$job$BDiscoveryDevice = BBacnetDiscoverDevicesJob.class("[Lcom.tridium.bacnet.job.BDiscoveryDevice;", false);
        }
        var2_2 = new Array(v0);
        var3_3 = this.getProperties();
        if (true) ** GOTO lbl11
        do {
            if ((var4_4 = (BDiscoveryDevice)var3_3.get()).getObjectId().equals((Object)var1_1)) {
                var2_2.add((Object)var4_4);
            }
lbl11:
            // 4 sources

            if ((v1 = BBacnetDiscoverDevicesJob.class$com$tridium$bacnet$job$BDiscoveryDevice) != null) continue;
            v1 = BBacnetDiscoverDevicesJob.class("[Lcom.tridium.bacnet.job.BDiscoveryDevice;", false);
        } while (var3_3.next(v1));
        return (BDiscoveryDevice[])var2_2.trim();
    }

    public void receiveIAm(IAmRequest iAmRequest, BBacnetAddress bBacnetAddress) {
        int n = iAmRequest.getObjectId().getInstanceNumber();
        if (this.identifierInRange(this.params, n) && this.networkInRange(this.params, bBacnetAddress.getNetworkNumber())) {
            this.setLinkLayer(bBacnetAddress);
            this.addDevice(iAmRequest, bBacnetAddress);
        }
    }

    private final void setLinkLayer(BBacnetAddress bBacnetAddress) {
        BNetworkPort bNetworkPort = ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getNetwork().getPortByNetwork(bBacnetAddress.getNetworkNumber());
        if (bNetworkPort != null && bNetworkPort.getNetworkNumber() == bBacnetAddress.getNetworkNumber()) {
            BBacnetLinkLayer bBacnetLinkLayer = bNetworkPort.getLink();
            if (bBacnetLinkLayer instanceof BBacnetIpLinkLayer) {
                bBacnetAddress.setInt(BBacnetAddress.addressType, 2, BacnetConst.noWrite);
            } else if (bBacnetLinkLayer instanceof BBacnetEthernetLinkLayer) {
                bBacnetAddress.setInt(BBacnetAddress.addressType, 1, BacnetConst.noWrite);
            } else if (bBacnetLinkLayer instanceof BBacnetMstpLinkLayer) {
                bBacnetAddress.setInt(BBacnetAddress.addressType, 3, BacnetConst.noWrite);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void addDevice(IAmRequest iAmRequest, BBacnetAddress bBacnetAddress) {
        block5: {
            IAmDevice iAmDevice = new IAmDevice(iAmRequest, bBacnetAddress);
            String string = null;
            Vector vector = this.iAmDevices;
            synchronized (vector) {
                int n = this.index(this.iAmDevices, iAmRequest.getObjectId().getInstanceNumber(), bBacnetAddress);
                if (n < 0) {
                    this.iAmDevices.add(iAmDevice);
                    string = MessageFormat.format(lex.getText("deviceManager.found"), new Object[]{iAmRequest.getObjectId(), bBacnetAddress});
                } else {
                    iAmDevice.dup = true;
                    this.iAmDevices.add(iAmDevice);
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl15 : MonitorExitStatement: MONITOREXIT : var5_5
                if (string == null) break block5;
            }
            this.log().message(string);
        }
    }

    private final boolean identifierInRange(BDeviceDiscoveryConfig bDeviceDiscoveryConfig, int n) {
        if (bDeviceDiscoveryConfig.isDefaultRange()) {
            return true;
        }
        boolean bl = false;
        if (n >= bDeviceDiscoveryConfig.getDeviceLowLimit() && n <= bDeviceDiscoveryConfig.getDeviceHighLimit()) {
            bl = true;
        }
        return bl;
    }

    private final boolean networkInRange(BDeviceDiscoveryConfig bDeviceDiscoveryConfig, int n) {
        BDiscoveryNetworks bDiscoveryNetworks = bDeviceDiscoveryConfig.getNetworks();
        if (bDiscoveryNetworks.isAllNetworks()) {
            return true;
        }
        return bDiscoveryNetworks.contains(n);
    }

    private final int index(Vector vector, int n, BBacnetAddress bBacnetAddress) {
        int n2 = 0;
        while (n2 < vector.size()) {
            IAmDevice iAmDevice = (IAmDevice)vector.get(n2);
            if (iAmDevice.iAm.getObjectId().getInstanceNumber() == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private final boolean isValidName(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        return string.length() != 1 || SlotPath.isValidName((String)string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.iAmDevices = new Vector();
    }

    public BBacnetDiscoverDevicesJob() {
        this.this();
    }

    public BBacnetDiscoverDevicesJob(BBacnetNetwork bBacnetNetwork, BDeviceDiscoveryConfig bDeviceDiscoveryConfig) {
        super(bBacnetNetwork);
        this.this();
        this.params = bDeviceDiscoveryConfig;
    }

    static {
        Class clazz = class$com$tridium$bacnet$job$BBacnetDiscoverDevicesJob;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$job$BBacnetDiscoverDevicesJob = BBacnetDiscoverDevicesJob.class("[Lcom.tridium.bacnet.job.BBacnetDiscoverDevicesJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class IAmDevice {
        IAmRequest iAm;
        BBacnetAddress addr;
        boolean dup;

        IAmDevice(IAmRequest iAmRequest, BBacnetAddress bBacnetAddress) {
            this.iAm = iAmRequest;
            this.addr = bBacnetAddress;
        }
    }
}

