/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.history;

import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.datatypes.BTrendEvent;
import com.tridium.bacnet.history.BBacnetBooleanTrendRecord;
import com.tridium.bacnet.history.BBacnetEnumTrendRecord;
import com.tridium.bacnet.history.BBacnetNumericTrendRecord;
import com.tridium.bacnet.history.BBacnetTrendLogAlarmSourceExt;
import com.tridium.bacnet.history.BBacnetTrendRecord;
import com.tridium.bacnet.history.BIBacnetTrendLogExt;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.stack.BBacnetStack;
import java.io.IOException;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmService;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetLogRecord;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.export.BBacnetNotificationClassDescriptor;
import javax.baja.bacnet.export.BOutOfServiceExt;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.point.BBacnetProxyExt;
import javax.baja.control.BPointExtension;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BTrendFlags;
import javax.baja.history.BTrendRecord;
import javax.baja.history.HistoryException;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.log.Log;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BTypeSpec;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BacnetTrendLogUtil
implements BacnetConst {
    protected static AsnOutputStream asnOut = new AsnOutputStream();
    protected static Log log = Log.getLog((String)"bacnet.history");
    public static long MAX_SEQ_NUM = 0xFFFFFFFFL;
    private static final RangeData EMPTY_RESULT = new ReadLogResult(0L, -1, new byte[0], false, false, false);
    static /* synthetic */ Class class$com$tridium$bacnet$history$BBacnetTrendLogAlarmSourceExt;
    static /* synthetic */ Class class$javax$baja$bacnet$point$BBacnetProxyExt;
    static /* synthetic */ Class class$com$tridium$bacnet$history$BacnetTrendLogUtil$EncodedRecord;

    public static final long incrementSequenceNumber(long l) {
        if (l < 0L) {
            return 1L;
        }
        if (++l > MAX_SEQ_NUM) {
            l = 1L;
        }
        return l;
    }

    public static BOutOfServiceExt getOosExt(BHistoryExt bHistoryExt) {
        BPointExtension[] bPointExtensionArray = bHistoryExt.getParentPoint().getExtensions();
        int n = 0;
        while (n < bPointExtensionArray.length) {
            if (bPointExtensionArray[n] instanceof BOutOfServiceExt) {
                return (BOutOfServiceExt)bPointExtensionArray[n];
            }
            ++n;
        }
        return null;
    }

    public static BIHistory getHistory(BIBacnetTrendLogExt bIBacnetTrendLogExt) {
        BHistoryConfig bHistoryConfig;
        BHistoryId bHistoryId;
        BHistoryService bHistoryService;
        BHistoryDatabase bHistoryDatabase;
        BIHistory bIHistory = bIBacnetTrendLogExt.getHistory();
        if (bIHistory == null && (bHistoryDatabase = (bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase()).exists(bHistoryId = (bHistoryConfig = bIBacnetTrendLogExt.getHistoryConfig()).getId())) {
            bIHistory = bHistoryDatabase.getHistory(bHistoryId);
        }
        return bIHistory;
    }

    public static BTypeSpec findHistoryTypeByRecords(BBacnetDevice bBacnetDevice, BBacnetObjectIdentifier bBacnetObjectIdentifier) throws Exception {
        if (log.isTraceOn()) {
            log.trace("findHistoryTypeByRecords for " + (Object)((Object)bBacnetObjectIdentifier));
        }
        BBacnetLogRecord bBacnetLogRecord = new BBacnetLogRecord();
        BTypeSpec bTypeSpec = null;
        long l = 1L;
        int n = 1;
        while (bTypeSpec == null && l > 0L) {
            ReadRangeAck readRangeAck = ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient().readRange(bBacnetDevice.getAddress(), bBacnetObjectIdentifier, 131, -1, 3, n++, null, 1);
            l = readRangeAck.getItemCount();
            if (l <= 0L) continue;
            try {
                AsnUtil.fromAsn(readRangeAck.getItemData(), (BValue)bBacnetLogRecord);
                bTypeSpec = bBacnetLogRecord.getNiagaraRecordType();
            }
            catch (AsnException asnException) {
                log.message("Unable to convert ASN-encoded BACnetLogRecord (" + ByteArrayUtil.toHexString((byte[])readRangeAck.getItemData()) + ") for object " + (Object)((Object)bBacnetObjectIdentifier));
            }
        }
        return bTypeSpec;
    }

    public static long getMaxRecords(BIBacnetTrendLogExt bIBacnetTrendLogExt) {
        BHistoryConfig bHistoryConfig = bIBacnetTrendLogExt.getHistoryConfig();
        long l = 0xFFFFFFFFL;
        if (bHistoryConfig.getCapacity().isByRecordCount()) {
            l = bHistoryConfig.getCapacity().getMaxRecords();
        } else if (bHistoryConfig.getCapacity().isByStorageSize()) {
            long l2 = bHistoryConfig.getCapacity().getMaxStorage();
            int n = 1;
            try {
                n = bHistoryConfig.getRecordSize();
            }
            catch (Exception exception) {
                log.message("Unable to determine bytes per record for BacnetTrendLogExt " + bIBacnetTrendLogExt);
            }
            l = l2 / (long)n;
        }
        return l;
    }

    public static BBacnetTrendLogAlarmSourceExt getAlarmExt(BIBacnetTrendLogExt bIBacnetTrendLogExt) {
        if (bIBacnetTrendLogExt == null) {
            return null;
        }
        SlotCursor slotCursor = ((BComplex)bIBacnetTrendLogExt).getProperties();
        Class clazz = class$com$tridium$bacnet$history$BBacnetTrendLogAlarmSourceExt;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$history$BBacnetTrendLogAlarmSourceExt = BacnetTrendLogUtil.class("[Lcom.tridium.bacnet.history.BBacnetTrendLogAlarmSourceExt;", false);
        }
        if (slotCursor.next(clazz)) {
            return (BBacnetTrendLogAlarmSourceExt)slotCursor.get();
        }
        return null;
    }

    public static BBacnetNotificationClassDescriptor getNotificationClass(BIBacnetTrendLogExt bIBacnetTrendLogExt) {
        BBacnetTrendLogAlarmSourceExt bBacnetTrendLogAlarmSourceExt = BacnetTrendLogUtil.getAlarmExt(bIBacnetTrendLogExt);
        if (bBacnetTrendLogAlarmSourceExt == null) {
            return null;
        }
        try {
            BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BAlarmClass bAlarmClass = bAlarmService.lookupAlarmClass(bBacnetTrendLogAlarmSourceExt.getAlarmClass());
            BBacnetObjectIdentifier bBacnetObjectIdentifier = BBacnetNetwork.localDevice().lookupBacnetObjectId(bAlarmClass.getHandleOrd());
            if (bBacnetObjectIdentifier != null) {
                return (BBacnetNotificationClassDescriptor)BBacnetNetwork.localDevice().lookupBacnetObject(bBacnetObjectIdentifier);
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.message("getNotificationClass on " + bIBacnetTrendLogExt + ":Unable to find alarm service!", (Throwable)serviceNotFoundException);
        }
        return null;
    }

    static NErrorType getFailureError(BIBacnetTrendLogExt bIBacnetTrendLogExt) {
        ErrorType errorType;
        SlotCursor slotCursor = ((BComplex)bIBacnetTrendLogExt).getParent().getProperties();
        Class clazz = class$javax$baja$bacnet$point$BBacnetProxyExt;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$point$BBacnetProxyExt = BacnetTrendLogUtil.class("[Ljavax.baja.bacnet.point.BBacnetProxyExt;", false);
        }
        if (slotCursor.next(clazz) && (errorType = ((BBacnetProxyExt)slotCursor.get()).getLastReadError()) != null) {
            return new NErrorType(errorType.getErrorClass(), errorType.getErrorCode());
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeEvent(BIBacnetTrendLogExt bIBacnetTrendLogExt, BAbsTime bAbsTime, BStatus bStatus, long l, BTrendEvent bTrendEvent) throws IOException {
        BHistoryExt bHistoryExt = (BHistoryExt)bIBacnetTrendLogExt;
        BBacnetTrendRecord bBacnetTrendRecord = bIBacnetTrendLogExt.getRecord();
        BTrendFlags bTrendFlags = bBacnetTrendRecord.getTrendFlags();
        BBacnetTrendLogAlarmSourceExt bBacnetTrendLogAlarmSourceExt = BacnetTrendLogUtil.getAlarmExt(bIBacnetTrendLogExt);
        try {
            block15: {
                block16: {
                    BIHistory bIHistory = BacnetTrendLogUtil.getHistory(bIBacnetTrendLogExt);
                    if (bIHistory != null && bIHistory.getRecordCount() != 0) break block16;
                    if (bTrendEvent.isLogStatus()) {
                        BBacnetBitString bBacnetBitString = bTrendEvent.getLogStatus();
                        BTrendEvent bTrendEvent2 = BTrendEvent.makeLogStatus(BBacnetBitString.make(bBacnetBitString, 1, true));
                        bBacnetTrendRecord.set(bAbsTime, bStatus, l, bTrendEvent2, bTrendFlags.set(4, true));
                        if (bTrendEvent2.isLogDisabled()) {
                            BacnetTrendLogUtil.extAppend(bIBacnetTrendLogExt, bBacnetTrendRecord);
                            break block15;
                        } else {
                            BacnetTrendLogUtil.appendRecord(bIBacnetTrendLogExt, bBacnetTrendRecord);
                        }
                        break block15;
                    } else {
                        BTrendEvent bTrendEvent3 = bIBacnetTrendLogExt.getEnabled() ? BTrendEvent.LOG_STATUS_ENABLED_BUFFER_PURGED : BTrendEvent.LOG_STATUS_DISABLED_BUFFER_PURGED;
                        BAbsTime bAbsTime2 = bAbsTime.subtract(BRelTime.make((long)1L));
                        bBacnetTrendRecord.set(bAbsTime2, bStatus, l, bTrendEvent3, bTrendFlags.set(4, true));
                        if (bTrendEvent3.isLogDisabled()) {
                            BacnetTrendLogUtil.extAppend(bIBacnetTrendLogExt, bBacnetTrendRecord);
                        } else {
                            BacnetTrendLogUtil.appendRecord(bIBacnetTrendLogExt, bBacnetTrendRecord);
                        }
                        if (!bHistoryExt.getStatus().isFault()) {
                            bIBacnetTrendLogExt.setTotalRecordCount(l);
                            if (bBacnetTrendLogAlarmSourceExt != null) {
                                bBacnetTrendLogAlarmSourceExt.incrementRecordsSinceNotification();
                            }
                        }
                        l = BacnetTrendLogUtil.incrementSequenceNumber(l);
                        bBacnetTrendRecord.set(bAbsTime, bStatus, l, bTrendEvent, bTrendFlags.set(4, true));
                        BacnetTrendLogUtil.appendRecord(bIBacnetTrendLogExt, bBacnetTrendRecord);
                    }
                    break block15;
                }
                bBacnetTrendRecord.set(bAbsTime, bStatus, l, bTrendEvent, bTrendFlags.set(4, true));
                if (bTrendEvent.isLogDisabled() || bTrendEvent.isTimeChange()) {
                    BacnetTrendLogUtil.extAppend(bIBacnetTrendLogExt, bBacnetTrendRecord);
                } else {
                    BacnetTrendLogUtil.appendRecord(bIBacnetTrendLogExt, bBacnetTrendRecord);
                }
            }
            if (!bHistoryExt.getStatus().isFault()) {
                bIBacnetTrendLogExt.setTotalRecordCount(l);
                if (bBacnetTrendLogAlarmSourceExt != null) {
                    bBacnetTrendLogAlarmSourceExt.incrementRecordsSinceNotification();
                }
                BacnetTrendLogUtil.checkForBufferFull(bIBacnetTrendLogExt);
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            bBacnetTrendRecord.setTrendFlags(bTrendFlags);
            throw throwable;
        }
        {
            Object var11_16 = null;
        }
        bBacnetTrendRecord.setTrendFlags(bTrendFlags);
    }

    public static void writeRecord(BIBacnetTrendLogExt bIBacnetTrendLogExt, BAbsTime bAbsTime, BStatusValue bStatusValue) throws IOException {
        Object object;
        if (!bIBacnetTrendLogExt.getEnabled()) {
            return;
        }
        BHistoryExt bHistoryExt = (BHistoryExt)bIBacnetTrendLogExt;
        BBacnetTrendRecord bBacnetTrendRecord = bIBacnetTrendLogExt.getRecord();
        BTrendFlags bTrendFlags = bBacnetTrendRecord.getTrendFlags();
        BBacnetTrendLogAlarmSourceExt bBacnetTrendLogAlarmSourceExt = BacnetTrendLogUtil.getAlarmExt(bIBacnetTrendLogExt);
        long l = BacnetTrendLogUtil.incrementSequenceNumber(bIBacnetTrendLogExt.getTotalRecordCount());
        boolean bl = false;
        try {
            object = BacnetTrendLogUtil.getHistory(bIBacnetTrendLogExt);
            if (object == null || object.getRecordCount() == 0) {
                bl = true;
            }
        }
        catch (HistoryException historyException) {
            bl = true;
        }
        if (bl) {
            object = bAbsTime.subtract(BRelTime.make((long)1L));
            BacnetTrendLogUtil.appendRecord(bIBacnetTrendLogExt, bBacnetTrendRecord.set((BAbsTime)object, bStatusValue.getStatus(), l, BTrendEvent.LOG_STATUS_ENABLED_BUFFER_PURGED, bTrendFlags.set(4, true)));
            if (!bHistoryExt.getStatus().isFault()) {
                bIBacnetTrendLogExt.setTotalRecordCount(l);
                if (bBacnetTrendLogAlarmSourceExt != null) {
                    bBacnetTrendLogAlarmSourceExt.incrementRecordsSinceNotification();
                }
            }
        }
        object = BTrendEvent.DEFAULT;
        NErrorType nErrorType = BacnetTrendLogUtil.getFailureError(bIBacnetTrendLogExt);
        if (nErrorType != null) {
            object = BTrendEvent.makeFailure(nErrorType);
            bBacnetTrendRecord.setTrendFlags(bTrendFlags.set(4, true));
        }
        l = BacnetTrendLogUtil.incrementSequenceNumber(bIBacnetTrendLogExt.getTotalRecordCount());
        bBacnetTrendRecord.set(bAbsTime, bStatusValue, l, (BTrendEvent)((Object)object), BTrendFlags.DEFAULT);
        BacnetTrendLogUtil.appendRecord(bIBacnetTrendLogExt, bBacnetTrendRecord);
        if (!bHistoryExt.getStatus().isFault()) {
            bIBacnetTrendLogExt.setTotalRecordCount(l);
            if (bBacnetTrendLogAlarmSourceExt != null) {
                bBacnetTrendLogAlarmSourceExt.incrementRecordsSinceNotification();
            }
            BacnetTrendLogUtil.checkForBufferFull(bIBacnetTrendLogExt);
        }
    }

    private static final void checkForBufferFull(BIBacnetTrendLogExt bIBacnetTrendLogExt) {
        long l = BacnetTrendLogUtil.getMaxRecords(bIBacnetTrendLogExt);
        BIHistory bIHistory = BacnetTrendLogUtil.getHistory(bIBacnetTrendLogExt);
        if (bIHistory == null) {
            return;
        }
        int n = bIHistory.getRecordCount();
        if ((long)n == l - 1L && bIBacnetTrendLogExt.getHistoryConfig().getFullPolicy() == BFullPolicy.stop) {
            ((BHistoryExt)bIBacnetTrendLogExt).setEnabled(false);
        }
    }

    private static final void appendRecord(BIBacnetTrendLogExt bIBacnetTrendLogExt, BTrendRecord bTrendRecord) throws IOException {
        BIHistory bIHistory = BacnetTrendLogUtil.getHistory(bIBacnetTrendLogExt);
        Cursor cursor = bIHistory.timeQuery(bIHistory.getLastTimestamp(), bIHistory.getLastTimestamp()).cursor();
        cursor.next();
        BBacnetTrendRecord bBacnetTrendRecord = (BBacnetTrendRecord)cursor.get();
        if (bBacnetTrendRecord.getLogEvent().equals((Object)BTrendEvent.DEFAULT)) {
            bIBacnetTrendLogExt.append(bTrendRecord);
        } else {
            BacnetTrendLogUtil.extAppend(bIBacnetTrendLogExt, bTrendRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void extAppend(BIBacnetTrendLogExt bIBacnetTrendLogExt, BTrendRecord bTrendRecord) {
        BHistoryExt bHistoryExt = (BHistoryExt)bIBacnetTrendLogExt;
        BIHistory bIHistory = BacnetTrendLogUtil.getHistory(bIBacnetTrendLogExt);
        if (!bHistoryExt.isRunning()) return;
        if (!Sys.atSteadyState()) return;
        try {
            BIBacnetTrendLogExt bIBacnetTrendLogExt2 = bIBacnetTrendLogExt;
            synchronized (bIBacnetTrendLogExt2) {
                if (bIHistory != null) {
                    bIHistory.append((BIHistoryRecordSet)bTrendRecord);
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var4_4
                if (bIHistory == null) return;
            }
            bHistoryExt.updateStatus();
            return;
        }
        catch (HistoryNotFoundException historyNotFoundException) {
            log.message("Unable to append record to history: record=" + bTrendRecord + " history=" + bIBacnetTrendLogExt, (Throwable)historyNotFoundException);
            return;
        }
        catch (Exception exception) {
            log.message("Unable to append record to history: record=" + bTrendRecord + " history=" + bIBacnetTrendLogExt, (Throwable)exception);
        }
    }

    private static final int getLogDatumType(BBacnetTrendRecord bBacnetTrendRecord, Integer n) {
        switch (bBacnetTrendRecord.getLogDatumType()) {
            case 0: 
            case 8: 
            case 9: {
                return bBacnetTrendRecord.getLogDatumType();
            }
        }
        if (n == null) {
            return bBacnetTrendRecord.getLogDatumType();
        }
        switch (n) {
            case 0: {
                return 7;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 6;
            }
            case 9: {
                return 3;
            }
            case -2: {
                if (bBacnetTrendRecord instanceof BBacnetBooleanTrendRecord) {
                    return 3;
                }
                if (bBacnetTrendRecord instanceof BBacnetEnumTrendRecord) {
                    return 4;
                }
                if (bBacnetTrendRecord instanceof BBacnetNumericTrendRecord) {
                    return 2;
                }
                return bBacnetTrendRecord.getLogDatumType();
            }
        }
        return 10;
    }

    public static RangeData readRangeAll(BIBacnetTrendLogExt bIBacnetTrendLogExt, int n, Integer n2) {
        BIHistory bIHistory = BacnetTrendLogUtil.getHistory(bIBacnetTrendLogExt);
        if (bIHistory == null || bIHistory.getRecordCount() == 0) {
            return EMPTY_RESULT;
        }
        BAbsTime bAbsTime = bIHistory.getFirstTimestamp();
        Cursor cursor = bIHistory.timeQuery(bAbsTime, bAbsTime).cursor();
        long l = 1L;
        int n3 = bIHistory.getRecordCount();
        if (cursor.next()) {
            l = ((BBacnetTrendRecord)cursor.get()).getSequenceNumber();
        }
        return BacnetTrendLogUtil.readRangeBySequence(bIBacnetTrendLogExt, l, n3, n, n2);
    }

    public static RangeData readRangeByPosition(BIBacnetTrendLogExt bIBacnetTrendLogExt, long l, int n, int n2, Integer n3) {
        BIHistory bIHistory = BacnetTrendLogUtil.getHistory(bIBacnetTrendLogExt);
        if (bIHistory == null || bIHistory.getRecordCount() == 0) {
            return EMPTY_RESULT;
        }
        long l2 = bIHistory.getRecordCount();
        long l3 = bIBacnetTrendLogExt.getTotalRecordCount();
        long l4 = l3 - l2 + 1L;
        if (l4 < 1L) {
            l4 = MAX_SEQ_NUM + l4;
        }
        long l5 = l4 + l - 1L;
        return BacnetTrendLogUtil.readRangeBySequence(bIBacnetTrendLogExt, l5, n, n2, n3);
    }

    public static RangeData readRangeByTime(BIBacnetTrendLogExt bIBacnetTrendLogExt, BBacnetDateTime bBacnetDateTime, int n, int n2, Integer n3) {
        BIHistory bIHistory = BacnetTrendLogUtil.getHistory(bIBacnetTrendLogExt);
        if (bIHistory == null || bIHistory.getRecordCount() == 0) {
            return EMPTY_RESULT;
        }
        BAbsTime bAbsTime = bBacnetDateTime.toBAbsTime();
        Cursor cursor = null;
        long l = 1L;
        if (n >= 0) {
            cursor = bIHistory.timeQuery(bAbsTime, null).cursor();
            BAbsTime bAbsTime2 = null;
            while (cursor.next()) {
                BBacnetDateTime bBacnetDateTime2 = new BBacnetDateTime(((BBacnetTrendRecord)cursor.get()).getTimestamp());
                if (bBacnetDateTime2.toBAbsTime().equals((Object)bAbsTime)) continue;
                bAbsTime2 = ((BBacnetTrendRecord)cursor.get()).getTimestamp();
                break;
            }
            if (bAbsTime2 == null) {
                return EMPTY_RESULT;
            }
            l = ((BBacnetTrendRecord)cursor.get()).getSequenceNumber();
        } else {
            cursor = bIHistory.timeQuery(null, bAbsTime).cursor();
            BAbsTime bAbsTime3 = null;
            BBacnetTrendRecord bBacnetTrendRecord = null;
            while (cursor.next()) {
                BBacnetDateTime bBacnetDateTime3 = new BBacnetDateTime(((BBacnetTrendRecord)cursor.get()).getTimestamp());
                if (bBacnetDateTime3.toBAbsTime().equals((Object)bAbsTime)) continue;
                bBacnetTrendRecord = (BBacnetTrendRecord)cursor.get();
            }
            if (bBacnetTrendRecord == null) {
                return EMPTY_RESULT;
            }
            bAbsTime3 = bBacnetTrendRecord.getTimestamp();
            if (bAbsTime3 != null) {
                l = bBacnetTrendRecord.getSequenceNumber();
            }
        }
        return BacnetTrendLogUtil.readRangeBySequence(bIBacnetTrendLogExt, l, n, n2, n3);
    }

    public static RangeData readRangeBySequence(BIBacnetTrendLogExt bIBacnetTrendLogExt, long l, int n, int n2, Integer n3) {
        if (n == 0) {
            return EMPTY_RESULT;
        }
        BIHistory bIHistory = BacnetTrendLogUtil.getHistory(bIBacnetTrendLogExt);
        if (bIHistory == null || bIHistory.getRecordCount() == 0) {
            return EMPTY_RESULT;
        }
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        long l2 = 0L;
        if (n > 0) {
            l2 = l;
            Cursor cursor = bIHistory.scan();
            cursor.next();
            BBacnetTrendRecord bBacnetTrendRecord = (BBacnetTrendRecord)cursor.get();
            long l3 = bBacnetTrendRecord.getSequenceNumber();
            long l4 = BacnetTrendLogUtil.findBeginRecord(cursor, l2);
            if (l4 == l3) {
                bl = true;
            }
            if (l4 < 0L) {
                return EMPTY_RESULT;
            }
            BBacnetTrendRecord bBacnetTrendRecord2 = (BBacnetTrendRecord)cursor.get();
            long l5 = l4;
            AsnOutputStream asnOutputStream = new AsnOutputStream();
            do {
                AsnOutputStream asnOutputStream2 = new AsnOutputStream();
                try {
                    asnOutputStream.writeTo(asnOutputStream2);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Error writing to temp ASN output stream");
                }
                int n5 = BacnetTrendLogUtil.getLogDatumType(bBacnetTrendRecord2, n3);
                BBacnetLogRecord.writeLogRecord(bBacnetTrendRecord2.getTimestamp(), (BSimple)(bBacnetTrendRecord2.getStatus().isNull() ? BBacnetNull.DEFAULT : bBacnetTrendRecord2.get(bBacnetTrendRecord2.getValueProperty())), n5, bBacnetTrendRecord2.getStatus(), bBacnetTrendRecord2.getLogEvent().getLong(), (AsnOutput)asnOutputStream);
                if (n2 > 0 && asnOutputStream.size() > n2) {
                    asnOutputStream = asnOutputStream2;
                    bl3 = true;
                    break;
                }
                ++n4;
                if (!cursor.next()) {
                    bl2 = true;
                    break;
                }
                bBacnetTrendRecord2 = (BBacnetTrendRecord)cursor.get();
                l4 = bBacnetTrendRecord2.getSequenceNumber();
            } while (n4 < n);
            return new ReadLogResult(n4, l5, asnOutputStream.toByteArray(), bl, bl2, bl3);
        }
        l2 = l + (long)n + 1L;
        Cursor cursor = bIHistory.scan();
        cursor.next();
        BBacnetTrendRecord bBacnetTrendRecord = (BBacnetTrendRecord)cursor.get();
        long l6 = bBacnetTrendRecord.getSequenceNumber();
        long l7 = BacnetTrendLogUtil.findBeginRecord(cursor, l2);
        if (l7 == l6) {
            bl = true;
        }
        if (l7 < 0L) {
            return EMPTY_RESULT;
        }
        BBacnetTrendRecord bBacnetTrendRecord3 = (BBacnetTrendRecord)cursor.get();
        AsnOutputStream asnOutputStream = new AsnOutputStream();
        Class clazz = class$com$tridium$bacnet$history$BacnetTrendLogUtil$EncodedRecord;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$history$BacnetTrendLogUtil$EncodedRecord = BacnetTrendLogUtil.class("[Lcom.tridium.bacnet.history.BacnetTrendLogUtil$EncodedRecord;", false);
        }
        Array array = new Array(clazz);
        int n6 = 0;
        n = Math.abs(n);
        do {
            int n7 = BacnetTrendLogUtil.getEncodedRecordSize(bBacnetTrendRecord3, n3);
            array.add((Object)new EncodedRecord(bBacnetTrendRecord3, n7));
            n6 += n7;
            ++n4;
            while (n2 > 0 && n6 > n2) {
                bl = false;
                bl3 = true;
                EncodedRecord encodedRecord = (EncodedRecord)array.remove(0);
                n6 -= encodedRecord.size;
                --n4;
            }
            if (!cursor.next()) {
                bl2 = true;
                break;
            }
            bBacnetTrendRecord3 = (BBacnetTrendRecord)cursor.get();
            l7 = bBacnetTrendRecord3.getSequenceNumber();
        } while (n4 < n);
        asnOutputStream.reset();
        long l8 = ((EncodedRecord)array.get((int)0)).rec.getSequenceNumber();
        int n8 = 0;
        while (n8 < array.size()) {
            BBacnetTrendRecord bBacnetTrendRecord4 = ((EncodedRecord)array.get((int)n8)).rec;
            int n9 = BacnetTrendLogUtil.getLogDatumType(bBacnetTrendRecord4, n3);
            BBacnetLogRecord.writeLogRecord(bBacnetTrendRecord4.getTimestamp(), (BSimple)(bBacnetTrendRecord4.getStatus().isNull() ? BBacnetNull.DEFAULT : bBacnetTrendRecord4.get(bBacnetTrendRecord4.getValueProperty())), n9, bBacnetTrendRecord4.getStatus(), bBacnetTrendRecord4.getLogEvent().getLong(), (AsnOutput)asnOutputStream);
            ++n8;
        }
        return new ReadLogResult(n4, l8, asnOutputStream.toByteArray(), bl, bl2, bl3);
    }

    private static final long findBeginRecord(Cursor cursor, long l) {
        BBacnetTrendRecord bBacnetTrendRecord = (BBacnetTrendRecord)cursor.get();
        long l2 = bBacnetTrendRecord.getSequenceNumber();
        while (l2 < l) {
            if (cursor.next()) {
                bBacnetTrendRecord = (BBacnetTrendRecord)cursor.get();
                l2 = bBacnetTrendRecord.getSequenceNumber();
                continue;
            }
            return -1;
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final int getEncodedRecordSize(BBacnetTrendRecord bBacnetTrendRecord, Integer n) {
        AsnOutputStream asnOutputStream = asnOut;
        synchronized (asnOutputStream) {
            asnOut.reset();
            int n2 = BacnetTrendLogUtil.getLogDatumType(bBacnetTrendRecord, n);
            BAbsTime bAbsTime = bBacnetTrendRecord.getTimestamp();
            BBacnetNull bBacnetNull = bBacnetTrendRecord.getStatus().isNull() ? BBacnetNull.DEFAULT : bBacnetTrendRecord.get(bBacnetTrendRecord.getValueProperty());
            BBacnetLogRecord.writeLogRecord(bAbsTime, (BSimple)bBacnetNull, n2, bBacnetTrendRecord.getStatus(), bBacnetTrendRecord.getLogEvent().getLong(), (AsnOutput)asnOut);
            return asnOut.size();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ReadLogResult
    implements RangeData {
        long itemCount;
        long firstSequenceNumber;
        byte[] itemData;
        boolean includeFirst;
        boolean includeLast;
        boolean moreItems;

        public BBacnetBitString getResultFlags() {
            return BBacnetBitString.make(new boolean[]{this.includeFirst, this.includeLast, this.moreItems});
        }

        public boolean includesFirstItem() {
            return this.includeFirst;
        }

        public boolean includesLastItem() {
            return this.includeLast;
        }

        public boolean isMoreItems() {
            return this.moreItems;
        }

        public long getItemCount() {
            return this.itemCount;
        }

        public long getFirstSequenceNumber() {
            return this.firstSequenceNumber;
        }

        public byte[] getItemData() {
            return this.itemData;
        }

        public ErrorType getError() {
            return null;
        }

        public int getErrorClass() {
            return -1;
        }

        public int getErrorCode() {
            return -1;
        }

        public boolean isError() {
            return false;
        }

        public int getPropertyId() {
            return 131;
        }

        public int getPropertyArrayIndex() {
            return -1;
        }

        public void writeAsn(AsnOutput asnOutput) {
        }

        public void readAsn(AsnInput asnInput) {
        }

        ReadLogResult(long l, long l2, byte[] byArray, boolean bl, boolean bl2, boolean bl3) {
            this.itemCount = l;
            this.firstSequenceNumber = l2;
            this.itemData = byArray;
            this.includeFirst = bl;
            this.includeLast = bl2;
            this.moreItems = bl3;
        }
    }

    static class EncodedRecord {
        BBacnetTrendRecord rec;
        int size;

        EncodedRecord(BBacnetTrendRecord bBacnetTrendRecord, int n) {
            this.rec = (BBacnetTrendRecord)bBacnetTrendRecord.newCopy();
            this.size = n;
        }
    }
}

