/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.history;

import com.tridium.bacnet.ObjectTypeList;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.history.BBacnetHistoryDeviceExt;
import com.tridium.bacnet.history.BacnetTrendLogUtil;
import com.tridium.bacnet.job.BacnetDiscoveryUtil;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.DeviceRegistry;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import java.util.HashMap;
import java.util.Map;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetLogRecord;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.RejectException;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.driver.history.ArchiveException;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Array;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.ByteArrayUtil;
import javax.baja.util.IFuture;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetHistoryImport
extends BHistoryImport
implements BacnetConst {
    public static final Property historyId = BBacnetHistoryImport.newProperty((int)1, (BValue)BHistoryId.NULL, null);
    public static final Lexicon lex = Lexicon.make((String)"bacnet");
    private static final String UNKNOWN = lex.get("historyType.unknown", "unknown");
    public static final Property objectId = BBacnetHistoryImport.newProperty((int)0, (BValue)BBacnetObjectIdentifier.make(20), null);
    public static final Property localHistoryName = BBacnetHistoryImport.newProperty((int)1, (String)"", null);
    public static final Property localHistoryNameFormat = BBacnetHistoryImport.newProperty((int)0, (BValue)BFormat.make((String)"%name%"), null);
    public static final Property referenceTime = BBacnetHistoryImport.newProperty((int)0, (BValue)new BBacnetDateTime(BAbsTime.make((long)0L, (BTimeZone)BTimeZone.UTC)), null);
    public static final Property maxRecordsPerRequest = BBacnetHistoryImport.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)Integer.MAX_VALUE));
    public static final Property alwaysRequestByReferenceTime = BBacnetHistoryImport.newProperty((int)0, (boolean)false, null);
    public static final Property lastSequenceNumberProcessed = BBacnetHistoryImport.newProperty((int)0, (BValue)BLong.make((long)0L), null);
    public static final Property maxStartingEvents = BBacnetHistoryImport.newProperty((int)4, (int)3, null);
    public static final Property discoveryHistoryType = BBacnetHistoryImport.newProperty((int)5, (String)UNKNOWN, null);
    public static final Action clearRecordsInDevice = BBacnetHistoryImport.newAction((int)128, null);
    public static final Type TYPE;
    public static final Log log;
    private AsnInputStream asnIn;
    private boolean bufferReady;
    private boolean formatChecked;
    private boolean overridesConfigured;
    byte[] prev;
    String prevNam;
    boolean oprChange;
    static /* synthetic */ Class class$com$tridium$bacnet$history$BBacnetHistoryImport;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetLogRecord;

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(objectId, (BValue)bBacnetObjectIdentifier, null);
    }

    public String getLocalHistoryName() {
        return this.getString(localHistoryName);
    }

    public void setLocalHistoryName(String string) {
        this.setString(localHistoryName, string, null);
    }

    public BFormat getLocalHistoryNameFormat() {
        return (BFormat)this.get(localHistoryNameFormat);
    }

    public void setLocalHistoryNameFormat(BFormat bFormat) {
        this.set(localHistoryNameFormat, (BValue)bFormat, null);
    }

    public BBacnetDateTime getReferenceTime() {
        return (BBacnetDateTime)this.get(referenceTime);
    }

    public void setReferenceTime(BBacnetDateTime bBacnetDateTime) {
        this.set(referenceTime, (BValue)bBacnetDateTime, null);
    }

    public int getMaxRecordsPerRequest() {
        return this.getInt(maxRecordsPerRequest);
    }

    public void setMaxRecordsPerRequest(int n) {
        this.setInt(maxRecordsPerRequest, n, null);
    }

    public boolean getAlwaysRequestByReferenceTime() {
        return this.getBoolean(alwaysRequestByReferenceTime);
    }

    public void setAlwaysRequestByReferenceTime(boolean bl) {
        this.setBoolean(alwaysRequestByReferenceTime, bl, null);
    }

    public long getLastSequenceNumberProcessed() {
        return this.getLong(lastSequenceNumberProcessed);
    }

    public void setLastSequenceNumberProcessed(long l) {
        this.setLong(lastSequenceNumberProcessed, l, null);
    }

    public int getMaxStartingEvents() {
        return this.getInt(maxStartingEvents);
    }

    public void setMaxStartingEvents(int n) {
        this.setInt(maxStartingEvents, n, null);
    }

    public String getDiscoveryHistoryType() {
        return this.getString(discoveryHistoryType);
    }

    public void setDiscoveryHistoryType(String string) {
        this.setString(discoveryHistoryType, string, null);
    }

    public void clearRecordsInDevice() {
        this.invoke(clearRecordsInDevice, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BBacnetDevice device() {
        return (BBacnetDevice)this.getDeviceExt().getDevice();
    }

    public final BBacnetHistoryDeviceExt deviceExt() {
        return (BBacnetHistoryDeviceExt)this.getDeviceExt();
    }

    public void started() throws Exception {
        super.started();
        if (Sys.atSteadyState() && this.isEnabled()) {
            this.postConfigureOverrides();
            if (this.getExecutionTime().getTriggerMode() != BManualTriggerMode.DEFAULT) {
                this.execute();
            }
        }
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        if (this.device().isOperational()) {
            this.postConfigureOverrides();
            if (this.getExecutionTime().getTriggerMode() != BManualTriggerMode.DEFAULT) {
                this.execute();
            }
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)status) && Sys.atSteadyState() && this.isEnabled() && !this.overridesConfigured) {
            this.postConfigureOverrides();
        }
    }

    protected BBacnetClientLayer client() {
        return ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient();
    }

    public void doClearRecordsInDevice() {
        this.doClearDeviceRecords();
    }

    public boolean isBufferReady() {
        return this.bufferReady;
    }

    public void setBufferReady(boolean bl) {
        this.bufferReady = bl;
    }

    protected IFuture postExecute(Action action, BValue bValue, Context context) {
        try {
            return BBacnetNetwork.bacnet().postAsync(new AsyncImport());
        }
        catch (Exception exception) {
            this.executeFail(exception);
            return null;
        }
    }

    protected void postConfigureOverrides() {
        try {
            if (this.device().isOperational()) {
                BBacnetNetwork.bacnet().postAsync(new Runnable(){

                    public final void run() {
                        BBacnetHistoryImport.this.configureOverrides();
                    }
                });
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final synchronized void configureOverrides() {
        if (this.overridesConfigured) {
            return;
        }
        if (this.device().isOperational()) {
            BComponent bComponent = this.getConfigOverrides();
            this.setTimeZone(bComponent);
            this.setLogInterval(bComponent);
            this.setValueFacets(bComponent);
            this.overridesConfigured = true;
        }
    }

    private final void setTimeZone(BComponent bComponent) {
        BTimeZone bTimeZone = this.deviceExt().getTimeZone();
        if (bTimeZone == null) {
            log.warning("TimeZone determined from TimeZoneDatabase and device values is null, resetting to default!");
            bTimeZone = BTimeZone.getLocal();
            Property property = bComponent.getProperty("timeZone");
            if (property == null) {
                bComponent.add("timeZone", (BValue)bTimeZone, 0, BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"driver:TimeZoneSelectionFE")), null);
            } else {
                bComponent.set(property, (BValue)bTimeZone);
                bComponent.setFlags((Slot)property, bComponent.getFlags((Slot)property) & 0xFFFFFFFE);
                bComponent.setFacets((Slot)property, BFacets.make((BFacets)bComponent.getSlotFacets((Slot)property), (String)"fieldEditor", (BIDataValue)BString.make((String)"driver:TimeZoneSelectionFE")));
            }
        } else if (bComponent.getProperty("timeZone") == null) {
            bComponent.add("timeZone", (BValue)bTimeZone, 0, BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"driver:TimeZoneSelectionFE")), null);
        } else {
            bComponent.set("timeZone", (BValue)bTimeZone);
        }
    }

    private final void setLogInterval(BComponent bComponent) {
        try {
            byte[] byArray = this.client().readProperty(this.device().getAddress(), this.getObjectId(), 134);
            long l = AsnUtil.fromAsnUnsignedInteger(byArray);
            BCollectionInterval bCollectionInterval = BCollectionInterval.IRREGULAR;
            if (l >= 0L) {
                bCollectionInterval = BCollectionInterval.make((BRelTime)BRelTime.make((long)(l * 10L)));
            }
            BBacnetHistoryImport.setOrAdd(bComponent, "interval", (BValue)bCollectionInterval);
        }
        catch (BacnetException bacnetException) {
            log.message("Unable to read Log_Interval from " + (Object)((Object)this.getObjectId()) + " in " + this.device() + ':' + (Object)((Object)bacnetException));
        }
    }

    private final void setValueFacets(BComponent bComponent) {
        BBacnetObjectIdentifier bBacnetObjectIdentifier;
        BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference = this.getDeviceObjectProp();
        if (bBacnetDeviceObjectPropertyReference != null && BBacnetHistoryImport.hasValueFacets(bBacnetDeviceObjectPropertyReference) && (bBacnetObjectIdentifier = bBacnetDeviceObjectPropertyReference.getDeviceId()) != null) {
            BFacets bFacets;
            HashMap hashMap;
            BBacnetAddress bBacnetAddress;
            if (bBacnetObjectIdentifier == BBacnetObjectIdentifier.DEFAULT_DEVICE) {
                bBacnetObjectIdentifier = this.device().getObjectId();
            }
            if ((bBacnetAddress = DeviceRegistry.getDeviceAddress(bBacnetObjectIdentifier)) != null && (hashMap = BacnetDiscoveryUtil.discoverFacets(bBacnetDeviceObjectPropertyReference.getObjectId(), bBacnetAddress)) != null && (bFacets = BFacets.make((Map)hashMap)) != null) {
                BBacnetHistoryImport.setOrAdd(bComponent, "valueFacets", (BValue)bFacets);
            }
        }
    }

    public BHistoryRecord correctTimestamp(BHistoryRecord bHistoryRecord) {
        BTimeZone bTimeZone = this.deviceExt().getTimeZone();
        if (bTimeZone == null) {
            return bHistoryRecord;
        }
        BAbsTime bAbsTime = bHistoryRecord.getTimestamp();
        BRelTime bRelTime = BRelTime.make((long)bAbsTime.getTimeZone().getUtcOffset());
        BRelTime bRelTime2 = BRelTime.make((long)bTimeZone.getUtcOffset());
        bHistoryRecord.setTimestamp(BAbsTime.make((BAbsTime)bAbsTime.subtract(bRelTime2).add(bRelTime), (BTimeZone)bTimeZone));
        return bHistoryRecord;
    }

    public void doExecute() throws ArchiveException {
        if (!this.isRunning()) {
            return;
        }
        BBacnetDevice bBacnetDevice = this.device();
        if (bBacnetDevice.isOperational()) {
            if (!this.device().isServiceSupported("readRange")) {
                throw new ArchiveException(lex.getText("serviceNotSupported.readRange"));
            }
            this.importHistoryData();
        }
    }

    private final void importHistoryData() throws ArchiveException {
        BBacnetDevice bBacnetDevice = this.device();
        if (!this.overridesConfigured) {
            this.configureOverrides();
        }
        BHistoryDatabase bHistoryDatabase = this.getHistoryDb();
        this.verifyLocalNameFormat();
        BIHistory bIHistory = this.getOrCreateHistory(bHistoryDatabase);
        if (bIHistory == null) {
            throw new ArchiveException("Cannot create history for " + this);
        }
        long l = -1;
        int n = 6;
        BBacnetDateTime bBacnetDateTime = this.getReferenceTime();
        int n2 = this.getMaxRecordsPerRequest();
        if (n2 == 0) {
            n2 = 10;
        }
        try {
            if (this.getAlwaysRequestByReferenceTime()) {
                n = 7;
            } else if (bBacnetDevice.getProtocolRevision() < 3) {
                n = 4;
            } else {
                l = this.determineNextIndex();
                if (l < 0L) {
                    this.executeOk();
                    return;
                }
            }
            ReadRangeAck readRangeAck = null;
            boolean bl = true;
            while (bl) {
                Object object;
                Class clazz;
                ReadRangeAck readRangeAck2 = null;
                try {
                    readRangeAck2 = this.client().readRange(bBacnetDevice.getAddress(), this.getObjectId(), 131, -1, n, l, bBacnetDateTime, n2);
                }
                catch (RejectException rejectException) {
                    if (rejectException.getRejectReason() != 6) continue;
                    this.setAlwaysRequestByReferenceTime(true);
                    n = 7;
                    continue;
                }
                if (readRangeAck2 == null) {
                    log.message("Error importing history data for " + this + ": null response from device!");
                    break;
                }
                if (((Object)readRangeAck2).equals(readRangeAck)) {
                    log.message("Error importing history data for " + this + ": duplicate response (loop?):\nResponse:" + readRangeAck2);
                    break;
                }
                readRangeAck = readRangeAck2;
                byte[] byArray = readRangeAck2.getItemData();
                if (byArray == null || byArray.length == 0) break;
                boolean bl2 = false;
                if (readRangeAck2.isMoreItems() || !readRangeAck2.includesLastItem()) {
                    bl2 = true;
                }
                bl = bl2;
                this.asnIn.setBuffer(byArray);
                long l2 = readRangeAck2.getFirstSequenceNumber();
                if (l2 == (long)-1) {
                    l2 = BacnetTrendLogUtil.incrementSequenceNumber(this.getLastSequenceNumberProcessed());
                }
                if ((clazz = class$javax$baja$bacnet$datatypes$BBacnetLogRecord) == null) {
                    clazz = BBacnetHistoryImport.class("[Ljavax.baja.bacnet.datatypes.BBacnetLogRecord;", false);
                }
                Array array = new Array(clazz);
                while (this.asnIn.peekTag() != -1) {
                    object = new BBacnetLogRecord();
                    ((BBacnetLogRecord)object).readAsn(this.asnIn);
                    array.add(object);
                }
                object = (BBacnetLogRecord[])array.trim();
                Object object2 = object[((BBacnetLogRecord[])object).length - 1];
                this.getReferenceTime().copyFrom((BComplex)((BBacnetLogRecord)object2).getTimestamp());
                this.setLastSequenceNumberProcessed(readRangeAck2.getFirstSequenceNumber() + (long)((Object)object).length - 1L);
                int n3 = 0;
                while (n3 < ((Object)object).length) {
                    Object object3 = object[n3];
                    try {
                        BHistoryRecord bHistoryRecord = ((BBacnetLogRecord)object3).initializeNiagaraRecord(bIHistory.getConfig().makeRecord(), l2);
                        bIHistory.append((BIHistoryRecordSet)this.correctTimestamp(bHistoryRecord));
                    }
                    catch (Exception exception) {
                        log.error("Ignore trend record " + l2 + ':' + exception.toString());
                        if (!log.isTraceOn()) break;
                        exception.printStackTrace();
                        break;
                    }
                    l2 = BacnetTrendLogUtil.incrementSequenceNumber(l2);
                    ++n3;
                }
                if (!bl) continue;
                l = BacnetTrendLogUtil.incrementSequenceNumber(this.getLastSequenceNumberProcessed());
                bBacnetDateTime = this.getReferenceTime();
            }
            this.executeOk();
        }
        catch (Exception exception) {
            log.error("Exception reading range (device " + bBacnetDevice.getAddress() + ", id " + (Object)((Object)this.getObjectId()) + ", rangeType " + n + ", referenceIndex " + l + ", referenceTime " + bBacnetDateTime + ", count " + n2 + ')', (Throwable)exception);
            throw new ArchiveException((Throwable)exception);
        }
    }

    protected BHistoryDatabase getHistoryDb() throws ArchiveException {
        try {
            BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            return bHistoryService.getDatabase();
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            this.executeFail(serviceNotFoundException);
            throw new ArchiveException((Throwable)serviceNotFoundException);
        }
    }

    protected long determineNextIndex() throws BacnetException {
        long l = this.getLastSequenceNumberProcessed();
        long l2 = BacnetTrendLogUtil.incrementSequenceNumber(l);
        byte[] byArray = this.client().readProperty(this.device().getAddress(), this.getObjectId(), 145);
        long l3 = AsnUtil.fromAsnUnsignedInteger(byArray);
        byArray = this.client().readProperty(this.device().getAddress(), this.getObjectId(), 141);
        long l4 = AsnUtil.fromAsnUnsignedInteger(byArray);
        if (log.isTraceOn()) {
            log.trace("determineNextIndex():lastSeq=" + l + " recordCount=" + l4 + " totalRecordCount=" + l3 + " expectedSeq=" + l2);
        }
        if (l4 == 0L || l == l3) {
            return -1;
        }
        if (l4 <= l3) {
            long l5 = l3 - l4 + 1L;
            if (l2 < l5 || l2 > l3) {
                l2 = l5;
            }
        } else {
            long l6 = BacnetTrendLogUtil.MAX_SEQ_NUM - (l4 - l3) + 1L;
            if (l2 < l6 && l2 > l3) {
                l2 = l6;
            }
        }
        if (log.isTraceOn()) {
            log.trace(" --> expectedSeq=" + l2);
        }
        return l2;
    }

    private final BBacnetDeviceObjectPropertyReference getDeviceObjectPropEx() throws ArchiveException {
        try {
            return this.readDeviceObjectProp();
        }
        catch (Throwable throwable) {
            throw new ArchiveException(throwable);
        }
    }

    private final BBacnetDeviceObjectPropertyReference getDeviceObjectProp() {
        try {
            return this.readDeviceObjectProp();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private final BBacnetDeviceObjectPropertyReference readDeviceObjectProp() throws BacnetException {
        byte[] byArray = this.client().readProperty(this.device().getAddress(), this.getObjectId(), 132);
        boolean bl = false;
        if (this.prev == null || !ByteArrayUtil.equals((byte[])byArray, (byte[])this.prev)) {
            bl = true;
        }
        this.oprChange = bl;
        this.prev = byArray;
        this.asnIn.setBuffer(byArray);
        BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference = new BBacnetDeviceObjectPropertyReference();
        bBacnetDeviceObjectPropertyReference.readAsn(this.asnIn);
        return bBacnetDeviceObjectPropertyReference;
    }

    private final BIHistory getOrCreateHistory(BHistoryDatabase bHistoryDatabase) {
        String string = this.getLocalHistoryName();
        BHistoryId bHistoryId = BHistoryId.make((String)this.device().getName(), (String)string);
        if (bHistoryId == null) {
            throw new ArchiveException("Invalid names for historyId:" + this.device().getName() + '/' + string);
        }
        BIHistory bIHistory = bHistoryDatabase.getHistory(bHistoryId);
        if (bIHistory != null) {
            return bIHistory;
        }
        BTypeSpec bTypeSpec = this.getTypeSpec();
        if (bTypeSpec == null) {
            throw new ArchiveException("History type cannot be determined from device!");
        }
        return this.createHistory(bHistoryDatabase, bTypeSpec, bHistoryId);
    }

    protected BIHistory createHistory(BHistoryDatabase bHistoryDatabase, BTypeSpec bTypeSpec, BHistoryId bHistoryId) {
        BHistoryConfig bHistoryConfig = new BHistoryConfig(bHistoryId, bTypeSpec);
        bHistoryConfig = this.makeLocalConfig(bHistoryConfig);
        if (log.isTraceOn()) {
            log.trace("Create history from config:" + bHistoryConfig);
        }
        bHistoryDatabase.createHistory(bHistoryConfig);
        bHistoryId = bHistoryConfig.getId();
        return bHistoryDatabase.getHistory(bHistoryId);
    }

    protected BTypeSpec getTypeSpec() {
        BTypeSpec bTypeSpec = null;
        if (!this.getDiscoveryHistoryType().equalsIgnoreCase(UNKNOWN)) {
            bTypeSpec = BTypeSpec.make((String)"bacnet", (String)("Bacnet" + this.getDiscoveryHistoryType() + "TrendRecord"));
        }
        if (bTypeSpec != null) {
            return bTypeSpec;
        }
        try {
            bTypeSpec = this.getTypeSpec(this.getDeviceObjectPropEx());
        }
        catch (Exception exception) {
            log.trace("Cannot create history for " + this + " from Log_DeviceObjectProperty");
        }
        if (bTypeSpec != null) {
            return bTypeSpec;
        }
        if (this.getDiscoveryHistoryType().equalsIgnoreCase(UNKNOWN)) {
            try {
                bTypeSpec = BacnetTrendLogUtil.findHistoryTypeByRecords(this.device(), this.getObjectId());
            }
            catch (Exception exception) {
                log.trace("Cannot get history type spec for " + this + " from records");
            }
        }
        return bTypeSpec;
    }

    private static final boolean hasValueFacets(BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference) {
        if (bBacnetDeviceObjectPropertyReference.getPropertyId() == 85 && bBacnetDeviceObjectPropertyReference.getPropertyArrayIndex() == -1) {
            switch (bBacnetDeviceObjectPropertyReference.getObjectId().getObjectType()) {
                case 3: 
                case 4: 
                case 5: 
                case 13: 
                case 14: 
                case 19: {
                    return true;
                }
            }
        }
        return false;
    }

    protected BTypeSpec getTypeSpec(BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference) {
        try {
            Object object;
            if (bBacnetDeviceObjectPropertyReference.getObjectId().getInstanceNumber() != 0x3FFFFF && (object = ObjectTypeList.getInstance().getPropertyInfo(bBacnetDeviceObjectPropertyReference.getObjectId().getObjectType(), bBacnetDeviceObjectPropertyReference.getPropertyId())) != null) {
                return this.asnTagToTypeSpec(((PropertyInfo)object).getAsnType());
            }
            object = this.client().readProperty(this.device().getAddress(), bBacnetDeviceObjectPropertyReference.getObjectId(), bBacnetDeviceObjectPropertyReference.getPropertyId());
            this.asnIn.setBuffer((byte[])object);
            int n = this.asnIn.peekTag();
            if (this.asnIn.isApplicationTag(n)) {
                return this.asnTagToTypeSpec(n);
            }
            return BTypeSpec.make((String)"bacnet", (String)"BacnetStringTrendRecord");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private final BTypeSpec asnTagToTypeSpec(int n) {
        switch (n) {
            case 1: {
                return BTypeSpec.make((String)"bacnet", (String)"BacnetBooleanTrendRecord");
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return BTypeSpec.make((String)"bacnet", (String)"BacnetNumericTrendRecord");
            }
            case 9: {
                return BTypeSpec.make((String)"bacnet", (String)"BacnetEnumTrendRecord");
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                return BTypeSpec.make((String)"bacnet", (String)"BacnetStringTrendRecord");
            }
        }
        return BTypeSpec.make((String)"bacnet", (String)"BacnetStringTrendRecord");
    }

    public void doClearDeviceRecords() {
        Throwable throwable = null;
        try {
            if (!this.device().isServiceSupported("writeProperty")) {
                log.message("Cannot clear device records:" + lex.getText("serviceNotSupported.writeProperty"));
            } else {
                this.client().writeProperty(this.device().getAddress(), this.getObjectId(), 141, AsnUtil.toAsnUnsigned(0L));
            }
        }
        catch (Exception exception) {
            log.error("Problem during auto-clear of trend log records (device " + this.device().getAddress() + ", id " + (Object)((Object)this.getObjectId()) + ')', throwable);
        }
    }

    public String verifyLocalNameFormat() {
        String string;
        String string2 = string = this.getLocalHistoryNameFormat().format((Object)this);
        if (!this.formatChecked) {
            boolean bl = localHistoryName.isEquivalentToDefaultValue(this.get(localHistoryName));
            if (!bl && !this.getLocalHistoryName().equals(string)) {
                this.setLocalHistoryNameFormat(BFormat.make((String)this.getLocalHistoryName()));
                string2 = this.getLocalHistoryName();
            } else {
                this.setLocalHistoryName(string);
            }
            this.formatChecked = true;
        }
        return string2;
    }

    private static final void setOrAdd(BComponent bComponent, String string, BValue bValue) {
        if (bComponent.get(string) == null) {
            bComponent.add(string, bValue);
        } else {
            bComponent.set(string, bValue);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.asnIn = new AsnInputStream();
        this.bufferReady = false;
        this.formatChecked = false;
        this.overridesConfigured = false;
        this.prev = null;
        this.prevNam = null;
        this.oprChange = true;
    }

    public BBacnetHistoryImport() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$history$BBacnetHistoryImport;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$history$BBacnetHistoryImport = BBacnetHistoryImport.class("[Lcom.tridium.bacnet.history.BBacnetHistoryImport;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"bacnet.history");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class AsyncImport
    implements Runnable {
        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    BBacnetHistoryImport.this.doExecute();
                }
                catch (Throwable throwable) {
                    BBacnetHistoryImport.this.executeFail(throwable);
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                BBacnetHistoryImport.this.setState(BDescriptorState.idle);
                throw throwable;
            }
            {
                Object var2_4 = null;
            }
            BBacnetHistoryImport.this.setState(BDescriptorState.idle);
        }

        AsyncImport() {
        }
    }
}

