/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.datatypes;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.log.Log;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.util.Lexicon;

public class ListManipulation
implements Runnable {
    private static final Lexicon lex = Lexicon.make((String)"bacnet");
    private BBacnetObject object;
    private Property property;
    private BValue listElement;
    private boolean add;

    protected boolean checkEquals(BObject bObject, BValue bValue) {
        return bObject.equivalent((Object)bValue);
    }

    public void run() {
        if (!this.object.get(this.property).getType().is(BBacnetListOf.TYPE)) {
            return;
        }
        BBacnetListOf bBacnetListOf = (BBacnetListOf)this.object.get(this.property);
        if (this.add) {
            boolean bl = false;
            if (this.object.device().isServiceSupported("addListElement")) {
                try {
                    this.object.addListElement(this.property, this.listElement);
                    bl = true;
                }
                catch (BacnetException bacnetException) {
                    Log.getLog((String)"bacnet.client").warning("Unable to add list element " + this.listElement + " in property " + this.property + " of " + this.object + " using AddListElement:" + (Object)((Object)bacnetException));
                }
            }
            if (!bl) {
                try {
                    if (!this.object.device().isServiceSupported("writeProperty")) {
                        throw new UnsupportedOperationException(lex.getText("serviceNotSupported.writeProperty"));
                    }
                    this.object.readProperty(this.property);
                    SlotCursor slotCursor = bBacnetListOf.getProperties();
                    boolean bl2 = true;
                    while (slotCursor.next()) {
                        if (!slotCursor.get().getType().is(bBacnetListOf.getListType()) || !this.checkEquals(slotCursor.get(), this.listElement)) continue;
                        bl2 = false;
                        break;
                    }
                    if (bl2) {
                        bBacnetListOf.add(null, this.listElement);
                        this.object.writeProperty(this.property);
                    }
                }
                catch (Exception exception) {
                    Log.getLog((String)"bacnet.client").warning("Unable to add list element " + this.listElement + " in property " + this.property + " of " + this.object + " using WriteProperty:" + exception);
                }
            }
        } else {
            boolean bl = false;
            if (this.object.device().isServiceSupported("removeListElement")) {
                try {
                    this.object.removeListElement(this.property, this.listElement);
                    bl = true;
                }
                catch (BacnetException bacnetException) {
                    Log.getLog((String)"bacnet.client").warning("Unable to remove list element " + this.listElement + " in property " + this.property + " of " + this.object + " using RemoveListElement:" + (Object)((Object)bacnetException));
                }
            }
            if (!bl) {
                try {
                    if (!this.object.device().isServiceSupported("writeProperty")) {
                        throw new UnsupportedOperationException(lex.getText("serviceNotSupported.writeProperty"));
                    }
                    this.object.readProperty(this.property);
                    Object[] objectArray = bBacnetListOf.getChildren(bBacnetListOf.getListType().getTypeClass());
                    boolean bl3 = false;
                    int n = 0;
                    while (n < objectArray.length) {
                        if (this.checkEquals((BObject)objectArray[n], this.listElement)) {
                            bl3 = true;
                            bBacnetListOf.remove((BComplex)objectArray[n]);
                            break;
                        }
                        ++n;
                    }
                    if (bl3) {
                        this.object.writeProperty(this.property);
                    }
                }
                catch (Exception exception) {
                    Log.getLog((String)"bacnet.client").warning("Unable to remove list element " + this.listElement + " in property " + this.property + " of " + this.object + " using WriteProperty:" + exception);
                }
            }
        }
    }

    public ListManipulation(BBacnetObject bBacnetObject, Property property, BValue bValue, boolean bl) {
        this.object = bBacnetObject;
        this.property = property;
        this.listElement = bValue;
        this.add = bl;
    }
}

