/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn.notificationParameters;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.BacnetNotificationParameters;
import java.util.HashMap;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.sys.BString;
import javax.baja.sys.Context;

public class FloatingLimit
extends BacnetNotificationParameters {
    public static final int REFERENCE_VALUE_TAG = 0;
    public static final int STATUS_FLAGS_TAG = 1;
    public static final int SETPOINT_VALUE_TAG = 2;
    public static final int ERROR_LIMIT_TAG = 3;
    float referenceValue;
    BBacnetBitString statusFlags;
    float setpointValue;
    float errorLimit;

    public int getChoiceType() {
        return 4;
    }

    public float getReferenceValue() {
        return this.referenceValue;
    }

    public BBacnetBitString getStatusFlags() {
        return this.statusFlags;
    }

    public float getSetpointValue() {
        return this.setpointValue;
    }

    public float getErrorLimit() {
        return this.errorLimit;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeOpeningTag(4);
        asnOutputStream.writeReal(0, this.referenceValue);
        asnOutputStream.writeBitString(1, this.statusFlags);
        asnOutputStream.writeReal(2, this.setpointValue);
        asnOutputStream.writeReal(3, this.errorLimit);
        asnOutputStream.writeClosingTag(4);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.readEncoded(null, asnInputStream);
    }

    public void readEncoded(BBacnetObjectIdentifier bBacnetObjectIdentifier, AsnInputStream asnInputStream) throws AsnException {
        int n = asnInputStream.peekTag();
        if (!asnInputStream.isOpeningTag(4)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInputStream.skipTag();
        this.referenceValue = asnInputStream.readReal(0);
        this.statusFlags = asnInputStream.readBitString(1);
        this.setpointValue = asnInputStream.readReal(2);
        this.errorLimit = asnInputStream.readReal(3);
        n = asnInputStream.peekTag();
        if (!asnInputStream.isClosingTag(4)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInputStream.skipTag();
    }

    public String toString(Context context) {
        if (context != null && context.equals(BacnetConst.facetsContext)) {
            return this.toFacetString();
        }
        return this.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("  floating-limit\n");
        stringBuffer.append("    " + this.referenceValue);
        stringBuffer.append("    " + (Object)((Object)this.statusFlags));
        stringBuffer.append("    " + this.setpointValue);
        stringBuffer.append("    " + this.errorLimit);
        return stringBuffer.toString();
    }

    public String toFacetString() {
        StringBuffer stringBuffer = new StringBuffer("evtVals");
        stringBuffer.append(".ref." + this.referenceValue);
        stringBuffer.append(".sF." + this.statusFlags.toString(BacnetBitStringUtil.BacnetStatusFlags));
        stringBuffer.append(".setpt." + this.setpointValue);
        stringBuffer.append(".lim." + this.errorLimit);
        return stringBuffer.toString();
    }

    public void addAlarmData(HashMap hashMap) {
        hashMap.put("referenceValue", BString.make((String)String.valueOf(this.referenceValue)));
        hashMap.put("statusFlags", BString.make((String)this.statusFlags.toString(BacnetBitStringUtil.BacnetStatusFlags)));
        hashMap.put("setpointValue", BString.make((String)String.valueOf(this.setpointValue)));
        hashMap.put("errorLimit", BString.make((String)String.valueOf(this.errorLimit)));
    }

    public FloatingLimit() {
    }

    public FloatingLimit(float f, BBacnetBitString bBacnetBitString, float f2, float f3) {
        this.referenceValue = f;
        this.statusFlags = bBacnetBitString;
        this.setpointValue = f2;
        this.errorLimit = f3;
    }
}

