/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn.notificationParameters;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.BacnetNotificationParameters;
import java.util.HashMap;
import java.util.ListIterator;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.io.AsnException;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Extended
extends BacnetNotificationParameters {
    public static final int VENDOR_ID_TAG = 0;
    public static final int EXTENDED_EVENT_TYPE_TAG = 1;
    public static final int PARAMETERS_TAG = 2;
    public static final int REFERENCE_TAG = 0;
    private static final int NUL = 0;
    private static final int REAL = 1;
    private static final int UNS = 2;
    private static final int BOOL = 3;
    private static final int DUBL = 4;
    private static final int OCT = 5;
    private static final int BITS = 6;
    private static final int ENUM = 7;
    private static final int REF = 8;
    int vendorId;
    long extendedEventType;
    Array parameters;
    static /* synthetic */ Class class$com$tridium$bacnet$asn$notificationParameters$Extended$Param;

    public int getChoiceType() {
        return 9;
    }

    public int getVendorId() {
        return this.vendorId;
    }

    public void setVendorId(int n) {
        this.vendorId = n;
    }

    public long getExtendedEventType() {
        return this.extendedEventType;
    }

    public void setExtendedEventType(long l) {
        this.extendedEventType = l;
    }

    public Array getParameters() {
        return this.parameters;
    }

    public void setParameters(Array array) {
        this.parameters = array;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeOpeningTag(9);
        asnOutputStream.writeUnsignedInteger(0, this.vendorId);
        asnOutputStream.writeUnsignedInteger(1, this.extendedEventType);
        asnOutputStream.writeOpeningTag(2);
        ListIterator listIterator = this.parameters.iterator();
        while (listIterator.hasNext()) {
            this.writeParameter(asnOutputStream, (Param)listIterator.next());
        }
        asnOutputStream.writeClosingTag(2);
        asnOutputStream.writeClosingTag(9);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.readEncoded(null, asnInputStream);
    }

    public void readEncoded(BBacnetObjectIdentifier bBacnetObjectIdentifier, AsnInputStream asnInputStream) throws AsnException {
        int n = asnInputStream.peekTag();
        if (!asnInputStream.isOpeningTag(9)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInputStream.skipTag();
        this.vendorId = asnInputStream.readUnsignedInt(0);
        this.extendedEventType = asnInputStream.readUnsignedInteger(1);
        n = asnInputStream.peekTag();
        if (!asnInputStream.isOpeningTag(2)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInputStream.skipTag();
        Class clazz = class$com$tridium$bacnet$asn$notificationParameters$Extended$Param;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$asn$notificationParameters$Extended$Param = Extended.class("[Lcom.tridium.bacnet.asn.notificationParameters.Extended$Param;", false);
        }
        this.parameters = new Array(clazz);
        Param param = this.readParameter(asnInputStream);
        while (param != null) {
            this.parameters.add((Object)param);
            param = this.readParameter(asnInputStream);
        }
        asnInputStream.skipTag();
    }

    private final void validate() {
        if (this.parameters == null) {
            Class clazz = class$com$tridium$bacnet$asn$notificationParameters$Extended$Param;
            if (clazz == null) {
                clazz = class$com$tridium$bacnet$asn$notificationParameters$Extended$Param = Extended.class("[Lcom.tridium.bacnet.asn.notificationParameters.Extended$Param;", false);
            }
            this.parameters = new Array(clazz);
        }
    }

    private final Param readParameter(AsnInputStream asnInputStream) throws AsnException {
        int n = asnInputStream.peekApplicationTag();
        switch (n) {
            case 0: {
                return new Param();
            }
            case 4: {
                return new Param(asnInputStream.readReal());
            }
            case 2: {
                return new Param(asnInputStream.readUnsigned());
            }
            case 1: {
                return new Param(asnInputStream.readBoolean());
            }
            case 5: {
                return new Param(asnInputStream.readDouble());
            }
            case 6: {
                return new Param(asnInputStream.readOctetString());
            }
            case 8: {
                return new Param(asnInputStream.readBitString());
            }
            case 9: {
                return new Param(asnInputStream.readEnumerated());
            }
        }
        if (asnInputStream.isOpeningTag(0)) {
            asnInputStream.skipTag();
            BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference = new BBacnetDeviceObjectPropertyReference();
            bBacnetDeviceObjectPropertyReference.readAsn(asnInputStream);
            Param param = new Param(bBacnetDeviceObjectPropertyReference);
            asnInputStream.peekTag();
            if (!asnInputStream.isClosingTag(0)) {
                throw new AsnException("Invalid tag: " + n);
            }
            asnInputStream.skipTag();
            return param;
        }
        if (asnInputStream.isClosingTag(2)) {
            return null;
        }
        throw new AsnException("Invalid tag: " + n);
    }

    private final void writeParameter(AsnOutputStream asnOutputStream, Param param) {
        switch (param.typ) {
            case 0: {
                asnOutputStream.writeNull();
                break;
            }
            case 1: {
                asnOutputStream.writeReal(((Float)param.obj).floatValue());
                break;
            }
            case 2: {
                asnOutputStream.writeUnsigned((BBacnetUnsigned)((Object)param.obj));
                break;
            }
            case 3: {
                asnOutputStream.writeBoolean((Boolean)param.obj);
                break;
            }
            case 4: {
                asnOutputStream.writeDouble((Double)param.obj);
                break;
            }
            case 5: {
                asnOutputStream.writeOctetString((BBacnetOctetString)((Object)param.obj));
                break;
            }
            case 6: {
                asnOutputStream.writeBitString((BBacnetBitString)((Object)param.obj));
                break;
            }
            case 7: {
                asnOutputStream.writeEnumerated((Integer)param.obj);
                break;
            }
            case 8: {
                asnOutputStream.writeOpeningTag(0);
                ((BBacnetDeviceObjectPropertyReference)param.obj).writeAsn(asnOutputStream);
                asnOutputStream.writeClosingTag(0);
                break;
            }
        }
    }

    public String toString(Context context) {
        if (context != null && context.equals(BacnetConst.facetsContext)) {
            return this.toFacetString();
        }
        return this.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("  extended\n");
        stringBuffer.append("    " + this.vendorId);
        stringBuffer.append("    " + this.extendedEventType);
        stringBuffer.append("    " + this.parameters);
        return stringBuffer.toString();
    }

    public String toFacetString() {
        StringBuffer stringBuffer = new StringBuffer("evtVals");
        stringBuffer.append(".vId." + this.vendorId);
        stringBuffer.append(".eetyp." + this.extendedEventType);
        stringBuffer.append(".params.");
        Extended.toFacetString(this.parameters, stringBuffer);
        return stringBuffer.toString();
    }

    public void addAlarmData(HashMap hashMap) {
        hashMap.put("vendorId", BString.make((String)String.valueOf(this.vendorId)));
        hashMap.put("extendedEventType", BString.make((String)String.valueOf(this.extendedEventType)));
        hashMap.put("parameters", BString.make((String)Extended.toFacetString(this.parameters)));
    }

    private static final String toFacetString(Array array) {
        StringBuffer stringBuffer = new StringBuffer();
        Extended.toFacetString(array, stringBuffer);
        return stringBuffer.toString();
    }

    private static final void toFacetString(Array array, StringBuffer stringBuffer) {
        ListIterator listIterator = array.iterator();
        while (listIterator.hasNext()) {
            stringBuffer.append(Extended.toFacetString((Param)listIterator.next())).append('_');
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
    }

    private static final String toFacetString(Param param) {
        switch (param.typ) {
            case 0: {
                return "n";
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                return String.valueOf(param.obj);
            }
            case 5: {
                return ((BBacnetOctetString)((Object)param.obj)).toString(BacnetConst.facetsContext);
            }
            case 6: {
                return ((BBacnetBitString)((Object)param.obj)).toString(BacnetConst.facetsContext);
            }
            case 8: {
                return ((BBacnetDeviceObjectPropertyReference)param.obj).toString(BacnetConst.facetsContext);
            }
        }
        return "err";
    }

    static /* synthetic */ int access$0() {
        return 0;
    }

    static /* synthetic */ int access$1() {
        return 1;
    }

    static /* synthetic */ int access$2() {
        return 2;
    }

    static /* synthetic */ int access$3() {
        return 3;
    }

    static /* synthetic */ int access$4() {
        return 4;
    }

    static /* synthetic */ int access$5() {
        return 5;
    }

    static /* synthetic */ int access$6() {
        return 6;
    }

    static /* synthetic */ int access$7() {
        return 7;
    }

    static /* synthetic */ int access$8() {
        return 8;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Extended() {
    }

    public Extended(int n, long l, Array array) {
        this.vendorId = n;
        this.extendedEventType = l;
        this.parameters = array;
        this.validate();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Param {
        int typ;
        Object obj;

        Param() {
            this.typ = 0;
            this.obj = null;
        }

        Param(float f) {
            this.typ = 1;
            this.obj = new Float(f);
        }

        Param(BBacnetUnsigned bBacnetUnsigned) {
            this.typ = 2;
            this.obj = bBacnetUnsigned;
        }

        Param(boolean bl) {
            this.typ = 3;
            this.obj = new Boolean(bl);
        }

        Param(double d) {
            this.typ = 4;
            this.obj = new Double(d);
        }

        Param(byte[] byArray) {
            this.typ = 5;
            this.obj = BBacnetOctetString.make(byArray);
        }

        Param(BBacnetBitString bBacnetBitString) {
            this.typ = 6;
            this.obj = bBacnetBitString;
        }

        Param(int n) {
            this.typ = 7;
            this.obj = new Integer(n);
        }

        Param(BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference) {
            this.typ = 8;
            this.obj = bBacnetDeviceObjectPropertyReference;
        }
    }
}

