/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn.notificationParameters;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.BacnetNotificationParameters;
import com.tridium.bacnet.asn.NBacnetPropertyValue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RejectException;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.util.ByteArrayUtil;

public class ComplexEventType
extends BacnetNotificationParameters {
    private Vector listOfPropertyValues;

    public int getChoiceType() {
        return 6;
    }

    public void addPropertyValue(PropertyValue propertyValue) {
        this.listOfPropertyValues.add(propertyValue);
    }

    public Vector getListOfPropertyValues() {
        return this.listOfPropertyValues;
    }

    public Iterator getPropertyValues() {
        return this.listOfPropertyValues.iterator();
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeOpeningTag(6);
        Iterator iterator = this.listOfPropertyValues.iterator();
        while (iterator.hasNext()) {
            PropertyValue propertyValue = (PropertyValue)iterator.next();
            propertyValue.writeAsn(asnOutputStream);
        }
        asnOutputStream.writeClosingTag(6);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.readEncoded(null, asnInputStream);
    }

    public void readEncoded(BBacnetObjectIdentifier bBacnetObjectIdentifier, AsnInputStream asnInputStream) throws AsnException {
        try {
            int n = asnInputStream.peekTag();
            if (!asnInputStream.isOpeningTag(6)) {
                throw new AsnException("Invalid tag: " + n);
            }
            asnInputStream.skipTag();
            n = asnInputStream.peekTag();
            while (!asnInputStream.isClosingTag(6)) {
                if (n == -1) {
                    throw new AsnException("No closing tag");
                }
                NBacnetPropertyValue nBacnetPropertyValue = new NBacnetPropertyValue();
                nBacnetPropertyValue.readAsn(asnInputStream);
                this.listOfPropertyValues.add(nBacnetPropertyValue);
                n = asnInputStream.peekTag();
            }
            asnInputStream.skipTag();
        }
        catch (RejectException rejectException) {
            throw new AsnException(rejectException.toString());
        }
    }

    public String toString(Context context) {
        if (context != null && context.equals(BacnetConst.facetsContext)) {
            return this.toFacetString();
        }
        return this.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("  complex-event-type\n");
        Iterator iterator = this.listOfPropertyValues.iterator();
        while (iterator.hasNext()) {
            PropertyValue propertyValue = (PropertyValue)iterator.next();
            stringBuffer.append("    ").append(propertyValue.toString()).append("\n");
        }
        return stringBuffer.toString();
    }

    public String toFacetString() {
        StringBuffer stringBuffer = new StringBuffer("evtVals");
        Iterator iterator = this.listOfPropertyValues.iterator();
        while (iterator.hasNext()) {
            PropertyValue propertyValue = (PropertyValue)iterator.next();
            stringBuffer.append("..val.");
            ComplexEventType.valueToFacetString(propertyValue, stringBuffer);
        }
        return stringBuffer.toString();
    }

    private static final void valueToFacetString(PropertyValue propertyValue, StringBuffer stringBuffer) {
        stringBuffer.append(propertyValue.getPropertyId()).append('.');
        if (propertyValue.getPropertyArrayIndex() != -1) {
            stringBuffer.append(propertyValue.getPropertyArrayIndex()).append('.');
        }
        stringBuffer.append(ByteArrayUtil.toHexString((byte[])propertyValue.getPropertyValue()));
        if (propertyValue.getPriority() != -1) {
            stringBuffer.append('.').append(propertyValue.getPriority());
        }
    }

    public void addAlarmData(HashMap hashMap) {
        Iterator iterator = this.listOfPropertyValues.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            hashMap.put("complexEventValue" + n++, BString.make((String)iterator.next().toString()));
        }
    }

    public ComplexEventType() {
        this.listOfPropertyValues = new Vector();
    }

    public ComplexEventType(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            if (!(vector.get(n) instanceof NBacnetPropertyValue)) {
                throw new IllegalArgumentException();
            }
            ++n;
        }
        this.listOfPropertyValues = vector;
    }
}

