/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn.notificationParameters;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.BacnetNotificationParameters;
import java.util.HashMap;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.sys.BString;
import javax.baja.sys.Context;

public class ChangeOfValue
extends BacnetNotificationParameters {
    public static final int NEW_VALUE_TAG = 0;
    public static final int CHANGED_BITS_TAG = 0;
    public static final int CHANGED_VALUE_TAG = 1;
    public static final int STATUS_FLAGS_TAG = 1;
    boolean isValue;
    BBacnetBitString changedBits;
    float changedValue;
    BBacnetBitString statusFlags;

    public int getChoiceType() {
        return 2;
    }

    public boolean isValue() {
        return this.isValue;
    }

    public BBacnetBitString getChangedBits() {
        return this.changedBits;
    }

    public float getChangedValue() {
        return this.changedValue;
    }

    public BBacnetBitString getStatusFlags() {
        return this.statusFlags;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeOpeningTag(2);
        asnOutputStream.writeOpeningTag(0);
        if (this.isValue) {
            asnOutputStream.writeReal(1, this.changedValue);
        } else {
            asnOutputStream.writeBitString(0, this.changedBits);
        }
        asnOutputStream.writeBitString(1, this.statusFlags);
        asnOutputStream.writeClosingTag(0);
        asnOutputStream.writeClosingTag(2);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.readEncoded(null, asnInputStream);
    }

    public void readEncoded(BBacnetObjectIdentifier bBacnetObjectIdentifier, AsnInputStream asnInputStream) throws AsnException {
        asnInputStream.skipOpeningTag(2);
        asnInputStream.skipOpeningTag(0);
        if (asnInputStream.isValueTag(0)) {
            this.isValue = false;
            this.changedBits = asnInputStream.readBitString(0);
        } else {
            this.isValue = true;
            this.changedValue = asnInputStream.readReal(1);
        }
        asnInputStream.skipClosingTag(0);
        this.statusFlags = asnInputStream.readBitString(1);
        asnInputStream.skipClosingTag(2);
    }

    public String toString(Context context) {
        if (context != null && context.equals(BacnetConst.facetsContext)) {
            return this.toFacetString();
        }
        return this.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("  change-of-value\n");
        if (this.isValue) {
            stringBuffer.append("    " + this.changedValue);
        } else {
            stringBuffer.append("    " + (Object)((Object)this.changedBits));
        }
        stringBuffer.append("    " + (Object)((Object)this.statusFlags));
        return stringBuffer.toString();
    }

    public String toFacetString() {
        StringBuffer stringBuffer = new StringBuffer("evtVals");
        if (this.isValue) {
            stringBuffer.append(".val." + this.changedValue);
        } else {
            stringBuffer.append(".bits." + this.changedBits.toString(BacnetConst.facetsContext));
        }
        stringBuffer.append(".sF." + this.statusFlags.toString(BacnetBitStringUtil.BacnetStatusFlags));
        return stringBuffer.toString();
    }

    public void addAlarmData(HashMap hashMap) {
        if (this.isValue) {
            hashMap.put("changedValue", BString.make((String)String.valueOf(this.changedValue)));
        } else {
            hashMap.put("changedBits", BString.make((String)this.changedBits.toString()));
        }
        hashMap.put("statusFlags", BString.make((String)this.statusFlags.toString(BacnetBitStringUtil.BacnetStatusFlags)));
    }

    public ChangeOfValue() {
    }

    public ChangeOfValue(BBacnetBitString bBacnetBitString, BBacnetBitString bBacnetBitString2) {
        this.isValue = false;
        this.changedBits = bBacnetBitString;
        this.statusFlags = bBacnetBitString2;
    }

    public ChangeOfValue(float f, BBacnetBitString bBacnetBitString) {
        this.isValue = true;
        this.changedValue = f;
        this.statusFlags = bBacnetBitString;
    }
}

