/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn.notificationParameters;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.BacnetNotificationParameters;
import com.tridium.bacnet.asn.NBacnetPropertyStates;
import java.util.HashMap;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.sys.BString;
import javax.baja.sys.Context;

public class ChangeOfState
extends BacnetNotificationParameters {
    public static final int NEW_STATE_TAG = 0;
    public static final int STATUS_FLAGS_TAG = 1;
    NBacnetPropertyStates newState;
    BBacnetBitString statusFlags;

    public int getChoiceType() {
        return 1;
    }

    public BBacnetBitString getStatusFlags() {
        return this.statusFlags;
    }

    public NBacnetPropertyStates getNewState() {
        return this.newState;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeOpeningTag(1);
        asnOutputStream.writeOpeningTag(0);
        this.newState.writeEncoded(asnOutputStream);
        asnOutputStream.writeClosingTag(0);
        asnOutputStream.writeBitString(1, this.statusFlags);
        asnOutputStream.writeClosingTag(1);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.readEncoded(null, asnInputStream);
    }

    public void readEncoded(BBacnetObjectIdentifier bBacnetObjectIdentifier, AsnInputStream asnInputStream) throws AsnException {
        int n = asnInputStream.peekTag();
        if (!asnInputStream.isOpeningTag(1)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInputStream.skipTag();
        n = asnInputStream.peekTag();
        if (!asnInputStream.isOpeningTag(0)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInputStream.skipTag();
        this.newState = new NBacnetPropertyStates();
        this.newState.readEncoded(bBacnetObjectIdentifier, asnInputStream);
        n = asnInputStream.peekTag();
        if (!asnInputStream.isClosingTag(0)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInputStream.skipTag();
        this.statusFlags = asnInputStream.readBitString(1);
        n = asnInputStream.peekTag();
        if (!asnInputStream.isClosingTag(1)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInputStream.skipTag();
    }

    public String toString(Context context) {
        if (context != null && context.equals(BacnetConst.facetsContext)) {
            return this.toFacetString();
        }
        return this.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("  change-of-state\n");
        stringBuffer.append("    " + this.newState);
        stringBuffer.append("    " + (Object)((Object)this.statusFlags));
        return stringBuffer.toString();
    }

    public String toFacetString() {
        StringBuffer stringBuffer = new StringBuffer("evtVals");
        stringBuffer.append(".state." + this.newState.toString(BacnetConst.facetsContext));
        stringBuffer.append(".sF." + this.statusFlags.toString(BacnetBitStringUtil.BacnetStatusFlags));
        return stringBuffer.toString();
    }

    public void addAlarmData(HashMap hashMap) {
        hashMap.put("newState", BString.make((String)this.newState.toString()));
        hashMap.put("statusFlags", BString.make((String)this.statusFlags.toString(BacnetBitStringUtil.BacnetStatusFlags)));
    }

    public ChangeOfState() {
    }

    public ChangeOfState(NBacnetPropertyStates nBacnetPropertyStates, BBacnetBitString bBacnetBitString) {
        this.newState = nBacnetPropertyStates;
        this.statusFlags = bBacnetBitString;
    }
}

