/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn.notificationParameters;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.BacnetNotificationParameters;
import java.util.HashMap;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.sys.BString;
import javax.baja.sys.Context;

public class ChangeOfBitstring
extends BacnetNotificationParameters {
    public static final int REFERENCED_BITSTRING_TAG = 0;
    public static final int STATUS_FLAGS_TAG = 1;
    BBacnetBitString referencedBitstring;
    BBacnetBitString statusFlags;

    public int getChoiceType() {
        return 0;
    }

    public BBacnetBitString getStatusFlags() {
        return this.statusFlags;
    }

    public BBacnetBitString getReferencedBitstring() {
        return this.referencedBitstring;
    }

    public void writeEncoded(AsnOutputStream asnOutputStream) {
        asnOutputStream.writeOpeningTag(0);
        asnOutputStream.writeBitString(0, this.referencedBitstring);
        asnOutputStream.writeBitString(1, this.statusFlags);
        asnOutputStream.writeClosingTag(0);
    }

    public void readEncoded(AsnInputStream asnInputStream) throws AsnException {
        this.readEncoded(null, asnInputStream);
    }

    public void readEncoded(BBacnetObjectIdentifier bBacnetObjectIdentifier, AsnInputStream asnInputStream) throws AsnException {
        int n = asnInputStream.peekTag();
        if (!asnInputStream.isOpeningTag(0)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInputStream.skipTag();
        this.referencedBitstring = asnInputStream.readBitString(0);
        this.statusFlags = asnInputStream.readBitString(1);
        asnInputStream.peekTag();
        if (!asnInputStream.isClosingTag(0)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInputStream.skipTag();
    }

    public String toString(Context context) {
        if (context != null && context.equals(BacnetConst.facetsContext)) {
            return this.toFacetString();
        }
        return this.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("  change-of-bitstring\n");
        stringBuffer.append("    " + (Object)((Object)this.referencedBitstring));
        stringBuffer.append("    " + (Object)((Object)this.statusFlags));
        return stringBuffer.toString();
    }

    public String toFacetString() {
        StringBuffer stringBuffer = new StringBuffer("evtVals");
        stringBuffer.append(".refBS." + this.referencedBitstring.toString(BacnetConst.facetsContext));
        stringBuffer.append(".sF." + this.statusFlags.toString(BacnetBitStringUtil.BacnetStatusFlags));
        return stringBuffer.toString();
    }

    public void addAlarmData(HashMap hashMap) {
        hashMap.put("referencedBitstring", BString.make((String)this.referencedBitstring.toString()));
        hashMap.put("statusFlags", BString.make((String)this.statusFlags.toString(BacnetBitStringUtil.BacnetStatusFlags)));
    }

    public ChangeOfBitstring() {
    }

    public ChangeOfBitstring(BBacnetBitString bBacnetBitString, BBacnetBitString bBacnetBitString2) {
        this.referencedBitstring = bBacnetBitString;
        this.statusFlags = bBacnetBitString2;
    }
}

