/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn;

import com.tridium.bacnet.asn.AsnConst;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.PropertyValue;

public class NReadAccessResult
implements AsnConst {
    public static final int OBJECT_ID_TAG = 0;
    public static final int LIST_OF_RESULTS_TAG = 1;
    private BBacnetObjectIdentifier objectId;
    private Vector listOfResults;

    public BBacnetObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public void addResult(PropertyValue propertyValue) {
        this.listOfResults.addElement(propertyValue);
    }

    public ListIterator getResults() {
        return this.listOfResults.listIterator();
    }

    public Vector getListOfResults() {
        return this.listOfResults;
    }

    public void writeAsn(AsnOutput asnOutput) {
        asnOutput.writeObjectIdentifier(0, this.objectId);
        asnOutput.writeOpeningTag(1);
        Iterator iterator = this.listOfResults.iterator();
        while (iterator.hasNext()) {
            NReadPropertyResult nReadPropertyResult = (NReadPropertyResult)iterator.next();
            nReadPropertyResult.writeAsn(asnOutput);
        }
        asnOutput.writeClosingTag(1);
    }

    public void readAsn(AsnInput asnInput) throws AsnException {
        this.objectId = asnInput.readObjectIdentifier(0);
        int n = asnInput.peekTag();
        if (!asnInput.isOpeningTag(1)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInput.skipTag();
        n = asnInput.peekTag();
        while (!asnInput.isClosingTag(1)) {
            if (n == -1) {
                throw new AsnException("Invalid tag: " + n);
            }
            NReadPropertyResult nReadPropertyResult = new NReadPropertyResult(this);
            nReadPropertyResult.readAsn(asnInput);
            this.listOfResults.addElement(nReadPropertyResult);
            n = asnInput.peekTag();
        }
        asnInput.skipTag();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("NReadAccessResult: ");
        stringBuffer.append("\n  " + (Object)((Object)this.objectId));
        Iterator iterator = this.listOfResults.iterator();
        while (iterator.hasNext()) {
            PropertyValue propertyValue = (PropertyValue)iterator.next();
            stringBuffer.append(propertyValue.toString());
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public NReadAccessResult() {
        this.listOfResults = new Vector();
    }

    public NReadAccessResult(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.objectId = bBacnetObjectIdentifier;
        this.listOfResults = new Vector();
    }
}

