/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn;

import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RejectException;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NBacnetPropertyValue
implements BacnetConst,
PropertyValue {
    public static final int PROPERTY_ID_TAG = 0;
    public static final int PROPERTY_ARRAY_INDEX_TAG = 1;
    public static final int VALUE_TAG = 2;
    public static final int PRIORITY_TAG = 3;
    private int propertyId;
    private int propertyArrayIndex;
    private byte[] propertyValue;
    private int priority;

    public int getPropertyId() {
        return this.propertyId;
    }

    public boolean isPropertyArrayIndexUsed() {
        boolean bl = false;
        if (this.propertyArrayIndex != -1) {
            bl = true;
        }
        return bl;
    }

    public int getPropertyArrayIndex() {
        return this.propertyArrayIndex;
    }

    public byte[] getPropertyValue() {
        return this.propertyValue;
    }

    public boolean isPriorityUsed() {
        boolean bl = false;
        if (this.priority != -1) {
            bl = true;
        }
        return bl;
    }

    public int getPriority() {
        return this.priority;
    }

    public ErrorType getPropertyAccessError() {
        throw new IllegalStateException();
    }

    public boolean isError() {
        return false;
    }

    public int getErrorClass() {
        throw new IllegalStateException();
    }

    public int getErrorCode() {
        throw new IllegalStateException();
    }

    public void writeAsn(AsnOutput asnOutput) {
        asnOutput.writeEnumerated(0, this.propertyId);
        if (this.propertyArrayIndex != -1) {
            asnOutput.writeUnsignedInteger(1, this.propertyArrayIndex);
        }
        asnOutput.writeEncodedValue(2, this.propertyValue);
        if (this.priority != -1) {
            asnOutput.writeUnsignedInteger(3, this.priority);
        }
    }

    public void readAsn(AsnInput asnInput) throws AsnException, RejectException {
        this.propertyId = asnInput.readEnumerated(0);
        asnInput.peekTag();
        this.propertyArrayIndex = asnInput.isValueTag(1) ? asnInput.readUnsignedInt(1) : -1;
        this.propertyValue = asnInput.readEncodedValue(2);
        asnInput.peekTag();
        this.priority = asnInput.isValueTag(3) ? asnInput.readUnsignedInt(3) : -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n  " + BBacnetPropertyIdentifier.tag(this.propertyId));
        if (this.propertyArrayIndex != -1) {
            stringBuffer.append("[" + this.propertyArrayIndex + ']');
        }
        stringBuffer.append(" val=").append(ByteArrayUtil.toHexString((byte[])this.propertyValue));
        stringBuffer.append(" pri=").append(this.priority);
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.propertyArrayIndex = -1;
        this.priority = -1;
    }

    public NBacnetPropertyValue() {
        this(-1, -1, null, -1);
    }

    public NBacnetPropertyValue(int n, byte[] byArray) {
        this(n, -1, byArray, -1);
    }

    public NBacnetPropertyValue(int n, byte[] byArray, int n2) {
        this(n, -1, byArray, n2);
    }

    public NBacnetPropertyValue(int n, int n2, byte[] byArray) {
        this(n, n2, byArray, -1);
    }

    public NBacnetPropertyValue(int n, int n2, byte[] byArray, int n3) {
        this.this();
        this.propertyId = n;
        this.propertyArrayIndex = n2;
        this.propertyValue = byArray;
        this.priority = n3;
    }

    public NBacnetPropertyValue(PropertyValue propertyValue) {
        this.this();
        this.propertyId = propertyValue.getPropertyId();
        this.propertyArrayIndex = propertyValue.getPropertyArrayIndex();
        this.propertyValue = propertyValue.getPropertyValue();
    }
}

