/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn;

import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;

public class NBacnetObjectPropertyReference
implements BacnetConst {
    public static final int OBJECT_ID_TAG = 0;
    public static final int PROPERTY_ID_TAG = 1;
    public static final int PROPERTY_ARRAY_INDEX_TAG = 2;
    private BBacnetObjectIdentifier objectId;
    private int propertyId;
    private int propertyArrayIndex;

    public BBacnetObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.objectId = bBacnetObjectIdentifier;
    }

    public int getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(int n) {
        this.propertyId = n;
    }

    public boolean isPropertyArrayIndexUsed() {
        boolean bl = false;
        if (this.propertyArrayIndex != -1) {
            bl = true;
        }
        return bl;
    }

    public int getPropertyArrayIndex() {
        return this.propertyArrayIndex;
    }

    public void setPropertyArrayIndex(int n) {
        this.propertyArrayIndex = n;
    }

    public void writeAsn(AsnOutput asnOutput) {
        asnOutput.writeObjectIdentifier(0, this.objectId);
        asnOutput.writeEnumerated(1, this.propertyId);
        if (this.propertyArrayIndex != -1) {
            asnOutput.writeUnsignedInteger(2, this.propertyArrayIndex);
        }
    }

    public void readAsn(AsnInput asnInput) throws AsnException {
        this.objectId = asnInput.readObjectIdentifier(0);
        this.propertyId = asnInput.readEnumerated(1);
        asnInput.peekTag();
        this.propertyArrayIndex = asnInput.isValueTag(2) ? asnInput.readUnsignedInt(2) : -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("\n  " + (Object)((Object)this.objectId));
        stringBuffer.append("\n  " + BBacnetPropertyIdentifier.tag(this.propertyId));
        if (this.propertyArrayIndex != -1) {
            stringBuffer.append("[" + this.propertyArrayIndex + ']');
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof NBacnetObjectPropertyReference) {
            boolean bl = false;
            if (this.objectId == ((NBacnetObjectPropertyReference)object).objectId && this.propertyId == ((NBacnetObjectPropertyReference)object).propertyId && this.propertyArrayIndex == ((NBacnetObjectPropertyReference)object).propertyArrayIndex) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public NBacnetObjectPropertyReference() {
        this(BBacnetObjectIdentifier.DEFAULT, -1, -1);
    }

    public NBacnetObjectPropertyReference(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this(bBacnetObjectIdentifier, -1, -1);
    }

    public NBacnetObjectPropertyReference(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n) {
        this(bBacnetObjectIdentifier, n, -1);
    }

    public NBacnetObjectPropertyReference(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2) {
        this.objectId = bBacnetObjectIdentifier;
        this.propertyId = n;
        this.propertyArrayIndex = n2;
    }
}

