/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.asn;

import com.tridium.bacnet.asn.AsnConst;
import java.util.StringTokenizer;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BExtensibleEnumList;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.sys.BEnum;
import javax.baja.sys.BString;

public class NAlarmSummary
implements AsnConst {
    private BBacnetObjectIdentifier objectId;
    private BEnum alarmState;
    private BBacnetBitString acknowledgedTransitions;

    public BBacnetObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public BEnum getAlarmState() {
        return this.alarmState;
    }

    public BBacnetBitString getAcknowledgedTransitions() {
        return this.acknowledgedTransitions;
    }

    public void writeAsn(AsnOutput asnOutput) {
        asnOutput.writeObjectIdentifier(this.objectId);
        asnOutput.writeEnumerated(this.alarmState.getOrdinal());
        asnOutput.writeBitString(this.acknowledgedTransitions);
    }

    public void readAsn(AsnInput asnInput) throws AsnException {
        this.readAsn(null, asnInput);
    }

    public void readAsn(BBacnetObjectIdentifier bBacnetObjectIdentifier, AsnInput asnInput) throws AsnException {
        BBacnetDevice bBacnetDevice;
        this.objectId = asnInput.readObjectIdentifier();
        BExtensibleEnumList bExtensibleEnumList = BBacnetNetwork.localDevice().getEnumerationList();
        if (bBacnetObjectIdentifier != null && (bBacnetDevice = BBacnetNetwork.bacnet().doLookupDeviceById(bBacnetObjectIdentifier)) != null) {
            bExtensibleEnumList = bBacnetDevice.getEnumerationList();
        }
        int n = asnInput.readEnumerated();
        this.alarmState = bExtensibleEnumList.getEventState().getRange().get(n);
        this.acknowledgedTransitions = asnInput.readBitString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("NAlarmSummary: ");
        stringBuffer.append("\n  objectId:" + (Object)((Object)this.objectId));
        stringBuffer.append("\n  alarmState:" + this.alarmState);
        stringBuffer.append("\n  ackedTransitions:" + (Object)((Object)this.acknowledgedTransitions));
        return stringBuffer.toString();
    }

    public BString toJob() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.objectId.toString()).append('|').append(this.alarmState.toString()).append('|').append(this.acknowledgedTransitions.toString(BacnetBitStringUtil.BacnetEventTransitionBits));
        return BString.make((String)stringBuffer.toString());
    }

    public static String fromJob(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        if (stringTokenizer.countTokens() < 3) {
            return "Cannot parse:" + string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Object ID:").append(stringTokenizer.nextToken()).append("; Alarm State:").append(stringTokenizer.nextToken()).append("; Acked Transitions:").append(stringTokenizer.nextToken()).append("\n");
        return stringBuffer.toString();
    }

    public NAlarmSummary() {
    }

    public NAlarmSummary(BBacnetObjectIdentifier bBacnetObjectIdentifier, BEnum bEnum, BBacnetBitString bBacnetBitString) {
        this.objectId = bBacnetObjectIdentifier;
        this.alarmState = bEnum;
        this.acknowledgedTransitions = bBacnetBitString;
    }
}

